<?php
/**
 * Internationalisation file for Maintenance extension.
 *
 * @file
 * @ingroup Extensions
 */

$messages = array();

/** English
 * @author Ryan Schmidt
 * @author Purodha
 */
$messages['en'] = array(
	// special page text
	'maintenance' => 'Run maintenance scripts',
	// description
	'maintenance-desc' => '[[Special:Maintenance|Wiki interface]] for various maintenance scripts',
	// for Special:ListGroupRights
	'right-maintenance' => 'Run maintenance scripts through [[Special:Maintenance]]',
	// main form
	'maintenance-backlink' => 'Back to script selection',
	'maintenance-header' => 'Please select a script below to execute. Descriptions are next to each script',
	// errors
	'maintenance-error-badini' => 'The metadata.ini file is either corrupted or missing. Please re-download the Maintenance extension',
	'maintenance-error-invalidtype' => 'The script specified was not found',
	'maintenance-error-badargs' => 'You did not specify all of the required options',
	// generic includes
	'maintenance-generic-done' => 'done',
	'maintenance-generic-username' => 'Username',
	'maintenance-generic-password' => 'Password',
	'maintenance-generic-reason' => 'Reason',
	'maintenance-generic-notrans' => '$1', #Do not translate this message
	// generic messages from cleanupTable.inc
	'maintenance-cleanupTable-dry-run' => 'Perform a dry run',
	'maintenance-cleanupTable-check' => 'Checking for bad titles...',
	'maintenance-cleanupTable-checkfix' => 'Checking and fixing bad titles...',
	'maintenance-cleanupTable-progress' => '$1 $2: $3% done on $4; ETA $5 [$6/$7] $8/sec <$9% updated>', #$1=wiki id, $2=timestamp, $3=portion done, $4=table name, $5=eta, $6=num processed, $7=total, $8=processed/sec, $9=updated rate
	'maintenance-cleanupTable-missingparam' => '$1: Missing parameter $2', #$1=method name, $2=list of params missing (hardcoded in cleanupTables.inc to be seperated by a comma and a space, e.g. "param1, param2")
	'maintenance-cleanupTable-processing' => 'Processing $1...', #$1=table name
	'maintenance-cleanupTable-finished' => 'Finished $1... $2 of $3 {{PLURAL:$3|row|rows}} updated', #$1=table name, $2=num updated, $3=num processed
	// default options
	'maintenance-option-quiet' => 'Suppress non-error output',
	'maintenance-option-globals' => 'Output globals at the end of processing for debugging',
	'maintenance-option-confirm' => 'Confirm',
	'maintenance-option-batch-size' => 'Run this many operations per batch, default: $1', #$1=batch size
	'maintenance-option-required' => '(required)', #not yet used
	'maintenance-option-optional' => '(optional)', #not yet used
	// default output
	'maintenance-output-success' => '$1 ran successfully!', #$1=name of script
	'maintenance-output-failure' => '$1 did not run successfully!', #$1=name of script
	// attachLatest
	'maintenance-attachLatest' => 'Use this form to fix entries in the page table where page_latest is set to 0',
	'maintenance-attachLatest-desc' => 'Fix page_latest entries in the page table',
	'maintenance-attachLatest-option-fix' => 'Actually fix the entries, will dry run otherwise',
	'maintenance-attachLatest-output-begin' => 'Looking for pages with page_latest set to 0...',
	'maintenance-attachLatest-output-notime' => '$1 $2 [[$3]] cannot find the latest rev time?!', #$1=wiki id, $2=page id, $3=page name
	'maintenance-attachLatest-output-norev' => '$1 $2 [[$3]] latest time $4, cannot find revision id', #$1=wiki id, $2=page id, $3=page name, $4=latest time
	'maintenance-attachLatest-output-found' => '$1 $2 [[$3]] latest time $4, rev id $5', #$1=wiki id, $2=page id, $3=page name, $4=latest time, $5=rev id
	'maintenance-attachLatest-output-done' => 'Done! Processed $1 {{PLURAL:$1|page|pages}}.', #$1=number of pages with page_latest=0
	'maintenance-attachLatest-output-dryrun' => 'This was a dry run; rerun with "{{int:maintenance-attachLatest-option-fix}}" to update page_latest.',
	// benchmarkPurge
	'maintenance-benchmarkPurge' => 'Use this form to test how long the Squid purge functions take',
	'maintenance-benchmarkPurge-desc' => 'Benchmark the Squid purge functions',
	'maintenance-benchmarkPurge-option-count' => 'How many URLs to feed to Squid for purging',
	'maintenance-benchmarkPurge-error-nosquid' => "Squid purge benchmark doesn't do much without Squid support on.",
	'maintenance-benchmarkPurge-output-numsquids' => 'There are $1 defined Squid {{PLURAL:$1|server|servers}}:', #$1=number of squid servers
	'maintenance-benchmarkPurge-output-trial' => '$1 {{PLURAL:$1|title|titles}} in $2ms ($3ms each)', #$1=number of titles, $2=total time, $3=average time
	// changePassword
	'maintenance-changePassword' => "Use this form to change a user's password",
	'maintenance-changePassword-desc' => "Change a user's password",
	'maintenance-changePassword-option-user' => '{{int:maintenance-generic-username}}',
	'maintenance-changePassword-option-password' => '{{int:maintenance-generic-password}}',
	'maintenance-changePassword-error-nouser' => 'No such user: $1', #$1=username
	'maintenance-changePassword-output-set' => 'Password set for $1', #$1=username
	// checkAutoLoader
	'maintenance-checkAutoLoader' => 'Use this form to do some sanity checks on the AutoLoader',
	'maintenance-checkAutoLoader-desc' => 'AutoLoader sanity checks',
	'maintenance-checkAutoLoader-output-list1' => "\t'\$1' => '\$2',", #$1=class, $2=file
	'maintenance-checkAutoLoader-output-list2' => '$1: Wrong file: found in $2, listed in $3', #$1=class, $2=file, $3=file
	// checkBadRedirects
	'maintenance-checkBadRedirects' => 'Use this form to see if pages marked as redirects really are redirects',
	'maintenance-checkBadRedirects-desc' => 'Check for bad redirects',
	'maintenance-checkBadRedirects-output-header' => 'Fetching redirects...',
	'maintenance-checkBadRedirects-output-found' => "Found \$1 {{PLURAL:$1|redirect|redirects}}.\nChecking for bad redirects...", #$1=number of redirects
	'maintenance-checkBadRedirects-output-footer' => "\nDone.",
	// checkImages
	'maintenance-checkImages' => 'Use this form to see which images on your wiki are corrupted',
	'maintenance-checkImages-desc' => 'Check images to see if they exist, are readable, etc',
	'maintenance-checkImages-output-noaccess' => '$1: not locally accessible', #$1=image name
	'maintenance-checkImages-output-missing' => '$1: missing', #$1=image name
	'maintenance-checkImages-output-isdir' => '$1: is a directory', #$1=image name
	'maintenance-checkImages-output-truncated' => '$1: truncated, was $2', #$1=image name, $2=db size
	'maintenance-checkImages-output-mismatch' => '$1: size mismatch DB=$2, actual=$3', #$1=image name, $2=db size, $3=actual size
	'maintenance-checkImages-output-good' => 'Good images: $1/$2', #$1=good images, $2=total images
	// checkSyntax
	'maintenance-checkSyntax' => 'Use this form to check the syntax of all PHP files in MediaWiki',
	'maintenance-checkSyntax-desc' => 'Check syntax for all PHP files in MediaWiki',
	'maintenance-checkSyntax-option-with-extensions' => 'Also recurse the extensions folder',
	'maintenance-checkSyntax-option-path' => 'Specific path (file or directory) to check, either with absolute path or relative to the root of this MediaWiki installation',
	'maintenance-checkSyntax-option-list-file' => 'List of files or directories to check',
	'maintenance-checkSyntax-option-modified' => 'Check only files that were modified (requires svn command-line client)',
	'maintenance-checkSyntax-option-syntax-only' => 'Check for syntax validity only, skip code style warnings',
	'maintenance-checkSyntax-output-parsekit' => 'Checking syntax (using parsekit)',
	'maintenance-checkSyntax-output-phpl' => 'Checking syntax (using php -l, this can take a long time)',
	'maintenance-checkSyntax-output-footer' => 'Done! $1 files checked, $2 failures and $3 warnings found', #$1=files checked, $2=php errors, $3=php warnings
	'maintenance-checkSyntax-output-svnlist' => 'Retrieving list from Subversion...',
	'maintenance-checkSyntax-output-done' => '{{int:maintenance-generic-done}}',
	'maintenance-checkSyntax-output-buildlist' => 'Building file list...',
	'maintenance-checkSyntax-output-error' => 'Error in $1 line $2: $3', #$1=file, $2=line no, $3=error message
	'maintenance-checkSyntax-output-warning' => 'Warning in file $1: $2 found', #$1=file, $2=warning message
	'maintenance-checkSyntax-error-nofile' => 'Error: cannot find file or directory $1', #$1=file or directory path
	'maintenance-checkSyntax-error-cantopen' => 'Cannot open file $1', #$1=filename
	'maintenance-checkSyntax-error-svnerr' => 'Error retrieving list from Subversion!',
	// checkUsernames
	'maintenance-checkUsernames' => 'Use this form to show which usernames are invalid due to configuration changes. If nothing is listed after running this script, all usernames are valid',
	'maintenance-checkUsernames-desc' => 'Verify that database usernames are actually valid',
	'maintenance-checkUsernames-error-notvalid' => 'Invalid username: "$3" (user id $2)', #$1=wiki id, $2=user id, $3=username
	// cleanupCaps
	'maintenance-cleanupCaps' => 'Use this form to fix broken pages caused by modifying $wgCapitalLinks',
	'maintenance-cleanupCaps-desc' => 'Script to cleanup capitalization',
	'maintenance-cleanupCaps-option-dry-run' => '{{int:maintenance-cleanupTable-dry-run}}',
	'maintenance-cleanupCaps-option-namespace' => 'Namespace number to run caps cleanup on',
	'maintenance-cleanupCaps-output-islower' => '"$1" already lowercase.', #$1=page name
	'maintenance-cleanupCaps-output-clash' => '"$1" skipped; "$2" already exists', #$1=upppercase page name, $2=lowercase page name
	'maintenance-cleanupCaps-output-dryrun' => '"$1" -> "$2": DRY RUN, NOT MOVED', #$1=upppercase page name, $2=lowercase page name
	'maintenance-cleanupCaps-output-moved' => '"$1" -> "$2": $3', #$1=upppercase page name, $2=lowercase page name, $3=status of move (ok or not)
	'maintenance-cleanupCaps-output-check' => '{{int:maintenance-cleanupTable-check}}',
	'maintenance-cleanupCaps-output-checkfix' => '{{int:maintenance-cleanupTable-checkfix}}',
	'maintenance-cleanupCaps-output-progress' => '{{int:maintenance-cleanupTable-progress|$1|$2|$3|$4|$5|$6|$7|$8|$9}}',
	'maintenance-cleanupCaps-output-processing' => '{{int:maintenance-cleanupTable-processing|$1}}',
	'maintenance-cleanupCaps-output-finished' => '{{int:maintenance-cleanupTable-check|$1|$2|$3}}',
	'maintenance-cleanupCaps-error-missingparam' => '{{int:maintenance-cleanupTable-missingparam|$1|$2}}',
	'maintenance-cleanupCaps-error-noneed' => '$wgCapitalLinks is on -- no need for caps links cleanup.',
	// cleanupImages
	// cleanupSpam
	'maintenance-cleanupSpam' => 'Use this form to revert spam edits that link to external sites',
	'maintenance-cleanupSpam-desc' => 'Clean up all spam from a given hostname',
	'maintenance-cleanupSpam-option-hostname' => 'Hostname that was spamming',
	'maintenance-cleanupSpam-output-found' => 'Found $1 {{PLURAL:$1|article|articles}} containing $2', #$1=count, $2=hostname
	'maintenance-cleanupSpam-output-done' => '{{int:maintenance-generic-done}}',
	'maintenance-cleanupSpam-output-false' => 'False match',
	'maintenance-cleanupSpam-output-blanking' => 'blanking',
	'maintenance-cleanupSpam-output-reverting' => 'reverting',
	'maintenance-cleanupSpam-output-page' => '$1 ...', #$1=page name
	'maintenance-cleanupSpam-error-invalid' => 'Not a valid hostname specification: $1', #$1=hostname
	'maintenance-cleanupSpam-error-noid' => 'Internal error: no page for ID $1', #$1=page id
	// cleanupTitles
	// cleanupWatchlist
	// clearInterwikiCache
	'maintenance-clearInterwikiCache' => 'Use this form to completely clear the interwiki cache',
	'maintenance-clearInterwikiCache-desc' => 'Clear all interwiki links for all languages from the cache',
	'maintenance-clearInterwikiCache-done' => '{{int:maintenance-generic-done}}',
	'maintenance-clearInterwikiCache-db' => '$1...', #$1=db name
	// clearCacheStats
	// convertLinks
	// convertUserOptions
	// createAndPromote
	'maintenance-createAndPromote' => 'Use this form to create a new user and promote it to administrator. Check the bureaucrat box if you wish to promote to bureaucrat as well',
	'maintenance-createAndPromote-desc' => 'Create a user and promote to administrator status',
	'maintenance-createAndPromote-option-bureaucrat' => 'Promote user to bureaucrat status',
	'maintenance-createAndPromote-option-username' => '{{int:maintenance-generic-username}}',
	'maintenance-createAndPromote-option-password' => '{{int:maintenance-generic-password}}',
	'maintenance-createAndPromote-output-creating' => 'Creating and promoting {{ns:user}}:$2...', #$1=wiki id, $2=username
	'maintenance-createAndPromote-output-done' => '{{int:maintenance-generic-done}}',
	'maintenance-createAndPromote-error-invalid' => '{{int:noname}}',
	'maintenance-createAndPromote-error-exists' => '{{int:userexists}}',
	'maintenance-createAndPromote-error-password' => 'An error was encountered with the password you entered: $1', #$1=password error
	// deleteArchivedFiles
	// deleteArchivedRevisions
	// deleteBatch
	'maintenance-deleteBatch' => 'Use this form to mass-delete pages. Put only one page per line',
	'maintenance-deleteBatch-desc' => 'Mass-delete pages',
	// deleteDefaultMessages
	// deleteImageMemcached
	// deleteOldRevisions
	// deleteOrphanedRevisions
	// deleteRevision
	'maintenance-deleteRevision' => 'Use this form to mass-delete revisions. Put only one revision number per line',
	'maintenance-deleteRevision-desc' => 'Remove revisions from the database',
	// deleteSelfExternals
	// dumpLinks
	// dumpSisterSites
	// dumpUploads
	// edit
	// fetchText
	// findhooks
	// fixSlaveDesync
	// fixTimestamps
	// fixUserRegistration
	// generateSitemap
	// getLagTimes
	// getSlaveServer
	// getText
	// httpSessionDownload
	// initEditCount
	'maintenance-initEditCount' => '',
	'maintenance-initEditCount-desc' => 'Recalculate the edit counts of users',
	// initSiteStats
	'maintenance-initSiteStats' => 'Use this form to recalculate site statistics, specifying if you want to recalculate page views as well',
	'maintenance-initSiteStats-desc' => 'Recalculate site statistics',
	// lag
	// mctest
	// mergeMessageFileList
	// migrateUserGroup
	// minify
	// moveBatch
	'maintenance-moveBatch' => 'Use this form to mass-move pages. Each line should specify a source page and destination page separated by a pipe',
	'maintenance-moveBatch-desc' => 'Mass-move pages',
	// namespaceDupes
	// nextJobDB
	// nukeNS
	// nukePage
	// orphans
	// patchSql
	// populateCategory
	// populateLogSearch
	// populateLogUsertext
	// populateParentId
	// populateRevisionLength
	// populateSha1
	// protect
	// purgeList
	// purgeOldText
	// reassignEdits
	'maintenance-reassignEdits-desc' => 'Reassign edits from one user to another',
	// rebuildall
	// rebuildFileCache
	// rebuildLocalisationCache
	// rebuildmessages
	// rebuildrecentchanges
	// rebuildtextindex
	// refreshCategoryCounts
	// refreshImageCount
	// refreshLinks
	// removeUnusedAccounts
	// renameDbPrefix
	// renderDump
	// rollbackEdits
	// runBatchedQuery
	// runJobs
	'maintenance-runJobs' => '',
	'maintenance-runJobs-desc' => 'Run jobs in the job queue',
	'maintenance-runJobs-option-maxjobs' => 'Maximum number of jobs to run',
	'maintenance-runJobs-option-type' => 'Type of job to run',
	'maintenance-runJobs-option-procs' => 'Number of processes to use', #currently not used
	'maintenance-runJobs-option-exclusive' => 'Run only one exclusive runJobs script at a time. Timeout is 1800 seconds.',
	'maintenance-runJobs-output-job' => '{{int:maintenance-generic-notrans|$1}}', #$1=job result
	'maintenance-runJobs-error-invalidprocs' => 'You must specify between 1 and 1000 processes', #currently not used
	// showJobs
	'maintenance-showJobs' => '',
	'maintenance-showJobs-desc' => 'Show a list of jobs pending in the job queue',
	'maintenance-showJobs-option-group' => 'Show number of jobs per job type',
	'maintenance-showJobs-output-job' => '{{int:maintenance-generic-notrans|$1}}', #$1=job info
	// showSiteStats
	// sql
	'maintenance-sql' => 'Use this form to execute a SQL query on the database.',
	'maintenance-sql-desc' => 'Execute an SQL query',
	'maintenance-sql-option-file' => 'SQL to execute',
	'maintenance-sql-output-row' => '{{int:maintenance-generic-notrans|$1}}', #$1=print_r result of row
	'maintenance-sql-output-aff' => 'Query OK, $1 {{PLURAL:$1|row|rows}} affected',
	'maintenance-sql-error-cantopen' => 'Unable to open input file',
	'maintenance-sql-error-sql' => '{{int:maintenance-generic-notrans|$1}}', #$1=sql error
	// sqlite
	// showCacheStats
	'maintenance-showCacheStats' => '',
	'maintenance-showCacheStats-desc' => 'Show Memcached statistics',
	// undelete
	// updateArticleCount
	// updateDoubleWidthSearch
	// updateRestrictions
	// updateSearchIndex
	// updateSpecialPages
	// waitForSlave
##########---------- UNSORTED AND/OR OLD MESSAGES BELOW THIS POINT ----------##########
	// eval
	'maintenance-eval' => 'Use this form to evaluate PHP code in the MediaWiki environment.',
	'maintenance-eval-desc' => 'Evaluate PHP code in the MediaWiki environment',
	// initSiteStats
	'maintenance-update' => 'Use UPDATE when updating a table? Unchecked uses DELETE/INSERT instead.',
	'maintenance-noviews' => 'Check this to prevent updating the number of pageviews',
	// createAndPromote, perhaps others
	'maintenance-invalidname' => 'Invalid username!',
	// all scripts
	'maintenance-output-success' => '$1 ran successfully!',
	// createAndPromote
	'maintenance-userexists' => 'User already exists!',
	// deleteBatch, moveBatch, perhaps others
	'maintenance-invalidtitle' => 'Invalid title "$1"!',
	// deleteBatch, moveBatch, perhaps others
	'maintenance-titlenoexist' => 'Title specified ("$1") does not exist!',
	// unsure
	'maintenance-failed' => 'FAILED',
	'maintenance-deleted' => 'DELETED',
	// deleteRevisions
	'maintenance-revdelete' => 'Deleting {{PLURAL:$3|revision|revisions}} $1 from wiki $2',
	'maintenance-revnotfound' => 'Revision $1 not found!',
	// showCacheStats
	'maintenance-showCacheStats-edits' => 'Number of edits: $1',
	'maintenance-showCacheStats-articles' => 'Number of pages in the main namespace: $1',
	'maintenance-showCacheStats-pages' => 'Number of pages: $1',
	'maintenance-showCacheStats-users' => 'Number of users: $1',
	'maintenance-showCacheStats-admins' => 'Number of admins: $1',
	'maintenance-showCacheStats-images' => 'Number of files: $1',
	'maintenance-showCacheStats-views' => 'Number of pageviews: $1',
	'maintenance-showCacheStats-update' => 'Updating database{{int:ellipsis}}',
	// moveBatch
	'maintenance-move' => 'Moving $1 to $2{{int:ellipsis}}',
	'maintenance-movefail' => 'Error encountered while moving: $1.
Aborting move',
	// unsure
	'maintenance-error' => 'Error: $1',
	// showCacheStats
	'maintenance-memc-fake' => 'You are running FakeMemCachedClient. No statistics can be provided',
	'maintenance-memc-requests' => 'Requests',
	'maintenance-memc-withsession' => 'with session:',
	'maintenance-memc-withoutsession' => 'without session:',
	'maintenance-memc-total' => 'total:',
	'maintenance-memc-parsercache' => 'Parser cache',
	'maintenance-memc-hits' => 'hits:',
	'maintenance-memc-invalid' => 'invalid:',
	'maintenance-memc-expired' => 'expired:',
	'maintenance-memc-absent' => 'absent:',
	'maintenance-memc-stub' => 'stub threshold:',
	'maintenance-memc-imagecache' => 'Image cache',
	'maintenance-memc-misses' => 'misses:',
	'maintenance-memc-updates' => 'updates:',
	'maintenance-memc-uncacheable' => 'uncacheable:',
	'maintenance-memc-diffcache' => 'Diff Cache',
	// reassignEdits
	'maintenance-reassignEdits' => 'Use this form to reassign edits from one user to another.',
	'maintenance-re-from' => 'Name of the user to assign edits from',
	'maintenance-re-to' => 'Name of the user to assign edits to',
	'maintenance-re-force' => 'Reassign even if the target user does not exist',
	'maintenance-re-rc' => 'Do not update the recent changes table',
	'maintenance-re-report' => 'Print out details of what would be changed, but do not update it',
	'maintenance-re-nf' => 'User $1 not found',
	'maintenance-re-rr' => 'Run the script again without "$1" to update.',
	'maintenance-re-ce' => 'Current edits: $1',
	'maintenance-re-de' => 'Deleted edits: $1',
	'maintenance-re-rce' => 'RecentChanges entries: $1',
	'maintenance-re-total' => 'Total entries to change: $1',
	'maintenance-re-re' => 'Reassigning edits{{int:ellipsis}} done',
);

/** Message documentation (Message documentation)
 * @author Darth Kule
 * @author EugeneZelenko
 * @author Fryed-peach
 * @author IAlex
 * @author Jon Harald Søby
 * @author Lloffiwr
 * @author Nemo bis
 * @author Purodha
 * @author Raymond
 * @author Ryan Schmidt
 * @author Shirayuki
 * @author Siebrand
 * @author The Evil IP address
 * @author Translationista
 * @author Umherirrender
 */
$messages['qqq'] = array(
	'maintenance' => 'Special page title and what is shown in [[Special:SpecialPages]]',
	'maintenance-desc' => '{{desc|name=Maintenance|url=http://www.mediawiki.org/wiki/Extension:Maintenance}}',
	'right-maintenance' => '{{doc-right|maintenance}}',
	'maintenance-backlink' => 'This text is shown in the link back to the list of runnable maintenance scripts',
	'maintenance-header' => 'This text is shown in the top of the list of runnable maintenance scripts, prompting the user to choose a script to run',
	'maintenance-error-badini' => 'Do not translate the <code>metadata.ini</code> part.',
	'maintenance-error-invalidtype' => 'Shown when the user tries to run a script that is disabled or that does not exist',
	'maintenance-error-badargs' => 'Shown when the user tries to run a script without filling in required text inputs, checkboxes, etc.',
	'maintenance-generic-done' => 'done',
	'maintenance-generic-username' => '{{Identical|Username}}',
	'maintenance-generic-password' => '{{Identical|Password}}',
	'maintenance-generic-reason' => '{{Identical|Reason}}',
	'maintenance-generic-notrans' => '{{notranslate}}',
	'maintenance-cleanupTable-dry-run' => 'Label for a checkbox indicating that the script will run, but will not fix anything (a "dry run")',
	'maintenance-cleanupTable-check' => 'Script output. "Titles" in this case refers to page names',
	'maintenance-cleanupTable-checkfix' => 'Script output. "Titles" in this case refers to page names',
	'maintenance-cleanupTable-progress' => 'Script output that shows the current progress.
* $1 is the wiki id
* $2 is the timestamp
* $3 is the portion done (percent)
* $4 is the SQL table name that is being worked on
* $5 is the ETA on when the script will finish
* $6 is the number of records processed
* $7 is the total number of records
* $8 is how many records are processed per second
* $9 is what percent of the records needed to be fixed',
	'maintenance-cleanupTable-missingparam' => 'Script output to show that an error occurred.
* $1 is the PHP method name that had the error
* $2 is the list of missing parameters (hardcoded in MediaWiki core\'s /maintenance/cleanupTables.inc to be seperated by a comma and a space, e.g. "param1, param2")',
	'maintenance-cleanupTable-processing' => 'Script output.
* $1 is the SQL table name',
	'maintenance-cleanupTable-finished' => 'Script output.
* $1 is the SQL table name
* $2 is the number of records that were fixed
* $3 is the number of records that were processed',
	'maintenance-option-quiet' => 'Label for a checkbox',
	'maintenance-option-globals' => 'Label for a checkbox',
	'maintenance-option-confirm' => '{{Identical|Confirm}}',
	'maintenance-option-batch-size' => 'Label for a text input shown when running a script that has a "batch mode", where a bulk of operations can be run in one script execution. $1 is the default batch size',
	'maintenance-option-required' => 'This message is currently not used in the extension.
{{Identical|Required}}',
	'maintenance-option-optional' => 'This message is currently not used in the extension',
	'maintenance-output-success' => 'Indicates a script ran successfully.
* $1 is the name of the script',
	'maintenance-output-failure' => 'Indicates a script did not run successfully.
* $1 is the name of the script',
	'maintenance-attachLatest' => 'Do not translate <code>page_latest</code>',
	'maintenance-attachLatest-desc' => 'Do not translate <code>page_latest</code>',
	'maintenance-attachLatest-option-fix' => 'Checkbox label. "dry run" refers to when the script is run and shows what needs to be fixed, but does not fix those items. Also called from {{msg-mw|maintenance-attachLatest-output-dryrun}} for the same context.',
	'maintenance-attachLatest-output-begin' => 'Do not translate <code>page_latest</code>',
	'maintenance-attachLatest-output-notime' => '* $1 is the wiki id (database name)
* $2 is the page id (number)
* $3 is the page name',
	'maintenance-attachLatest-output-norev' => '* $1 is the wiki id (database name)
* $2 is the page id (number)
* $3 is the page name
* $4 is the latest revision time of the page',
	'maintenance-attachLatest-output-found' => '* $1 is the wiki id (database name)
* $2 is the page id (number)
* $3 is the page name
* $4 is the latest revision time of the page
* $5 is the latest revision id (number)',
	'maintenance-attachLatest-output-done' => 'Parameters:
* $1 - the number of pages that were processed by this script
{{Identical|Done}}',
	'maintenance-attachLatest-output-dryrun' => 'Do not translate <code>page_latest</code>.',
	'maintenance-benchmarkPurge' => '"Squid" refers to the software that provides a reverse proxy cache to speed up the MediaWiki software. It is probably not translatable.',
	'maintenance-benchmarkPurge-desc' => '"Squid" refers to the software that provides a reverse proxy cache to speed up the MediaWiki software. It is probably not translatable. "Benchmark" refers to measuring how fast something is.',
	'maintenance-benchmarkPurge-option-count' => '"Squid" refers to the software that provides a reverse proxy cache to speed up the MediaWiki software. It is probably not translatable.',
	'maintenance-benchmarkPurge-error-nosquid' => '"Squid" refers to the software that provides a reverse proxy cache to speed up the MediaWiki software. It is probably not translatable.',
	'maintenance-benchmarkPurge-output-numsquids' => '"Squid" refers to the software that provides a reverse proxy cache to speed up the MediaWiki software. It is probably not translatable.
* $1 is the number of Squid servers',
	'maintenance-benchmarkPurge-output-trial' => '* $1 is the number of titles processed in the trial
* $2 is the total time of the trial in milliseconds
* $3 is the average time of each title in milliseconds',
	'maintenance-changePassword-desc' => 'Used as description',
	'maintenance-changePassword-option-user' => '{{notranslate}}',
	'maintenance-changePassword-option-password' => '{{notranslate}}',
	'maintenance-changePassword-error-nouser' => '*$1 - username',
	'maintenance-changePassword-output-set' => '*$1 - username',
	'maintenance-checkAutoLoader-desc' => 'Used as description',
	'maintenance-checkAutoLoader-output-list1' => '{{notranslate}}',
	'maintenance-checkBadRedirects-desc' => 'Used as description',
	'maintenance-checkBadRedirects-output-found' => '*$1 - number of redirects',
	'maintenance-checkBadRedirects-output-footer' => '{{Identical|Done}}',
	'maintenance-checkImages-desc' => 'Used as description',
	'maintenance-checkImages-output-good' => '*$1 - number of good images
*$2 - number of images',
	'maintenance-checkSyntax-desc' => 'Used as description',
	'maintenance-checkSyntax-option-with-extensions' => 'Used as option',
	'maintenance-checkSyntax-option-path' => 'Used as option',
	'maintenance-checkSyntax-option-list-file' => 'Used as option',
	'maintenance-checkSyntax-option-modified' => 'Used as option',
	'maintenance-checkSyntax-option-syntax-only' => 'Used as option',
	'maintenance-checkSyntax-output-footer' => '*$1 - number of files checked
*$2 - number of failures
*$3 - number of warnings',
	'maintenance-checkSyntax-output-done' => '{{notranslate}}',
	'maintenance-checkSyntax-output-error' => '*$1 - filename
*$2 - line number
*$3 - error message',
	'maintenance-checkSyntax-output-warning' => '*$1 - filename
*$2 - ...',
	'maintenance-checkSyntax-error-nofile' => '*$1 - name of file or directory',
	'maintenance-checkSyntax-error-cantopen' => '*$1 - filename',
	'maintenance-checkUsernames-desc' => 'Used as description',
	'maintenance-checkUsernames-error-notvalid' => '*$2 - user ID
*$3 - username',
	'maintenance-cleanupCaps-desc' => 'Used as description',
	'maintenance-cleanupCaps-option-dry-run' => '{{notranslate}}',
	'maintenance-cleanupCaps-option-namespace' => 'Used as option',
	'maintenance-cleanupCaps-output-moved' => '{{notranslate}}',
	'maintenance-cleanupCaps-output-check' => '{{notranslate}}',
	'maintenance-cleanupCaps-output-checkfix' => '{{notranslate}}',
	'maintenance-cleanupCaps-output-progress' => '{{notranslate}}',
	'maintenance-cleanupCaps-output-processing' => '{{notranslate}}',
	'maintenance-cleanupCaps-output-finished' => '{{notranslate}}',
	'maintenance-cleanupCaps-error-missingparam' => '{{notranslate}}',
	'maintenance-cleanupSpam-desc' => 'Used as description',
	'maintenance-cleanupSpam-output-found' => 'Parameters:
* $1 is a count for number of matches
* $2 is an external link that was spammed.',
	'maintenance-cleanupSpam-output-done' => '{{notranslate}}',
	'maintenance-cleanupSpam-error-invalid' => '*$1 - provided hostname',
	'maintenance-cleanupSpam-error-noid' => '*$1 - page ID',
	'maintenance-clearInterwikiCache-desc' => 'Used as description',
	'maintenance-clearInterwikiCache-done' => '{{notranslate}}',
	'maintenance-createAndPromote-desc' => 'Used as description',
	'maintenance-createAndPromote-option-username' => '{{notranslate}}',
	'maintenance-createAndPromote-option-password' => '{{notranslate}}',
	'maintenance-createAndPromote-output-creating' => 'Progress message from [[mw:Manual:createAndPromote.php|createAndPromote.php]], which creates a new user and auto-promotes them to sysop status.',
	'maintenance-createAndPromote-output-done' => '{{notranslate}}',
	'maintenance-createAndPromote-error-invalid' => '{{notranslate}}',
	'maintenance-createAndPromote-error-exists' => '{{notranslate}}',
	'maintenance-createAndPromote-error-password' => '$1 can be one of the following:
* {{msg-mw|password-change-forbidden}}
* {{msg-mw|passwordtooshort}}
* {{msg-mw|password-name-match}}
* {{msg-mw|password-login-forbidden}}
* {{msg-mw|externaldberror}}
* Anything returned by the [[mw:Manual:Hooks/isValidPassword|isValidPassword]] hook.',
	'maintenance-deleteBatch-desc' => 'Used as description',
	'maintenance-deleteRevision-desc' => 'Used as description',
	'maintenance-initEditCount' => '{{notranslate}}',
	'maintenance-initEditCount-desc' => 'Used as description',
	'maintenance-initSiteStats-desc' => 'Used as description',
	'maintenance-moveBatch-desc' => 'Used as description',
	'maintenance-reassignEdits-desc' => 'Used as description',
	'maintenance-runJobs' => '{{notranslate}}',
	'maintenance-runJobs-desc' => 'Used as description',
	'maintenance-runJobs-output-job' => '{{notranslate}}',
	'maintenance-showJobs' => '{{notranslate}}',
	'maintenance-showJobs-desc' => 'Used as description',
	'maintenance-showJobs-output-job' => '{{notranslate}}',
	'maintenance-sql-desc' => 'Used as description',
	'maintenance-sql-output-row' => '{{notranslate}}',
	'maintenance-sql-output-aff' => '* $1 is the number of records that were fixed',
	'maintenance-sql-error-sql' => '{{notranslate}}',
	'maintenance-showCacheStats' => '{{notranslate}}',
	'maintenance-showCacheStats-desc' => 'Used as description',
	'maintenance-eval-desc' => 'Used as description',
	'maintenance-update' => '{{doc-important|Do not translate "<code>UPDATE</code>", "<code>DELETE</code>" or "<code>INSERT</code>".}}
This message appears next to a checkbox.

"Unchecked" means that the checkbox has not been "checked".
Words having the same meaning as "checked" in this sentence are "marked", "ticked" and "selected".

This message is currently not used in this extension.',
	'maintenance-failed' => '{{Identical|Failed}}',
	'maintenance-deleted' => 'This message is currently not used in this extension.
{{Identical|Deleted}}',
	'maintenance-revdelete' => '* $1 is a list of revisions numbers
* $2 is the local wiki id (string containing database name and tables prefix, if any)

This message is currently not used in this extension.',
	'maintenance-error' => '{{Identical|Error}}',
	'maintenance-memc-total' => 'This message is currently not used in this extension.
{{Identical|Total}}',
	'maintenance-memc-hits' => 'This message is currently not used in this extension.
{{Identical|Hits}}',
	'maintenance-re-report' => 'Used as text for an option check box. Also substituted in {{msg-mw|maintenance-re-rr}}.

This message is currently not used in this extension.',
	'maintenance-re-nf' => '*$1 - username',
	'maintenance-re-rr' => '* $1 is substituted by {{msg-mw|maintenance-re-report}}

 This message is currently not used in this extension.',
);

/** Afrikaans (Afrikaans)
 * @author Arnobarnard
 * @author Naudefj
 */
$messages['af'] = array(
	'maintenance-generic-done' => 'uitgevoer',
	'maintenance-generic-username' => 'Gebruikersnaam',
	'maintenance-generic-password' => 'Wagwoord',
	'maintenance-generic-reason' => 'Rede',
	'maintenance-option-confirm' => 'Bevestig',
	'maintenance-option-required' => '(verpligtend)',
	'maintenance-option-optional' => '(opsioneel)',
	'maintenance-checkBadRedirects-output-footer' => 'Uitgevoer.',
	'maintenance-invalidname' => 'Ongeldige gebruikersnaam!',
	'maintenance-invalidtitle' => 'Ongeldige bladsynaam: "$1"!',
	'maintenance-deleted' => 'Geskrap',
	'maintenance-showCacheStats-edits' => 'Aantal wysigings: $1',
	'maintenance-showCacheStats-pages' => 'Aantal bladsye: $1',
	'maintenance-showCacheStats-users' => 'Aantal gebruikers: $1',
	'maintenance-showCacheStats-images' => 'Aantal lêers: $1',
	'maintenance-memc-total' => 'totaal:',
	'maintenance-memc-invalid' => 'ongeldig:',
	'maintenance-memc-absent' => 'afwesig:',
);

/** Aragonese (aragonés)
 * @author Juanpabl
 */
$messages['an'] = array(
	'maintenance-option-confirm' => 'Confirmar',
);

/** Arabic (العربية)
 * @author Meno25
 * @author OsamaK
 * @author Ouda
 */
$messages['ar'] = array(
	'maintenance' => 'تشغيل سكريبتات الصيانة',
	'maintenance-desc' => '[[Special:Maintenance|واجهة وب]] لسكربتات صيانة مختلفة',
	'right-maintenance' => 'تشغيل سكريبتات الصيانة من خلال [[Special:Maintenance]]',
	'maintenance-backlink' => 'الرجوع إلى اختيار السكريبت',
	'maintenance-header' => 'من فضلك اختر سكريبت بالأسفل للتنفيذ.
الوصوفات بجانب كل سكريبت',
	'maintenance-error-invalidtype' => 'السكريبت المحدد لم يتم العثور عليه',
	'maintenance-generic-username' => 'اسم المستخدم',
	'maintenance-generic-password' => 'كلمة السر',
	'maintenance-generic-reason' => 'السبب',
	'maintenance-option-confirm' => 'تأكيد',
	'maintenance-output-success' => '$1 عمل بنجاح!',
	'maintenance-changePassword' => 'استخدم هذه الاستمارة لتغيير كلمة السر لمستخدم',
	'maintenance-changePassword-desc' => 'غير كلمة السر لمستخدم',
	'maintenance-createAndPromote' => 'استخدم هذه الاستمارة لإنشاء مستخدم جديد وترقيته إلى مدير نظام.
علم على صندوق البيروقراط لو كنت ترغب في ترقيته إلى بيروقراط أيضا',
	'maintenance-createAndPromote-desc' => 'إنشاء مستخدم وترقية إلى حالة إداري',
	'maintenance-deleteBatch' => 'استخدم هذه الاستمارة لحذف الصفحات بشكل كمي.
ضع فقط صفحة واحدة في كل سطر',
	'maintenance-deleteBatch-desc' => 'حذف كمي للصفحات',
	'maintenance-deleteRevision' => 'استخدم هذه الاستمارة لحذف المراجعات بشكل كمي.
ضع فقط رقم مراجعة واحد في كل سطر',
	'maintenance-deleteRevision-desc' => 'إزالة المراجعات من قاعدة البيانات',
	'maintenance-initEditCount-desc' => 'إعادة حساب عدد التعديلات للمستخدمين',
	'maintenance-initSiteStats' => 'استخدم هذه الاستمارة لإعادة حساب إحصاءات الموقع، محددا ما إذا كنت ترغب في إعادة حساب مشاهدات الصفحات أيضا',
	'maintenance-initSiteStats-desc' => 'إعادة حساب إحصاءات الموقع',
	'maintenance-moveBatch' => 'استخدم هذه الاستمارة لنقل الصفحات بشكل كمي.
كل سطر ينبغي أن يحدد صفحة مصدر وصفحة هدف مفصولين ببايب',
	'maintenance-moveBatch-desc' => 'نقل كمي للصفحات',
	'maintenance-reassignEdits-desc' => 'إعادة إلحاق التعديلات من مستخدم إلى آخر',
	'maintenance-runJobs-desc' => 'تنفيذ الأشغال في طابور الشغل',
	'maintenance-showJobs-desc' => 'يعرض قائمة بالأشغال قيد الانتظار في طابور الشغل',
	'maintenance-sql' => 'على قاعدة البيانات SQL استعمل هذا النموذج لتنفيذ استعلام',
	'maintenance-sql-desc' => 'SQL نفذ استعلام',
	'maintenance-showCacheStats-desc' => 'عرض إحصاءات ميم كاشد',
	'maintenance-eval' => 'استخدم هذه الاستمارة لتقييم كود PHP في بيئة.',
	'maintenance-eval-desc' => 'في بيئة الميدياويكي PHP قيم كود',
	'maintenance-update' => 'استخدم UPDATE عند تحديث جدول غير المعلم يستخدم DELETE/INSERT بدلا من ذلك.',
	'maintenance-noviews' => 'علم على هذا لمنع تحديث عدد عرض الصفحات',
	'maintenance-invalidname' => 'اسم مستخدم غير صحيح!',
	'maintenance-userexists' => 'المستخدم موجود حاليا!',
	'maintenance-invalidtitle' => 'عنوان غير صحيح "$1"!',
	'maintenance-titlenoexist' => 'العنوان المحدد ("$1") غير موجود!',
	'maintenance-failed' => 'فشل',
	'maintenance-deleted' => 'تم حذفه',
	'maintenance-revdelete' => 'حذف {{PLURAL:$3|المراجعة|المراجعات}} $1 من الويكي $2',
	'maintenance-revnotfound' => 'المراجعة $1 لم يتم العثور عليها!',
	'maintenance-showCacheStats-edits' => 'عدد التعديلات: $1',
	'maintenance-showCacheStats-articles' => 'عدد الصفحات في النطاق الرئيسي: $1',
	'maintenance-showCacheStats-pages' => 'عدد الصفحات: $1',
	'maintenance-showCacheStats-users' => 'عدد المستخدمين: $1',
	'maintenance-showCacheStats-admins' => 'عدد الإداريين: $1',
	'maintenance-showCacheStats-images' => 'عدد الملفات: $1',
	'maintenance-showCacheStats-views' => 'عدد مرات عرض الصفحة: $1',
	'maintenance-showCacheStats-update' => 'جاري تحديث قاعدة البيانات...',
	'maintenance-move' => 'نقل $1 إلى $2...',
	'maintenance-movefail' => 'تمت مصادفة خطأ أثناء النقل: $1.
ترك النقل',
	'maintenance-error' => 'خطأ: $1',
	'maintenance-memc-fake' => 'أنت تشغل FakeMemCachedClient. لا إحصاءات يمكن توفيرها',
	'maintenance-memc-requests' => 'طلبات',
	'maintenance-memc-withsession' => 'مع جلسة:',
	'maintenance-memc-withoutsession' => 'بدون جلسة:',
	'maintenance-memc-total' => 'مجموع:',
	'maintenance-memc-parsercache' => 'كاش المحلل',
	'maintenance-memc-hits' => 'ضربات:',
	'maintenance-memc-invalid' => 'غير صحيح:',
	'maintenance-memc-expired' => 'انتهى:',
	'maintenance-memc-absent' => 'غائب:',
	'maintenance-memc-stub' => 'الحد للبذرة:',
	'maintenance-memc-imagecache' => 'كاش الصورة',
	'maintenance-memc-misses' => 'مفقودات:',
	'maintenance-memc-updates' => 'تحديثات:',
	'maintenance-memc-uncacheable' => 'لا يمكن تخزينه:',
	'maintenance-memc-diffcache' => 'كاش الفرق',
	'maintenance-reassignEdits' => 'استخدم هذه الاستمارة لإعادة إلحاق التعديلات من مستخدم إلى آخر.',
	'maintenance-re-from' => 'اسم المستخدم لإلحاق التعديلات منه',
	'maintenance-re-to' => 'اسم المستخدم لإلحاق التعديلات إليه',
	'maintenance-re-force' => 'أعد الإلحاق حتى لو كان المستخدم الهدف غير موجود',
	'maintenance-re-rc' => 'لا تحدث جدول أحدث التغييرات',
	'maintenance-re-report' => 'اطبع تفاصيل ما سيتم تغييره، لكن لا تحدثه',
	'maintenance-re-nf' => 'المستخدم $1 لم يتم العثور عليه',
	'maintenance-re-rr' => 'أعد تشغيل السكريبت مرة أخرى بدون "$1" للتحديث.',
	'maintenance-re-ce' => 'تعديلات حالية: $1',
	'maintenance-re-de' => 'تعديلات محذوفة: $1',
	'maintenance-re-rce' => 'مدخلات أحدث التغييرات: $1',
	'maintenance-re-total' => 'إجمالي المدخلات للتغيير: $1',
	'maintenance-re-re' => 'جاري إعادة إلحاق التعديلات... تم',
);

/** Aramaic (ܐܪܡܝܐ)
 * @author Basharh
 */
$messages['arc'] = array(
	'maintenance-deleted' => 'ܫܝܦܬ',
	'maintenance-showCacheStats-pages' => 'ܡܢܝܢܐ ܕܦܐܬܬ̈ܐ: $1',
	'maintenance-showCacheStats-users' => 'ܡܢܝܢܐ ܕܡܦܠܚܢ̈ܐ: $1',
	'maintenance-showCacheStats-admins' => 'ܡܢܝܢܐ ܕܡܕܒܪ̈ܢܐ: $1',
	'maintenance-showCacheStats-images' => 'ܡܢܝܢܐ ܕܠܦܦ̈ܐ: $1',
	'maintenance-error' => 'ܦܘܕܐ: $1',
	'maintenance-memc-invalid' => 'ܠܐ ܬܪܝܨܐ:',
	'maintenance-memc-updates' => 'ܚܘܕ̈ܬܐ:',
);

/** Egyptian Spoken Arabic (مصرى)
 * @author Ghaly
 * @author Meno25
 * @author Ouda
 */
$messages['arz'] = array(
	'maintenance' => 'تشغيل سكريبتات الصيانة',
	'maintenance-desc' => '[[Special:Maintenance|واجهة ويب]] لسكريبتات صيانة مختلفة',
	'right-maintenance' => 'تشغيل سكريبتات الصيانة من خلال [[Special:Maintenance]]',
	'maintenance-backlink' => 'الرجوع إلى اختيار السكريبت',
	'maintenance-header' => 'من فضلك اختر سكريبت بالأسفل للتنفيذ.
الوصوفات بجانب كل سكريبت',
	'maintenance-error-invalidtype' => 'نوع غير صحيح!', # Fuzzy
	'maintenance-option-confirm' => 'تأكيد',
	'maintenance-output-success' => '$1 عمل بنجاح!',
	'maintenance-changePassword' => 'استخدم هذه الاستمارة لتغيير كلمة السر لمستخدم',
	'maintenance-changePassword-desc' => 'غير كلمة السر ليوزر',
	'maintenance-createAndPromote' => 'استخدم هذه الإستمارة لإنشاء مستخدم جديد وترقيته إلى مدير نظام.
علم على صندوق البيروقراط لو كنت ترغب فى ترقيته إلى بيروقراط أيضا',
	'maintenance-createAndPromote-desc' => 'إنشاء يوزر وترقية لإدارى',
	'maintenance-deleteBatch' => 'استخدم هذه الإستمارة لحذف الصفحات بشكل كمى.
ضع فقط صفحة واحدة فى كل سطر',
	'maintenance-deleteBatch-desc' => 'حذف كمى للصفحات',
	'maintenance-deleteRevision' => 'استخدم هذه الإستمارة لحذف المراجعات بشكل كمى.
ضع فقط رقم مراجعة واحد فى كل سطر',
	'maintenance-deleteRevision-desc' => 'إزالة المراجعات من قاعدة البيانات',
	'maintenance-initEditCount-desc' => 'إعادة حساب عدد التعديلات لليوزرز',
	'maintenance-initSiteStats' => 'استخدم هذه الإستمارة لإعادة حساب إحصاءات الموقع، محددا ما إذا كنت ترغب فى إعادة حساب مشاهدات الصفحات أيضا',
	'maintenance-initSiteStats-desc' => 'إعادة حساب إحصاءات الموقع',
	'maintenance-moveBatch' => 'استخدم هذه الإستمارة لنقل الصفحات بشكل كمى.
كل سطر ينبغى أن يحدد صفحة مصدر وصفحة هدف مفصولين ببايب',
	'maintenance-moveBatch-desc' => 'نقل كمى للصفحات',
	'maintenance-reassignEdits-desc' => 'إعادة إلحاق التعديلات من مستخدم إلى آخر',
	'maintenance-runJobs-desc' => 'تنفيذ الأشغال فى طابور الشغل',
	'maintenance-showJobs-desc' => 'يعرض قائمة بالأشغال قيد الانتظار فى طابور الشغل',
	'maintenance-sql' => 'على قاعدة البيانات SQL استعمل هذا النموذج لتنفيذ استعلام.',
	'maintenance-sql-desc' => 'SQL نفذ استعلام',
	'maintenance-showCacheStats-desc' => 'عرض إحصاءات ميم كاشد',
	'maintenance-eval' => 'استخدم هذه الاستمارة لتقييم كود PHP فى بيئة.',
	'maintenance-eval-desc' => 'فى بيئة الميدياويكى PHP قيم كود',
	'maintenance-update' => 'استخدم UPDATE عند تحديث جدول غير المعلم يستخدم DELETE/INSERT بدلا من ذلك.',
	'maintenance-noviews' => 'علم على هذا لمنع تحديث عدد عرض الصفحات',
	'maintenance-invalidname' => 'اسم يوزر مش صحيح !',
	'maintenance-userexists' => 'اليوزر موجود  دلوقتى!',
	'maintenance-invalidtitle' => 'عنوان غير صحيح "$1"!',
	'maintenance-titlenoexist' => 'العنوان المحدد ("$1") غير موجود!',
	'maintenance-failed' => 'فشل',
	'maintenance-deleted' => 'تم حذفه',
	'maintenance-revdelete' => 'حذف {{PLURAL:$3|المراجعه|المراجعات}} $1 من الويكى $2',
	'maintenance-revnotfound' => 'المراجعة $1 لم يتم العثور عليها!',
	'maintenance-showCacheStats-edits' => 'عدد التعديلات: $1',
	'maintenance-showCacheStats-articles' => 'عدد الصفحات فى النطاق الرئيسي: $1',
	'maintenance-showCacheStats-pages' => 'عدد الصفحات: $1',
	'maintenance-showCacheStats-users' => 'عدد المستخدمين: $1',
	'maintenance-showCacheStats-admins' => 'عدد الإداريين: $1',
	'maintenance-showCacheStats-images' => 'عدد الملفات: $1',
	'maintenance-showCacheStats-views' => 'عدد مرات عرض الصفحة: $1',
	'maintenance-showCacheStats-update' => 'جارى تحديث قاعدة البيانات...',
	'maintenance-move' => 'نقل $1 إلى $2...',
	'maintenance-movefail' => 'تمت مصادفة خطأ أثناء النقل: $1.
ترك النقل',
	'maintenance-error' => 'خطأ: $1',
	'maintenance-memc-fake' => 'أنت تشغل FakeMemCachedClient. لا إحصاءات يمكن توفيرها',
	'maintenance-memc-requests' => 'طلبات',
	'maintenance-memc-withsession' => 'مع جلسة:',
	'maintenance-memc-withoutsession' => 'بدون جلسة:',
	'maintenance-memc-total' => 'مجموع:',
	'maintenance-memc-parsercache' => 'كاش المحلل',
	'maintenance-memc-hits' => 'ضربات:',
	'maintenance-memc-invalid' => 'غير صحيح:',
	'maintenance-memc-expired' => 'انتهى:',
	'maintenance-memc-absent' => 'غائب:',
	'maintenance-memc-stub' => 'الحد للبذرة:',
	'maintenance-memc-imagecache' => 'كاش الصورة',
	'maintenance-memc-misses' => 'مفقودات:',
	'maintenance-memc-updates' => 'تحديثات:',
	'maintenance-memc-uncacheable' => 'لا يمكن تخزينه:',
	'maintenance-memc-diffcache' => 'كاش الفرق',
	'maintenance-reassignEdits' => 'استخدم هذه الاستمارة لإعادة إلحاق التعديلات من مستخدم إلى آخر.',
	'maintenance-re-from' => 'اسم المستخدم لإلحاق التعديلات منه',
	'maintenance-re-to' => 'اسم المستخدم لإلحاق التعديلات إليه',
	'maintenance-re-force' => 'أعد الإلحاق حتى لو كان المستخدم الهدف غير موجود',
	'maintenance-re-rc' => 'لا تحدث جدول أحدث التغييرات',
	'maintenance-re-report' => 'اطبع تفاصيل ما سيتم تغييره، لكن لا تحدثه',
	'maintenance-re-nf' => 'المستخدم $1 غير موجود',
	'maintenance-re-rr' => 'أعد تشغيل السكريبت مرة أخرى بدون "$1" للتحديث.',
	'maintenance-re-ce' => '$1 : التعديلات الحالية',
	'maintenance-re-de' => '$1 : التعديلات المحذوفة',
	'maintenance-re-rce' => 'مدخلات أحدث التغييرات: $1',
	'maintenance-re-total' => 'إجمالى المدخلات للتغيير: $1',
	'maintenance-re-re' => 'جارى إعادة إلحاق التعديلات... تم',
);

/** Azerbaijani (azərbaycanca)
 * @author Cekli829
 */
$messages['az'] = array(
	'maintenance-generic-done' => 'heç biri',
	'maintenance-generic-username' => 'İstifadəçi adı',
	'maintenance-generic-password' => 'Parol',
	'maintenance-generic-reason' => 'Səbəb',
	'maintenance-option-confirm' => 'Təsdiq et',
	'maintenance-checkBadRedirects-output-footer' => '
Oldu.',
	'maintenance-deleted' => 'SİLİNİB',
	'maintenance-error' => 'Xəta: $1',
	'maintenance-memc-total' => 'ümumi:',
);

/** Bashkir (башҡортса)
 * @author Haqmar
 */
$messages['ba'] = array(
	'maintenance-invalidname' => 'Яңылыш ҡатнашыусы исеме!',
	'maintenance-userexists' => 'Ҡатнашыусы бар инде!',
	'maintenance-invalidtitle' => 'Хаталы исем "$1"!',
	'maintenance-titlenoexist' => 'Күрһәтелгән исем ("$1") юҡ!',
	'maintenance-failed' => 'УҢЫШҺЫҘ!',
	'maintenance-deleted' => 'ЮЙЫЛДЫ',
);

/** Belarusian (Taraškievica orthography) (беларуская (тарашкевіца)‎)
 * @author EugeneZelenko
 * @author Jim-by
 * @author Wizardist
 */
$messages['be-tarask'] = array(
	'maintenance' => 'Запуск скрыптоў падтрымкі',
	'maintenance-desc' => '[[Special:Maintenance|Вікі-інтэрфэйс]] для розных скрыптоў падтрымкі',
	'right-maintenance' => 'запуск скрыптоў падтрымкі праз [[Special:Maintenance]]',
	'maintenance-backlink' => 'Вярнуцца ў выбар скрыптоў',
	'maintenance-header' => 'Калі ласка, выберыце скрыпт для запуску.
Апісаньне знаходзіцца каля кожнага скрыпта',
	'maintenance-error-badini' => 'Файл metadata.ini пашкоджаны ці адсутнічае. Калі ласка, загрузіце зноў пашырэньне Maintenance',
	'maintenance-error-invalidtype' => 'Пазначаны скрыпт ня знойдзены',
	'maintenance-error-badargs' => 'Вы не пазначылі ўсе абавязковыя налады',
	'maintenance-generic-done' => 'зроблена',
	'maintenance-generic-username' => 'Імя ўдзельніка',
	'maintenance-generic-password' => 'Пароль',
	'maintenance-generic-reason' => 'Прычына',
	'maintenance-cleanupTable-dry-run' => 'Выканаць тэставы запуск',
	'maintenance-cleanupTable-check' => 'Праверка няслушных назваў…',
	'maintenance-cleanupTable-checkfix' => 'Праверка і выпраўленьне няслушных назваў…',
	'maintenance-cleanupTable-progress' => '$1 $2: $3% зроблена ў $4; ETA $5 [$6/$7] $8/сэк <$9% зьменена>',
	'maintenance-cleanupTable-missingparam' => '$1: адсутнічае парамэтар $2',
	'maintenance-cleanupTable-processing' => 'Апрацоўка $1…',
	'maintenance-cleanupTable-finished' => 'Скончана $1… $2 {{PLURAL:$2|радок з $3 зьменены|радкі з $3 зьмененыя|радкоў з $3 зьмененыя}}',
	'maintenance-option-quiet' => 'Паказваць толькі памылкі',
	'maintenance-option-globals' => 'Вывадзіць глябальныя зьменныя у канцы працэсу наладкі',
	'maintenance-option-confirm' => 'Пацьвердзіць',
	'maintenance-option-batch-size' => 'Запуск гэтых шматлікіх працэсаў у пакеце, па змоўчваньні: $1',
	'maintenance-option-required' => '(абавязкова)',
	'maintenance-option-optional' => '(неабавязкова)',
	'maintenance-output-success' => '$1 пасьпяхова запушчаны!',
	'maintenance-output-failure' => 'Не атрымалася запусьціць $1!',
	'maintenance-attachLatest' => 'Выкарыстоўвайце гэтую форму для выпраўленьня элемэнтаў табліцы старонак, дзе page_latest устаноўленае ў 0',
	'maintenance-attachLatest-desc' => 'Выправіць элемэнты page_latest у табліцы старонак',
	'maintenance-attachLatest-option-fix' => 'Сапраўды выпраўляць элемэнты, інакш запусьціць тэставы запуск',
	'maintenance-attachLatest-output-begin' => 'Пошук старонак з page_latest устаноўленым у 0…',
	'maintenance-attachLatest-output-notime' => '$1 $2 [[$3]] ня можа знайсьці час апошняй вэрсіі?!',
	'maintenance-attachLatest-output-norev' => '$1 $2 [[$3]] апошнім часам $4, немагчыма знайсьці ідэнтыфікатар вэрсіі',
	'maintenance-attachLatest-output-found' => '$1 $2 [[$3]] апошнім часам $4, ідэнтыфікатар вэрсіі $5',
	'maintenance-attachLatest-output-done' => 'Выканана! {{PLURAL:$1|Апрацаваная $1 старонка|Апрацаваныя $1 старонкі|Апрацаваныя $1 старонак}}.',
	'maintenance-attachLatest-output-dryrun' => 'Гэта быў тэставы запуск. Выканайце ізноў з «{{int:maintenance-attachLatest-option-fix}}» каб абнавіць page_latest.',
	'maintenance-benchmarkPurge' => 'Выкарыстоўвайце гэтую форму для праверкі колькасьці часу, які зоймуць функцыі ачысткі Squid',
	'maintenance-benchmarkPurge-desc' => 'Вымярэньне хуткасьці функцыяў ачысткі Squid',
	'maintenance-benchmarkPurge-option-count' => 'Колькі URL-адрасоў патрэбна для ачысткі Squid',
	'maintenance-benchmarkPurge-error-nosquid' => 'Вымярэньне хуткасьці ачысткі Squid не працуе без падтрымкі Squid.',
	'maintenance-benchmarkPurge-output-numsquids' => '{{PLURAL:$1|Вызначаны $1 сэрвэр Squid|Вызначаныя $1 сэрвэры Squid|Вызначаныя $1 сэрвэраў Squid}}:',
	'maintenance-benchmarkPurge-output-trial' => '$1 {{PLURAL:$1|назва|назвы|назваў}} у $2мс ($3мс кожная)',
	'maintenance-changePassword' => 'Выкарыстоўвайце гэтую форму для зьмены паролю ўдзельніка',
	'maintenance-changePassword-desc' => 'Зьмяніць пароль удзельніка',
	'maintenance-changePassword-error-nouser' => 'Удзельнік не існуе: $1',
	'maintenance-changePassword-output-set' => 'Пароль для $1 вызначаны',
	'maintenance-checkAutoLoader' => 'Выкарыстоўвайце гэтую форму для праверак слушнасьці ў AutoLoader',
	'maintenance-checkAutoLoader-desc' => 'Праверкі слушнасьці AutoLoader',
	'maintenance-checkAutoLoader-output-list2' => '$1: Няслушны файл: знойдзены ў $2, знаходзіцца ў сьпісе $3',
	'maintenance-checkBadRedirects' => 'Выкарыстоўвайце гэтую форму для таго, каб пабачыць ці сапраўды пазначаныя як перанакіравані ўсе перанакіравані',
	'maintenance-checkBadRedirects-desc' => 'Пошук няслушных перанакіраваньняў',
	'maintenance-checkBadRedirects-output-header' => 'Выбарка перанакіраваньняў…',
	'maintenance-checkBadRedirects-output-found' => 'Знойдзена $1 {{PLURAL:$1|перанакіраваньне|перанакіраваньні|перанакіраваньняў}}.
Шукаюцца няслушныя перанакіраваньні…',
	'maintenance-checkBadRedirects-output-footer' => 'Зроблена.',
	'maintenance-checkImages' => 'Выкарыстоўвайце гэтую форму, каб убачыць, якія выявы ў Вашай вікі пашкоджаныя',
	'maintenance-checkImages-desc' => 'Праверка выяваў на іх існаваньне, чытальнасьць і г. д.',
	'maintenance-checkImages-output-noaccess' => '$1: недаступны лякальна',
	'maintenance-checkImages-output-missing' => '$1: адсутнічае',
	'maintenance-checkImages-output-isdir' => '$1: дырэкторыя',
	'maintenance-checkImages-output-truncated' => '$1: скарочаныя, былі $2',
	'maintenance-checkImages-output-mismatch' => '$1: памер не супадае: у базе зьвестак — $2, фактычны — $3',
	'maintenance-checkImages-output-good' => 'Добрыя выявы: $1/$2',
	'maintenance-checkSyntax' => 'Выкарыстоўвайце гэтую форму для праверкі сынтаксісу ўсіх PHP-файлаў MediaWiki',
	'maintenance-checkSyntax-desc' => 'Праверыць сынтаксіс усіх PHP-файлаў MediaWiki',
	'maintenance-checkSyntax-option-with-extensions' => 'Таксама рэкурсыўна дырэкторыю пашырэньняў',
	'maintenance-checkSyntax-option-path' => 'Асобны шлях (файл ці дырэкторыя) для праверкі з абсалютным ці адносным шляхам да карэннай дырэкторыі гэтай MediaWiki',
	'maintenance-checkSyntax-option-list-file' => 'Сьпіс файлаў ці дырэкторыяў для праверкі',
	'maintenance-checkSyntax-option-modified' => 'Правяраць толькі файлы, якія зьмяняліся (патрабуе SVN-кліент каманднага радку)',
	'maintenance-checkSyntax-option-syntax-only' => 'Правяраць толькі слушнасьць сынтаксісу, прапускаць папярэджаньні стылю коду',
	'maintenance-checkSyntax-output-parsekit' => 'Праверка сынтаксісу (выкарыстоўваецца parsekit)',
	'maintenance-checkSyntax-output-phpl' => 'Праверка сынтаксісу (выкарыстоўваецца php -l, гэта можа цягнуцца доўгі час)',
	'maintenance-checkSyntax-output-footer' => 'Выканана! {{PLURAL:$1|Правераны $1 файл|Правераныя $1 файлы|Правераныя $1 файлаў}}, знойдзеныя $2 {{PLURAL:$2|памылка|памылкі|памылак}} і $3 {{PLURAL:$3|папярэджаньне|папярэджаньні|папярэджаньняў}}',
	'maintenance-checkSyntax-output-svnlist' => 'Атрыманьне сьпісу з Subversion…',
	'maintenance-checkSyntax-output-buildlist' => 'Стварэньне сьпісу файлаў…',
	'maintenance-checkSyntax-output-error' => 'Памылка ў $1, радок $2: $3',
	'maintenance-checkSyntax-output-warning' => 'Папярэджаньне ў файле $1: знойдзена $2',
	'maintenance-checkSyntax-error-nofile' => 'Памылка: немагчыма знайсьці файл ці дырэкторыю $1',
	'maintenance-checkSyntax-error-cantopen' => 'Немагчыма адкрыць файл $1',
	'maintenance-checkSyntax-error-svnerr' => 'Немагчыма атрымаць сьпіс з Subversion!',
	'maintenance-checkUsernames' => 'Выкарыстоўвайце гэтую форму, каб паказаць, якія імёны ўдзельнікаў зьяўляюцца няслушнымі ў выніку зьменаў канфігурацыі. Калі нічога не трапіла ў сьпіс пасьля запуску гэтага скрыпта, гэта азначае, што ўсе імёны ўдзельнікаў зьяўляюцца слушнымі',
	'maintenance-checkUsernames-desc' => 'Упэўніцеся, што база зьвестак зьяўляецца слушнай',
	'maintenance-checkUsernames-error-notvalid' => 'Няслушнае імя ўдзельніка: «$3» (ідэнтыфікатар удзельніка $2)',
	'maintenance-cleanupCaps' => 'Выкарыстоўвайце гэтую форму для выпраўленьня пашкоджаных старонак па прычыне зьмены $wgCapitalLinks',
	'maintenance-cleanupCaps-desc' => 'Скрыпт выпраўленьня спасылак, якія пачынаюцца з вялікіх літар',
	'maintenance-cleanupCaps-option-namespace' => 'Нумар прасторы назваў для выпраўленьня спасылак, якія пачынаюцца з вялікіх літар',
	'maintenance-cleanupCaps-output-islower' => '«$1» ужо пачынаецца з малой літары.',
	'maintenance-cleanupCaps-output-clash' => '«$1» прапушчаная; «$2» ужо існуе',
	'maintenance-cleanupCaps-output-dryrun' => '«$1» → «$2»: ТЭСТАВЫ ЗАПУСК, НЕ ПЕРАНЕСЕНАЯ',
	'maintenance-cleanupCaps-error-noneed' => '$wgCapitalLinks устаноўлены — няма неабходнасьці для ачысткі спасылак, якія пачынаюцца з малых літар.',
	'maintenance-cleanupSpam' => 'Выкарыстоўвайце гэтую форму, каб скасоўваць спамэрскія праўкі, у якіх утрымліваюцца вонкавыя спасылкі',
	'maintenance-cleanupSpam-desc' => 'Выдаліць увесь спам з дадзенага дамэну',
	'maintenance-cleanupSpam-option-hostname' => 'Дамэн, зь якога вядзецца спам-рассылка',
	'maintenance-cleanupSpam-output-found' => '{{PLURAL:$1|Знойдзены $1 артыкул, які ўтрымлівае|Знойдзеныя $1 артыкулы, якія ўтрымліваюць|Знойдзеныя $1 артыкулаў, якія ўтрымліваюць}} $2',
	'maintenance-cleanupSpam-output-false' => 'Аблуднае дапасаваньне',
	'maintenance-cleanupSpam-output-blanking' => 'ачышчаем',
	'maintenance-cleanupSpam-output-reverting' => 'адкочваем',
	'maintenance-cleanupSpam-error-invalid' => 'Няслушнае вызначэньне імя хосту: $1',
	'maintenance-cleanupSpam-error-noid' => 'Унутраная памылка: няма старонкі з ідэнтыфікатарам $1',
	'maintenance-clearInterwikiCache' => 'Гэтая форма служыць для поўнай ачысткі кэшу інтэрвікі',
	'maintenance-clearInterwikiCache-desc' => 'Ачысьціць кэш ад інтэрвікі-спасылак ва ўсіх мовах',
	'maintenance-createAndPromote' => 'Выкарыстоўвайце гэтую форму для стварэньня новага ўдзельніка з правамі адміністратара.
Пазначце поле ніжэй, каб зрабіць яго бюракратам',
	'maintenance-createAndPromote-desc' => 'Стварыць удзельнікам з правамі адміністратара',
	'maintenance-createAndPromote-option-bureaucrat' => 'Надаць удзельніку правы бюракрата',
	'maintenance-createAndPromote-output-creating' => 'Стварэньне і наданьне правоў {{ns:user}}:$2…',
	'maintenance-createAndPromote-error-password' => 'З уведзеным паролем адбылася памылка: $1',
	'maintenance-deleteBatch' => 'Выкарыстоўвайце гэтую форму для масавага выдаленьня старонак.
Пастаўце толькі адну назву старонкі ў кожны радок',
	'maintenance-deleteBatch-desc' => 'Масавае выдаленьне старонак',
	'maintenance-deleteRevision' => 'Выкарыстоўвайце гэтую форму для масавага выдаленьня вэрсіяў старонак.
Пастаўце толькі адну вэрсію ў кожны радок',
	'maintenance-deleteRevision-desc' => 'Выдаліць вэрсіі старонак з базы зьвестак',
	'maintenance-initEditCount-desc' => 'Пералічыць колькасьць рэдагаваньняў удзельнікаў',
	'maintenance-initSiteStats' => 'Выкарыстоўвайце гэтую форму для перападліку статыстыкі сайта. Пазначце, калі Вы таксама жадаеце перападлічыць прагляд старонак',
	'maintenance-initSiteStats-desc' => 'Пералічыць статыстыку сайта',
	'maintenance-moveBatch' => 'Выкарыстоўвайце гэтую форму для масавага пераносу старонак.
У кожным радку павінна быць крынічная старонка і мэтавая старонка, падзеленыя сымбалем «|»',
	'maintenance-moveBatch-desc' => 'Масавы перанос старонак',
	'maintenance-reassignEdits-desc' => 'Пераназначыць рэдагаваньні ад аднаго ўдзельніка да іншага',
	'maintenance-runJobs-desc' => 'Выканаць заданьні з чаргі заданьняў',
	'maintenance-runJobs-option-maxjobs' => 'Максымальная колькасьць задачаў для запуску',
	'maintenance-runJobs-option-type' => 'Тыпы задачаў для запуску',
	'maintenance-runJobs-option-procs' => 'Колькасьць працэсаў для выкарыстаньня',
	'maintenance-runJobs-option-exclusive' => 'Запусьціць толькі адзін асобны скрыпт runJobs ў гэты час. Затрымка 1800 сэкундаў.',
	'maintenance-runJobs-error-invalidprocs' => 'Вы павінны падаць колькасьць працэсаў паміж 1 і 1000',
	'maintenance-showJobs-desc' => 'Паказаць сьпіс заданьняў з чаргі заданьняў',
	'maintenance-showJobs-option-group' => 'Паказваць колькасьць задачаў па іх тыпам',
	'maintenance-sql' => 'Выкарыстоўвайце гэтую форму для выкананьня SQL-запыту ў базе зьвестак.',
	'maintenance-sql-desc' => 'Выканаць SQL-запыт',
	'maintenance-sql-option-file' => 'SQL для выкананьня',
	'maintenance-sql-output-aff' => 'Запыт пасьпяховы, $1 {{PLURAL:$1|радок пашкоджаны|радкі пашкоджаныя|радкоў пашкоджаныя}}',
	'maintenance-sql-error-cantopen' => 'Немагчыма адкрыць уваходны файл',
	'maintenance-showCacheStats-desc' => 'Паказаць статыстыку Memcached',
	'maintenance-eval' => 'Выкарыстоўвайце гэтую форму для тэставаньня PHP-коду ў асяродзьдзі MediaWiki.',
	'maintenance-eval-desc' => 'Праверыць РНР код у асяродзьдзі MediaWiki',
	'maintenance-update' => 'Выкарыстоўвайце UPDATE для абнаўленьня табліцы? Паспрабуйце выкарыстоўваць замест гэтага DELETE/INSERT.',
	'maintenance-noviews' => 'Пазначце гэта, каб не абнаўляць колькасьць праглядаў старонак',
	'maintenance-invalidname' => 'Няслушнае імя ўдзельніка!',
	'maintenance-userexists' => 'Удзельнік ужо існуе!',
	'maintenance-invalidtitle' => 'Няслушная назва «$1»!',
	'maintenance-titlenoexist' => 'Пазначаная назва («$1») не існуе!',
	'maintenance-failed' => 'НЕ АТРЫМАЛАСЯ',
	'maintenance-deleted' => 'ВЫДАЛЕНА',
	'maintenance-revdelete' => 'Выдаленьне {{PLURAL:$3|вэрсіі|вэрсіяў}} $1 з вікі $2',
	'maintenance-revnotfound' => 'Вэрсія $1 ня знойдзена!',
	'maintenance-showCacheStats-edits' => 'Колькасьць рэдагаваньняў: $1',
	'maintenance-showCacheStats-articles' => 'Колькасьць старонак у асноўнай прасторы назваў: $1',
	'maintenance-showCacheStats-pages' => 'Колькасьць старонак: $1',
	'maintenance-showCacheStats-users' => 'Колькасьць удзельнікаў: $1',
	'maintenance-showCacheStats-admins' => 'Колькасьць адміністратараў: $1',
	'maintenance-showCacheStats-images' => 'Колькасьць файлаў: $1',
	'maintenance-showCacheStats-views' => 'Колькасьць праглядаў старонак: $1',
	'maintenance-showCacheStats-update' => 'Абнаўленьня базы зьвестак...',
	'maintenance-move' => 'Перанос $1 у $2...',
	'maintenance-movefail' => 'Узьнікла памылка пад час пераносу: $1.
Перанос адменены',
	'maintenance-error' => 'Памылка: $1',
	'maintenance-memc-fake' => 'Вы запусьцілі FakeMemCachedClient. Немагчыма атрымаць ніякай статыстыкі',
	'maintenance-memc-requests' => 'Запыты',
	'maintenance-memc-withsession' => 'з сэансам:',
	'maintenance-memc-withoutsession' => 'без сэансу:',
	'maintenance-memc-total' => 'усяго:',
	'maintenance-memc-parsercache' => 'Кэш парсэра',
	'maintenance-memc-hits' => 'трапляньняў:',
	'maintenance-memc-invalid' => 'няслушных:',
	'maintenance-memc-expired' => 'састарэўшых:',
	'maintenance-memc-absent' => 'адсутнічае:',
	'maintenance-memc-stub' => 'памер накіду:',
	'maintenance-memc-imagecache' => 'Кэш выяваў',
	'maintenance-memc-misses' => 'не трапіла:',
	'maintenance-memc-updates' => 'абнаўленьняў:',
	'maintenance-memc-uncacheable' => 'некэшаваных:',
	'maintenance-memc-diffcache' => 'Кэш параўнаньняў вэрсіяў',
	'maintenance-reassignEdits' => 'Выкарыстоўвайце гэтую форму для перадачы рэдагаваньняў ад аднаго ўдзельніка да іншага.',
	'maintenance-re-from' => 'Імя ўдзельніка для перадачы рэдагаваньняў да іншага',
	'maintenance-re-to' => 'Імя ўдзельніка для перадачы рэдагаваньняў ад іншага',
	'maintenance-re-force' => 'Перадаць, нават калі мэтавы ўдзельнік не існуе',
	'maintenance-re-rc' => 'Не абнаўляць табліцу апошніх зьменаў',
	'maintenance-re-report' => 'Вывесьці падрабязнасьці пра тое, што павінна быць зьменена, але без абнаўленьня',
	'maintenance-re-nf' => '{{GENDER:$1|Удзельнік $1 ня знойдзены|Удзельніца $1 ня знойдзеная}}',
	'maintenance-re-rr' => 'Зноў запусьціць скрыпт без «$1» для абнаўленьня.',
	'maintenance-re-ce' => 'Цяперашнія рэдагаваньні: $1',
	'maintenance-re-de' => 'Выдаленыя рэдагаваньні: $1',
	'maintenance-re-rce' => 'Запісы апошніх зьменаў: $1',
	'maintenance-re-total' => 'Усяго элемэнтаў для зьмены: $1',
	'maintenance-re-re' => 'Перадача рэдагаваньняў... выкананая',
);

/** Bulgarian (български)
 * @author DCLXVI
 */
$messages['bg'] = array(
	'maintenance' => 'Пускане на скриптове за поддръжка',
	'maintenance-desc' => '[[Special:Maintenance|Уеб интерфейс]] за различни скриптове за поддръжка',
	'maintenance-backlink' => 'Връщане към избора на скрипт',
	'maintenance-error-invalidtype' => 'Невалиден тип!', # Fuzzy
	'maintenance-generic-username' => 'Потребителско име',
	'maintenance-generic-password' => 'Парола',
	'maintenance-generic-reason' => 'Причина',
	'maintenance-option-confirm' => 'Потвърждаване',
	'maintenance-output-success' => '$1 беше изпълнен успешно!',
	'maintenance-changePassword' => 'Формулярът по-долу се използва за промяна на паролата на потребител',
	'maintenance-changePassword-desc' => 'Променяне на потребителска парола',
	'maintenance-checkBadRedirects-output-footer' => 'Готово.',
	'maintenance-createAndPromote' => 'Следният формуляр служи за създаване на нов потребител и предоставянето му на администраторски права.
Поставянето на отметка ще добави и права на бюрократ.',
	'maintenance-createAndPromote-desc' => 'Създаване на потребител и даване на администраторски права',
	'maintenance-deleteBatch' => 'Този формуляр служи за масово изтриване на страници.
Всеки ред трябва да съдържа по една страница',
	'maintenance-deleteBatch-desc' => 'Масово изтриване на страници',
	'maintenance-deleteRevision' => 'Този формуляр служи за масово изтриване на версии.
Всеки ред трябва да съдържа по един номер на версия',
	'maintenance-deleteRevision-desc' => 'Премахване на версии от базата от данни',
	'maintenance-initEditCount-desc' => 'Преизчисляване на броя редакции, направени от потребителите',
	'maintenance-initSiteStats-desc' => 'Опресняване на статистиките на сайта',
	'maintenance-moveBatch' => 'Този формуляр служи за масово преместване на страници.
Всеки ред трябва да съдържа основна страница и целева страница, разделени с отвесна черта',
	'maintenance-moveBatch-desc' => 'Масово преместване на страници',
	'maintenance-update' => 'Използване на UPDATE при обновяване на таблиците? Без отметка се използва DELETE/INSERT.',
	'maintenance-noviews' => 'Поставянето на отметка ще спре обновяването на броя прегледи на страниците',
	'maintenance-invalidname' => 'Невалидно потребителско име!',
	'maintenance-userexists' => 'Този потребител вече съществува!',
	'maintenance-invalidtitle' => 'Невалидно заглавие „$1“!',
	'maintenance-titlenoexist' => 'Посоченото заглавие („$1“) не съществува!',
	'maintenance-revdelete' => 'Изтриване на версии $1 от уики $2', # Fuzzy
	'maintenance-revnotfound' => 'Версия $1 не беше намерена!',
	'maintenance-showCacheStats-edits' => 'Брой редакции: $1',
	'maintenance-showCacheStats-articles' => 'Брой страници в основното именно пространство: $1',
	'maintenance-showCacheStats-pages' => 'Брой страници: $1',
	'maintenance-showCacheStats-users' => 'Брой потребители: $1',
	'maintenance-showCacheStats-admins' => 'Брой администратори: $1',
	'maintenance-showCacheStats-images' => 'Брой файлове: $1',
	'maintenance-showCacheStats-views' => 'Брой прегледи на страниците: $1',
	'maintenance-showCacheStats-update' => 'Обновяване на базата от данни...',
	'maintenance-move' => 'Преместване на $1 като $2...',
	'maintenance-movefail' => 'Възникна грешка при преместване: $1.
Прекратяване на преместването.',
	'maintenance-error' => 'Грешка: $1',
	'maintenance-memc-requests' => 'Заявки',
	'maintenance-memc-withsession' => 'със сесия:',
	'maintenance-memc-withoutsession' => 'без сесия:',
	'maintenance-memc-total' => 'общо:',
	'maintenance-re-ce' => 'Текущи редакции: $1',
	'maintenance-re-de' => 'Изтрити редакции: $1',
);

/** Bengali (বাংলা)
 * @author Ehsanulhb
 * @author Wikitanvir
 */
$messages['bn'] = array(
	'maintenance-error-badargs' => 'আপনি সকল বাধ্যতামূলক অপশন উল্লেখ করেননি',
	'maintenance-generic-done' => 'সম্পন্ন',
	'maintenance-generic-username' => 'ব্যবহারকারী নাম',
	'maintenance-generic-password' => 'শব্দচাবি',
	'maintenance-generic-reason' => 'কারণ',
	'maintenance-cleanupTable-processing' => '$1 প্রক্রিয়াকরণ করা হচ্ছে...',
	'maintenance-option-confirm' => 'নিশ্চিত করুন',
	'maintenance-option-required' => '(বাধ্যতামূলক)',
	'maintenance-option-optional' => '(ঐচ্ছিক)',
	'maintenance-output-success' => '$1 সফলভাবে চালু হয়েছিলো!',
	'maintenance-output-failure' => '$1 সফলভাবে চালু হয়নি!',
	'maintenance-changePassword-desc' => 'ব্যবহারকারীর শব্দচাবি পরিবর্তন করুন',
	'maintenance-changePassword-error-nouser' => '"$1" নামে কোন ব্যবহারকারী নেই।',
	'maintenance-changePassword-output-set' => '$1-এর জন্য শব্দচাবি ঠিক করা হয়েছে',
	'maintenance-checkBadRedirects-output-header' => 'পুনর্নির্দেশনার আনা হচ্ছে...',
	'maintenance-checkBadRedirects-output-footer' => 'নিষ্পন্ন হয়েছে।',
	'maintenance-checkImages-output-noaccess' => '$1:  স্থানীয়ভাবে প্রবেশ করা সম্ভব নয়',
	'maintenance-checkImages-output-missing' => '$1: হারানো গেছে',
	'maintenance-checkImages-output-isdir' => '$1: একটি ডিরেক্টরি',
	'maintenance-checkImages-output-good' => 'ভালো চিত্রসমূহ: $1/$2',
	'maintenance-failed' => 'ব্যর্থ',
	'maintenance-deleted' => 'অপসারিত',
	'maintenance-error' => 'ত্রুটি: $1',
	'maintenance-memc-requests' => 'অনুরোধ',
	'maintenance-memc-withsession' => 'সেশনসহ:',
	'maintenance-memc-withoutsession' => 'সেশন ছাড়া:',
	'maintenance-memc-total' => 'সর্বমোট:',
	'maintenance-memc-parsercache' => 'পার্সার ক্যাশে',
	'maintenance-memc-hits' => 'হিট:',
	'maintenance-memc-invalid' => 'ত্রুটিপূর্ণ:',
	'maintenance-memc-expired' => 'মেয়াদোত্তীর্ণ হবে:',
	'maintenance-memc-absent' => 'অনুপস্থিত',
	'maintenance-memc-imagecache' => 'চিত্র ক্যাশে',
	'maintenance-memc-misses' => 'হারানো:',
	'maintenance-memc-updates' => 'হালনাগাদ:',
	'maintenance-memc-diffcache' => 'পার্থক্য ক্যাশে',
);

/** Breton (brezhoneg)
 * @author Fohanno
 * @author Fulup
 * @author Y-M D
 */
$messages['br'] = array(
	'maintenance' => 'Lañsañ ar skriptoù kas en-dro',
	'maintenance-desc' => '[[Special:Maintenance|Etrefas Wiki]] evit skriptoù kas en-dro a-bep seurt',
	'right-maintenance' => 'Lañsañ ar skriptoù kas en-dro adalek [[Special:Maintenance]]',
	'maintenance-backlink' => 'Distreiñ da zibab ar skript',
	'maintenance-header' => 'Mar plij dibabit ur skript da seveniñ, amañ da-heul.
An diskrivadurioù a vez goude pep hini anezho.',
	'maintenance-error-invalidtype' => "N'eo ket bet kavet ar skript meneget",
	'maintenance-error-badargs' => "N'hoc'h eus ket spisaet an holl dibarzhioù rekis",
	'maintenance-generic-done' => 'graet',
	'maintenance-generic-username' => 'Anv implijer',
	'maintenance-generic-password' => 'Ger-tremen',
	'maintenance-generic-reason' => 'Abeg',
	'maintenance-cleanupTable-dry-run' => 'Kas un tremen da benn hep kemmañ an diaz roadennoù',
	'maintenance-cleanupTable-check' => 'O wiriañ an titiloù fall...',
	'maintenance-cleanupTable-checkfix' => 'O wiriañ hag o kempenn an titloù fall...',
	'maintenance-cleanupTable-progress' => '$1 $2 : $3% graet dwar $4; ETA $5 [$6/$7] $8/sec <$9% hizivaet>',
	'maintenance-cleanupTable-missingparam' => '$1: Arventenn a vank $2',
	'maintenance-cleanupTable-processing' => 'O plediñ gant $1...',
	'maintenance-cleanupTable-finished' => 'Echuet $1... $2 diwar $3 {{PLURAL:$3|linenn}} hizivaet',
	'maintenance-option-confirm' => 'Kadarnaat',
	'maintenance-option-required' => '(rekis)',
	'maintenance-option-optional' => '(diret)',
	'maintenance-output-success' => '$1 zo aet da benn vat !',
	'maintenance-output-failure' => "N'eus ket gallet $1 treiñ evel ma oa dleet !",
	'maintenance-attachLatest' => 'Grit gant ar furmskrid-mañ da reizhañ an enmontoù en daolenn "pajenn" m\'eo termenet page_latest da 0',
	'maintenance-attachLatest-desc' => 'Reizhañ an enmontoù page_latest en daolenn "pajenn"',
	'maintenance-attachLatest-option-fix' => 'Reizhañ ar monedoù da vat, a-hend-all ne ziskouezo nemet ar monedoù faziek hep o reizhañ',
	'maintenance-attachLatest-output-begin' => 'O klask pajennoù gant page_latest lakaet da 0...',
	'maintenance-attachLatest-output-notime' => '$1 $2 [[$3]] dibosupl kavour deiziad an adweladenn ziwezhañ ?!',
	'maintenance-attachLatest-output-norev' => "$1 $2 [[$3]] deiziad dizezhañ $4, n'haller ket kavout anaouder an adweladenn",
	'maintenance-attachLatest-output-found' => '$1 $2 [[$3]] deiziad an adweladenn ziwezhañ $4, anaoueder an adweladenn $5',
	'maintenance-attachLatest-output-done' => 'Echu ! Pledet ez eus bet gant $1 pajenn.', # Fuzzy
	'maintenance-benchmarkPurge-output-numsquids' => 'Termenet ez eus $1 servijer Squid :', # Fuzzy
	'maintenance-benchmarkPurge-output-trial' => '$1 titl e $2ms ($3ms pep hini)', # Fuzzy
	'maintenance-changePassword' => 'Implijout ar furmskrid-mañ da cheñch ger-tremen un implijer',
	'maintenance-changePassword-desc' => 'Cheñch ger-tremen un implijer',
	'maintenance-changePassword-error-nouser' => 'Implijer ebet evel hemañ : $1',
	'maintenance-changePassword-output-set' => 'Ger-tremen termenet evit $1',
	'maintenance-checkAutoLoader-output-list2' => '$1 : restr fall : kavet e $2, rollet e $3',
	'maintenance-checkBadRedirects' => 'Ober gant ar furmskrid-mañ da welet hag adkasoù gwir zo eus ar pajennoù merket evel adkasoù',
	'maintenance-checkBadRedirects-desc' => 'Klask adkasoù fall',
	'maintenance-checkBadRedirects-output-header' => "Oc'h adtapout an adkasoù",
	'maintenance-checkBadRedirects-output-found' => 'Kavez ez eus bet $1 adkas.
O wiriañ an adkasoù fall...', # Fuzzy
	'maintenance-checkBadRedirects-output-footer' => '
Graet.',
	'maintenance-checkImages' => 'Ober gant ar furmskrid-mañ da welet peseurt skeudennoù zo brein war ho servijer', # Fuzzy
	'maintenance-checkImages-desc' => 'Gwiriañ ar skeudennoù da welet hag-eñ ez eus anezho, hag-eñ ez int lennus, h.a.',
	'maintenance-checkImages-output-noaccess' => "$1: n'eo ket hegerz ent lec'hel",
	'maintenance-checkImages-output-missing' => '$1: ezvezant',
	'maintenance-checkImages-output-isdir' => "$1: ur c'havlec'h eo",
	'maintenance-checkImages-output-truncated' => '$1 : krennet, a oa $2',
	'maintenance-checkImages-output-mismatch' => '$1: ment disklot diaz roadennoù =$2, bremañ =$3',
	'maintenance-checkImages-output-good' => 'Skeudennoù mat : $1/$2',
	'maintenance-checkSyntax' => 'Grit gant ar furmskrid-mañ da wiriañ ereadurezh an holl restroù PHP e MediaWiki',
	'maintenance-checkSyntax-desc' => 'Gwiriañ ereadur an holl restroù PHP e MediaWiki',
	'maintenance-checkSyntax-option-with-extensions' => 'Mont ivez dre renkell an astennoù',
	'maintenance-checkSyntax-option-list-file' => "Roll ar restroù pe kavlec'hioù da vezañ gwiriet",
	'maintenance-checkSyntax-output-parsekit' => 'O wiriañ an ereadurezh (en ur ober gant parsekit)',
	'maintenance-checkSyntax-output-footer' => "Echu ! $1 restr gwiriet, $2 c'hwitet ha $3 kemenn diwall kavet",
	'maintenance-checkSyntax-output-svnlist' => "Oc'h adtapout a roll digant Subversion...",
	'maintenance-checkSyntax-output-buildlist' => 'O sevel roll ar restroù...',
	'maintenance-checkSyntax-output-error' => 'Fazi e $1, linenn $2 : $3',
	'maintenance-checkSyntax-output-warning' => 'Kemenn diwall er restr $1 : $2 kavet',
	'maintenance-checkSyntax-error-nofile' => "Fazio : ar restr pe ar c'havlec'h $1 n'hall ket bezañ kavet",
	'maintenance-checkSyntax-error-cantopen' => "Ar restr $1 n'hall ket bezañ digoret",
	'maintenance-checkSyntax-error-svnerr' => 'Fazi en ur adtapout ar roll digant Subversion !',
	'maintenance-checkUsernames-desc' => 'Gwiriañ eo mat anvioù implijer an diaz roadennoù',
	'maintenance-checkUsernames-error-notvalid' => 'Anv implijer faziek: "$3" (Implijer ID $2)',
	'maintenance-cleanupCaps-output-islower' => 'Skrivet eo "$1" gant lizherennoù bihan dija.',
	'maintenance-cleanupCaps-output-dryrun' => '"$1" -> "$2": MOD AMPROUIÑ, N\'EO KET BET DILEC\'HIET',
	'maintenance-cleanupSpam-error-noid' => 'Fazi diabarzh : pajenn ebet evit an ID $1',
	'maintenance-createAndPromote' => "Implijit ar furmskrid-mañ evit krouiñ un implijer nevez ha lakaat anezhañ da verour.
Askit al log bureviad ma fell deoc'h reiñ dezhañ ar statud-se ivez.",
	'maintenance-createAndPromote-desc' => "Krouiñ un implijer hag uhelaat d'ar statud merour",
	'maintenance-createAndPromote-option-bureaucrat' => "Grataat ar statud Bureviad d'an implijer",
	'maintenance-deleteBatch' => 'Implijit ar furmskrid-mañ da zilemel pajennoù a-zruilh.
Lakait ur bajenn hepken dre linenn',
	'maintenance-deleteBatch-desc' => "Dilemel pajennoù a-yoc'h",
	'maintenance-deleteRevision' => 'Implijit ar furmskrid-mañ evit lemel a-vras stummoù.
Merkit ur stumm hepken dre linenn.',
	'maintenance-deleteRevision-desc' => 'Lemel adweladennoù eus an diaz roadennoù',
	'maintenance-initEditCount-desc' => 'Adjediñ konter kemmoù an implijerien',
	'maintenance-initSiteStats' => "Implijit ar furmskrid-mañ evit adjediñ stadegoù al lec'hienn, en ul lavarout ma fell deoc'h adjediñ an niver a weladennoù dre bajenn.",
	'maintenance-initSiteStats-desc' => "Adjediñ stadegoù al lec'hienn",
	'maintenance-moveBatch' => "Implijit ar furmskrid-mañ evit dilerc'hiañ pajennoù a-vras.
E pep linenn e rankimp kaout ar bajenn orin hag ar bajenn da dizhout dispartiet gant ur varenn (“|”)",
	'maintenance-moveBatch-desc' => "Dilec'hiañ pajennoù a-yoc'h",
	'maintenance-reassignEdits-desc' => "Addeverkañ kemmoù un implijer d'unan all",
	'maintenance-runJobs-desc' => "Lañsañ an trevelloù e roll ar re zo d'ober",
	'maintenance-runJobs-option-maxjobs' => 'Niver brasañ a drevelloù da seveniñ',
	'maintenance-runJobs-option-type' => 'Seurt trevell da seveniñ',
	'maintenance-showJobs-desc' => "Diskwel ur roll eus an trevelloù red e roll ar re d'ober",
	'maintenance-showJobs-option-group' => 'Diskwel an niver a drevelloù dre seurtoù trevelloù',
	'maintenance-sql' => 'Implijout ar furmskrid-mañ da seveniñ ur reked SQL war an diaz roadennoù.',
	'maintenance-sql-desc' => 'Seveniñ ur reked SQL',
	'maintenance-sql-option-file' => 'SQL da erounit',
	'maintenance-sql-output-aff' => 'Goulenn OK; sellet a ra ouzh $1 {{PLURAL:$1|enmont|enmont}}',
	'maintenance-sql-error-cantopen' => 'Dibosupl digeriñ ar restr moned',
	'maintenance-showCacheStats-desc' => 'Diskouez stadegoù ar grubuilh',
	'maintenance-eval' => "Ober gant ar furmskrid-mañ evit prizañ ar c'hod PHP en endro MediaWiki.",
	'maintenance-eval-desc' => "Priziañ ur c'hod PHP en endro MediaWiki",
	'maintenance-update' => 'Ha c\'hoant hoc\'h eus da implijout an doare "UPDATE" evit hizivaat war-eeun un daolenn? Diaskit an dibarzh evit implijout kentoc\'h "DELETE/INSERT" e plas.',
	'maintenance-noviews' => 'Askit kement-mañ evit enebiñ ouzh hizivadenn an niver a weladennoù evit ar pajennoù.',
	'maintenance-invalidname' => 'Anv implijer fall !',
	'maintenance-userexists' => "An implijer-mañ zo anezhañ c'hoazh !",
	'maintenance-invalidtitle' => 'Titl fall "$1" !',
	'maintenance-titlenoexist' => 'N\'eus ket eus an titl bet lakaet ("$1") !',
	'maintenance-failed' => "C'HWITET",
	'maintenance-deleted' => 'DILAMET',
	'maintenance-revdelete' => 'Dilemel an {{PLURAL:$3|adweladenn|adweladennoù}} $1 eus ar wiki $2',
	'maintenance-revnotfound' => "N'eo ket bet adkavet an adweladenn $1 !",
	'maintenance-showCacheStats-edits' => 'Niver a gemmoù : $1',
	'maintenance-showCacheStats-articles' => 'Niver a bajennoù en esaouenn bennañ : $1',
	'maintenance-showCacheStats-pages' => 'Niver a bajennoù : $1',
	'maintenance-showCacheStats-users' => 'Niver a implijerien : $1',
	'maintenance-showCacheStats-admins' => 'Niver a verourien : $1',
	'maintenance-showCacheStats-images' => 'Niver a restroù : $1',
	'maintenance-showCacheStats-views' => 'Niver a bajennoù gwelet : $1',
	'maintenance-showCacheStats-update' => "Oc'h hizivaat an diaz roadennoù{{int:ellipsis}}",
	'maintenance-move' => "Dilec'hiañ $1 da $2{{int:ellipsis}}",
	'maintenance-movefail' => "Ur fazi zo bet e-pad an adenvel : $1.
Harzet eo bet an dilec'hiañ.",
	'maintenance-error' => 'Fazi : $1',
	'maintenance-memc-fake' => "Emaoc'h oc'h implijout FakeMemCachedClient. Ne vo ket tu kaout a stadegoù.",
	'maintenance-memc-requests' => 'Rekedoù',
	'maintenance-memc-withsession' => "gant an dalc'h :",
	'maintenance-memc-withoutsession' => "hep an dalc'h :",
	'maintenance-memc-total' => 'hollad :',
	'maintenance-memc-parsercache' => 'Krubuilh ar parser',
	'maintenance-memc-hits' => 'klikoù :',
	'maintenance-memc-invalid' => 'direizh :',
	'maintenance-memc-expired' => "aet d'e dermen :",
	'maintenance-memc-absent' => 'ezvezant :',
	'maintenance-memc-stub' => "Treuzoù loc'hañ :",
	'maintenance-memc-imagecache' => 'Krubuilh ar skeudenn',
	'maintenance-memc-misses' => "c'hwitet :",
	'maintenance-memc-updates' => 'hizivadennoù :',
	'maintenance-memc-uncacheable' => 'er-maez krubuilh :',
	'maintenance-memc-diffcache' => "Krubuilh an diforc'hioù",
	'maintenance-reassignEdits' => "Implijit ar furmskrid-mañ evit addeverkañ kemmoù un implijer d'unan all.",
	'maintenance-re-from' => "Anv an implijer da biv eo ret kemer ar c'hemmoù",
	'maintenance-re-to' => "Anv an implijer da biv eo ret deverkañ ar c'hemmoù",
	'maintenance-re-force' => "Addeverkañ zoken ma n'eus ket eus an implijer voned",
	'maintenance-re-rc' => "Chom hep hizivaat taolenn ar c'hemmoù nevez",
	'maintenance-re-report' => 'Diskwel ar munudoù eus ar pezh a vo kemmet, met hep hizivaat ar roadennoù',
	'maintenance-re-nf' => "An implijer $1 n'eo ket bet kavet",
	'maintenance-re-rr' => 'Lañsañ en-dro ar skript hep hizivaat "$1".',
	'maintenance-re-ce' => 'Kemmoù evit poent : $1',
	'maintenance-re-de' => 'Aozadennoù dilamet : $1',
	'maintenance-re-rce' => "Monedoù e taolenn ar c'hemmoù ziwezhañ : $1",
	'maintenance-re-total' => 'Niver hollek a gemmoù da gemmañ : $1',
	'maintenance-re-re' => "Addeverkañ ar c'hemmoù{{int:ellipsis}} graet",
);

/** Bosnian (bosanski)
 * @author CERminator
 */
$messages['bs'] = array(
	'maintenance' => 'Pokretanje skripti za održavanje',
	'maintenance-desc' => '[[Special:Maintenance|Web interfejs]] za razne skripte održavanja',
	'right-maintenance' => 'Pokretanje skripti održavanja preko [[Special:Maintenance]]',
	'maintenance-backlink' => 'Nazad na odabir skripte',
	'maintenance-header' => 'Molimo odaberite skriptu za izvršenje ispod.
Opisi su navedeni pored svake skripte',
	'maintenance-error-invalidtype' => 'Navedena skripta nije nađena',
	'maintenance-error-badargs' => 'Niste odredili sve neophodne opcije',
	'maintenance-generic-done' => 'završeno',
	'maintenance-generic-username' => 'Korisničko ime',
	'maintenance-generic-password' => 'Šifra',
	'maintenance-generic-reason' => 'Razlog',
	'maintenance-cleanupTable-dry-run' => 'Izvedi probni rad',
	'maintenance-option-confirm' => 'Potvrdi',
	'maintenance-option-optional' => '(opcionalno)',
	'maintenance-output-success' => '$1 je bio pokrenut uspješno!',
	'maintenance-changePassword' => 'Koristi ovaj obrazac za promjenu šifre korisnika',
	'maintenance-changePassword-desc' => 'Promjena korisničke šifre',
	'maintenance-checkBadRedirects-output-footer' => 'Završeno.',
	'maintenance-checkImages-output-missing' => '$1: nedostaje',
	'maintenance-createAndPromote' => 'Koristite ovaj obrazac za pravljenje novog korisnika i njegovo postavljanje kao administratora.
Označite kutiju birokrata ako želite da ga unaprijedite i u birokratu',
	'maintenance-createAndPromote-desc' => 'Napravi korisnika i unaprijedi ga u status administratora',
	'maintenance-deleteBatch' => 'Koristite ovaj obrazac za masovno brisanje stranica.
Stavite po jednu stranicu u svaki red',
	'maintenance-deleteBatch-desc' => 'Masovno brisanje stranica',
	'maintenance-deleteRevision' => 'Koristite ovaj obrazac za masovno brisanje revizija.
Stavite samo jedan broj revizije u jedan red',
	'maintenance-deleteRevision-desc' => 'Ukloni revizije iz baze podataka',
	'maintenance-initEditCount-desc' => 'Ponovno preračunaj broj izmjena korisnika',
	'maintenance-initSiteStats' => 'Koristite ovaj obrazac za ponovo računanje statistika sajta, navodeći da li želite i ponovo računanje pregleda stranice',
	'maintenance-initSiteStats-desc' => 'Ponovno izračunavanje statistike sajta',
	'maintenance-moveBatch' => 'Koristite ovaj obrazac za masovno premještanje stranica.
Svaka linija treba navesti izvornu stranicu i odredišnu stranicu razdvojene uspravnom linijom',
	'maintenance-moveBatch-desc' => 'Masovno premještanje stranica',
	'maintenance-reassignEdits-desc' => 'Prerasporedi izmjene od jednog korisnika drugom',
	'maintenance-runJobs-desc' => 'Pokreni poslove koji čekaju u redu',
	'maintenance-showJobs-desc' => 'Pokaži spisak poslova koji čekaju na izvršenje',
	'maintenance-sql' => 'Koristite ovaj obrazac za izvršavanje SQL upita u bazi podataka.',
	'maintenance-sql-desc' => 'Izvrši SQL zahtjev',
	'maintenance-showCacheStats-desc' => 'Prikaži Memcached statistike',
	'maintenance-eval' => 'Koristite ovaj obrazac za ocjenu PHP koda u MediaWiki okruženju.',
	'maintenance-eval-desc' => 'Ocijenjivanje PHP koda u MediaWiki okruženju',
	'maintenance-update' => 'Koristite UPDATE kada ažurirate tabelu? Umjesto toga ukloni upotrebu DELETE/INSERT.',
	'maintenance-noviews' => 'Odaberite ovo za prevenciju ažuriranja broja pogleda na stranicu',
	'maintenance-invalidname' => 'Nevaljano korisničko ime!',
	'maintenance-userexists' => 'Korisnik već postoji!',
	'maintenance-invalidtitle' => 'Nevaljan naslov "$1"!',
	'maintenance-titlenoexist' => 'Navedeni naslov ("$1") ne postoji!',
	'maintenance-failed' => 'NEUSPJELO',
	'maintenance-deleted' => 'OBRISANO',
	'maintenance-revdelete' => 'Brisanje {{PLURAL:$3|revizije|revizija}} $1 iz wikija $2',
	'maintenance-revnotfound' => 'Revizija $1 nije pronađena!',
	'maintenance-showCacheStats-edits' => 'Broj uređivanja: $1',
	'maintenance-showCacheStats-articles' => 'Broj stranica u glavnom imenskom prostoru: $1',
	'maintenance-showCacheStats-pages' => 'Broj stranica: $1',
	'maintenance-showCacheStats-users' => 'Broj korisnika: $1',
	'maintenance-showCacheStats-admins' => 'Broj administratora: $1',
	'maintenance-showCacheStats-images' => 'Broj datoteka: $1',
	'maintenance-showCacheStats-views' => 'Broj pregleda stranica: $1',
	'maintenance-showCacheStats-update' => 'Ažuriranje baze podataka...',
	'maintenance-move' => 'Premještam $1 na $2...',
	'maintenance-movefail' => 'Greška se desila pri premještanju: $1.
Odustajem od premještanja',
	'maintenance-error' => 'Greška: $1',
	'maintenance-memc-fake' => 'Vi koristite FakeMemCachedClient. Ne može se prikupiti statistika',
	'maintenance-memc-requests' => 'Zahtjevi',
	'maintenance-memc-withsession' => 'sa sesijom:',
	'maintenance-memc-withoutsession' => 'bez sesije:',
	'maintenance-memc-total' => 'ukupno:',
	'maintenance-memc-parsercache' => 'keš parsera',
	'maintenance-memc-hits' => 'pogodaka:',
	'maintenance-memc-invalid' => 'nevaljano:',
	'maintenance-memc-expired' => 'isteklo:',
	'maintenance-memc-absent' => 'otsutno:',
	'maintenance-memc-stub' => 'ograničenje stubova:',
	'maintenance-memc-imagecache' => 'Keš slike',
	'maintenance-memc-misses' => 'promašaji:',
	'maintenance-memc-updates' => 'ažuriranja:',
	'maintenance-memc-uncacheable' => 'ne može se keširati:',
	'maintenance-memc-diffcache' => 'Diff keš',
	'maintenance-reassignEdits' => 'Koristite ovaj obrazac za ponovno dodjeljivanje izmjena od jednog korisnika drugom.',
	'maintenance-re-from' => 'Ime korisnika s kojeg se oduzimaju izmjene',
	'maintenance-re-to' => 'Ime korisnika kojem se dodjeljuju izmjene',
	'maintenance-re-force' => 'Ponovo dodijeli čak i ako određeni korisnik ne postoji',
	'maintenance-re-rc' => 'Ne ažuriraj tabelu nedavnih izmjena',
	'maintenance-re-report' => 'štampanja detalja o tome šta bi se moglo izmijeniti, ali ih ne ažurira',
	'maintenance-re-nf' => '{{GENDER:$1|Korisnik|Korisnica}} $1 nije {{GENDER:$1|pronađen|pronađena}}',
	'maintenance-re-rr' => 'Pokrenite skriptu ponovno bez "$1" radi ažuriranja.',
	'maintenance-re-ce' => 'Trenutne izmjene: $1',
	'maintenance-re-de' => 'Obrisane izmjene: $1',
	'maintenance-re-rce' => 'Stavke nedavnih promjena: $1',
	'maintenance-re-total' => 'Ukupno stavki za izmjenu: $1',
	'maintenance-re-re' => 'Preraspoređivanje izmjena{{int:ellipsis}} završeno',
);

/** Catalan (català)
 * @author Paucabot
 * @author Solde
 */
$messages['ca'] = array(
	'maintenance-option-confirm' => 'Confirma',
	'maintenance-changePassword-desc' => "Canvia la contrasenya d'un usuari",
	'maintenance-deleteBatch-desc' => 'Eliminació massiva de pàgines',
	'maintenance-invalidname' => "Nom d'usuari no vàlid!",
	'maintenance-deleted' => 'ELIMINAT',
	'maintenance-showCacheStats-edits' => "Nombre d'edicions: $1",
	'maintenance-showCacheStats-pages' => 'Nombre de pàgines: $1',
	'maintenance-showCacheStats-users' => "Nombre d'usuaris: $1",
);

/** Czech (česky)
 * @author Chmee2
 * @author Jkjk
 * @author Vks
 */
$messages['cs'] = array(
	'maintenance' => 'Spustit skripty údržby',
	'maintenance-desc' => '[[Special:Maintenance|Wiki rozhraní]] pro různé skripty údržby',
	'right-maintenance' => 'Spouštět skripty údržby pomocí [[Special:Maintenance]]',
	'maintenance-backlink' => 'Zpět na výběr skriptu',
	'maintenance-header' => 'Vyberte prosím níže skript, který se má spustit. Popisky jsou u jednotlivých skriptů.',
	'maintenance-error-badini' => 'Soubor metadata.ini chybí nebo je poškozený, stáhněte znovu rozšíření Maintenance.',
	'maintenance-error-invalidtype' => 'Skript nenalezen',
	'maintenance-error-badargs' => 'Nevyplnil jste všechny potřebné parametry',
	'maintenance-generic-done' => 'hotovo',
	'maintenance-generic-username' => 'Uživatelské jméno',
	'maintenance-generic-password' => 'Heslo',
	'maintenance-generic-reason' => 'Důvod',
	'maintenance-cleanupTable-dry-run' => 'Provedení nanečisto',
	'maintenance-cleanupTable-check' => 'Hledám špatné názvy stránek...',
	'maintenance-cleanupTable-checkfix' => 'Hledám a opravuji špatné názvy stránek...',
	'maintenance-cleanupTable-progress' => '$1 $2: $3% hotovo z $4; předpokládaný konec v $5 [$6/$7] $8/sekudnu <$9% změněno>',
	'maintenance-cleanupTable-missingparam' => '$1: Parametr $2 chybí',
	'maintenance-cleanupTable-processing' => 'Zpracovává se $1...',
	'maintenance-cleanupTable-finished' => 'Hotovo $1... $2 z $3 {{PLURAL:$3|řádku|řádků}} opraveno',
	'maintenance-option-quiet' => 'Potlačit nechybový výstup',
	'maintenance-option-globals' => 'Vypsat globální proměnné na konci zpracování při ladění',
	'maintenance-option-confirm' => 'Potvrdit',
	'maintenance-option-batch-size' => 'Spusťte tolik operací v dávce, výchozí:$1',
	'maintenance-option-required' => '(vyžadováno)',
	'maintenance-option-optional' => '(volitelné)',
	'maintenance-output-success' => '$1 úspěšně proběhl!',
	'maintenance-output-failure' => '$1 neproběhl úspěšně!',
	'maintenance-attachLatest-output-done' => 'Hotovo! {{PLURAL:$1|Zpracována|Zpracovány|Zpracováno}} $1 {{PLURAL:$1|stránka|stránky|stránek}}',
	'maintenance-changePassword' => 'Tento formulář slouží ke změně hesla uživatele',
	'maintenance-changePassword-desc' => 'Změnit heslo uživatele',
	'maintenance-changePassword-error-nouser' => 'Uživatel „$1“ neexistuje',
	'maintenance-changePassword-output-set' => 'Heslo nastaveno pro $1',
	'maintenance-checkAutoLoader-output-list2' => '$1: Chybný soubor: nalezen v $2, použit v $3',
	'maintenance-checkBadRedirects' => 'Použijte tento formulář a uvidíte, jestli stránky označené jako přesměrování jsou opravdu přesměrováními',
	'maintenance-checkBadRedirects-desc' => 'Hledat nesprávná přesměrování',
	'maintenance-checkBadRedirects-output-header' => 'Hledám přesměrování...',
	'maintenance-checkBadRedirects-output-found' => '$1 přesměrování {{PLURAL:$1|nalezeno|nalezena|nalezeno}}.
Hledám chybná přesměrování',
	'maintenance-checkBadRedirects-output-footer' => 'Hotovo.',
	'maintenance-checkImages' => 'Použijte tento formulář a uvidíte, které obrázky na Vaší wiki jsou poškozené',
	'maintenance-checkImages-desc' => 'Hledat obrázky a ověřit, jestli existují, dají se načíst, atd.',
	'maintenance-checkImages-output-noaccess' => '$1: není místně přístupný',
	'maintenance-checkImages-output-missing' => '$1: chybí',
	'maintenance-checkImages-output-isdir' => '$1: je adresář',
	'maintenance-checkImages-output-truncated' => '$1: zkrácený, byl $2',
	'maintenance-checkImages-output-mismatch' => '$1: velikost je rozdílná - v databázi $2, současná $3',
	'maintenance-checkImages-output-good' => 'Správné obrázky: $1/$2',
	'maintenance-checkSyntax-output-svnlist' => 'Načítám seznam ze Subversion...',
	'maintenance-checkSyntax-output-buildlist' => 'Vytvářím seznam souborů...',
	'maintenance-checkUsernames-desc' => 'Ověřit, že databázové přihlašovací jména jsou skutečně platná.',
	'maintenance-checkUsernames-error-notvalid' => 'Neplatné uživatelské jméno: „$3“ (uživatelské id $2)',
	'maintenance-cleanupCaps-output-islower' => '„$1“ už je malými písmeny.',
	'maintenance-cleanupSpam-option-hostname' => 'Název hostitele, který spamoval',
	'maintenance-cleanupSpam-output-false' => 'Falešná shoda',
	'maintenance-cleanupSpam-output-reverting' => 'vracení zpět',
	'maintenance-deleteBatch-desc' => 'Hromadné mazání stránek',
	'maintenance-moveBatch-desc' => 'Hromadný přesun stránek',
	'maintenance-sql-desc' => 'Vykonat SQL dotaz',
	'maintenance-sql-option-file' => 'SQL k provedení',
	'maintenance-sql-error-cantopen' => 'Nelze otevřít vstupní soubor',
	'maintenance-noviews' => 'Označit tady, aby se neaktualizoval počet zobrazení stránky',
	'maintenance-invalidname' => 'Neplatné uživatelské jméno!',
	'maintenance-userexists' => 'Uživatel již existuje!',
	'maintenance-invalidtitle' => 'Nesprávný název „$1“!',
	'maintenance-titlenoexist' => 'Zadaný název „$1“ neexistuje!',
	'maintenance-failed' => 'SELHALO', # Fuzzy
	'maintenance-deleted' => 'ODSTRANĚNO',
	'maintenance-revdelete' => '{{PLURAL:$3|Maže se verze|Mažou se verze}} $1 z wiki $2',
	'maintenance-revnotfound' => 'Verze $1 nenalezena!',
	'maintenance-showCacheStats-edits' => 'Počet editací: $1',
	'maintenance-showCacheStats-articles' => 'Počet stránek ve hlavním jmenném prostoru: $1',
	'maintenance-showCacheStats-pages' => 'Počet stránek: $1',
	'maintenance-showCacheStats-users' => 'Počet uživatelů: $1',
	'maintenance-showCacheStats-admins' => 'Počet správců: $1',
	'maintenance-showCacheStats-images' => 'Počet souborů: $1',
	'maintenance-showCacheStats-views' => 'Počet zobrazení stránek: $1',
	'maintenance-memc-requests' => 'Požadavky',
	'maintenance-memc-total' => 'celkem:',
	'maintenance-memc-parsercache' => 'Mezipaměť parseru',
	'maintenance-memc-hits' => 'zásahy:',
	'maintenance-memc-invalid' => 'neplatné:',
	'maintenance-memc-expired' => 'vypršelé:',
	'maintenance-memc-absent' => 'chybí:',
	'maintenance-memc-stub' => 'hranice velikosti pahýlu',
	'maintenance-memc-imagecache' => 'Předstažené obrázky',
	'maintenance-memc-misses' => 'netrefené:',
	'maintenance-memc-updates' => 'aktualizace:',
	'maintenance-memc-uncacheable' => 'nekešovatelné:',
	'maintenance-memc-diffcache' => 'Vyrovnávací paměť pro porovnávání',
	'maintenance-re-nf' => 'Uživatel $1 nebyl nalezen',
);

/** German (Deutsch)
 * @author ChrisiPK
 * @author DaSch
 * @author George Animal
 * @author Imre
 * @author Kghbln
 * @author Leithian
 * @author MF-Warburg
 * @author Melancholie
 * @author Metalhead64
 * @author MichaelFrey
 * @author Purodha
 * @author Raimond Spekking
 * @author Revolus
 * @author Umherirrender
 */
$messages['de'] = array(
	'maintenance' => 'Wartungsskript starten',
	'maintenance-desc' => 'Stellt die Spezialseite [[Special:Maintenance|Webinterface]] bereit, über die verschiedene Wartungsskripte ausgeführt werden können',
	'right-maintenance' => 'Wartungsskripte über [[Special:Maintenance]] starten',
	'maintenance-backlink' => 'Zurück zur Skript-Auswahl',
	'maintenance-header' => 'Bitte ein Skript zur Ausführung auswählen.
Die jeweiligen Beschreibungen sind neben jedem Skript angegeben.',
	'maintenance-error-badini' => 'Die Datei metadata.ini ist entweder beschädigt oder nicht vorhanden. Bitte die Programmerweiterung Maintenance erneut herunterladen.',
	'maintenance-error-invalidtype' => 'Das angegebene Skript wurde nicht gefunden',
	'maintenance-error-badargs' => 'Es wurden nicht alle erforderlichen Optionen eingestellt',
	'maintenance-generic-done' => 'erledigt',
	'maintenance-generic-username' => 'Benutzername',
	'maintenance-generic-password' => 'Passwort',
	'maintenance-generic-reason' => 'Grund',
	'maintenance-cleanupTable-dry-run' => 'Einen Probelauf durchführen',
	'maintenance-cleanupTable-check' => 'Überprüfe auf falsche Seitennamen …',
	'maintenance-cleanupTable-checkfix' => 'Überprüfe und korrigiere falsche Seitennamen …',
	'maintenance-cleanupTable-progress' => '$1 $2: $3% auf $4 erledigt. Der voraussichtlicher Zeitbedarf  beträgt $5 [$6/$7] $8/sek. <$9% aktualisiert>',
	'maintenance-cleanupTable-missingparam' => '$1: Parameter $2 fehlt',
	'maintenance-cleanupTable-processing' => 'Verarbeite $1 …',
	'maintenance-cleanupTable-finished' => '$1 Zeilen erledigt … $2 von {{PLURAL:$3|einer Zeile|$3 Zeilen}} wurden aktualisiert',
	'maintenance-option-quiet' => 'Mit Ausnahme von Fehlern die Verarbeitungsausgabe während der Verarbeitung unterdrücken',
	'maintenance-option-globals' => 'Globale Variablen am Ende der Verarbeitung für die Fehlerbehebung ausgeben',
	'maintenance-option-confirm' => 'Bestätigen',
	'maintenance-option-batch-size' => 'Anzahl der Operationen pro Verarbeitungslauf. Standard: $1',
	'maintenance-option-required' => '(erforderlich)',
	'maintenance-option-optional' => '(optional)',
	'maintenance-output-success' => '$1 erfolgreich ausgeführt.',
	'maintenance-output-failure' => '$1 erfolglos ausgeführt!',
	'maintenance-attachLatest' => 'Diese Maske verwenden, um Einträge in der Seitentabelle zu korrigieren, in denen „page_latest“ 0 beträgt.',
	'maintenance-attachLatest-desc' => 'Korrektur der Einträge zu „page_latest“ in der Seitentabelle',
	'maintenance-attachLatest-option-fix' => 'Einträge tatsächlich korrigieren. Ansonsten wird ein Probedurchlauf durchgeführt.',
	'maintenance-attachLatest-output-begin' => 'Suche nach Seiteneinträgen in denen „page_latest“ 0 beträgt …',
	'maintenance-attachLatest-output-notime' => '$1 $2 [[$3]] kann den neuesten Versionszeitpunkt nicht ermitteln?!',
	'maintenance-attachLatest-output-norev' => '$1 $2 [[$3]] neuester Versionszeitpunkt $4, kann die Versionsnummer nicht ermitteln',
	'maintenance-attachLatest-output-found' => '$1 $2 [[$3]] neuester Versionszeitpunkt $4, Versionsnummer $5',
	'maintenance-attachLatest-output-done' => 'Fertig! Es {{PLURAL:$1|wurde eine Seite|wurden $1 Seiten}} verarbeitet.',
	'maintenance-attachLatest-output-dryrun' => 'Dies war ein Probedurchlauf. Erneut mit „{{int:maintenance-attachLatest-option-fix}}“ ausführen, um „page_latest“ zu aktualisieren.',
	'maintenance-benchmarkPurge' => 'Diese Maske verwenden, um zu testen wie viel Zeit die Cachebereinigungsfunktionen der Squidserver benötigen.',
	'maintenance-benchmarkPurge-desc' => 'Leistungsvergleich der Cachebereinigungsfunktionen der Squidserver',
	'maintenance-benchmarkPurge-option-count' => 'Wie viele URLs sollen den Squidservern zur Cachebereinigung geschickt werden?',
	'maintenance-benchmarkPurge-error-nosquid' => 'Ein Leistungsvergleich der Cachebereinigungsfunktionen der Squidserver ist unnötig, sofern keine Squidserver eingerichtet wurden.',
	'maintenance-benchmarkPurge-output-numsquids' => 'Es {{PLURAL:$1|ist ein eingerichteter Squidserver|sind $1 eingerichtete Squidserver}} vorhanden:',
	'maintenance-benchmarkPurge-output-trial' => '{{PLURAL:$1|Ein Seitenname|$1 Seitennamen}} in $2 ms ($3 ms pro Seitenname)',
	'maintenance-changePassword' => 'Passwort eines Benutzers ändern',
	'maintenance-changePassword-desc' => 'Änderung des Passwort eines Benutzers',
	'maintenance-changePassword-error-nouser' => 'Der Benutzer ist nicht vorhanden: „$1“',
	'maintenance-changePassword-output-set' => 'Passwort für $1 festgelegt',
	'maintenance-checkAutoLoader' => 'Diese Maske verwenden, um Plausibilitätsprüfungen am AutoLoader durchzuführen.',
	'maintenance-checkAutoLoader-desc' => 'Plausibilitätsprüfungen am AutoLoader',
	'maintenance-checkAutoLoader-output-list2' => '$1: Falsche Datei: in $2 gefunden, aufgeführt in $3',
	'maintenance-checkBadRedirects' => 'Diese Maske verwenden, um zu überprüfen ob als Weiterleitung gekennzeichnete Seiten tatsächlich Weiterleitungen sind.',
	'maintenance-checkBadRedirects-desc' => 'Suche nach fehlerhaften Weiterleitungen',
	'maintenance-checkBadRedirects-output-header' => 'Lade Weiterleitungen …',
	'maintenance-checkBadRedirects-output-found' => 'Es {{PLURAL:$1|wurde eine Weiterleitung|wurden $1 Weiterleitungen}} gefunden.
Prüfung auf fehlerhafte Weiterleitungen …',
	'maintenance-checkBadRedirects-output-footer' => 'Erledigt.',
	'maintenance-checkImages' => 'Diese Maske verwenden, um nach fehlerhaften Bildern auf dem Wiki zu suchen.',
	'maintenance-checkImages-desc' => 'Überprüfung von Bildern, um festzustellen, ob sie vorhanden, abrufbar, usw. sind.',
	'maintenance-checkImages-output-noaccess' => '$1: lokaler Zugriff nicht möglich',
	'maintenance-checkImages-output-missing' => '$1: nicht vorhanden',
	'maintenance-checkImages-output-isdir' => '$1: ist ein Verzeichnis',
	'maintenance-checkImages-output-truncated' => '$1: ist unvollständig, war $2',
	'maintenance-checkImages-output-mismatch' => '$1: Größenabweichung, $2 in der Datenbank, tatsächlich aber $3',
	'maintenance-checkImages-output-good' => 'Einwandfreie Bilder: $1/$2',
	'maintenance-checkSyntax' => 'Diese Maske verwenden, um die Syntax aller PHP-Dateien von MediaWiki zu überprüfen.',
	'maintenance-checkSyntax-desc' => 'Überprüfung der Syntax aller PHP-Dateien von MediaWiki',
	'maintenance-checkSyntax-option-with-extensions' => 'Auch die Dateien im Verzeichnis „…/extensions“ überprüfen',
	'maintenance-checkSyntax-option-path' => 'Ein bestimmter Pfad (Datei oder Verzeichnis) für die Überprüfung. Entweder einen absoluten Pfad oder einen relativen Pfad zum Hauptverzeichnis dieser MediaWiki-Installation angeben',
	'maintenance-checkSyntax-option-list-file' => 'Liste der zu überprüfenden Dateien oder Verzeichnisse',
	'maintenance-checkSyntax-option-modified' => 'Lediglich modifizierte Dateien überprüfen (erfordert einen Kommandozeilen-Client für SVN)',
	'maintenance-checkSyntax-option-syntax-only' => 'Lediglich die Gültigkeit der Syntax überprüfen und dabei Warnungen zur Codestruktur auslassen',
	'maintenance-checkSyntax-output-parsekit' => 'Überprüfe die Syntax (mit parsekit)',
	'maintenance-checkSyntax-output-phpl' => 'Überprüfe die Syntax (mit php -l, was eine lange Zeit in Anspruch nehmen kann)',
	'maintenance-checkSyntax-output-footer' => 'Fertig! Es wurden $1 Dateien überprüft und dabei $2 Fehler gefunden sowie $3 Warnungen ausgegeben.',
	'maintenance-checkSyntax-output-svnlist' => 'Rufe Liste aus Subversion ab …',
	'maintenance-checkSyntax-output-buildlist' => 'Generiere die Dateiliste …',
	'maintenance-checkSyntax-output-error' => 'Fehler in Datei $1, Zeile $2: $3',
	'maintenance-checkSyntax-output-warning' => 'Warnung für Datei $1: $2 gefunden',
	'maintenance-checkSyntax-error-nofile' => 'Fehler: Die Datei oder das Verzeichnis $1 wurde nicht gefunden.',
	'maintenance-checkSyntax-error-cantopen' => 'Die Datei $1 kann nicht geöffnet werden.',
	'maintenance-checkSyntax-error-svnerr' => 'Fehler beim Abrufen der Liste aus Subversion.',
	'maintenance-checkUsernames' => 'Diese Maske verwenden, um die aufgrund von Konfigurationsänderungen ungültig gewordenen Benutzernamen zu ermitteln. Sofern nach Ausführung des Skriptes keine Liste ausgegeben wird, sind aller Benutzernamen gültig.',
	'maintenance-checkUsernames-desc' => 'Überprüfung der Datenbankbenutzernamen auf deren Gültigkeit',
	'maintenance-checkUsernames-error-notvalid' => 'Ungültiger Benutzername: „$3“ (Benutzerkennung $2)',
	'maintenance-cleanupCaps' => 'Diese Maske verwenden, um fehlerhafte Seiten zu berichtigen, die aufgrund der Änderung von <code>$wgCapitalLinks</code> unbrauchbar sind.',
	'maintenance-cleanupCaps-desc' => 'Skript zu Bereinigung von Fehler durch Großschreibung',
	'maintenance-cleanupCaps-option-namespace' => 'Nummer des Namensraums auf dem die Bereinigung von Großsachreibungsfehlern durchgeführt werden soll',
	'maintenance-cleanupCaps-output-islower' => '„$1“ ist bereits klein geschrieben.',
	'maintenance-cleanupCaps-output-clash' => '„$1“ wurde übersprungen, da „$2“ bereits vorhanden ist',
	'maintenance-cleanupCaps-output-dryrun' => '„$1“ → „$2“: Probelauf ohne Verschiebung',
	'maintenance-cleanupCaps-error-noneed' => 'Der Parameter $wgCapitalLinks ist aktiv. Es ist nicht erforderlich eine Bereinigung von Fehler durch Großschreibung durchzuführen.',
	'maintenance-cleanupSpam' => 'Diese Maske verwenden, um Spambearbeitungen rückgängig zu machen, die Links zu externen Websites enthalten.',
	'maintenance-cleanupSpam-desc' => 'Alle Spambearbeitungen eines anzugebenden Hosts bereinigen',
	'maintenance-cleanupSpam-option-hostname' => 'Der Host mit dem die Spambearbeitungen durchgeführt wurden',
	'maintenance-cleanupSpam-output-found' => 'Es {{PLURAL:$1|wurde ein Artikel|wurden $1 Artikel}} gefunden, {{PLURAL:$1|der $2 enthielt|die $2 enthielten}}',
	'maintenance-cleanupSpam-output-false' => 'Falsche Übereinstimmung',
	'maintenance-cleanupSpam-output-blanking' => 'leeren',
	'maintenance-cleanupSpam-output-reverting' => 'zurücksetzen',
	'maintenance-cleanupSpam-error-invalid' => 'Dies ist keine gültige Spezifikation eines Hosts: $1',
	'maintenance-cleanupSpam-error-noid' => 'Interner Fehler: Zu Seitenkennung $1 ist keine Seite vorhanden',
	'maintenance-clearInterwikiCache' => 'Diese Maske nutzen, um den Interwikicache vollständig zu löschen',
	'maintenance-clearInterwikiCache-desc' => 'Alle Interwikilinks für alle Sprachen aus dem Cache entfernen',
	'maintenance-createAndPromote' => 'Diese Maske verwenden, um einen neuen Benutzer zu erstellen und um ihn zum Administrator zu machen.
Kreuze das Auswahlkästchen Bürokrat an, sofern er auch zum Bürokraten gemachte werden soll.',
	'maintenance-createAndPromote-desc' => 'Ein Benutzerkonto erstellen und dieses der Benutzergruppe Administrator zuordnen',
	'maintenance-createAndPromote-option-bureaucrat' => 'Den Benutzer der Benutzergruppe Bürokrat zuordnen',
	'maintenance-createAndPromote-output-creating' => 'Erstellung und Benutzergruppenzuordnung von Benutzer:$2 …',
	'maintenance-createAndPromote-error-password' => 'Es ist bezüglich des angegebenen Passworts ein Fehler aufgetreten: $1',
	'maintenance-deleteBatch' => 'Diese Maske verwenden, um viele Seiten gleichzeitig zu löschen.
Nur eine Seite je Zeile angeben.',
	'maintenance-deleteBatch-desc' => 'Massenlöschung von Seiten',
	'maintenance-deleteRevision' => 'Diese Maske verwenden, um viele Versionen gleichzeitig zu löschen.
Nur eine Versionsnummer je Zeile angeben.',
	'maintenance-deleteRevision-desc' => 'Versionen aus der Datenbank entfernen',
	'maintenance-initEditCount-desc' => 'Benutzerbeitragszähler eines Benutzers neu berechnen',
	'maintenance-initSiteStats' => 'Diese Maske verwenden, um die Seitenstatistiken neu zu berechnen. Dabei kann zudem angegeben werden, ob auch die Seitenaufrufe neu berechnet werden sollen.',
	'maintenance-initSiteStats-desc' => 'Seitenstatistik neu berechnen',
	'maintenance-moveBatch' => 'Diese Maske verwenden, um viele Seiten gleichzeitig zu verschieben.
Je Zeile eine durch einen senkrechten Strich („|“) getrennte Quell- sowie Zielseite angeben.',
	'maintenance-moveBatch-desc' => 'Massenverschiebung von Seiten',
	'maintenance-reassignEdits-desc' => 'Bearbeitungen eines Benutzers einem anderen zuweisen',
	'maintenance-runJobs-desc' => 'Aufträge in Warteschlange ausführen',
	'maintenance-runJobs-option-maxjobs' => 'Maximale Anzahl der auszuführenden Aufträge aus der Auftragswarteschlange',
	'maintenance-runJobs-option-type' => 'Art der auszuführenden Aufträge',
	'maintenance-runJobs-option-procs' => 'Anzahl der zu verwendenden Prozesse',
	'maintenance-runJobs-option-exclusive' => 'Das runJobs-Skript nur einzeln ausführen. Dem Skript stehen 1800 Sekunden bis zum Abbruch zur Verfügung.',
	'maintenance-runJobs-error-invalidprocs' => 'Die Anzahl der zu verwendenden Prozesse muss zwischen 1 und 1000 liegen.',
	'maintenance-showJobs-desc' => 'Liste der auf Abarbeitung wartenden Jobs in der Jobqueue',
	'maintenance-showJobs-option-group' => 'Anzahl der Aufträge je Auftragsart anzeigen',
	'maintenance-sql' => 'Diese Maske verwenden, um eine SQL-Abfrage in der Datenbank auszuführen.',
	'maintenance-sql-desc' => 'Eine SQL-Abfrage ausführen',
	'maintenance-sql-option-file' => 'Auszuführende SQL-Abfrage',
	'maintenance-sql-output-aff' => 'Abfrage erfolgreich. {{PLURAL:$1|Eine Zeile|$1 Zeilen}} waren betroffen.',
	'maintenance-sql-error-cantopen' => 'Kann Eingabedatei nicht öffnen',
	'maintenance-showCacheStats-desc' => 'Zeige Memcached-Statistik',
	'maintenance-eval' => 'Diese Maske verwenden, um PHP-Codes in der MediaWiki-Umgebung auszuwerten.',
	'maintenance-eval-desc' => 'PHP-Code in der MediaWiki-Umgebung auswerten',
	'maintenance-update' => 'UPDATE zum Aktualisieren von Tabellen verwenden? Wenn nicht aktiviert, wird DELETE/INSERT verwendet.',
	'maintenance-noviews' => 'Aktualisierung des Seitenaufrufszählers deaktivieren',
	'maintenance-invalidname' => 'Ungültiger Benutzername!',
	'maintenance-userexists' => 'Der Benutzer ist bereits vorhanden.',
	'maintenance-invalidtitle' => 'Ungültiger Titel „$1“!',
	'maintenance-titlenoexist' => 'Der angegebene Titel („$1“) existiert nicht!',
	'maintenance-failed' => 'GESCHEITERT',
	'maintenance-deleted' => 'GELÖSCHT',
	'maintenance-revdelete' => 'Lösche {{PLURAL:$3|Version|Versionen}} $1 von Wiki $2',
	'maintenance-revnotfound' => 'Version $1 nicht gefunden!',
	'maintenance-showCacheStats-edits' => 'Anzahl an Bearbeitungen: $1',
	'maintenance-showCacheStats-articles' => 'Anzahl von Seiten im Hauptnamensraum: $1',
	'maintenance-showCacheStats-pages' => 'Anzahl an Seiten: $1',
	'maintenance-showCacheStats-users' => 'Anzahl an Benutzern: $1',
	'maintenance-showCacheStats-admins' => 'Anzahl an Administratoren: $1',
	'maintenance-showCacheStats-images' => 'Anzahl an Dateien: $1',
	'maintenance-showCacheStats-views' => 'Anzahl an Seitenaufrufen: $1',
	'maintenance-showCacheStats-update' => 'Aktualisiere Datenbank …',
	'maintenance-move' => 'Verschiebe $1 nach $2 …',
	'maintenance-movefail' => 'Fehler beim Verschieben: $1
Verschieben abgebrochen',
	'maintenance-error' => 'Fehler: $1',
	'maintenance-memc-fake' => 'Es wird ein FakeMemCachedClient genutzt. Es sind daher keine Statistiken verfügbar.',
	'maintenance-memc-requests' => 'Anfragen',
	'maintenance-memc-withsession' => 'mit Sitzung:',
	'maintenance-memc-withoutsession' => 'ohne Sitzung:',
	'maintenance-memc-total' => 'gesamt:',
	'maintenance-memc-parsercache' => 'Parser-Zwischenspeicher',
	'maintenance-memc-hits' => 'Treffer:',
	'maintenance-memc-invalid' => 'Ungültig:',
	'maintenance-memc-expired' => 'abgelaufen:',
	'maintenance-memc-absent' => 'abwesend:',
	'maintenance-memc-stub' => 'Stubgrenze:',
	'maintenance-memc-imagecache' => 'Bildercache',
	'maintenance-memc-misses' => 'verpasst:',
	'maintenance-memc-updates' => 'Updates:',
	'maintenance-memc-uncacheable' => 'nicht cachebar:',
	'maintenance-memc-diffcache' => 'Diff-Zwischenspeicher',
	'maintenance-reassignEdits' => 'Benutze diese Seite um Bearbeitungen eines Benutzers einem anderen zuzuweisen.',
	'maintenance-re-from' => 'Benutzer, dem die Bearbeitungen weggenommen werden sollen',
	'maintenance-re-to' => 'Benutzer, dem die Bearbeitungen zugewiesen werden sollen',
	'maintenance-re-force' => 'Auch neu zuweisen wenn der neue Benutzer nicht existiert',
	'maintenance-re-rc' => 'Datenbank-Tabelle Letzte Änderungen nicht aktualisieren',
	'maintenance-re-report' => 'Nichts ändern, nur zeigen, was geändert werden würde',
	'maintenance-re-nf' => 'Benutzer $1 nicht gefunden',
	'maintenance-re-rr' => 'Zum Neuzuweisen das Skript noch einmal ohne „$1“ laufen lassen.',
	'maintenance-re-ce' => 'Aktuelle Bearbeitungen: $1',
	'maintenance-re-de' => 'Gelöschte Bearbeitungen: $1',
	'maintenance-re-rce' => 'Einträge in den Letzten Änderungen: $1',
	'maintenance-re-total' => 'Zu ändernde Einträge: $1',
	'maintenance-re-re' => 'Neuzuordnung der Edits … erledigt',
);

/** Zazaki (Zazaki)
 * @author Erdemaslancan
 * @author Mirzali
 */
$messages['diq'] = array(
	'maintenance-generic-done' => 'qeyd ke',
	'maintenance-generic-username' => 'Namey karberi',
	'maintenance-generic-password' => 'Parola',
	'maintenance-generic-reason' => 'Sebeb',
	'maintenance-option-optional' => '(opsiyonel)',
	'maintenance-checkBadRedirects-output-footer' => 'Qeyd ke.',
	'maintenance-failed' => 'NÊŞA',
	'maintenance-deleted' => 'ESTERİYA',
	'maintenance-showCacheStats-edits' => 'Amriya vurnayışan: $1',
	'maintenance-showCacheStats-pages' => 'Amariya pelan: $1',
	'maintenance-showCacheStats-users' => 'Amariya karberan: $1',
	'maintenance-showCacheStats-admins' => 'Amariya xizmetkaran: $1',
	'maintenance-showCacheStats-images' => 'Amariya dosyayan: $1',
	'maintenance-showCacheStats-views' => 'Amariya pelan mocnayış: $1',
	'maintenance-error' => 'Xırab: $1',
	'maintenance-memc-requests' => 'Wazteni',
	'maintenance-memc-diffcache' => 'Ferqê Verhafızi',
);

/** Lower Sorbian (dolnoserbski)
 * @author Michawiki
 */
$messages['dsb'] = array(
	'maintenance' => 'Wótwardowańske skripty wuwjasć',
	'maintenance-desc' => '[[Special:Maintenance|Wikijowy interfejs]] za wšake wótwardowańske skripty',
	'right-maintenance' => 'Wótwardowańske skripty pśez [[Special:Maintenance]] wuwjasć',
	'maintenance-backlink' => 'Slědk k wuběrkoju skriptow',
	'maintenance-header' => 'Pšosym wubjeŕ skript za wuwjaźenje.
Wopisanja su pódla wótpowědnego skripta.',
	'maintenance-error-invalidtype' => 'Pódany skript njejo se namakał',
	'maintenance-option-confirm' => 'Wobkšuśiś',
	'maintenance-output-success' => '$1 wuspěšnje wuwjeźony!',
	'maintenance-changePassword' => 'Wužyj toś ten formular, aby změnił gronidło wužywarja',
	'maintenance-changePassword-desc' => 'Gronidło wužywarja změniś',
	'maintenance-createAndPromote' => 'Wužyj toś ten formular, aby napórał nowego wužywarja a pózwignuł jogo k administratoroju.
Markěruj běrokratowy kašćik, jolic coš jogo teke k běrokratoju pózwignuś.',
	'maintenance-createAndPromote-desc' => 'Wužywarske konto napóraś a status administratora daś',
	'maintenance-deleteBatch' => 'Wužyj toś ten formular, aby lašował boki z kopicami.
Napiš jano jaden bok na smužku',
	'maintenance-deleteBatch-desc' => 'Boki z kopicami wulašowaś',
	'maintenance-deleteRevision' => 'Wužyj toś ten formular, aby lašował wersije z kopicami.
Napiš jano jaden wersijowy numer na smužku',
	'maintenance-deleteRevision-desc' => 'Wersije z datoweje banki wótpóraś',
	'maintenance-initEditCount-desc' => 'Licenja změnow wužywarjow hyšći raz woblicyś',
	'maintenance-initSiteStats' => 'Wužyj toś ten formular, aby znowego woblicył statistiku sedła. Pódaj, lěc coš zwobraznjenja boka teke znowego woblicyś.',
	'maintenance-initSiteStats-desc' => 'Statistika sedłow hyšći raz woblicyś',
	'maintenance-moveBatch' => 'Wužyj toś ten formular, aby pśesunuł boki z kopicami.
Kužda smužka by měła žrědłowy bok a celowy bok pódaś, kótrejž stej pśez znamješko rołka (|) wótźělonej',
	'maintenance-moveBatch-desc' => 'Boki z kopicami pśesunuś',
	'maintenance-reassignEdits-desc' => 'Změny jadnego wužywarja k drugemu znowego pśipokazaś',
	'maintenance-runJobs-desc' => 'Nadawki w rěźe cakajucych nadawkow wuwjasć',
	'maintenance-showJobs-desc' => 'Lisćinu nadawkow pokazaś, kótarež cakaju w rěźe nadawkow',
	'maintenance-sql' => 'Wužyj toś ten formular, aby wuwjadł SQL-wótpšašanje w datowej bance.',
	'maintenance-sql-desc' => 'SQL_wótpšašanje wuwjasć',
	'maintenance-showCacheStats-desc' => 'Statistiku Memcached pokazaś',
	'maintenance-eval' => 'Wužyj toś ten formular, aby wugódnośił PHP-kod we wokolinje MediaWiki.',
	'maintenance-eval-desc' => 'PHP-kod we wokolinje MediaWiki wugódnośiś',
	'maintenance-update' => 'UPDATE za aktualizěrowanje tabele wužywaś? Jolic to njejo wubrane, DELETE/INSERT se wužywa.',
	'maintenance-noviews' => 'Wubjeŕ to, aby zajźował aktualizaciji licby zwobraznjenjow boka',
	'maintenance-invalidname' => 'Njepłaśiwe wužywarske mě!',
	'maintenance-userexists' => 'Wužywaŕ južo eksistěrujo!',
	'maintenance-invalidtitle' => 'Njepłaśiwy titel "$1"!',
	'maintenance-titlenoexist' => 'Pódany titel ("$1") njeeksistěrujo!',
	'maintenance-failed' => 'NJERAŹIŁO SE',
	'maintenance-deleted' => 'WULAŠOWANY',
	'maintenance-revdelete' => '{{PLURAL:$3|Lašujo se wersija|Lašujotej se wersiji|Lašuju se wersije|Lašuju se wersije}} $1 z wikija $2',
	'maintenance-revnotfound' => 'Wersija $1 njenamakana!',
	'maintenance-showCacheStats-edits' => 'Licba změnow: $1',
	'maintenance-showCacheStats-articles' => 'Licba bokow w głownem mjenjowem rumje: $1',
	'maintenance-showCacheStats-pages' => 'Licba bokow: $1',
	'maintenance-showCacheStats-users' => 'Licba wužywarjow: $1',
	'maintenance-showCacheStats-admins' => 'Licba administratorow: $1',
	'maintenance-showCacheStats-images' => 'Licba datajow: $1',
	'maintenance-showCacheStats-views' => 'Licba zwobraznjenjow bokow: $1',
	'maintenance-showCacheStats-update' => 'Datowa banka se aktualizěrujo{{int:ellipsis}}',
	'maintenance-move' => '$1 do $2 se pśesuwa{{int:ellipsis}}',
	'maintenance-movefail' => 'Zmólka pśi pśesuwanju: $1.
Pśesunjenje pśetergnjone',
	'maintenance-error' => 'Zmólka: $1',
	'maintenance-memc-fake' => 'Wuwjedujoš FakeMemCacheClient. Žedna statistika k dispoziciji.',
	'maintenance-memc-requests' => 'Napšašowanja',
	'maintenance-memc-withsession' => 'z pósejźenim:',
	'maintenance-memc-withoutsession' => 'bźez pósejźenja:',
	'maintenance-memc-total' => 'dogromady:',
	'maintenance-memc-parsercache' => 'Parserowy cache',
	'maintenance-memc-hits' => 'trjefarje:',
	'maintenance-memc-invalid' => 'njepłaśiwy:',
	'maintenance-memc-expired' => 'pśepadnjony:',
	'maintenance-memc-absent' => 'njepśibytny:',
	'maintenance-memc-stub' => 'zarodkowy prog:',
	'maintenance-memc-imagecache' => 'Cache wobrazow',
	'maintenance-memc-misses' => 'zmólenja:',
	'maintenance-memc-updates' => 'aktualizacije:',
	'maintenance-memc-uncacheable' => 'cache njedajo se wužywaś',
	'maintenance-memc-diffcache' => 'Cache rozdźělow',
	'maintenance-reassignEdits' => 'Wužyj toś ten formular, aby znowego pśipokazał změny wót jadnego wužywarja k drugemu wužywarjeju.',
	'maintenance-re-from' => 'Mě wužywarja, wót kótaregož změny maju se pśipokazaś',
	'maintenance-re-to' => 'Mě wužywarja, kótaremuž změny maju se pśipokazaś',
	'maintenance-re-force' => 'Znowego pśipokazaś, samo gaby celowy wužywaŕ njeeksistěrował',
	'maintenance-re-rc' => 'Tabelu aktualnych změnow njeaktualizěrowaś',
	'maintenance-re-report' => 'Drobnostki pokazaś, kótarež by se změnili, ale njeaktualizěruj',
	'maintenance-re-nf' => 'Wužywaŕ $1 njenamakany',
	'maintenance-re-rr' => 'Skript za aktualizaciju znowego bźez "$1" wuwjasć',
	'maintenance-re-ce' => 'Aktualne změny: $1',
	'maintenance-re-de' => 'Wulašowane změny: $1',
	'maintenance-re-rce' => 'Zapiski w aktualnych změnach: $1',
	'maintenance-re-total' => 'Wšykne zapiski, kótarež maju se změniś: $1',
	'maintenance-re-re' => 'Změny se znowego pśipokazuju{{int:ellipsis}} gótowe',
);

/** Greek (Ελληνικά)
 * @author Consta
 * @author Crazymadlover
 * @author Omnipaedista
 * @author ZaDiak
 */
$messages['el'] = array(
	'maintenance-error-invalidtype' => 'Μη έγκυρος τύπος!', # Fuzzy
	'maintenance-generic-done' => 'έγινε',
	'maintenance-generic-username' => 'Όνομα χρήστη',
	'maintenance-generic-password' => 'Κωδικός πρόσβασης',
	'maintenance-generic-reason' => 'Αιτία',
	'maintenance-option-confirm' => 'Επιβεβαίωση',
	'maintenance-option-required' => '(απαιτείται)',
	'maintenance-option-optional' => '(προαιρετικό)',
	'maintenance-output-success' => 'Το $1 έτρεξε επιτυχώς!',
	'maintenance-changePassword-desc' => 'Αλλαγή κωδικού ενός χρήστη',
	'maintenance-checkBadRedirects-output-footer' => 'Έγινε.',
	'maintenance-deleteBatch-desc' => 'Μαζική διαγραφή σελίδων',
	'maintenance-initSiteStats-desc' => 'Επανυπολογισμός των στατιστικών του ιστοτόπου',
	'maintenance-moveBatch-desc' => 'Μαζική μετακίνηση σελίδων',
	'maintenance-sql-desc' => 'Εκτέλεση ενός αιτήματος SQL',
	'maintenance-invalidname' => 'Μη έγκυρο όνομα χρήστη!',
	'maintenance-userexists' => 'Ο χρήστης υπάρχει ήδη!',
	'maintenance-invalidtitle' => 'Μη έγκυρος τίτλος "$1"!',
	'maintenance-titlenoexist' => 'Ο τίτλος που δόθηκε ("$1") δεν υπάρχει!',
	'maintenance-failed' => 'ΑΠΕΤΥΧΕ',
	'maintenance-deleted' => 'ΔΙΑΓΡΑΜΜΕΝΟΣ',
	'maintenance-revnotfound' => 'Η έκδοση $1 δεν βρέθηκε!',
	'maintenance-showCacheStats-edits' => 'Αριθμός επεξεργασιών: $1',
	'maintenance-showCacheStats-articles' => 'Αριθμός σελίδων στην κύρια περιοχή: $1',
	'maintenance-showCacheStats-pages' => 'Αριθμός σελίδων: $1',
	'maintenance-showCacheStats-users' => 'Αριθμός χρηστών: $1',
	'maintenance-showCacheStats-admins' => 'Αριθμός διαχειριστών: $1',
	'maintenance-showCacheStats-images' => 'Αριθμός αρχείων: $1',
	'maintenance-showCacheStats-views' => 'Αριθμός προβολών σελίδων: $1',
	'maintenance-showCacheStats-update' => 'Ενημέρωση βάσης δεδομένων{{int:ellipsis}}',
	'maintenance-move' => 'Μετακίνηση $1 σε $2{{int:ellipsis}}',
	'maintenance-error' => 'Σφάλμα: $1',
	'maintenance-memc-requests' => 'Αιτήσεις',
	'maintenance-memc-withsession' => 'με σύνοδο:',
	'maintenance-memc-withoutsession' => 'χωρίς σύνοδο:',
	'maintenance-memc-total' => 'σύνολο:',
	'maintenance-memc-parsercache' => 'Λανθάνουσα λεξιαναλυτή',
	'maintenance-memc-hits' => 'χτυπήματα:',
	'maintenance-memc-invalid' => 'μη έγκυρο:',
	'maintenance-memc-expired' => 'ληγμένο:',
	'maintenance-memc-absent' => 'απών:',
	'maintenance-memc-imagecache' => 'Λανθάνουσα μνήμη εικόνας',
	'maintenance-memc-misses' => 'αστοχίες:',
	'maintenance-memc-updates' => 'αναβαθμίσεις:',
	'maintenance-memc-uncacheable' => 'χωρίς λανθάνουσα μνήμη:',
	'maintenance-memc-diffcache' => 'Λανθάνουσα μνήμη διαφορών',
	'maintenance-re-nf' => 'Ο χρήστης $1 δεν βρέθηκε',
	'maintenance-re-ce' => 'Τωρινές επεξεργασίες: $1',
	'maintenance-re-de' => 'Διαγραμμένες επεξεργασίες: $1',
	'maintenance-re-rce' => 'Καταχωρήσεις ΠροσφάτωνΑλλαγών: $1',
	'maintenance-re-total' => 'Συνολικές καταχωρήσεις για αλλαγή: $1',
	'maintenance-re-re' => 'Έγινε επανανάθεση επεξεργασιών{{int:ellipsis}}',
);

/** British English (British English)
 * @author Shirayuki
 */
$messages['en-gb'] = array(
	'maintenance-cleanupCaps-desc' => 'Script to cleanup capitalisation',
);

/** Esperanto (Esperanto)
 * @author Michawiki
 * @author Yekrats
 */
$messages['eo'] = array(
	'maintenance-error-invalidtype' => 'La petita skripto ne estis trovita',
	'maintenance-option-confirm' => 'Konfirmi',
	'maintenance-output-success' => '$1 sukcesis!',
	'maintenance-changePassword-desc' => 'Ŝangi pasvorton de uzanto',
	'maintenance-deleteBatch-desc' => 'Amasforigi paĝojn',
	'maintenance-initSiteStats-desc' => 'Rekalkuli retejan statistikon',
	'maintenance-moveBatch-desc' => 'Amasmovi paĝojn',
	'maintenance-invalidname' => 'Nevalida salutnomo!',
	'maintenance-userexists' => 'Uzanto jam ekzistas!',
	'maintenance-invalidtitle' => 'Nevalida titolo "$1"!',
	'maintenance-failed' => 'MALSUKCESIS',
	'maintenance-deleted' => 'FORIGITA',
	'maintenance-revdelete' => 'Forigante {{PLURAL:$3|version|versiojn}} $1 el vikio $2',
	'maintenance-revnotfound' => 'Revisio $1 ne estas trovita!',
	'maintenance-showCacheStats-edits' => 'Nombro de redaktoj: $1',
	'maintenance-showCacheStats-articles' => 'Nombro de paĝoj en la ĉefa nomspaco: $1',
	'maintenance-showCacheStats-pages' => 'Nombro de paĝoj: $1',
	'maintenance-showCacheStats-users' => 'Nombro de uzantoj: $1',
	'maintenance-showCacheStats-admins' => 'Nombro de administrantoj: $1',
	'maintenance-showCacheStats-images' => 'Nombro de dosieroj: $1',
	'maintenance-showCacheStats-views' => 'Nombro de paĝvidoj: $1',
	'maintenance-showCacheStats-update' => 'Ĝisdatigante datumbazon{{int:ellipsis}}',
	'maintenance-move' => 'Movante $1 al $2{{int:ellipsis}}',
	'maintenance-error' => 'Eraro: $1',
	'maintenance-memc-requests' => 'Petoj',
	'maintenance-memc-withsession' => 'kun seanco:',
	'maintenance-memc-withoutsession' => 'sen seanco:',
	'maintenance-memc-total' => 'sumo:',
	'maintenance-memc-parsercache' => 'Kaŝmemoro de sintaksa analizilo',
	'maintenance-memc-hits' => 'trafoj:',
	'maintenance-memc-invalid' => 'nevalida:',
	'maintenance-memc-imagecache' => 'Bilda memorkaŝujo',
	'maintenance-memc-misses' => 'maltrafoj:',
	'maintenance-memc-updates' => 'ĝisdatigoj:',
	'maintenance-memc-diffcache' => 'Diferenca Kaŝmemoro',
	'maintenance-re-ce' => 'Nunaj redaktoj: $1',
	'maintenance-re-de' => 'Forigitaj redaktoj: $1',
);

/** Spanish (español)
 * @author Armando-Martin
 * @author Crazymadlover
 * @author Dalton2
 * @author Dferg
 * @author Fitoschido
 * @author Imre
 * @author Locos epraix
 * @author Mor
 * @author Pertile
 * @author Translationista
 */
$messages['es'] = array(
	'maintenance' => 'Ejecutar scripts de mantenimiento',
	'maintenance-desc' => '[[Special:Maintenance|Interfaz wiki]] para variados scripts de mantenimiento',
	'right-maintenance' => 'Ejecutar scripts de mantenimiento a través de [[Special:Maintenance]]',
	'maintenance-backlink' => 'Regresar a selección de escritura',
	'maintenance-header' => 'Por favor, seleccione el script de abajo para ejecutarlo.
Las descripciones están del lado de cada script',
	'maintenance-error-badini' => 'El archivo metadata.ini está dañado o no existe. Por favor, vuelva a descargar la extensión de mantenimiento',
	'maintenance-error-invalidtype' => 'El script especificado no fue encontrado',
	'maintenance-error-badargs' => 'No ha especificado todas las opciones necesarias',
	'maintenance-generic-done' => 'hecho',
	'maintenance-generic-username' => 'Nombre de usuario',
	'maintenance-generic-password' => 'Contraseña',
	'maintenance-generic-reason' => 'Motivo',
	'maintenance-cleanupTable-dry-run' => 'Realizar un simulacro',
	'maintenance-cleanupTable-check' => 'Comprobando títulos erróneos...',
	'maintenance-cleanupTable-checkfix' => 'Comprobando y corrigiendo títulos erróneos...',
	'maintenance-cleanupTable-progress' => '$1 $2: $3% hecho en $4; hora prevista de fin $5 [$6/$7] $8/s <$9% actualizado>',
	'maintenance-cleanupTable-missingparam' => '$1: Falta el parámetro $2',
	'maintenance-cleanupTable-processing' => 'Procesando $1...',
	'maintenance-cleanupTable-finished' => 'Terminado $1... $2 de $3 {{PLURAL:$3|línea actualizada|líneas actualizadas}}',
	'maintenance-option-quiet' => 'Eliminar la salida de todo lo que no sea un error',
	'maintenance-option-globals' => 'Mostrar las variables globales al final del proceso de depuración',
	'maintenance-option-confirm' => 'Confirmar',
	'maintenance-option-batch-size' => 'Ejecutar este número de operaciones por lotes; por defecto: $1',
	'maintenance-option-required' => '(obligatorio)',
	'maintenance-option-optional' => '(opcional)',
	'maintenance-output-success' => '$1 se ejecutó con éxito!',
	'maintenance-output-failure' => '¡$1no se ha ejecutado correctamente!',
	'maintenance-attachLatest' => 'Emplee este formulario para corregir las entradas en la tabla de la página en las que page_latest esté establecido en 0',
	'maintenance-attachLatest-desc' => 'Arreglar las entradas page_latest en la tabla de la página',
	'maintenance-attachLatest-option-fix' => 'Arreglar realmente las entradas; si no, realizar un simulacro',
	'maintenance-attachLatest-output-begin' => 'Buscando páginas con page_latest establecido a 0...',
	'maintenance-attachLatest-output-notime' => '$1 $2 [[$3]] no se puede encontrar la fecha de la última revisión?!',
	'maintenance-attachLatest-output-norev' => '$1 $2 [[$3]] última fecha  $4, no se puede encontrar el identificador de la revisión',
	'maintenance-attachLatest-output-found' => '$1 $2 [[$3]] última fecha $4, identificador de la revisión $5',
	'maintenance-attachLatest-output-done' => '¡Hecho! $1 {{PLURAL:$1|página procesada|páginas procesadas}}.',
	'maintenance-attachLatest-output-dryrun' => 'Esto fue un simulacro; vuelva a ejecutar el "script" con "{{int:maintenance-attachLatest-option-fix}}" para actualizar page_latest.',
	'maintenance-benchmarkPurge' => 'Utilice este formulario para probar cuánto tardan las funciones de limpieza de Squid',
	'maintenance-benchmarkPurge-desc' => 'Medir el tiempo de las funciones de limpeza de Squid',
	'maintenance-benchmarkPurge-option-count' => '¿Cuántas direcciones URL alimentan a calamarSquid para la limpieza',
	'maintenance-benchmarkPurge-error-nosquid' => 'La medida del grado de limpieza de Squid fue poco significativa sin el soporte para Squid activado.',
	'maintenance-benchmarkPurge-output-numsquids' => 'Hay $1 {{PLURAL:$1|servidor Squid definido|servidores Squid definidos}}:',
	'maintenance-benchmarkPurge-output-trial' => '$1 {{PLURAL:$1|título|títulos}} en $2 ms ($3 ms cada uno)',
	'maintenance-changePassword' => 'Utiliza este formulario para cambiar la contraseña de un usuario:',
	'maintenance-changePassword-desc' => 'Cambiar la contraseña de un usuario',
	'maintenance-changePassword-error-nouser' => 'No existe el usuario: $1',
	'maintenance-changePassword-output-set' => 'Contraseña establecida para $1',
	'maintenance-checkAutoLoader' => 'Utilice este formulario para hacer algunas comprobaciones de integridad en AutoLoader',
	'maintenance-checkAutoLoader-desc' => 'Comprobaciones de integridad de AutoLoader',
	'maintenance-checkAutoLoader-output-list2' => '$1: Archivo erróneo: encontrado en $2, listado en $3',
	'maintenance-checkBadRedirects' => 'Utilice este formulario para ver si las páginas señaladas como redirecciones son realmente redirecciones',
	'maintenance-checkBadRedirects-desc' => 'Comprobación de redirecciones erróneas',
	'maintenance-checkBadRedirects-output-header' => 'Obtención de redirecciones...',
	'maintenance-checkBadRedirects-output-found' => 'Se encontraron $1 {{PLURAL:$1|redirección|redirecciones}}.
Comprobando las redirecciones erróneas...',
	'maintenance-checkBadRedirects-output-footer' => 'Hecho.',
	'maintenance-checkImages' => 'Utilice este formulario para ver qué imágenes de su wiki están dañadas',
	'maintenance-checkImages-desc' => 'Compruebe las imágenes para ver si existen, son legibles, etc.',
	'maintenance-checkImages-output-noaccess' => '$1: no accesible localmente',
	'maintenance-checkImages-output-missing' => '$1: Inexistente',
	'maintenance-checkImages-output-isdir' => '$1: es un directorio',
	'maintenance-checkImages-output-truncated' => '$1: truncado, era $2',
	'maintenance-checkImages-output-mismatch' => '$1: tamaño incompatible; base de datos=$2, real=$3',
	'maintenance-checkImages-output-good' => 'Buenas imágenes:  $1/$2',
	'maintenance-checkSyntax' => 'Utilice este formulario para comprobar la sintaxis de todos los archivos PHP de MediaWiki',
	'maintenance-checkSyntax-desc' => 'Compruebe la sintaxis para todos los archivos PHP de MediaWiki',
	'maintenance-checkSyntax-option-with-extensions' => 'Recorrer también la carpeta de extensiones',
	'maintenance-checkSyntax-option-path' => 'Ruta de acceso específica (archivo o directorio) para comprobar, con ruta de acceso absoluta o relativa a la raíz de esta instalación de MediaWiki',
	'maintenance-checkSyntax-option-list-file' => 'Lista de archivos o directorios para comprobar',
	'maintenance-checkSyntax-option-modified' => 'Comprobar solamente los archivos que sufrieron modificaciones (necesita el cliente SVN en la línea de comandos)',
	'maintenance-checkSyntax-option-syntax-only' => 'Compruebe sólo la validez de la sintaxis, omitir las advertencias sobre estilo de código',
	'maintenance-checkSyntax-output-parsekit' => 'Comprobación de sintaxis (mediante parsekit)',
	'maintenance-checkSyntax-output-phpl' => 'Comprobación de sintaxis (usando php -l, esto puede tardar mucho tiempo)',
	'maintenance-checkSyntax-output-footer' => '¡Hecho!  $1 archivos comprobados, $2  fallos y  $3 avisos encontrados',
	'maintenance-checkSyntax-output-svnlist' => 'Recuperando la lista desde Subversion...',
	'maintenance-checkSyntax-output-buildlist' => 'Construyendo la lista de archivos...',
	'maintenance-checkSyntax-output-error' => 'Error en $1  línea  $2: $3',
	'maintenance-checkSyntax-output-warning' => 'Atención en el archivo  $1 :  $2  encontrado',
	'maintenance-checkSyntax-error-nofile' => 'Error: no se puede encontrar el archivo o el directorio $1',
	'maintenance-checkSyntax-error-cantopen' => 'No se puede abrir el archivo $1',
	'maintenance-checkSyntax-error-svnerr' => '¡Error al recuperar la lista desde Subversion!',
	'maintenance-checkUsernames' => 'Utilice este formulario para mostrar los nombres de usuario inválidos debido a cambios en la configuración. Si nada aparece después de ejecutar esta secuencia de comandos, todos los nombres de usuario son válidos',
	'maintenance-checkUsernames-desc' => 'Compruebe que los nombres de usuario de base de datos son realmente válidos',
	'maintenance-checkUsernames-error-notvalid' => 'Nombre de usuario no válido: "$3" (identificador de usuario  $2 )',
	'maintenance-cleanupCaps' => 'Utilice este formulario para arreglar páginas rotas causadas por modificación de $wgCapitalLinks',
	'maintenance-cleanupCaps-desc' => 'Secuencia de comandos (script) para limpiar la utilización de mayúsculas y minúsculas',
	'maintenance-cleanupCaps-option-namespace' => 'Número del espacio de nombres en el que realizar la limpieza de la utilización de mayúsculas y minúsculas',
	'maintenance-cleanupCaps-output-islower' => '"$1" ya en minúsculas.',
	'maintenance-cleanupCaps-output-clash' => '"$1" saltado; "$2" ya existe',
	'maintenance-cleanupCaps-output-dryrun' => '"$1" -> "$2": SIMULACRO, NO TRASLADADO',
	'maintenance-cleanupCaps-error-noneed' => '$wgCapitalLinks está activado; no se necesita realizar la limpeza de la utilización de mayúsculas y minúsculas.',
	'maintenance-cleanupSpam' => 'Utilice este formulario para revertir las ediciones de spam que enlazan a sitios externos',
	'maintenance-cleanupSpam-desc' => 'Limpiar todo el spam procedente de un servidor (host) determinado',
	'maintenance-cleanupSpam-option-hostname' => 'Nombre del host que estaba causando spam',
	'maintenance-cleanupSpam-output-found' => 'Se ha encontrado $1 {{PLURAL:$1|artículo|artículos}} que contienen $2',
	'maintenance-cleanupSpam-output-false' => 'Concordancia errónea',
	'maintenance-cleanupSpam-output-blanking' => 'Borrado',
	'maintenance-cleanupSpam-output-reverting' => 'Reversión',
	'maintenance-cleanupSpam-error-invalid' => 'No es una especificación de nombre de host válido: $1',
	'maintenance-cleanupSpam-error-noid' => 'Error interno: no hay ninguna página con el identificador ID $1',
	'maintenance-clearInterwikiCache' => 'Utilice este formulario para borrar completamente la memoria caché de interwikis',
	'maintenance-clearInterwikiCache-desc' => 'Borrar todos los enlaces interwiki para todos los idiomas de la memoria caché',
	'maintenance-createAndPromote' => 'Usar este formulario para crear un nuevo usuario y promoverlo para administrador.
Verificar la tabla de burócrata si deseas promoverlo a burócrata también',
	'maintenance-createAndPromote-desc' => 'Crear un usuario y promoverlo al status de administrador',
	'maintenance-createAndPromote-option-bureaucrat' => 'Promover al usuario a estado de burócrata',
	'maintenance-createAndPromote-output-creating' => 'Creación y promoción del usuario: $2 ...',
	'maintenance-createAndPromote-error-password' => 'Se detectó un error en la contraseña que ha introducido: $1',
	'maintenance-deleteBatch' => 'Usar este formulario para borrado masivo de páginas.
Coloque solamente una página por línea',
	'maintenance-deleteBatch-desc' => 'Borrao masivo de páginas',
	'maintenance-deleteRevision' => 'Usar este formulario para borrado masivo de revisiones.
Coloque solamente un número de revisión por línea',
	'maintenance-deleteRevision-desc' => 'Quitar las revisiones de la base de datos',
	'maintenance-initEditCount-desc' => 'Recalcular los conteos de ediciones de los usuarios',
	'maintenance-initSiteStats' => 'Usar este formulario para recalcular estadísticas del sitio, especificando si deseas recalcular vistas de página también',
	'maintenance-initSiteStats-desc' => 'Recalcular estadísticas del sitio',
	'maintenance-moveBatch' => 'Use este formulario para trasladar páginas en masa. Cada línea debe especificar una página fuente y página destino separadas por una barra (“|”)',
	'maintenance-moveBatch-desc' => 'Movilización masiva de páginas',
	'maintenance-reassignEdits-desc' => 'Reasignar ediciones de un usuario a otro',
	'maintenance-runJobs-desc' => 'Ejecutar los trabajos de la cola de trabajos',
	'maintenance-runJobs-option-maxjobs' => 'Número máximo de trabajos a ejecutar',
	'maintenance-runJobs-option-type' => 'Tipo de trabajo a ejecutar',
	'maintenance-runJobs-option-procs' => 'Número de procesos a utilizar',
	'maintenance-runJobs-option-exclusive' => 'Ejecute exclusivamente una secuencia de comandos (script) de runJobs a la vez. El tiempo de espera (timeout) es de 1800 segundos.',
	'maintenance-runJobs-error-invalidprocs' => 'Debe especificar entre 1 y 1000 procesos',
	'maintenance-showJobs-desc' => 'Mostrar un listado de trabajos pendientes en la cola de trabajo',
	'maintenance-showJobs-option-group' => 'Mostrar el número de trabajos por tipo de trabajo',
	'maintenance-sql' => 'Utilizar este formulario para ejecutar una consulta SQL en la base de datos.',
	'maintenance-sql-desc' => 'Ejecutar una consulta SQL',
	'maintenance-sql-option-file' => 'SQL a ejecutar',
	'maintenance-sql-output-aff' => 'Consulta correcta, $1 {{PLURAL:$1|línea afectada|líneas afectadas}}',
	'maintenance-sql-error-cantopen' => 'No se puede abrir el archivo de entrada',
	'maintenance-showCacheStats-desc' => 'Mostrar estadísticas Memcached',
	'maintenance-eval' => 'Utiliza este formulario para evaluar código PHP en ambiente MediaWiki.',
	'maintenance-eval-desc' => 'Evaluar código PHP en ambiente MediaWiki',
	'maintenance-update' => '¿Utilizar UPDATE cuando se actualiza una tabla? Si está desmarcado utiliza DELETE/INSERT en lugar de UPDATE.',
	'maintenance-noviews' => 'Verificar esto para evitar la actualización del número de vistas a la página',
	'maintenance-invalidname' => '¡Nombre de usuario no válido!',
	'maintenance-userexists' => 'Usuario ya existe!',
	'maintenance-invalidtitle' => 'Título inválido "$1"!',
	'maintenance-titlenoexist' => 'Título especificado ("$1") no existe!',
	'maintenance-failed' => 'FALLADO',
	'maintenance-deleted' => 'BORRADO',
	'maintenance-revdelete' => 'Borrando {{PLURAL:$3|revisión|revisiones}} $1 del wiki $2',
	'maintenance-revnotfound' => 'Revisión $1 no encontrada!',
	'maintenance-showCacheStats-edits' => 'Número de ediciones: $1',
	'maintenance-showCacheStats-articles' => 'Número de páginas en el espacio de nombre principal: $1',
	'maintenance-showCacheStats-pages' => 'Número de páginas: $1',
	'maintenance-showCacheStats-users' => 'Número de usuarios: $1',
	'maintenance-showCacheStats-admins' => 'Número de administradores: $1',
	'maintenance-showCacheStats-images' => 'Número de archivos: $1',
	'maintenance-showCacheStats-views' => 'Número de vistas de página: $1',
	'maintenance-showCacheStats-update' => 'Actualizando base de datos...',
	'maintenance-move' => 'Trasladando $1 a $2...',
	'maintenance-movefail' => 'Se ha producido un error mientras se trasladaba: $1.
Se cancela el traslado.',
	'maintenance-error' => 'Error: $1',
	'maintenance-memc-fake' => 'Estás ejecutando FakeMemCachedClient. Estadísticas no pueden ser proveídas',
	'maintenance-memc-requests' => 'Solicitudes',
	'maintenance-memc-withsession' => 'Con sesión:',
	'maintenance-memc-withoutsession' => 'sin sesión:',
	'maintenance-memc-total' => 'total:',
	'maintenance-memc-parsercache' => 'Cache de analizador',
	'maintenance-memc-hits' => 'resultados:',
	'maintenance-memc-invalid' => 'inválido:',
	'maintenance-memc-expired' => 'expirado:',
	'maintenance-memc-absent' => 'ausente:',
	'maintenance-memc-stub' => 'umbral de esbozo:',
	'maintenance-memc-imagecache' => 'Cache de imagen',
	'maintenance-memc-misses' => 'fallos:',
	'maintenance-memc-updates' => 'actualizaciones:',
	'maintenance-memc-uncacheable' => 'no almacenable en caché:',
	'maintenance-memc-diffcache' => 'Caché de Dif',
	'maintenance-reassignEdits' => 'Usar este formulario para reasignar ediciones de un usuario a otro.',
	'maintenance-re-from' => 'Nombre del usuario desde el cual se asigna ediciones',
	'maintenance-re-to' => 'Nombre del usuario a quien se asigna ediciones',
	'maintenance-re-force' => 'Reasignar incluso si el usuario de destino no existe',
	'maintenance-re-rc' => 'No actualizar la tabla de cambios recientes',
	'maintenance-re-report' => 'Imprimir los detalles de lo que cambiaría, pero no actualizar',
	'maintenance-re-nf' => 'Usuario $1 no encontrado',
	'maintenance-re-rr' => 'Ejecutar el script de nuevo sin actualizar "$1".',
	'maintenance-re-ce' => 'Ediciones actuales: $1',
	'maintenance-re-de' => 'Ediciones borradas: $1',
	'maintenance-re-rce' => 'Entradas de cambios recientes: $1',
	'maintenance-re-total' => 'Cantidad total de entradas a cambiar: $1',
	'maintenance-re-re' => 'Reasignando las ediciones {{int:ellipsis}} hecho',
);

/** Estonian (eesti)
 * @author Avjoska
 * @author Pikne
 * @author Silvar
 */
$messages['et'] = array(
	'maintenance-error-invalidtype' => 'Määratud skripti ei leidu.',
	'maintenance-generic-done' => 'valmis',
	'maintenance-generic-username' => 'Kasutajanimi',
	'maintenance-generic-password' => 'Parool',
	'maintenance-generic-reason' => 'Põhjus',
	'maintenance-option-confirm' => 'Kinnita',
	'maintenance-changePassword-desc' => 'Muuda kasutaja parool',
	'maintenance-checkBadRedirects-output-footer' => 'Valmis.',
	'maintenance-checkSyntax-output-buildlist' => 'Faililoendi loomine...',
	'maintenance-deleteBatch-desc' => 'Lehekülgede lauskustutamine',
	'maintenance-invalidname' => 'Vigane kasutajanimi!',
	'maintenance-userexists' => 'Kasutaja on juba olemas!',
	'maintenance-failed' => 'NURJUS',
	'maintenance-deleted' => 'KUSTUTATUD',
	'maintenance-error' => 'Tõrge: $1',
	'maintenance-memc-total' => 'kokku:',
	'maintenance-memc-hits' => 'vaatamisi:',
	'maintenance-memc-invalid' => 'ei sobi:',
	'maintenance-memc-expired' => 'aegunud:',
	'maintenance-memc-absent' => 'puudub:',
	'maintenance-memc-updates' => 'uuendused:',
	'maintenance-re-nf' => 'Kasutajat $1 ei leidu',
);

/** Basque (euskara)
 * @author An13sa
 * @author පසිඳු කාවින්ද
 */
$messages['eu'] = array(
	'maintenance-generic-username' => 'Erabiltzaile izena',
	'maintenance-generic-password' => 'Pasahitza',
	'maintenance-generic-reason' => 'Arrazoia',
	'maintenance-option-confirm' => 'Baieztatu',
	'maintenance-invalidname' => 'Lankide izen okerra!',
	'maintenance-deleted' => 'EZABATUA',
	'maintenance-memc-total' => 'guztira:',
);

/** Persian (فارسی)
 * @author Mjbmr
 * @author پاناروما
 */
$messages['fa'] = array(
	'maintenance-generic-done' => 'انجام شد',
	'maintenance-generic-username' => 'نام کاربری',
	'maintenance-generic-password' => 'گذرواژه',
	'maintenance-generic-reason' => 'دلیل',
	'maintenance-option-confirm' => 'تأیید',
	'maintenance-option-required' => '(اجباری)',
	'maintenance-option-optional' => '(اختیاری)',
	'maintenance-checkBadRedirects-output-footer' => 'انجام شد.',
	'maintenance-checkSyntax-error-cantopen' => 'پرونده باز نمی‌شود $1',
	'maintenance-invalidname' => 'نام کاربری نامعتبر!',
	'maintenance-userexists' => 'کاربر در حال حاضر وجود دارد!',
	'maintenance-invalidtitle' => 'عنوان نامعتبر «$1»!',
	'maintenance-error' => 'خطا: $1',
	'maintenance-memc-requests' => 'درخواست‌ها',
	'maintenance-memc-total' => 'مجموع',
	'maintenance-memc-updates' => 'به روز رسانی‌ها:',
	'maintenance-re-nf' => 'کاربر $1 یافت نشد',
);

/** Finnish (suomi)
 * @author Beluga
 * @author Cimon Avaro
 * @author Crt
 * @author Jack Phoenix
 * @author Nedergard
 * @author Nike
 * @author Silvonen
 * @author Str4nd
 * @author Vililikku
 * @author ZeiP
 */
$messages['fi'] = array(
	'maintenance' => 'Suorita ylläpitoskriptejä',
	'maintenance-desc' => '[[Special:Maintenance|Wikikäyttöliittymä]] muutamille wikin ylläpitoon tarkoitetuille komentosarjoille.',
	'right-maintenance' => 'Ajaa ylläpitotyökaluita toimintosivun [[Special:Maintenance]] kautta',
	'maintenance-backlink' => 'Takaisin skriptin valintaan',
	'maintenance-header' => 'Valitse suoritettava skripti alapuolelta.
	Skriptien kuvaukset ovat niiden nimien vieressä',
	'maintenance-error-invalidtype' => 'Kelvoton tyyppi!', # Fuzzy
	'maintenance-error-badargs' => 'Kaikkia pakollisia tietoja ei ole annettu.',
	'maintenance-generic-done' => 'valmis',
	'maintenance-generic-username' => 'Käyttäjätunnus',
	'maintenance-generic-password' => 'Salasana',
	'maintenance-generic-reason' => 'Syy',
	'maintenance-cleanupTable-dry-run' => 'Tee koeajo',
	'maintenance-cleanupTable-missingparam' => '$1: Puuttuu parametri $2',
	'maintenance-option-confirm' => 'Vahvista',
	'maintenance-option-required' => '(pakollinen)',
	'maintenance-option-optional' => '(valinnainen)',
	'maintenance-output-success' => '$1 ajettiin onnistuneesti.',
	'maintenance-changePassword' => 'Vaihda käyttäjän salasana tällä lomakkeella',
	'maintenance-changePassword-desc' => 'Muuta käyttäjän salasana',
	'maintenance-changePassword-error-nouser' => 'Käyttäjää ei ole: $1',
	'maintenance-checkBadRedirects-output-footer' => '
Valmis.',
	'maintenance-checkImages-output-missing' => '$1: puuttuu',
	'maintenance-checkImages-output-isdir' => '$1: on hakemisto',
	'maintenance-checkImages-output-truncated' => '$1: katkaistu, oli $2',
	'maintenance-checkImages-output-mismatch' => '$1: kokoristiriita: tietokannassa $2, todellinen koko $3',
	'maintenance-checkSyntax-option-list-file' => 'Tarkistettavien tiedostojen ja hakemistojen luettelo',
	'maintenance-checkSyntax-output-buildlist' => 'Kootaan tiedostoluetteloa...',
	'maintenance-checkSyntax-output-warning' => 'Varoitus tiedostossa $1: $2 löytyi',
	'maintenance-checkSyntax-error-nofile' => 'Virhe: tiedostoa tai hakemistoa $1 ei löytynyt',
	'maintenance-checkSyntax-error-cantopen' => 'Tiedostoa $1 ei voitu avata',
	'maintenance-createAndPromote' => 'Käytä tätä lomaketta luodaksesi uuden käyttäjän ja ylentääksesi hänet ylläpitäjäksi.
Laita myös rasti byrokraatti-laatikkoon jos haluat ylentää käyttäjän byrokraatiksi',
	'maintenance-createAndPromote-desc' => 'Luo käyttäjä ja lisää ylläpitäjäksi',
	'maintenance-deleteBatch' => 'Käytä tätä lomaketta sivujen massapoistamiseen.
Laita vain yhden sivun nimi riviä kohden',
	'maintenance-deleteBatch-desc' => 'Massapoista sivuja',
	'maintenance-deleteRevision' => 'Käytä tätä lomaketta versioiden massapoistamiseen.
Laita vain yhden version numero riviä kohden',
	'maintenance-deleteRevision-desc' => 'Poista versioita tietokannasta',
	'maintenance-initEditCount-desc' => 'Laske uudelleen käyttäjien muokkausmäärät',
	'maintenance-initSiteStats' => 'Käytä tätä lomaketta sivuston tilastojen uudelleenlaskemiseen, määritellen myös, haluatko uudelleenlaskea sivujen näyttökerrat',
	'maintenance-initSiteStats-desc' => 'Laske sivuston tilastot uudelleen',
	'maintenance-moveBatch' => 'Käytä tätä lomaketta sivujen massasiirtoon.
Jokaisella rivillä tulisi olla lähdesivu ja kohdesivu pystyviivan erottamina',
	'maintenance-moveBatch-desc' => 'Massasiirrä sivuja',
	'maintenance-reassignEdits-desc' => 'Määritä muokkauksia käyttäjältä toiselle',
	'maintenance-runJobs-desc' => 'Aja työt ohjelmiston ylläpitotyöjonosta',
	'maintenance-showJobs-desc' => 'Näytä lista töistä ylläpitotyöjonossa',
	'maintenance-sql' => 'Tällä lomakkeella voit tehdä SQL-kyselyitä tietokannasta.',
	'maintenance-sql-desc' => 'Suorita SQL-kysely',
	'maintenance-showCacheStats-desc' => 'Näytä Memcached-tilastot',
	'maintenance-eval' => 'Käytä tätä lomaketta PHP-koodin suorittamiseksi MediaWiki-ympäristössä.',
	'maintenance-eval-desc' => 'Suorittaa PHP-koodia MediaWiki-ympäristössä.',
	'maintenance-update' => 'Käytä UPDATE-lausekkeita taulua päivitettäessä? Jos tätä ei ole valittu, DELETE/INSERT-lausekkeita käytetään sen sijaan.',
	'maintenance-noviews' => 'Valitse tämä estääksesi sivujen näyttökertojen päivittämisen',
	'maintenance-invalidname' => 'Virheellinen käyttäjätunnus.',
	'maintenance-userexists' => 'Käyttäjä on jo olemassa.',
	'maintenance-invalidtitle' => 'Kelvoton otsikko "$1"!',
	'maintenance-titlenoexist' => 'Määritellyn otsikon ("$1") mukaista artikkelia ei ole olemassa!',
	'maintenance-failed' => 'EPÄONNISTUI',
	'maintenance-deleted' => 'POISTETTU',
	'maintenance-revdelete' => 'Poistetaan {{PLURAL:$3|versio|versiot}} $1 wikistä $2',
	'maintenance-revnotfound' => 'Versiota $1 ei löydy.',
	'maintenance-showCacheStats-edits' => 'Muokkauksia yhteensä: $1',
	'maintenance-showCacheStats-articles' => 'Sivujen määrä päänimiavaruudessa: $1',
	'maintenance-showCacheStats-pages' => 'Sivuja yhteensä: $1',
	'maintenance-showCacheStats-users' => 'Käyttäjiä yhteensä: $1',
	'maintenance-showCacheStats-admins' => 'Ylläpitäjiä yhteensä: $1',
	'maintenance-showCacheStats-images' => 'Tiedostoja yhteensä: $1',
	'maintenance-showCacheStats-views' => 'Sivuja näytetty yhteensä: $1',
	'maintenance-showCacheStats-update' => 'Päivitetään tietokantaa{{int:ellipsis}}',
	'maintenance-move' => 'Siirretään $1 nimelle $2{{int:ellipsis}}',
	'maintenance-movefail' => 'Tapahtui virhe siirrettäessä sivua: $1.
Keskeytetään siirto',
	'maintenance-error' => 'Virhe: $1',
	'maintenance-memc-fake' => 'Käytössä on FakeMemCachedClient. Tilastoja ei voida tarjota',
	'maintenance-memc-requests' => 'Pyynnöt',
	'maintenance-memc-withsession' => 'istunnon kera:',
	'maintenance-memc-withoutsession' => 'ilman istuntoa:',
	'maintenance-memc-total' => 'yhteensä:',
	'maintenance-memc-parsercache' => 'Jäsentimen välimuisti',
	'maintenance-memc-hits' => 'osumia:',
	'maintenance-memc-invalid' => 'kelvottomia:',
	'maintenance-memc-expired' => 'vanhentunut:',
	'maintenance-memc-absent' => 'poissa:',
	'maintenance-memc-stub' => 'tyngän raja:',
	'maintenance-memc-imagecache' => 'Kuvien välimuisti',
	'maintenance-memc-misses' => 'huteja:',
	'maintenance-memc-updates' => 'päivityksiä:',
	'maintenance-memc-uncacheable' => 'ei-välimuistitettava:',
	'maintenance-memc-diffcache' => 'Erolistausvälimuisti',
	'maintenance-reassignEdits' => 'Käytä tätä lomaketta määrittääksesi muokkauksen yhdeltä käyttäjältä toiselle.',
	'maintenance-re-from' => 'Sen käyttäjän nimi, jolta muokkaus otetaan',
	'maintenance-re-to' => 'Sen käyttäjän nimi, jolle muokkaus annetaan',
	'maintenance-re-force' => 'Määritä uudelleen, vaikka kohdekäyttäjää ei olisi olemassa',
	'maintenance-re-rc' => 'Älä päivitä tuoreet muutokset -taulua',
	'maintenance-re-report' => 'Tulosta tiedot siitä mitä muutettaisiin, mutta älä tee muutoksia',
	'maintenance-re-nf' => 'Käyttäjää $1 ei löydy',
	'maintenance-re-rr' => 'Aja komentosarja uudestaan ilman valintaa ”$1” tehdäksesi muutokset.',
	'maintenance-re-ce' => 'Nykyisiä muokkauksia: $1',
	'maintenance-re-de' => 'Poistettuja muokkauksia: $1',
	'maintenance-re-rce' => 'Tuoreiden muutosten tietueet: $1',
	'maintenance-re-total' => 'Yhteensä muutoksia: $1',
	'maintenance-re-re' => 'Määritetään uudestaan muokkauksia{{int:ellipsis}} valmis',
);

/** French (français)
 * @author Crochet.david
 * @author Gomoko
 * @author Grondin
 * @author Hashar
 * @author IAlex
 * @author Justadust
 * @author Marc-André Beauchamp
 * @author PieRRoMaN
 * @author Sherbrooke
 * @author Urhixidur
 * @author Verdy p
 * @author Zetud
 */
$messages['fr'] = array(
	'maintenance' => 'Lancer les scripts de maintenance',
	'maintenance-desc' => '[[Special:Maintenance|Interface Web]] pour divers scripts de maintenance',
	'right-maintenance' => 'Lancer des scripts de maintenance depuis [[Special:Maintenance]]',
	'maintenance-backlink' => 'Retour à la sélection du script',
	'maintenance-header' => 'Veuillez sélectionner, ci-dessous, un script à exécuter.
Les descriptions sont à la suite de chacun de ceux-ci.',
	'maintenance-error-badini' => "Le fichier metadata.ini est endommagé ou manquant. Veuillez retélécharger l'extension Maintenance",
	'maintenance-error-invalidtype' => "Le script spécifié n'a pas été trouvé",
	'maintenance-error-badargs' => "Vous n'avez pas renseigné toutes les options requises",
	'maintenance-generic-done' => 'fait',
	'maintenance-generic-username' => 'Nom d’utilisateur',
	'maintenance-generic-password' => 'Mot de passe',
	'maintenance-generic-reason' => 'Raison',
	'maintenance-cleanupTable-dry-run' => 'Effectuer un passage sans modifier la base de données',
	'maintenance-cleanupTable-check' => 'Vérification des mauvais titres...',
	'maintenance-cleanupTable-checkfix' => 'Vérification et correction des mauvais titres...',
	'maintenance-cleanupTable-progress' => '$1 $2: $3% effectué(s) sur $4; ETA $5 [$6/$7] $8/sec <$9% mis à jour>',
	'maintenance-cleanupTable-missingparam' => '$1: Paramètre manquant $2',
	'maintenance-cleanupTable-processing' => 'En cours de traitement $1...',
	'maintenance-cleanupTable-finished' => 'Terminé $1... $2 sur $3 {{PLURAL:$3|ligne mise|lignes mises}} à jour',
	'maintenance-option-quiet' => "Supprimer la sortie de tout ce qui n'est pas une erreur",
	'maintenance-option-globals' => 'Afficher les variables globales à la fin du traitement pour le débogage',
	'maintenance-option-confirm' => 'Confirmer',
	'maintenance-option-batch-size' => "Exécutez ce nombre d'opérations par lot, par défaut : $1",
	'maintenance-option-required' => '(Requis)',
	'maintenance-option-optional' => '(facultatif)',
	'maintenance-output-success' => '$1 s’est déroulé avec succès !',
	'maintenance-output-failure' => "$1 ne s'est pas exécuté correctement!",
	'maintenance-attachLatest' => 'Utilisez ce formulaire pour corriger les entrées dans la table « page » où « page_latest » est définie à 0',
	'maintenance-attachLatest-desc' => 'Corriger les entrées « page_latest » dans la table « page »',
	'maintenance-attachLatest-option-fix' => "Réellement corriger les entrées, autrement n'affichera que les entrées érronnées mais sans les corriger",
	'maintenance-attachLatest-output-begin' => 'Recherche des pages avec page_latest à 0 ...',
	'maintenance-attachLatest-output-notime' => '$1 $2 [[$3]] impossible de trouver la date de la dernière révision ?!',
	'maintenance-attachLatest-output-norev' => "$1 $2 [[$3]] dernière date $4, impossible de trouver l'ID de la révision",
	'maintenance-attachLatest-output-found' => '$1 $2 [[$3]] date de la dernière révision $4, ID de la révision $5',
	'maintenance-attachLatest-output-done' => 'Fait ! $1 page{{PLURAL:$1||s}} traitée{{PLURAL:$1||s}}.',
	'maintenance-attachLatest-output-dryrun' => "Il s'agit d'un essai ; relancez le script avec « {{int:maintenance-attachLatest-option-fix}} » pour modifier page_latest.",
	'maintenance-benchmarkPurge' => 'Utilisez ce formulaire pour mesurer le temps que les fonctions de purge de Squid prennent',
	'maintenance-benchmarkPurge-desc' => "Mesurer le temps d'exécution des fonctions de purge de Squid",
	'maintenance-benchmarkPurge-option-count' => "Le nombre d'URL à donner à Squid pour la purge",
	'maintenance-benchmarkPurge-error-nosquid' => "La mesure du temps d'exécution ne fait pas grand chose sans le support de Squid activé.",
	'maintenance-benchmarkPurge-output-numsquids' => 'Il y a $1 {{PLURAL:$1|serveur Squid défini|serveurs Squid définis}}  :',
	'maintenance-benchmarkPurge-output-trial' => '$1 {{PLURAL:$1|titre|titres}} en $2 ms ($3 ms chacun)',
	'maintenance-changePassword' => 'Utiliser ce formulaire pour changer le mot de passe d’un utilisateur',
	'maintenance-changePassword-desc' => 'Changer le mot de passe d’un utilisateur',
	'maintenance-changePassword-error-nouser' => 'Aucun utilisateur « $1 »',
	'maintenance-changePassword-output-set' => 'Mot de passe défini pour $1',
	'maintenance-checkAutoLoader' => "Utilisez ce formulaire pour faire certaines vérifications d'intégrité du chargeur automatique",
	'maintenance-checkAutoLoader-desc' => "Contrôles d'intégrité du chargeur automatique",
	'maintenance-checkAutoLoader-output-list2' => '$1 : mauvais fichier : trouvé dans $2, répertorié dans $3',
	'maintenance-checkBadRedirects' => 'Utilisez ce formulaire pour voir si les pages marquées comme redirection sont vraiment des redirections',
	'maintenance-checkBadRedirects-desc' => 'Rechercher des mauvaises redirections',
	'maintenance-checkBadRedirects-output-header' => 'Récupération des redirections...',
	'maintenance-checkBadRedirects-output-found' => '$1 {{PLURAL:$1|redirection trouvée|redirections trouvées}}.
Recherche des mauvaises redirections...',
	'maintenance-checkBadRedirects-output-footer' => 'Fait.',
	'maintenance-checkImages' => 'Utilisez ce formulaire pour voir quelles images sur votre wiki sont corrompues.',
	'maintenance-checkImages-desc' => 'Vérifier les images pour voir si elles existent, sont lisibles, etc',
	'maintenance-checkImages-output-noaccess' => '$1 : non accessible localement',
	'maintenance-checkImages-output-missing' => '$1 : absent',
	'maintenance-checkImages-output-isdir' => '$1 : est un répertoire',
	'maintenance-checkImages-output-truncated' => '$1 : tronqué, était $2',
	'maintenance-checkImages-output-mismatch' => '$1: taille incompatible, base de données = $2, effectif = $3',
	'maintenance-checkImages-output-good' => 'Bonnes images : $1 / $2',
	'maintenance-checkSyntax' => 'Utilisez ce formulaire pour vérifier la syntaxe de tous les fichiers PHP dans MediaWiki',
	'maintenance-checkSyntax-desc' => 'Vérifier la syntaxe pour tous les fichiers PHP dans MediaWiki',
	'maintenance-checkSyntax-option-with-extensions' => 'Également parcourir le dossier des extensions',
	'maintenance-checkSyntax-option-path' => "Chemin d'accès spécifique (fichier ou répertoire) à vérifier, avec le chemin d'accès absolu ou relatif à la racine de cette installation de MediaWiki",
	'maintenance-checkSyntax-option-list-file' => 'Liste des fichiers ou répertoires à vérifier',
	'maintenance-checkSyntax-option-modified' => 'Ne vérifier que les fichiers qui ont été modifiés (requiert le client SVN en ligne de commande)',
	'maintenance-checkSyntax-option-syntax-only' => 'Ne vérifier que la validité de la syntaxe, ignorer les avertissements sur le style du code',
	'maintenance-checkSyntax-output-parsekit' => 'Vérification de la syntaxe (utilisation de parsekit)',
	'maintenance-checkSyntax-output-phpl' => 'Vérification de la syntaxe (en utilisant php-l, ce qui peut prendre un certain temps)',
	'maintenance-checkSyntax-output-footer' => 'Fait ! $1 fichiers vérifiés, $2 échecs et $3 avertissements trouvés',
	'maintenance-checkSyntax-output-svnlist' => 'Récupération de la liste de Subversion ...',
	'maintenance-checkSyntax-output-buildlist' => 'Construction de la liste de fichiers ...',
	'maintenance-checkSyntax-output-error' => 'Erreur dans $1, ligne $2 : $3',
	'maintenance-checkSyntax-output-warning' => 'Avertissement dans le fichier $1 : $2 trouvé',
	'maintenance-checkSyntax-error-nofile' => 'Erreur : ne peut pas trouver le fichier ou le répertoire $1',
	'maintenance-checkSyntax-error-cantopen' => 'Impossible d’ouvrir le fichier $1',
	'maintenance-checkSyntax-error-svnerr' => 'Erreur lors de la récupération de la liste depuis Subversion !',
	'maintenance-checkUsernames' => "Utilisez ce formulaire pour afficher les noms d'utilisateur invalides en raison de modifications de la configuration. Si rien n'est affiché après l'exécution de ce script, alors tous les noms d'utilisateur sont valides",
	'maintenance-checkUsernames-desc' => "Vérifie que les noms d'utilisateur de la base de données sont effectivement valides",
	'maintenance-checkUsernames-error-notvalid' => 'Nom d’utilisateur non valide : « $3 » (Utilisateur ID $2)',
	'maintenance-cleanupCaps' => 'Utilisez ce formulaire pour corriger les pages cassées par la modification de $wgCapitalLinks',
	'maintenance-cleanupCaps-desc' => 'Script pour nettoyer la capitalisation',
	'maintenance-cleanupCaps-option-namespace' => "Numéro de l'espace de noms dans lequel nettoyer la capitalisation",
	'maintenance-cleanupCaps-output-islower' => '« $1 » déjà en minuscules.',
	'maintenance-cleanupCaps-output-clash' => '« $1 » ignoré; « $2 » existe déjà',
	'maintenance-cleanupCaps-output-dryrun' => '« $1 » -> « $2 » : MODE ESSAI, NON DÉPLACÉ',
	'maintenance-cleanupCaps-error-noneed' => '$wgCapitalLinks est activé -- aucun besoin de nettoyer les liens avec majuscule.',
	'maintenance-cleanupSpam' => 'Utilisez ce formulaire pour rétablir les modifications de pourriel qui pointent vers des sites externes',
	'maintenance-cleanupSpam-desc' => "Nettoyer tous les pourriels d'un nom d'hôte donné",
	'maintenance-cleanupSpam-option-hostname' => "Nom d'hôte qui a pollué",
	'maintenance-cleanupSpam-output-found' => '$1 {{PLURAL:$1|articles|article}} contenant $2 {{PLURAL:$1|trouvé|trouvés}}',
	'maintenance-cleanupSpam-output-false' => 'Fausse correspondance',
	'maintenance-cleanupSpam-output-blanking' => 'découpage',
	'maintenance-cleanupSpam-output-reverting' => 'retour arrière',
	'maintenance-cleanupSpam-error-invalid' => "Spécification de nom d'hôte non valide: $1",
	'maintenance-cleanupSpam-error-noid' => "Erreur interne: aucune page pour l'ID $1",
	'maintenance-clearInterwikiCache' => 'Utilisez ce formulaire pour vider complètement le cache interwiki',
	'maintenance-clearInterwikiCache-desc' => 'Supprimer tous les liens interwiki pour toutes les langues dans le cache',
	'maintenance-createAndPromote' => 'Utiliser ce formulaire pour créer un nouvel utilisateur et le promouvoir administrateur.
Cocher la case bureaucrate si vous désirez lui conférer aussi ce statut.',
	'maintenance-createAndPromote-desc' => 'Créer un utilisateur et promouvoir au statut d’administrateur',
	'maintenance-createAndPromote-option-bureaucrat' => "Promouvoir l'utilisateur au statut de bureaucrate",
	'maintenance-createAndPromote-output-creating' => "Créer et promouvoir l'utilisateur: $2...",
	'maintenance-createAndPromote-error-password' => "Une erreur s'est produite avec le mot de passe que vous avez saisi: $1",
	'maintenance-deleteBatch' => 'Utilisez ce formulaire pour supprimer en masse des pages.
Indiquer une seule page par ligne.',
	'maintenance-deleteBatch-desc' => 'Suppression de pages en masse',
	'maintenance-deleteRevision' => 'Utilisez ce formulaire pour supprimer en masse des versions.
Indiquez une seule version par ligne.',
	'maintenance-deleteRevision-desc' => 'Enlever des versions de la base de données',
	'maintenance-initEditCount-desc' => 'Recalculer les compteurs de modifications des utilisateurs',
	'maintenance-initSiteStats' => 'Utilisez ce formulaire pour recalculer les statistiques du site, en indiquant, le cas échéant, si vous désirez le recalcul du nombre de visites par page.',
	'maintenance-initSiteStats-desc' => 'Recalculer les statistiques du site',
	'maintenance-moveBatch' => 'Utilisez ce formulaire pour déplacer en masse des pages.
Chaque ligne devra indiquer la page d’origine et celle de destination, lesquelles devront être séparées par un « <nowiki>|</nowiki> »',
	'maintenance-moveBatch-desc' => 'Renommage de pages en masse',
	'maintenance-reassignEdits-desc' => 'Réassigner des modifications d’un utilisateur vers un autre',
	'maintenance-runJobs-desc' => 'Lancer les tâches dans la liste de celles à accomplir',
	'maintenance-runJobs-option-maxjobs' => 'Nombre maximum de tâches à effectuer',
	'maintenance-runJobs-option-type' => 'Type de tâche à effectuer',
	'maintenance-runJobs-option-procs' => 'Nombre de processus à utiliser',
	'maintenance-runJobs-option-exclusive' => "Exécutez exclusivement un seul script runJobs à la fois. Le délai d'attente est de 1800 secondes.",
	'maintenance-runJobs-error-invalidprocs' => 'Vous devez spécifier entre 1 et 1000 processus',
	'maintenance-showJobs-desc' => 'Afficher une liste des tâches en cours dans la liste de celles à accomplir',
	'maintenance-showJobs-option-group' => 'Afficher le nombre de tâches par type de tâche',
	'maintenance-sql' => 'Utilisez cette forme pour exécuter une requête SQL sur la base de données.',
	'maintenance-sql-desc' => 'Exécuter une requête SQL',
	'maintenance-sql-option-file' => 'SQL à exécuter',
	'maintenance-sql-output-aff' => 'Requête OK, $1 {{PLURAL:$1|entrée affectée|entrées affectées}}',
	'maintenance-sql-error-cantopen' => "Impossible d'ouvrir le fichier d'entrée",
	'maintenance-showCacheStats-desc' => 'Afficher les statistiques de la mémoire cache',
	'maintenance-eval' => 'Utilisez cette forme pour évaluer le code PHP dans un environnement MediaWiki.',
	'maintenance-eval-desc' => 'Évaluer un code PHP dans l’environnement MediaWiki',
	'maintenance-update' => 'Voulez-vous utiliser la méthode « UPDATE » pour la mise à jour directe d’une table ? Décochez l’option pour utiliser plutôt « DELETE / INSERT » (suppression puis réinsertion).',
	'maintenance-noviews' => 'Cocher ceci pour empêcher la mise à jour du nombre de visites des pages.',
	'maintenance-invalidname' => 'Nom d’utilisateur incorrect !',
	'maintenance-userexists' => 'L’utilisateur existe déjà !',
	'maintenance-invalidtitle' => 'Titre incorrect « $1 » !',
	'maintenance-titlenoexist' => 'Le titre indiqué (« $1 ») n’existe pas !',
	'maintenance-failed' => 'ÉCHEC',
	'maintenance-deleted' => 'SUPPRIMÉ',
	'maintenance-revdelete' => 'Suppression {{PLURAL:$3|de la révision|des révisions}} $1 du wiki $2',
	'maintenance-revnotfound' => 'Version $1 introuvable !',
	'maintenance-showCacheStats-edits' => 'Nombre de modifications : $1',
	'maintenance-showCacheStats-articles' => 'Nombre de pages dans l’espace principal : $1',
	'maintenance-showCacheStats-pages' => 'Nombre de pages : $1',
	'maintenance-showCacheStats-users' => 'Nombre d’utilisateurs : $1',
	'maintenance-showCacheStats-admins' => 'Nombre d’administrateurs : $1',
	'maintenance-showCacheStats-images' => 'Nombre de fichiers : $1',
	'maintenance-showCacheStats-views' => 'Nombre de pages visitées : $1',
	'maintenance-showCacheStats-update' => 'Mise à jour de la base de données{{int:ellipsis}}',
	'maintenance-move' => 'Déplacement de $1 vers $2{{int:ellipsis}}',
	'maintenance-movefail' => 'Erreur survenue lors du renommage : $1.
Déplacement interrompu.',
	'maintenance-error' => 'Erreur : $1',
	'maintenance-memc-fake' => "Vous utilisez ''FakeMemCachedClient''. Aucune statistique ne sera fournie.",
	'maintenance-memc-requests' => 'Requêtes',
	'maintenance-memc-withsession' => 'avec la session :',
	'maintenance-memc-withoutsession' => 'sans la session :',
	'maintenance-memc-total' => 'total :',
	'maintenance-memc-parsercache' => 'Cache de l’analyseur syntaxique',
	'maintenance-memc-hits' => 'clics :',
	'maintenance-memc-invalid' => 'incorrects :',
	'maintenance-memc-expired' => 'expirés :',
	'maintenance-memc-absent' => 'absents :',
	'maintenance-memc-stub' => 'seuil de départ :',
	'maintenance-memc-imagecache' => 'Cache image',
	'maintenance-memc-misses' => 'perdus :',
	'maintenance-memc-updates' => 'mis à jour :',
	'maintenance-memc-uncacheable' => 'hors cache :',
	'maintenance-memc-diffcache' => 'Cache des diff',
	'maintenance-reassignEdits' => 'Utilisez ce formulaire pour réassigner des modifications d’un utilisateur vers un autre.',
	'maintenance-re-from' => 'Nom de l’utilisateur à qui prendre les modifications',
	'maintenance-re-to' => 'Nom de l’utilisateur à qui assigner les modifications',
	'maintenance-re-force' => 'Réassigner même si l’utilisateur cible n’existe pas',
	'maintenance-re-rc' => 'Ne pas modifier la table des modifications récentes',
	'maintenance-re-report' => 'Afficher les détails de ce qui va être modifié, mais sans mettre à jour les données',
	'maintenance-re-nf' => 'L’utilisateur « $1 » n’a pas été trouvé',
	'maintenance-re-rr' => 'Lancer de nouveau le script sans mettre à jour « $1 ».',
	'maintenance-re-ce' => 'Modifications actuelles : $1.',
	'maintenance-re-de' => 'Modifications supprimées : $1',
	'maintenance-re-rce' => 'Entrées dans la table des modifications récentes : $1',
	'maintenance-re-total' => 'Nombre total de modifications à modifier : $1',
	'maintenance-re-re' => 'Réaffectation des modifications{{int:ellipsis}} fait',
);

/** Franco-Provençal (arpetan)
 * @author Cedric31
 * @author ChrisPtDe
 */
$messages['frp'] = array(
	'maintenance' => 'Lanciér los scriptes de mantegnence',
	'maintenance-backlink' => 'Retôrn u chouèx du scripte',
	'maintenance-error-invalidtype' => 'Lo scripte spècifiâ est pas étâ trovâ',
	'maintenance-generic-done' => 'fêt',
	'maintenance-generic-username' => 'Nom d’utilisator',
	'maintenance-generic-password' => 'Contresegno',
	'maintenance-generic-reason' => 'Rêson',
	'maintenance-cleanupTable-dry-run' => 'Fâre un passâjo sen changiér la bâsa de balyês',
	'maintenance-cleanupTable-check' => 'Contrôlo des crouyos titros...',
	'maintenance-cleanupTable-checkfix' => 'Contrôlo et corrèccion des crouyos titros...',
	'maintenance-cleanupTable-progress' => '$1 $2: $3% fêt(s) sur $4 ; ETA $5 [$6/$7] $8/sec <$9% betâ a jorn>',
	'maintenance-cleanupTable-missingparam' => '$1 : paramètre manquent $2',
	'maintenance-cleanupTable-processing' => 'En cors de trètament $1...',
	'maintenance-cleanupTable-finished' => 'Chavonâ $1... $2 sur $3 {{PLURAL:$3|legne betâye|legnes betâyes}} a jorn',
	'maintenance-option-quiet' => 'Suprimar la sortia de tot cen qu’est pas una èrror',
	'maintenance-option-confirm' => 'Confirmar',
	'maintenance-option-required' => '(nècèssèro)',
	'maintenance-option-optional' => '(u chouèx)',
	'maintenance-output-success' => '$1 s’est dèroulâ avouéc reusséta !',
	'maintenance-output-failure' => '$1 s’est pas dèroulâ avouéc reusséta !',
	'maintenance-attachLatest-output-done' => 'Fêt ! $1 {{PLURAL:$1|pâge trètâye|pâges trètâyes}}.',
	'maintenance-benchmarkPurge-output-trial' => '$1 titro{{PLURAL:$1||s}} en $2 ms ($3 ms châcun)',
	'maintenance-changePassword-desc' => 'Changiér lo contresegno a un usanciér',
	'maintenance-changePassword-error-nouser' => 'Gins d’usanciér : $1',
	'maintenance-changePassword-output-set' => 'Contresegno dèfeni por $1',
	'maintenance-checkAutoLoader-desc' => 'Contrôlos d’entègritât du chargior ôtomatico',
	'maintenance-checkAutoLoader-output-list2' => '$1 : crouyo fichiér : trovâ dens $2, listâ dens $3',
	'maintenance-checkBadRedirects-desc' => 'Rechèrchiér des crouyes redirèccions',
	'maintenance-checkBadRedirects-output-header' => 'Rècupèracion de les redirèccions...',
	'maintenance-checkBadRedirects-output-found' => '$1 {{PLURAL:$1|redirèccion trovâye|redirèccions trovâyes}}.
Contrôlo de les crouyes redirèccions...',
	'maintenance-checkBadRedirects-output-footer' => 'Fêt.',
	'maintenance-checkImages-output-noaccess' => '$1 : pas accèssibla localament',
	'maintenance-checkImages-output-missing' => '$1 : absent',
	'maintenance-checkImages-output-isdir' => '$1 : est un rèpèrtouèro',
	'maintenance-checkImages-output-truncated' => '$1 : tronchiê, ére $2',
	'maintenance-checkImages-output-mismatch' => '$1: talye que vat pas avouéc, bâsa de balyês = $2, èfèctif = $3',
	'maintenance-checkImages-output-good' => 'Bônes émâges : $1 / $2',
	'maintenance-checkSyntax-output-buildlist' => 'Construccion de la lista de fichiérs...',
	'maintenance-checkSyntax-output-error' => 'Èrror dens $1, legne $2 : $3',
	'maintenance-checkSyntax-output-warning' => 'Avèrtissement dens lo fichiér $1 : $2 trovâ',
	'maintenance-checkSyntax-error-nofile' => 'Èrror : pôt pas trovar lo fichiér ou ben lo rèpèrtouèro $1',
	'maintenance-checkSyntax-error-cantopen' => 'Empossiblo d’uvrir lo fichiér $1',
	'maintenance-checkUsernames-error-notvalid' => 'Nom d’usanciér envalido : « $3 » (numerô d’usanciér $2)',
	'maintenance-cleanupCaps-output-islower' => '« $1 » ja en petiôtes lètres.',
	'maintenance-cleanupCaps-output-clash' => '« $1 » ignorâ ; « $2 » ègziste ja',
	'maintenance-cleanupCaps-output-dryrun' => '« $1 » -> « $2 » : FÔRMA ÈPRÔVA, PAS DÈPLACIÊ',
	'maintenance-cleanupSpam-output-found' => '$1 {{PLURAL:$1|articllo que contint|articllos que contegnont}} $2 trovâ{{PLURAL:$1||s}}',
	'maintenance-cleanupSpam-output-false' => 'Fôssa corrèspondance',
	'maintenance-deleteBatch-desc' => 'Suprèssion de pâges en massa',
	'maintenance-initSiteStats-desc' => 'Tornar calcular les statistiques du seto',
	'maintenance-moveBatch-desc' => 'Renomâjo de pâges en massa',
	'maintenance-sql-desc' => 'Ègzécutar una requéta SQL',
	'maintenance-sql-option-file' => 'SQL a ègzécutar',
	'maintenance-sql-output-aff' => 'Requéta OK, $1 {{PLURAL:$1|entrâ afèctâ|entrâs afèctâs}}',
	'maintenance-invalidname' => 'Nom d’usanciér envalido !',
	'maintenance-userexists' => 'L’usanciér ègziste ja !',
	'maintenance-invalidtitle' => 'Titro envalido « $1 » !',
	'maintenance-titlenoexist' => 'Lo titro spècefiâ (« $1 ») ègziste pas !',
	'maintenance-failed' => 'FALYITA',
	'maintenance-deleted' => 'SUPRIMÂ',
	'maintenance-revdelete' => 'Suprèssion de l{{PLURAL:$3|a vèrsion|es vèrsions}} $1 du vouiqui $2',
	'maintenance-revnotfound' => 'Vèrsion $1 entrovâbla !',
	'maintenance-showCacheStats-edits' => 'Nombro de changements : $1',
	'maintenance-showCacheStats-articles' => 'Nombro de pâges dens l’èspâço de noms principâl : $1',
	'maintenance-showCacheStats-pages' => 'Nombro de pâges : $1',
	'maintenance-showCacheStats-users' => 'Nombro d’usanciérs : $1',
	'maintenance-showCacheStats-admins' => 'Nombro d’administrators : $1',
	'maintenance-showCacheStats-images' => 'Nombro de fichiérs : $1',
	'maintenance-showCacheStats-views' => 'Nombro de pâges vues : $1',
	'maintenance-showCacheStats-update' => 'Misa a jorn de la bâsa de balyês{{int:ellipsis}}',
	'maintenance-move' => 'Dèplacement de $1 vers $2{{int:ellipsis}}',
	'maintenance-movefail' => 'Èrror arrevâ pendent lo renomâjo : $1.
Dèplacement arrètâ',
	'maintenance-error' => 'Èrror : $1',
	'maintenance-memc-requests' => 'Requétes',
	'maintenance-memc-withsession' => 'avouéc la sèance :',
	'maintenance-memc-withoutsession' => 'sen la sèance :',
	'maintenance-memc-total' => 'soma :',
	'maintenance-memc-parsercache' => 'Cache du parsor',
	'maintenance-memc-hits' => 'clics :',
	'maintenance-memc-invalid' => 'envalidos :',
	'maintenance-memc-expired' => 'èxpirâs :',
	'maintenance-memc-absent' => 'absents :',
	'maintenance-memc-stub' => 'lendâr de començons :',
	'maintenance-memc-imagecache' => 'Cache émâge',
	'maintenance-memc-misses' => 'pèrdus :',
	'maintenance-memc-updates' => 'betâs a jorn :',
	'maintenance-memc-uncacheable' => 'en defôr du cache :',
	'maintenance-memc-diffcache' => 'Cache des dif',
	'maintenance-re-nf' => 'L’usanciér « $1 » at pas étâ trovâ',
	'maintenance-re-ce' => 'Changements d’ora : $1',
	'maintenance-re-de' => 'Changements suprimâs : $1',
	'maintenance-re-rce' => 'Entrâs dens la trâbla des dèrriérs changements : $1',
	'maintenance-re-total' => 'Soma totâla d’entrâs a changiér : $1',
	'maintenance-re-re' => 'Rèafèctacion des changements{{int:ellipsis}} fêta',
);

/** Irish (Gaeilge)
 * @author Alison
 * @author පසිඳු කාවින්ද
 */
$messages['ga'] = array(
	'maintenance-generic-username' => 'Ainm úsáideora',
	'maintenance-generic-reason' => 'Fáth',
	'maintenance-option-confirm' => 'Deimhnigh',
	'maintenance-invalidname' => 'Ainm úsáideoir neamhbhailí!',
	'maintenance-invalidtitle' => 'Teideal neamhbhailí "$1"!',
	'maintenance-deleted' => 'SCRIOSTA',
	'maintenance-showCacheStats-pages' => 'Líon leathanaigh: $1',
	'maintenance-showCacheStats-users' => 'Líon úsáideoirí: $1',
	'maintenance-showCacheStats-admins' => 'Líon riarthóirí: $1',
	'maintenance-showCacheStats-images' => 'Líon comhaid: $1',
	'maintenance-error' => 'Earráid: $1',
	'maintenance-memc-requests' => 'Iarratais',
	'maintenance-memc-total' => 'iomlán:',
);

/** Galician (galego)
 * @author HombreDHojalata
 * @author Toliño
 */
$messages['gl'] = array(
	'maintenance' => 'Executar as escrituras de mantemento',
	'maintenance-desc' => '[[Special:Maintenance|Interface da web]] para diversas escrituras de mantemento',
	'right-maintenance' => 'Executar escrituras de mantemento mediante [[Special:Maintenance]]',
	'maintenance-backlink' => 'Volver á selección de escrituras',
	'maintenance-header' => 'Por favor, seleccione a escritura de embaixo que queira executar.
As descricións están ao lado de cada escritura',
	'maintenance-error-badini' => 'O ficheiro metadata.ini está corrompido ou non existe. Volva descargar a extensión de mantemento',
	'maintenance-error-invalidtype' => 'Non se atopou a escritura especificada',
	'maintenance-error-badargs' => 'Non especificou todas as opcións necesarias',
	'maintenance-generic-done' => 'feito',
	'maintenance-generic-username' => 'Nome de usuario',
	'maintenance-generic-password' => 'Contrasinal',
	'maintenance-generic-reason' => 'Motivo',
	'maintenance-cleanupTable-dry-run' => 'Realizar un simulacro',
	'maintenance-cleanupTable-check' => 'Comprobando os títulos erróneos...',
	'maintenance-cleanupTable-checkfix' => 'Comprobando e corrixindo os títulos erróneos...',
	'maintenance-cleanupTable-progress' => '$1 $2: $3% feito en $4; hora prevista de fin $5 [$6/$7] $8/s <$9% actualizado>',
	'maintenance-cleanupTable-missingparam' => '$1: Falta o parámetro $2',
	'maintenance-cleanupTable-processing' => 'Procesando $1...',
	'maintenance-cleanupTable-finished' => 'Terminado $1... $2 {{PLURAL:$3|liña|liñas}} de $3 {{PLURAL:$3|actualizada|actualizadas}}',
	'maintenance-option-quiet' => 'Eliminar a saída de todo aquilo que non sexa un erro',
	'maintenance-option-globals' => 'Mostrar as variables globais da fin do proceso de depuración',
	'maintenance-option-confirm' => 'Confirmar',
	'maintenance-option-batch-size' => 'Executar este número de operacións por conxunto de tarefas; por defecto: $1',
	'maintenance-option-required' => '(obrigatorio)',
	'maintenance-option-optional' => '(opcional)',
	'maintenance-output-success' => '$1 executouse con éxito!',
	'maintenance-output-failure' => '$1 non se executou correctamente!',
	'maintenance-attachLatest' => 'Empregue este formulario para corrixir as entradas na táboa da páxina nas que page_latest estea establecido en 0',
	'maintenance-attachLatest-desc' => 'Corrixir as entradas page_latest na táboa da páxina',
	'maintenance-attachLatest-option-fix' => 'Corrixir as entradas; senón, realizar un simulacro',
	'maintenance-attachLatest-output-begin' => 'Procurando as páxinas con page_latest establecido en 0...',
	'maintenance-attachLatest-output-notime' => '$1 $2 [[$3]] non se pode atopar a data da última revisión?!',
	'maintenance-attachLatest-output-norev' => '$1 $2 [[$3]] última data $4, non se pode atopar o identificador da revisión',
	'maintenance-attachLatest-output-found' => '$1 $2 [[$3]] última data $4, identificador da revisión $5',
	'maintenance-attachLatest-output-done' => 'Feito! {{PLURAL:$1|Procesouse $1 páxina|Procesáronse $1 páxinas}}.',
	'maintenance-attachLatest-output-dryrun' => 'Isto foi un simulacro; volva executar a escritura con "{{int:maintenance-attachLatest-option-fix}}" para actualizar page_latest.',
	'maintenance-benchmarkPurge' => 'Empregue este formulario para probar o tempo que tardan as funcións de limpeza de Squid',
	'maintenance-benchmarkPurge-desc' => 'Medir o tempo das funcións de limpeza de Squid',
	'maintenance-benchmarkPurge-option-count' => 'O número de enderezos URL que fornecer a Squid para a limpeza',
	'maintenance-benchmarkPurge-error-nosquid' => 'A medida do tempo de execución non fai gran cousa sen o soporte para Squid activado.',
	'maintenance-benchmarkPurge-output-numsquids' => 'Hai $1 {{PLURAL:$1|servidor|servidores}} Squid {{PLURAL:$1|definido|definidos}}:',
	'maintenance-benchmarkPurge-output-trial' => '$1 {{PLURAL:$1|título|títulos}} en $2 ms ($3 ms cada un)',
	'maintenance-changePassword' => 'Use este formulario para cambiar o contrasinal dun usuario',
	'maintenance-changePassword-desc' => 'Cambiar o contrasinal dun usuario',
	'maintenance-changePassword-error-nouser' => 'Non existe tal usuario: $1',
	'maintenance-changePassword-output-set' => 'Contrasinal definido para $1',
	'maintenance-checkAutoLoader' => 'Empregue este formulario para realizar algunhas comprobacións de integridade do AutoLoader',
	'maintenance-checkAutoLoader-desc' => 'Comprobacións de integridade do AutoLoader',
	'maintenance-checkAutoLoader-output-list2' => '$1: Ficheiro erróneo: atopado en $2, listado en $3',
	'maintenance-checkBadRedirects' => 'Empregue este formulario para comprobar se as páxinas marcadas como redireccións son realmente redireccións',
	'maintenance-checkBadRedirects-desc' => 'Comprobar as redireccións erróneas',
	'maintenance-checkBadRedirects-output-header' => 'Procurando as redireccións...',
	'maintenance-checkBadRedirects-output-found' => '{{PLURAL:$1|Atopouse $1 redirección|Atopáronse $1 redireccións}}.
Comprobando as redireccións erróneas...',
	'maintenance-checkBadRedirects-output-footer' => '
Feito.',
	'maintenance-checkImages' => 'Empregue este formulario para comprobar as imaxes corrompidas do wiki',
	'maintenance-checkImages-desc' => 'Consulte as imaxes para ver se existen, son lexibles etc.',
	'maintenance-checkImages-output-noaccess' => '$1: non está accesible localmente',
	'maintenance-checkImages-output-missing' => '$1: ausente',
	'maintenance-checkImages-output-isdir' => '$1: é un directorio',
	'maintenance-checkImages-output-truncated' => '$1: truncado, era $2',
	'maintenance-checkImages-output-mismatch' => '$1: tamaño incompatible; base de datos = $2, real = $3',
	'maintenance-checkImages-output-good' => 'Boas imaxes: $1/$2',
	'maintenance-checkSyntax' => 'Empregue este formulario para comprobar a sintaxe de todos os ficheiros PHP en MediaWiki',
	'maintenance-checkSyntax-desc' => 'Comprobar a sintaxe de todos os ficheiros PHP en MediaWiki',
	'maintenance-checkSyntax-option-with-extensions' => 'Tamén recorrer o cartafol das extensións',
	'maintenance-checkSyntax-option-path' => 'Ruta específica (ficheiro ou directorio) a comprobar, coa ruta de acceso absoluta ou relativa á raíz desta instalación de MediaWiki',
	'maintenance-checkSyntax-option-list-file' => 'Lista de ficheiros ou directorios a comprobar',
	'maintenance-checkSyntax-option-modified' => 'Comprobar soamente os ficheiros que sufriron modificacións (necesita o cliente SVN en liña de comandos)',
	'maintenance-checkSyntax-option-syntax-only' => 'Comprobar soamente a validez da sintaxe; ignorar as advertencias sobre o estilo do código',
	'maintenance-checkSyntax-output-parsekit' => 'Comprobando a sintaxe (empregando o parsekit)',
	'maintenance-checkSyntax-output-phpl' => 'Comprobando a sintaxe (empregando php -l; isto pode tarda un bo anaco)',
	'maintenance-checkSyntax-output-footer' => 'Feito! $1 ficheiros comprobados, $2 fallos e $3 avisos atopados',
	'maintenance-checkSyntax-output-svnlist' => 'Recuperando a lista desde Subversion...',
	'maintenance-checkSyntax-output-buildlist' => 'Construíndo a lista de ficheiros...',
	'maintenance-checkSyntax-output-error' => 'Erro en $1, liña $2: $3',
	'maintenance-checkSyntax-output-warning' => 'Aviso no ficheiro $1: $2 atopado',
	'maintenance-checkSyntax-error-nofile' => 'Erro: non se pode atopar o ficheiro ou directorio $1',
	'maintenance-checkSyntax-error-cantopen' => 'Non se pode abrir o ficheiro $1',
	'maintenance-checkSyntax-error-svnerr' => 'Erro ao recuperar a lista desde Subversion!',
	'maintenance-checkUsernames' => 'Empregue este formulario para comprobar os nomes de usuario non válidos debido ás modificacións na configuración. Se non hai nada na lista despois de executar esta escritura significa que todos os nomes de usuario son válidos',
	'maintenance-checkUsernames-desc' => 'Comprobar que os nomes de usuario da base de datos son realmente válidos',
	'maintenance-checkUsernames-error-notvalid' => 'Nome de usuario non válido: "$3" (identificador de usuario $2)',
	'maintenance-cleanupCaps' => 'Empregue o formulario de embaixo para corrixir as páxinas rotas causadas pola modificación de $wgCapitalLinks',
	'maintenance-cleanupCaps-desc' => 'Escritura para limpar a utilización de maiúsculas e minúsculas',
	'maintenance-cleanupCaps-option-namespace' => 'Número do espazo de nomes no que realizar a limpeza da utilización de maiúsculas e minúsculas',
	'maintenance-cleanupCaps-output-islower' => '"$1" xa está escrito en minúsculas.',
	'maintenance-cleanupCaps-output-clash' => '"$1" saltado; "$2" xa existe',
	'maintenance-cleanupCaps-output-dryrun' => '"$1" -> "$2": SIMULACRO, NON TRASLADADO',
	'maintenance-cleanupCaps-error-noneed' => '$wgCapitalLinks está activado; non se necesita realizar a limpeza da utilización de maiúsculas e minúsculas.',
	'maintenance-cleanupSpam' => 'Use este formulario para reverter as edicións vandálicas con spam que ligan a sitios web externos',
	'maintenance-cleanupSpam-desc' => 'Limpar todo o spam dun servidor determinado',
	'maintenance-cleanupSpam-option-hostname' => 'Nome do servidor que produce o spam',
	'maintenance-cleanupSpam-output-found' => '{{PLURAL:$1|Atopouse $1 artigo|Atopáronse $1 artigos}} que {{PLURAL:$1|contiña|contiñan}} $2',
	'maintenance-cleanupSpam-output-false' => 'Coincidencia incorrecta',
	'maintenance-cleanupSpam-output-blanking' => 'baleirado',
	'maintenance-cleanupSpam-output-reverting' => 'reversión',
	'maintenance-cleanupSpam-error-invalid' => 'A especificación do nome do servidor non é válida: $1',
	'maintenance-cleanupSpam-error-noid' => 'Erro interno: Non hai páxina ningunha para o ID $1',
	'maintenance-clearInterwikiCache' => 'Use este formulario para limpar completamente a caché do interwiki',
	'maintenance-clearInterwikiCache-desc' => 'Limpar todas as ligazóns interwiki de todas as linguas da caché',
	'maintenance-createAndPromote' => 'Use este formulario para crear un novo usuario e promovelo a administrador. Marque a caixa de burócrata se quere tamén promovelo a burócrata',
	'maintenance-createAndPromote-desc' => 'Crear un usuario e promovelo a administrador',
	'maintenance-createAndPromote-option-bureaucrat' => 'Dar ao usuario os dereitos de burócrata',
	'maintenance-createAndPromote-output-creating' => 'Creando e promovendo o usuario $2...',
	'maintenance-createAndPromote-error-password' => 'Houbo un erro co contrasinal que inseriu: $1',
	'maintenance-deleteBatch' => 'Use este formulario para borrar revisións en masa.
Poña só unha páxina por liña',
	'maintenance-deleteBatch-desc' => 'Borrar páxinas masivamente',
	'maintenance-deleteRevision' => 'Use este formulario para borrar revisións en masa.
Poña só un número de revisión por liña',
	'maintenance-deleteRevision-desc' => 'Borrar revisións da base de datos',
	'maintenance-initEditCount-desc' => 'Volver calcular o contador de edicións dos usuarios',
	'maintenance-initSiteStats' => 'Use este formulario para volver calcular as estatísticas do sitio, especificando se tamén quere calcular de novo as vistas por páxina',
	'maintenance-initSiteStats-desc' => 'Volver calcular as estatísticas do sitio',
	'maintenance-moveBatch' => 'Use este formulario para mover páxinas en masa.
Cada liña debería especificar unha fonte e destino da páxina separados por unha barra vertical ("|")',
	'maintenance-moveBatch-desc' => 'Mover páxinas masivamente',
	'maintenance-reassignEdits-desc' => 'Reasignar as edicións dun usuario a outro',
	'maintenance-runJobs-desc' => 'Executar os traballos na cola de traballo',
	'maintenance-runJobs-option-maxjobs' => 'Número máximo de tarefas a realizar',
	'maintenance-runJobs-option-type' => 'Tipo de tarefa a realizar',
	'maintenance-runJobs-option-procs' => 'Número de procesos a usar',
	'maintenance-runJobs-option-exclusive' => 'Execute exclusivamente unha soa escritura runJobs á vez. O tempo de espera é de 1800 segundos.',
	'maintenance-runJobs-error-invalidprocs' => 'Ten que especificar entre 1 e 1000 procesos',
	'maintenance-showJobs-desc' => 'Mostrar a lista dos traballos pendentes na cola de traballo',
	'maintenance-showJobs-option-group' => 'Mostrar o número de tarefas por tipo de tarefas',
	'maintenance-sql' => 'Use este formulario para executar unha pescuda SQL na base de datos.',
	'maintenance-sql-desc' => 'Executar unha pescuda SQL',
	'maintenance-sql-option-file' => 'SQL a executar',
	'maintenance-sql-output-aff' => 'Pescuda correcta, $1 {{PLURAL:$1|liña afectada|liñas afectadas}}',
	'maintenance-sql-error-cantopen' => 'Non se pode abrir o ficheiro de entrada',
	'maintenance-showCacheStats-desc' => 'Mostrar as estatísticas da memoria caché',
	'maintenance-eval' => 'Use este formulario para avaliar o código PHP no ambiente MediaWiki.',
	'maintenance-eval-desc' => 'Avaliar o código PHP no ambiente MediaWiki',
	'maintenance-update' => 'Desexa usar ACTUALIZAR ao actualizar unha táboa? Se non marca a opción, usarase, no canto diso, BORRAR/INSERTAR.',
	'maintenance-noviews' => 'Comprove isto para previr a actualización do número de vistas por páxina',
	'maintenance-invalidname' => 'Nome de usuario inválido!',
	'maintenance-userexists' => 'O usuario xa existe!',
	'maintenance-invalidtitle' => 'Título inválido "$1"!',
	'maintenance-titlenoexist' => 'O título especificado ("$1") non existe!',
	'maintenance-failed' => 'FALLIDO',
	'maintenance-deleted' => 'BORRADO',
	'maintenance-revdelete' => 'Borrando {{PLURAL:$3|a revisión|as revisións}} $1 de $2',
	'maintenance-revnotfound' => 'A revisión $1 non foi atopada!',
	'maintenance-showCacheStats-edits' => 'Número de edicións: $1',
	'maintenance-showCacheStats-articles' => 'Número de páxinas no espazo de nomes principal: $1',
	'maintenance-showCacheStats-pages' => 'Número de páxinas: $1',
	'maintenance-showCacheStats-users' => 'Número de usuarios: $1',
	'maintenance-showCacheStats-admins' => 'Número de administradores: $1',
	'maintenance-showCacheStats-images' => 'Número de ficheiros: $1',
	'maintenance-showCacheStats-views' => 'Número de vistas por páxina: $1',
	'maintenance-showCacheStats-update' => 'Actualizando a base de datos{{int:ellipsis}}',
	'maintenance-move' => 'Movendo "$1" a "$2"{{int:ellipsis}}',
	'maintenance-movefail' => 'Produciuse un erro durante o movemento: $1.
Cancelando a operación',
	'maintenance-error' => 'Erro: $1',
	'maintenance-memc-fake' => 'Está executando FakeMemCachedClient. As estatísticas non poden ser amosadas',
	'maintenance-memc-requests' => 'Solicitudes',
	'maintenance-memc-withsession' => 'con sesión:',
	'maintenance-memc-withoutsession' => 'sen sesión:',
	'maintenance-memc-total' => 'total:',
	'maintenance-memc-parsercache' => 'Analizador da memoria caché',
	'maintenance-memc-hits' => 'éxitos:',
	'maintenance-memc-invalid' => 'inválido:',
	'maintenance-memc-expired' => 'remata:',
	'maintenance-memc-absent' => 'falta:',
	'maintenance-memc-stub' => 'bosquexo:',
	'maintenance-memc-imagecache' => 'Imaxe da memoria caché',
	'maintenance-memc-misses' => 'perdas:',
	'maintenance-memc-updates' => 'actualizacións:',
	'maintenance-memc-uncacheable' => 'non se pode comprobar a caché:',
	'maintenance-memc-diffcache' => 'Diferenza na memoria caché',
	'maintenance-reassignEdits' => 'Use este formulario para reasignar as edicións dun usuario a outro.',
	'maintenance-re-from' => 'Nome do usuario do que coller as edicións',
	'maintenance-re-to' => 'Nome do usuario ao que asignar as edicións',
	'maintenance-re-force' => 'Reasignar incluso se o usuario non existe',
	'maintenance-re-rc' => 'Non actualizar a táboa de cambios recentes',
	'maintenance-re-report' => 'Imprimir os detalles do que será cambiado, pero non actualizalo',
	'maintenance-re-nf' => 'Non se atopou o usuario "$1"',
	'maintenance-re-rr' => 'Executar de novo a escritura sen "$1" para actualizar.',
	'maintenance-re-ce' => 'Edicións actuais: $1',
	'maintenance-re-de' => 'Edicións borradas: $1',
	'maintenance-re-rce' => 'Entradas nos Cambios recentes: $1',
	'maintenance-re-total' => 'Entradas totais a cambiar: $1',
	'maintenance-re-re' => 'Reasignando as edicións{{int:ellipsis}} feito',
);

/** Ancient Greek (Ἀρχαία ἑλληνικὴ)
 * @author Crazymadlover
 * @author Omnipaedista
 */
$messages['grc'] = array(
	'maintenance-option-confirm' => 'Κυροῦν',
	'maintenance-failed' => 'ΑΠΕΤΕΥΧΘΗ',
	'maintenance-deleted' => 'ΔΙΕΓΡΑΦΗ',
	'maintenance-memc-requests' => 'Αἰτήσεις',
	'maintenance-memc-total' => 'συνολικόν:',
);

/** Swiss German (Alemannisch)
 * @author Als-Chlämens
 * @author Als-Holder
 */
$messages['gsw'] = array(
	'maintenance' => 'Wartigsskript starte',
	'maintenance-desc' => '[[Special:Maintenance|Webinterface]] fir verschideni Wartigsskript',
	'right-maintenance' => 'Start Wartigsskript iber [[Special:Maintenance]]',
	'maintenance-backlink' => 'Zrugg zue dr Skript-Uuswahl',
	'maintenance-header' => 'Bitte wehl e Skript uus, wu soll uusgfiert wäre.
Bschrybige stehn näbe jedem Skript.',
	'maintenance-error-invalidtype' => 'Nit giltige Typ!', # Fuzzy
	'maintenance-generic-done' => 'erledigt',
	'maintenance-generic-username' => 'Benutzername',
	'maintenance-generic-password' => 'Passwort',
	'maintenance-generic-reason' => 'Grund',
	'maintenance-option-confirm' => 'Bstätige',
	'maintenance-output-success' => '$1 erfolgrych uusgfiert!',
	'maintenance-changePassword' => 'Passwort vun eme Benutzer ändere',
	'maintenance-changePassword-desc' => 'Passwort vun eme Benutzer ändere',
	'maintenance-createAndPromote' => 'Nimm die Maschke go ne neje Benutzer aazlege un e zuen eme Adminischtrator mache.
Aktivier d Bürokrat-Checkbox, wänn Du ne au zum Bürokrat witt mache.',
	'maintenance-createAndPromote-desc' => 'E Benutzerkonto aalege un Adminischtrator-Status vergee',
	'maintenance-deleteBatch' => 'Nimm die Maschke zum vil Syte z lesche.
Schryyb numen ei Syte pro Zyyle',
	'maintenance-deleteBatch-desc' => 'Masseleschig vu Syte',
	'maintenance-deleteRevision' => 'Nimm die Maschke go vil Versione z lesche.
Schryb numen ei Versionsnummere pro Zyyle',
	'maintenance-deleteRevision-desc' => 'Versionen us dr Datebank useneh',
	'maintenance-initEditCount-desc' => 'Benutzerbyytragszeller vun eme Benutzers nej rächne',
	'maintenance-initSiteStats' => 'Nimm die Maschke go d Sytestatischtike nej z rächne un gib debyy aa, eb Du au d Syteufruef witt nej rächne.',
	'maintenance-initSiteStats-desc' => 'Sytestatischtik nej rächne',
	'maintenance-moveBatch' => 'Nimm die Maschke go vil Syte verschiebe.
Jedi Zyyle sott e Quällsyten un e Ziilsyten aagee, dur e Sänkrächtstrich trännt',
	'maintenance-moveBatch-desc' => 'Masseverschiebig vu Syte',
	'maintenance-reassignEdits-desc' => 'Bearbeitige vun eme Benutzer eme andere zuewyyse',
	'maintenance-runJobs-desc' => 'Ufträg in dr Warteschlang uusfiere',
	'maintenance-showJobs-desc' => 'Lischt vu dr Ufträg in dr Warteschlang, wu no mien abgarbeitet wäre',
	'maintenance-sql' => 'Nimm die Maschke go ne SQL-Abfrog in dr Datebank uuszfiere.',
	'maintenance-sql-desc' => 'E SQL-Abfrog uusfiere',
	'maintenance-showCacheStats-desc' => 'Zeig Memcached-Statischtik',
	'maintenance-eval' => 'Bruuch des Formular go PHP-Code in MediaWiki uuswärte.',
	'maintenance-eval-desc' => 'PHP-Code in dr MediaWiki-Umgäbig uuswärte',
	'maintenance-update' => 'UPDATE zum Aktualisiere vu Tabälle neh? Wänn nit aktiviert, wird DELETE/INSERT bruucht.',
	'maintenance-noviews' => 'Aktualisierig vum Sytenufruefzeller deaktiviere',
	'maintenance-invalidname' => 'Nit giltige Benutzername!',
	'maintenance-userexists' => 'Benutzer git s scho!',
	'maintenance-invalidtitle' => 'Nit giltige Titel „$1“!',
	'maintenance-titlenoexist' => 'Dr Titel („$1“), wu Du aagee hesch, git s nit!',
	'maintenance-failed' => 'FÄHLGSCHLAA',
	'maintenance-deleted' => 'GLESCHT',
	'maintenance-revdelete' => '{{PLURAL:$3|Version|Versione}} $1 vu Wiki $2 lesche',
	'maintenance-revnotfound' => 'Version $1 nit gfunde!',
	'maintenance-showCacheStats-edits' => 'Aazahl vu Bearbeitige: $1',
	'maintenance-showCacheStats-articles' => 'Aszahl vu Syten im Hauptnamensruum: $1',
	'maintenance-showCacheStats-pages' => 'Aszahl vu Syte: $1',
	'maintenance-showCacheStats-users' => 'Aazahl vu Benutzer: $1',
	'maintenance-showCacheStats-admins' => 'Aazahl vu Adminischtratore: $1',
	'maintenance-showCacheStats-images' => 'Aazahl vu Dateie: $1',
	'maintenance-showCacheStats-views' => 'Aazahl vu Sytenufruef: $1',
	'maintenance-showCacheStats-update' => 'Am Datebank aktualisiere ...',
	'maintenance-move' => 'Am $1 no $2 verschiebe …',
	'maintenance-movefail' => 'Fähler bim Verschiebe: $1
Verschieben abbroche',
	'maintenance-error' => 'Fähler: $1',
	'maintenance-memc-fake' => 'Du bruuchsch FakeMemCachedClient. S sin kei Statischtike verfiegbar',
	'maintenance-memc-requests' => 'Aafroge',
	'maintenance-memc-withsession' => 'mit Sitzig:',
	'maintenance-memc-withoutsession' => 'ohni Sitzig:',
	'maintenance-memc-total' => 'gsamt:',
	'maintenance-memc-parsercache' => 'Parser-Zwischespycher',
	'maintenance-memc-hits' => 'Träffer:',
	'maintenance-memc-invalid' => 'Nit giltig:',
	'maintenance-memc-expired' => 'abgloffe:',
	'maintenance-memc-absent' => 'nit do:',
	'maintenance-memc-stub' => 'Stumpegränz:',
	'maintenance-memc-imagecache' => 'Bildercache',
	'maintenance-memc-misses' => 'nonig gmacht:',
	'maintenance-memc-updates' => 'Update:',
	'maintenance-memc-uncacheable' => 'nit cachebar:',
	'maintenance-memc-diffcache' => 'Diff-Zwischespycher',
	'maintenance-reassignEdits' => 'Bruuch die Syte go Bearbeitige vun eme Benutzer in eme andere zuewyyse.',
	'maintenance-re-from' => 'Benutzer, wu d Bearbeitige ewäggnuu solle wäre',
	'maintenance-re-to' => 'Benutzer, wu d Bearbeitige solle zuegwise wäre',
	'maintenance-re-force' => 'Au nej zuewyyse, wänn s dr nej Benutzer nit git',
	'maintenance-re-rc' => 'Datebank-Tabälle Letschti Änderige nit aktualisiere',
	'maintenance-re-report' => 'Nyt ändere, nume zeige, was gänderet tet wäre',
	'maintenance-re-nf' => 'Benutzer $1 nit gfunde',
	'maintenance-re-rr' => 'Zum Nejzuewyyse s Skript non emol laufe loo ohni „$1“.',
	'maintenance-re-ce' => 'Aktuälli Bearbeitige: $1',
	'maintenance-re-de' => 'Gleschti Bearbeitige: $1',
	'maintenance-re-rce' => 'Yyträg in dr Letschten Änderige: $1',
	'maintenance-re-total' => 'Yyträg, wu mien gänderet wäre: $1',
	'maintenance-re-re' => 'Nejzueornig vu dr Bearbeitige … gmacht',
);

/** Manx (Gaelg)
 * @author Shimmin Beg
 */
$messages['gv'] = array(
	'maintenance-generic-reason' => 'Fa:',
);

/** Hebrew (עברית)
 * @author Amire80
 * @author Rotemliss
 * @author YaronSh
 * @author חיים
 * @author ערן
 */
$messages['he'] = array(
	'maintenance' => 'הרצת סקריפטים של תחזוקה',
	'maintenance-desc' => '[[Special:Maintenance|ממשק אינטרנט]] למגוון סקריפטים של תחזוקה',
	'right-maintenance' => 'הרצת סקריפטים לתחזוקה דרך [[Special:Maintenance]]',
	'maintenance-backlink' => 'חזרה לבחירת הסקריפטים',
	'maintenance-header' => 'אנא בחרו איזה מהסקריפטים שלהלן להריץ.
התיאורים מופיעים ליד כל סקריפט',
	'maintenance-error-invalidtype' => 'הסקריפט שצוין לא נמצא',
	'maintenance-error-badargs' => 'לא צויינו כל ההגדרות הנדרשות',
	'maintenance-generic-done' => 'בוצע',
	'maintenance-generic-username' => 'שם משתמש',
	'maintenance-generic-password' => 'ססמה',
	'maintenance-generic-reason' => 'סיבה',
	'maintenance-cleanupTable-dry-run' => 'הרצה על יבש',
	'maintenance-cleanupTable-check' => 'בדיקת כותרות פגומות...',
	'maintenance-cleanupTable-checkfix' => 'בדיקה ותיקון של כותרות פגומות...',
	'maintenance-cleanupTable-processing' => 'מעבד $1...',
	'maintenance-cleanupTable-finished' => 'עודכן $1 ...  $2  מתוך $3 {{PLURAL:$3| רשומה|רשומות}}',
	'maintenance-option-confirm' => 'אישור',
	'maintenance-option-required' => '(חובה)',
	'maintenance-option-optional' => '(אופציונלי)',
	'maintenance-output-success' => 'הסקריפט $1 רץ בהצלחה!',
	'maintenance-output-failure' => '$1 נכשל בהרצה!',
	'maintenance-changePassword' => 'השתמשו בטופס זה כדי לשנות סיסמה של משתמש',
	'maintenance-changePassword-desc' => 'שינוי סיסמת משתמש',
	'maintenance-changePassword-error-nouser' => 'אין משתמש בשם: $1',
	'maintenance-changePassword-output-set' => 'סיסמה להגדרה עבור $1',
	'maintenance-checkBadRedirects-output-footer' => '
בוצע.',
	'maintenance-checkImages-output-good' => 'תמונות טובות: $1/$2',
	'maintenance-checkSyntax' => 'טופס זה משמש כדי לבדוק את התחביר של כל קבצי ה-PHP במדיה-ויקי',
	'maintenance-checkSyntax-desc' => 'בדיקת התחביר של כל קבצי ה-PHP במדיה-ויקי',
	'maintenance-checkSyntax-option-with-extensions' => 'בדיקה רקורסיבית בתיקיית ההרחבות',
	'maintenance-checkSyntax-option-list-file' => 'רשימת קבצים ותיקיות לבדיקה',
	'maintenance-checkSyntax-option-modified' => 'בדיקה רק של קבצים ששונו (מחייב לקוח שורת פקודה svn)',
	'maintenance-checkSyntax-option-syntax-only' => 'בדוק חוקיות תחביר בלבד, ללא אזהרות סגנון',
	'maintenance-checkSyntax-output-parsekit' => 'בדיקת תחביר (באמצעות parsekit)',
	'maintenance-checkSyntax-output-phpl' => 'בדיקת תחביר (באמצעות php -l, עשוי לקחת זמן ממושך)',
	'maintenance-checkSyntax-output-footer' => 'בוצע! $1  קבצים נבדקו, $2 בעיות ו $3  אזהרות נמצאו',
	'maintenance-checkSyntax-output-buildlist' => 'בונה רשימת קבצים...',
	'maintenance-checkSyntax-output-error' => 'שגיאה $1 בשורה $2: $3',
	'maintenance-checkSyntax-error-cantopen' => 'אין אפשרות לפתוח את הקובץ $1',
	'maintenance-checkUsernames-error-notvalid' => 'שם משתמש לא חוקי: "$3" (מזהה משתמש $2)',
	'maintenance-cleanupCaps-output-dryrun' => '" $1 "->" $2 ": הרצה על יבש, לא הועבר',
	'maintenance-cleanupSpam' => 'השתמשו בטופס לשחזור עריכות ספאם שמקשרות לאתרים חיצוניים',
	'maintenance-cleanupSpam-desc' => 'ניקוי כל הספאם משרת מסוים',
	'maintenance-cleanupSpam-option-hostname' => 'שם המארח המזבל',
	'maintenance-cleanupSpam-output-blanking' => 'ריקון',
	'maintenance-cleanupSpam-output-reverting' => 'שחזור',
	'maintenance-createAndPromote' => 'השתמשו בטופס זה כדי ליצור משתמש חדש ולקדם אותו לדרגת מפעיל מערכת.
סמנו את תיבת הביורוקרט אם ברצונכם לקדם אותו גם לדרגת ביורוקרט',
	'maintenance-createAndPromote-desc' => 'יצירת משתמש וקידומו למצב מפעיל מערכת',
	'maintenance-deleteBatch' => 'השתמשו בטופס זה למחיקת דפים המונית.
כתבו שם של דף אחד בכל שורה',
	'maintenance-deleteBatch-desc' => 'מחיקה המונית של דפים',
	'maintenance-deleteRevision' => 'השתמשו בטופס זה למחיקה המונית של גרסאות.
כתבו מספר גרסה אחד בכל שורה',
	'maintenance-deleteRevision-desc' => 'הסרת גרסאות ממסד הנתונים',
	'maintenance-initEditCount-desc' => 'חישוב מחדש של מספר העריכות שביצע כל משתמש',
	'maintenance-initSiteStats' => 'השתמשו בטופס זה כדי לחשב מחדש את סטטיסטיקות האתר, וציינו האם ברצונכם לחשב מחדש גם את סטטיסטיקות הצפיות בדפים',
	'maintenance-initSiteStats-desc' => 'חישוב מחדש של סטטיסטיקות האתר',
	'maintenance-moveBatch' => 'השתמשו בטופס זה להעברה המונית של דפים.
כל שורה אמורה לציין דף מקור ודף יעד המופרדים ב־"|"',
	'maintenance-moveBatch-desc' => 'העברה המונית של דפים',
	'maintenance-reassignEdits-desc' => 'הקצאת עריכות מחדש ממשתמש אחד לאחר',
	'maintenance-runJobs-desc' => 'הרצת משימות מתור המשימות',
	'maintenance-showJobs-desc' => 'הצגת רשימת משימות הממתינות בתור המשימות',
	'maintenance-sql' => 'השתמשו בטופס זה כדי להריץ שאילתת SQL על בסיס הנתונים.',
	'maintenance-sql-desc' => 'הרצת שאילתת SQL',
	'maintenance-sql-option-file' => 'SQL לביצוע',
	'maintenance-sql-output-aff' => 'השאילתא תקינה, {{PLURAL:$1|רשומה אחת שונתה|$1 רשומות שונו}}',
	'maintenance-sql-error-cantopen' => 'אין אפשרות לפתוח את קובץ הקלט',
	'maintenance-showCacheStats-desc' => 'הצגת סטטיסטיקת Memcached',
	'maintenance-eval' => 'השתמשו בטופס זה כדי להעריך קוד PHP בסביבת מדיה־ויקי.',
	'maintenance-eval-desc' => 'הרצת קוד PHP בסביבת מדיה־ויקי',
	'maintenance-update' => 'האם להשתמש ב־UPDATE לעדכון הטבלה? אם תבטלו את הסימון, ייעשה שימוש ב־DELETE/INSERT במקום זאת.',
	'maintenance-noviews' => 'סמנו זאת כדי למנוע את עדכון מספרי הצפיות בדפים',
	'maintenance-invalidname' => 'שם משתמש בלתי תקין!',
	'maintenance-userexists' => 'המשתמש כבר קיים!',
	'maintenance-invalidtitle' => 'הכותרת "$1" אינה תקינה!',
	'maintenance-titlenoexist' => 'הכותרת שצוינה ("$1") אינה קיימת!',
	'maintenance-failed' => 'נכשלה',
	'maintenance-deleted' => 'נמחק',
	'maintenance-revdelete' => 'מחיקת {{PLURAL:$3|הגרסה|הגרסאות}} $1 מאתר הוויקי $2',
	'maintenance-revnotfound' => 'הגרסה $1 לא נמצאה!',
	'maintenance-showCacheStats-edits' => 'מספר העריכות: $1',
	'maintenance-showCacheStats-articles' => 'מספר הדפים במרחב השם הראשי: $1',
	'maintenance-showCacheStats-pages' => 'מספר הדפים: $1',
	'maintenance-showCacheStats-users' => 'מספר המשתמשים: $1',
	'maintenance-showCacheStats-admins' => 'מספר מפעילי המערכת: $1',
	'maintenance-showCacheStats-images' => 'מספר הקבצים: $1',
	'maintenance-showCacheStats-views' => 'מספר הצפיות בדפים: $1',
	'maintenance-showCacheStats-update' => 'בסיס הנתונים מתעדכן...',
	'maintenance-move' => 'העברת $1 אל $2...',
	'maintenance-movefail' => 'אירעה שגיאה בעת העברת: $1.
ההעברה נקטעה',
	'maintenance-error' => 'שגיאה: $1',
	'maintenance-memc-fake' => 'אתם מריצים את FakeMemCachedClient. לא ניתן לספק סטטיסטיקה.',
	'maintenance-memc-requests' => 'בקשות',
	'maintenance-memc-withsession' => 'בהתחברות:',
	'maintenance-memc-withoutsession' => 'ללא התחברות:',
	'maintenance-memc-total' => 'סך הכול:',
	'maintenance-memc-parsercache' => 'מטמון המפענח',
	'maintenance-memc-hits' => 'פעמים בשימוש:',
	'maintenance-memc-invalid' => 'לא תקין:',
	'maintenance-memc-expired' => 'שתוקפו פג:',
	'maintenance-memc-absent' => 'נעדר:',
	'maintenance-memc-stub' => 'סף הקצרמרים:',
	'maintenance-memc-imagecache' => 'מטמון התמונות',
	'maintenance-memc-misses' => 'החטאות:',
	'maintenance-memc-updates' => 'עדכונים:',
	'maintenance-memc-uncacheable' => 'לא ניתן למטמון:',
	'maintenance-memc-diffcache' => 'מטמון השינויים',
	'maintenance-reassignEdits' => 'השתמשו בטופס זה כדי להקצות מחדש עריכות ממשתמש אחד לאחר.',
	'maintenance-re-from' => 'שם המשתמש ממנו יש להקצות את העריכות',
	'maintenance-re-to' => 'שם המשתמש אליו יוקצו העריכות',
	'maintenance-re-force' => 'ביצוע הקצאה מחודשת אפילו אם משתמש היעד אינו קיים',
	'maintenance-re-rc' => 'לא לעדכן את טבלת השינויים האחרונים',
	'maintenance-re-report' => 'הצגת הפרטים של מה שישתנה, ללא ביצוע השינויים',
	'maintenance-re-nf' => 'המשתמש $1 לא נמצא',
	'maintenance-re-rr' => 'הרצת הסקריפט שוב ללא "$1" לעדכון.',
	'maintenance-re-ce' => 'עריכות נוכחיות: $1',
	'maintenance-re-de' => 'עריכות שנמחקו: $1',
	'maintenance-re-rce' => 'רשומות שינויים אחרונים: $1',
	'maintenance-re-total' => 'סך כל הרשומות לשינוי: $1',
	'maintenance-re-re' => 'הקצאת העריכות מחדש... בוצעה',
);

/** Hindi (हिन्दी)
 * @author Ansumang
 */
$messages['hi'] = array(
	'maintenance-generic-username' => 'सदस्यनाम',
	'maintenance-generic-password' => 'पासवर्ड',
	'maintenance-generic-reason' => 'कारण',
	'maintenance-option-optional' => '(वैकल्पिक)',
);

/** Croatian (hrvatski)
 * @author Dalibor Bosits
 */
$messages['hr'] = array(
	'maintenance' => 'Pokreni skripte za održavanje',
	'maintenance-desc' => '[[Special:Maintenance|Web sučelje]] za različite skripte za održavanje',
	'maintenance-backlink' => 'Nazad na odabir skripte',
	'maintenance-header' => 'Odaberite dolje skriptu za pokrenuti.
Opis stoji pored svake skripte.',
	'maintenance-error-invalidtype' => 'Neispravna vrsta!', # Fuzzy
	'maintenance-option-confirm' => 'Potvrdi',
	'maintenance-output-success' => '$1 pokrenut uspješno!',
	'maintenance-changePassword' => 'Koristite ovu stranicu za promjenu suradničke lozinke',
	'maintenance-changePassword-desc' => 'Promijeni lozinku suradnika',
	'maintenance-createAndPromote' => 'Koristite ovu stranicu za stvaranje novog suradničkog računa i dodjelu sysop prava.
Označite kućicu bureaucrat ako želite dodijeliti i pravo birokrata.',
	'maintenance-createAndPromote-desc' => 'Stvori suradnički račun i dodijeli sysop pravo',
	'maintenance-deleteBatch' => 'Koristite ovu stranicu za skupno brisanje stranica.
Stavite samu jedno stranicu po retku.',
	'maintenance-deleteBatch-desc' => 'Skupno brisanje stranica',
	'maintenance-deleteRevision' => 'Koristite ovu stranicu za skupno brisanje izmjena.
Stavite broj samo jedne izmjene po retku.',
	'maintenance-deleteRevision-desc' => 'Ukloni izmjene iz baze podataka',
	'maintenance-initEditCount-desc' => 'Ponovno izračunaj broj uređivanja za suradnike',
	'maintenance-initSiteStats' => 'Koristite ovu stranicu za ponovno izračunavanje statistike, odredite ako želite izračunati i broj gledanja stranica također',
	'maintenance-initSiteStats-desc' => 'Ponovno izračunaj statistiku za projekt',
	'maintenance-moveBatch' => 'Koristite ovu stranicu za skupno premještanje stranica.
Svaki red mora sadržavati polazišnu stranicu i ciljnu stranicu odvojeno kosom crtom "|"',
	'maintenance-moveBatch-desc' => 'Skupno premještanje stranica',
	'maintenance-reassignEdits-desc' => 'Prenamjeni uređivanje od jednog suradnika drugom.',
	'maintenance-runJobs-desc' => 'Pokreni poslove u redu poslova',
	'maintenance-showJobs-desc' => 'Pokaži popis poslova u toku u redu poslova.',
	'maintenance-sql' => 'Koristite ovaj obrazac kako bi izvršili SQL upit na bazu.',
	'maintenance-sql-desc' => 'Izvrši SQL upit',
	'maintenance-showCacheStats-desc' => 'Pokaži memcached statistiku',
	'maintenance-eval-desc' => 'Procijeni PHP kod u MediaWiki okruženju',
	'maintenance-update' => 'Koristi UPDATE prilikom ažuriranja tablice? Neoznačeno umjesto toga koristi DELETE/INSERT.',
	'maintenance-noviews' => 'Označite ovo za sprečavanje ažuriranja broja gledanja stranica',
	'maintenance-invalidname' => 'Nevaljano suradničko ime!',
	'maintenance-userexists' => 'Suradnik već postoji!',
	'maintenance-invalidtitle' => 'Nevaljan naslov "$1"!',
	'maintenance-titlenoexist' => 'Određeni naslov ("$1") ne postoji!',
	'maintenance-failed' => 'NEUSPJEŠNO',
	'maintenance-deleted' => 'OBRISANO',
	'maintenance-revdelete' => 'Brisanje izmjene $1 s wiki $2', # Fuzzy
	'maintenance-revnotfound' => 'Izmjena $1 nije pronađena!',
	'maintenance-showCacheStats-edits' => 'Broj uređivanja: $1',
	'maintenance-showCacheStats-articles' => 'Broj stranica u glavnom imenskom prostoru: $1',
	'maintenance-showCacheStats-pages' => 'Broj stranica: $1',
	'maintenance-showCacheStats-users' => 'Broj suradnika: $1',
	'maintenance-showCacheStats-admins' => 'Broj administratora: $1',
	'maintenance-showCacheStats-images' => 'Broj datoteka: $1',
	'maintenance-showCacheStats-views' => 'Broj gledanja stranica: $1',
	'maintenance-showCacheStats-update' => 'Ažuriranje baze podataka{{int:ellipsis}}',
	'maintenance-move' => 'Premještam $1 na $2{{int:ellipsis}}',
	'maintenance-movefail' => 'Dogodila se greška prilikom premještanja: $1.
Premještanje prekinuto.',
	'maintenance-error' => 'Greška: $1',
	'maintenance-memc-fake' => 'Uključen je lažni memcache klijent. Statistika ne može biti pružena.',
	'maintenance-memc-requests' => 'Zahtjevi',
	'maintenance-memc-withsession' => 'sa sesijom:',
	'maintenance-memc-withoutsession' => 'bez sesije:',
	'maintenance-memc-total' => 'ukupno:',
	'maintenance-memc-parsercache' => 'Memorija parsera',
	'maintenance-memc-hits' => 'pogodaka:',
	'maintenance-memc-invalid' => 'neispravno:',
	'maintenance-memc-expired' => 'isteklo:',
	'maintenance-memc-absent' => 'odustno:',
	'maintenance-memc-stub' => 'prag mrve:',
	'maintenance-memc-imagecache' => 'Memorija slike',
	'maintenance-memc-misses' => 'neuspjelo:',
	'maintenance-memc-updates' => 'ažuriranja:',
	'maintenance-memc-uncacheable' => 'neuhvatljivo za memoriju:',
	'maintenance-memc-diffcache' => 'Diff memorija',
);

/** Upper Sorbian (hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'maintenance' => 'Wothladowanske skripty wuwjesć',
	'maintenance-desc' => '[[Special:Maintenance|Wikijowy interfejs]] za wšelake wothladowanske skripty',
	'right-maintenance' => 'Wothladowanske skripty přez [[Special:Maintenance]] wuwjesć',
	'maintenance-backlink' => 'Wróćo k wuběrej skriptow',
	'maintenance-header' => 'Prošu wubjer jedyn ze slědowacych skriptow, zo by jón wuwjedł.
Wopisanja su pódla wotpowědneho skripta',
	'maintenance-error-invalidtype' => 'Podaty skript njebu namakany',
	'maintenance-error-badargs' => 'Njejsy wšě trěbne opcije podał',
	'maintenance-generic-done' => 'dokónčeny',
	'maintenance-generic-username' => 'Wužiwarske mjeno',
	'maintenance-generic-password' => 'Hesło',
	'maintenance-generic-reason' => 'Přičina',
	'maintenance-cleanupTable-dry-run' => 'Probny běh přewjesć',
	'maintenance-cleanupTable-checkfix' => 'Wopačne titule so kontroluja a porjedźeja...',
	'maintenance-cleanupTable-missingparam' => '$1: Falowacy parameter $2',
	'maintenance-cleanupTable-processing' => '$1 so předźěłuje...',
	'maintenance-option-confirm' => 'Wobkrućić',
	'maintenance-option-required' => '(trěbny)',
	'maintenance-option-optional' => '(opcionalny)',
	'maintenance-output-success' => '$1 wuspěšnje wuwjedźeny!',
	'maintenance-output-failure' => '$1 njeje so wuspěšnje wuwjedł!',
	'maintenance-attachLatest-output-done' => 'Hotowo! $1 {{PLURAL:$1|strona předźěłana|stronje předźěłanej|strony předźěłane|stronow předźěłanych}}.',
	'maintenance-benchmarkPurge-output-trial' => '$1 {{PLURAL:$1|titul|titulaj|titule|titulow}} w $2ms ($3ms na titul)',
	'maintenance-changePassword' => 'Wužij tutón formular, zo by hesło wužiwarja změnił.',
	'maintenance-changePassword-desc' => 'Hesło wužiwarja změnić',
	'maintenance-changePassword-error-nouser' => 'Wužiwar njeeksistuje: $1',
	'maintenance-changePassword-output-set' => 'Hesło za $1 stajene',
	'maintenance-checkAutoLoader-output-list2' => '$1: Wopačna dataja : namakana w $2, w $3 podata',
	'maintenance-checkBadRedirects-desc' => 'Na njepłaćiwe dalesposrědkowanja kontrolować',
	'maintenance-checkBadRedirects-output-footer' => 'Dokónčene.',
	'maintenance-checkImages-output-noaccess' => '$1: žadyn lokalny přistup',
	'maintenance-checkImages-output-missing' => '$1: faluje',
	'maintenance-checkImages-output-isdir' => '$1: je zapis',
	'maintenance-checkImages-output-good' => 'Dobre wobrazy: $1/$2',
	'maintenance-checkSyntax' => 'Tutón formular wužiwać, zo by syntaksu wšěch PHP-datajow w MediaWiki kontrolowało',
	'maintenance-checkSyntax-desc' => 'Přepruwuj syntaksu wšěch PHP-datajow w MediaWiki',
	'maintenance-checkSyntax-option-list-file' => 'Lisćina datajow abo zapisow, kotrež maja so přepruwować',
	'maintenance-checkSyntax-output-parsekit' => 'Syntaksa so přepruwuje (z pomocu parsekita)',
	'maintenance-checkSyntax-output-footer' => 'Hotowo! $1 {{PLURAL:$1|dataja skontrolowana|dataji skontrolowanej|dataje skontrolowane|datajow skontrolowanych}}, $2 {{PLURAL:$2|zmylk|zmylkaj|zmylki|zmylkow}} a $3 {{PLURAL:$3|warnowanje namakane|warnowani namakanej|warnowanja namakane|warnowanjow namakanych}}',
	'maintenance-checkSyntax-output-svnlist' => 'Lisćina so ze Subversiona wotwołuje...',
	'maintenance-checkSyntax-output-buildlist' => 'Lisćina datajow so twori...',
	'maintenance-checkSyntax-output-error' => 'Zmylk w dataji $1, w rjadce $2: $3',
	'maintenance-checkSyntax-output-warning' => 'Warnowanje w dataji $1: $2 namakany',
	'maintenance-checkSyntax-error-nofile' => 'Zmylk: Dataja abo zapis $1 njeda so namakać',
	'maintenance-checkSyntax-error-cantopen' => 'Dataja $1 njeda so wočinić',
	'maintenance-checkSyntax-error-svnerr' => 'Zmylk při wotwołowanju lisćiny ze Subversion!',
	'maintenance-checkUsernames-error-notvalid' => 'Njepłaćiwe wužiwarske mjeno: "$3" (wužiwarski ID $2)',
	'maintenance-cleanupCaps-output-islower' => '"$1" je hižo mało pisany.',
	'maintenance-cleanupCaps-output-clash' => '"$1" přeskočeny; "$2" hižo eksistuje',
	'maintenance-cleanupSpam-output-found' => '{{PLURAL:$1|Je so $1 nastawk namakał|Stej so $1 nastawkaj namakałoj|Su so $1 nastawki namakali|Je so $1 nastawkow namakało}}, {{PLURAL:$1|kotryž $2 wobsahowaše|kotrejž $2 wobsahowaštej|kotrež $2 wobsahowachu|kotrež $2 wobsahowaše}}',
	'maintenance-cleanupSpam-output-false' => 'Wopačny wotpowědnik',
	'maintenance-cleanupSpam-error-noid' => 'Interny zmylk: žana strona za ID $1',
	'maintenance-createAndPromote' => 'Wužij tutón formular, zo by noweho wužiwarja wutworił a jeho k administratorej powyšił.
Wubjer běrokratowy kašćik, jeli chceš jeho tež k běrokratej powyšić.',
	'maintenance-createAndPromote-desc' => 'Wužiwarske konto załožić a do statusa administratora pozběhnyć',
	'maintenance-createAndPromote-option-bureaucrat' => 'Wužiwarja do statusa běrokrata powyšić',
	'maintenance-deleteBatch' => 'Wužij tutón formular, zo by strony z masami wušmórnył.
Napisaj jenož jednu stronu na linku',
	'maintenance-deleteBatch-desc' => 'Strony z masami wušmórnyć',
	'maintenance-deleteRevision' => 'Wužij tutón formular, zo by wersije z masami wušmórnył.
Napisaj jenož jednu wersiju na linku',
	'maintenance-deleteRevision-desc' => 'Wersije z datoweje banki wotstronić',
	'maintenance-initEditCount-desc' => 'Ličenja změnow wužiwarjow znowa wobličić',
	'maintenance-initSiteStats' => 'Wužij tutón formular, zo by statistiku sydła znowa wobličił. Podaj, hač chceš zwobraznjenja strony tež znowa wobličić',
	'maintenance-initSiteStats-desc' => 'Statistiku sydła znowa wobličić',
	'maintenance-moveBatch' => 'Wužij tutón formular, zo by strony z masami přesunył.
Kóžda linka měła žórłowu stronu a cilowu stronu podać, wótdźělenej přez znamješko rołka (|)',
	'maintenance-moveBatch-desc' => 'Strony z masami přesunyć',
	'maintenance-reassignEdits-desc' => 'Změny wot jednoho wužiwarja k druhemu wužiwarjej znowa připokazać',
	'maintenance-runJobs-desc' => 'Nadawki w rynku čakacych nadawkow wuwjesć',
	'maintenance-runJobs-option-maxjobs' => 'Maksimalna ličba nadawkow, kotrež maja so wuwjesć',
	'maintenance-runJobs-option-type' => 'Družina nadawka, kotryž ma so wuwjesć',
	'maintenance-runJobs-option-procs' => 'Ličba procesow, kotrež maja so wužiwać',
	'maintenance-runJobs-error-invalidprocs' => 'Dyrbi so mjez 1 a 1000 procesami podać',
	'maintenance-showJobs-desc' => 'Lisćinu nadawkow pokazać, kotrež w rynku nadawkow čakaja',
	'maintenance-showJobs-option-group' => 'Ličbu nadawkow po nadawkowym typje pokazać',
	'maintenance-sql' => 'Wužij tutón formular, zo by SQL-wotprašenje w datowej bance wuwjedł.',
	'maintenance-sql-desc' => 'SQL-wotprašenje wuwjesć',
	'maintenance-sql-option-file' => 'SQL, kotryž ma so wuwjesć',
	'maintenance-sql-output-aff' => 'Naprašowanje w porjadku, $1 {{PLURAL:$1|rjadka bě potrjechena|rjadce běštej potrjechenej|rjadki běchu potrjechene|rjadkow bě potrjechenych}}',
	'maintenance-sql-error-cantopen' => 'Zapodawanska dataja njeda so wočinić',
	'maintenance-showCacheStats-desc' => 'Statistiku Memcached pokazać',
	'maintenance-eval' => 'Wužij tutón formular, zo by PHP-kod we wokolinje MediaWiki wuhódnoćił.',
	'maintenance-eval-desc' => 'PHP-kod we wokolinje MediaWiki wuhódnoćić',
	'maintenance-update' => 'Při aktualizowanju tabele UPDATE wužiwać? Jeli to njeje wubrane, so DELETE/INSERT město toho wužiwa.',
	'maintenance-noviews' => 'Wubjer to, zo by aktualizowanju ličby zwobraznjenjow strony zadźěwał',
	'maintenance-invalidname' => 'Njepłaćiwe wužiwarske mjeno!',
	'maintenance-userexists' => 'Wužiwar hižo eksistuje!',
	'maintenance-invalidtitle' => 'Njepłaćiwy titul "$1"!',
	'maintenance-titlenoexist' => 'Pódaty titul ("$1") njeeksistuje!',
	'maintenance-failed' => 'NJEPORADŹENY',
	'maintenance-deleted' => 'WUŠMÓRNJENY',
	'maintenance-revdelete' => '{{PLURAL:$3|Wersija|Wersiji|Wersije|Wersije}} $1 so z wikija $2 {{PLURAL:$3|wušmóruje|wušmórujetej|wušmóruja|wušmóruja}}',
	'maintenance-revnotfound' => 'Wersija $1 njenamakana!',
	'maintenance-showCacheStats-edits' => 'Ličba změnow: $1',
	'maintenance-showCacheStats-articles' => 'Ličba stronow we hłownym mjenowym rumje: $1',
	'maintenance-showCacheStats-pages' => 'Ličba stronow: $1',
	'maintenance-showCacheStats-users' => 'Ličba wužiwarjow: $1',
	'maintenance-showCacheStats-admins' => 'Ličba administratorow: $1',
	'maintenance-showCacheStats-images' => 'Ličba datajow: $1',
	'maintenance-showCacheStats-views' => 'Ličba zwobraznjenjow strony: $1',
	'maintenance-showCacheStats-update' => 'Datowa banka so aktualizuje{{int:ellipsis}}',
	'maintenance-move' => '$1 so do $2 přesuwuje{{int:ellipsis}}',
	'maintenance-movefail' => 'Zmylk při přesunjenju: $1
Přesunjenje přetorhnjene',
	'maintenance-error' => 'Zmylk: $1',
	'maintenance-memc-fake' => 'Wuwjeduješ FakeMemCachedClient. Žana statistika k dispoziciji.',
	'maintenance-memc-requests' => 'Naprašowanja',
	'maintenance-memc-withsession' => 'z posedźenjom:',
	'maintenance-memc-withoutsession' => 'bjez posedźenja:',
	'maintenance-memc-total' => 'dohromady:',
	'maintenance-memc-parsercache' => 'Parserowy pufrowak',
	'maintenance-memc-hits' => 'wutrjechi:',
	'maintenance-memc-invalid' => 'njepłaćiwy:',
	'maintenance-memc-expired' => 'spadnjeny:',
	'maintenance-memc-absent' => 'njepřitomny:',
	'maintenance-memc-stub' => 'Zarodkowy próh:',
	'maintenance-memc-imagecache' => 'Wobrazowy pufrowak',
	'maintenance-memc-misses' => 'misnjenja:',
	'maintenance-memc-updates' => 'aktualizacije:',
	'maintenance-memc-uncacheable' => 'pufrowak njeda so wužiwać',
	'maintenance-memc-diffcache' => 'Pufrowak rozdźělow',
	'maintenance-reassignEdits' => 'Wužij tutón formular, zo by změny wot jednoho wužiwarja k druhemu wužiwarjej znowa připokazał.',
	'maintenance-re-from' => 'Mjeno wužiwarja, wot kotrehož so změny připokazuja',
	'maintenance-re-to' => 'Mjeno wužiwarja, kotremuž so změny připokazuja',
	'maintenance-re-force' => 'Znowa připokazać, byrnjež cilowy wužiwar njeeksistował',
	'maintenance-re-rc' => 'Tabelu aktualnych změnow njeaktualizować',
	'maintenance-re-report' => 'Podrobnosće pokazać, kotrež bychu so změnili, ale njeaktualizuj',
	'maintenance-re-nf' => 'Wužiwar $1 njenamakany',
	'maintenance-re-rr' => 'Skript za aktualizaciju hišće raz bjez "$1" wuwjesć.',
	'maintenance-re-ce' => 'Aktualne změny: $1',
	'maintenance-re-de' => 'Wušmórnjene změny: $1',
	'maintenance-re-rce' => 'Zapiski aktualnych změnow: $1',
	'maintenance-re-total' => 'Wšě změny, kotrež maja so změnić: $1',
	'maintenance-re-re' => 'Změny se připokazuja{{int:ellipsis}} sčinjeny',
);

/** Hungarian (magyar)
 * @author Dani
 * @author Dj
 * @author Glanthor Reviol
 */
$messages['hu'] = array(
	'maintenance' => 'Karbantartó-szkriptek futtatása',
	'maintenance-desc' => '[[Special:Maintenance|Wikis felület]] különböző karbantartó parancsfájlokhoz',
	'right-maintenance' => 'Karbantartó szkriptek futtatása a [[Special:Maintenance]] speciális lap segítségével',
	'maintenance-backlink' => 'Vissza a parancsfájl-választáshoz',
	'maintenance-header' => 'Kérlek válaszd ki az alábbiak közül a futtatni kívánt parancsfájlt.
Minden parancsfájl mellett megtalálható a leírása',
	'maintenance-error-invalidtype' => 'Érvénytelen típus!', # Fuzzy
	'maintenance-generic-done' => 'kész',
	'maintenance-generic-username' => 'Felhasználónév',
	'maintenance-generic-password' => 'Jelszó',
	'maintenance-generic-reason' => 'Ok',
	'maintenance-cleanupTable-checkfix' => 'Hibás címek ellenőrzése és javítása...',
	'maintenance-cleanupTable-missingparam' => '$1: hiányzó paraméter: $2',
	'maintenance-cleanupTable-processing' => '$1 feldolgozása...',
	'maintenance-cleanupTable-finished' => '$1 befejezve... $2 frissült a(z) $3 sorból', # Fuzzy
	'maintenance-option-confirm' => 'Megerősítés',
	'maintenance-option-required' => '(kötelező)',
	'maintenance-option-optional' => '(nem kötelező)',
	'maintenance-output-success' => '$1 sikeresen lefutott!',
	'maintenance-changePassword' => 'Ezen űrlap segítségével megváltoztathatod egy felhasználó jelszavát',
	'maintenance-changePassword-desc' => 'Felhasználói jelszavak megváltoztatása',
	'maintenance-changePassword-error-nouser' => 'Nincs ilyen felhasználó: $1',
	'maintenance-changePassword-output-set' => '$1 jelszava beállítva',
	'maintenance-checkBadRedirects-output-footer' => '
Kész.',
	'maintenance-checkImages-output-noaccess' => '$1: helyileg nem elérhető',
	'maintenance-checkImages-output-missing' => '$1: hiányzik',
	'maintenance-checkImages-output-isdir' => '$1: könyvtár',
	'maintenance-checkImages-output-truncated' => '$1: csonkolva erről: $2',
	'maintenance-checkImages-output-mismatch' => '$1: méret nem stimmel DB=$2, akruális=$3',
	'maintenance-checkImages-output-good' => 'Jó képek: $1/$2',
	'maintenance-checkUsernames-error-notvalid' => 'Érvénytelen felhasználónév: „$3” (azonosító: $2)',
	'maintenance-cleanupCaps-output-islower' => '„$1” már kisbetűs.',
	'maintenance-cleanupCaps-output-clash' => '„$1” kihagyva; „$2” már létezik',
	'maintenance-cleanupCaps-error-noneed' => 'A $wgCapitalLinks be van kapcsolva – nem szükséges a nagybetűs linkek karbantartása.',
	'maintenance-createAndPromote' => 'Ezen űrlap segítségével új felhasználót hozhatsz létre adminisztrátori jogosultsággal.
Kattintsd be a bürokrata jelölőnégyzetet ha bürokratává is szeretnéd tenni',
	'maintenance-createAndPromote-desc' => 'Felhasználó létrehozása és előléptetése adminisztrátorrá',
	'maintenance-deleteBatch' => 'Ezen űrlap segítségével tömegesen törölhetsz lapokat.
Soronként csak egy lapot adj meg',
	'maintenance-deleteBatch-desc' => 'Lapok tömeges törlése',
	'maintenance-deleteRevision' => 'Ezen űrlap segítségével tömegesen törölhetsz lapváltozatokat.
Soronként csak egy változatazonosítót adj meg',
	'maintenance-deleteRevision-desc' => 'Változatok eltávolítása az adatbázisból',
	'maintenance-initEditCount-desc' => 'Felhasználók szerkesztéseinek újraszámolása',
	'maintenance-initSiteStats' => 'Ezen űrlap segítségével újraszámoltathatod az oldal statisztikáit, valamint opcionálisan az oldalmegtekintések számát is',
	'maintenance-initSiteStats-desc' => 'Oldal statisztikáinak újraszámolása',
	'maintenance-moveBatch' => 'Ezen űrlap segítségével tömegesen nevezhetsz át lapokat.
Minden sorban egy-egy forráslapnak és céllapnak kell szerepelnie, pipe ( | ) karakterrel elválasztva',
	'maintenance-moveBatch-desc' => 'Lapok tömeges átnevezése',
	'maintenance-reassignEdits-desc' => 'Szerkesztések átkönyvelése egyik felhasználótól egy másikhoz',
	'maintenance-runJobs-desc' => 'Feladatok futtatása a feladatok várakozási sorában',
	'maintenance-runJobs-option-type' => 'Futtatandó feladat típusa',
	'maintenance-runJobs-option-procs' => 'Használt folyamatok száma',
	'maintenance-showJobs-desc' => 'Mutasd a feladatok várakozási sorában függőben levő feladatok listáját',
	'maintenance-showJobs-option-group' => 'Feladatok számának megjelenítése típusonként',
	'maintenance-sql' => 'Ezen űrlap segítségével SQL-lekérdezést futtathatsz az adatbázison.',
	'maintenance-sql-desc' => 'SQL-lekérdezés futtatása',
	'maintenance-sql-option-file' => 'Végrehajtandó SQL-parancs',
	'maintenance-sql-output-aff' => 'Lekérdezés rendben, $1 sort érintett',
	'maintenance-sql-error-cantopen' => 'Nem sikerült megnyitni a bemeneti fájlt',
	'maintenance-showCacheStats-desc' => 'Memcached statisztika megjelenítése',
	'maintenance-eval' => 'Ezen űrlap segítségével PHP-kódot futtathatsz a MediaWiki környezetben.',
	'maintenance-eval-desc' => 'PHP kód kiértékelése a MediaWiki környezetben',
	'maintenance-update' => 'Használja az UPDATE-et táblák frissítésekor? Ha nem pipálod ki, akkor DELETE/INSERT lesz használva helyette.',
	'maintenance-noviews' => 'Jelöld be ezt, ha nem szeretnéd frissíteni az oldalmegtekintések számát',
	'maintenance-invalidname' => 'Érvénytelen felhasználói név!',
	'maintenance-userexists' => 'A felhasználó már létezik!',
	'maintenance-invalidtitle' => 'Érvénytelen cím: „$1”!',
	'maintenance-titlenoexist' => 'A megadott cím („$1”) nem létezik!',
	'maintenance-failed' => 'Sikertelen',
	'maintenance-deleted' => 'TÖRÖLVE',
	'maintenance-revdelete' => 'A következő {{PLURAL:$3|változat|változatok}} törlése a(z) $2 wikiről: $1',
	'maintenance-revnotfound' => 'A(z) $1 változat nem található!',
	'maintenance-showCacheStats-edits' => 'Szerkesztések száma: $1',
	'maintenance-showCacheStats-articles' => 'A fő névtérben lévő lapok száma: $1',
	'maintenance-showCacheStats-pages' => 'Lapok száma: $1',
	'maintenance-showCacheStats-users' => 'Felhasználók száma: $1',
	'maintenance-showCacheStats-admins' => 'Adminisztrátorok száma: $1',
	'maintenance-showCacheStats-images' => 'Fájlok száma: $1',
	'maintenance-showCacheStats-views' => 'Lapletöltések száma: $1',
	'maintenance-showCacheStats-update' => 'Adatbázis frissítése…',
	'maintenance-move' => '$1 átnevezése $2 címre…',
	'maintenance-movefail' => 'Hiba történt az áthelyezés közben: $1.
Áthelyezés megszakítása',
	'maintenance-error' => 'Hiba: $1',
	'maintenance-memc-fake' => 'A FakeMemCachedClientet futtatod. Nem lehet statisztikát készíteni',
	'maintenance-memc-requests' => 'Kérelmek',
	'maintenance-memc-withsession' => 'munkamenettel:',
	'maintenance-memc-withoutsession' => 'munkamenet nélkül:',
	'maintenance-memc-total' => 'összesen:',
	'maintenance-memc-parsercache' => 'Elemző gyorsítótára',
	'maintenance-memc-hits' => 'találatok:',
	'maintenance-memc-invalid' => 'érvénytelen:',
	'maintenance-memc-expired' => 'lejárt:',
	'maintenance-memc-absent' => 'hiányzik:',
	'maintenance-memc-stub' => 'csonkok határa:',
	'maintenance-memc-imagecache' => 'Kép gyorsítótár',
	'maintenance-memc-misses' => 'találati hibák:',
	'maintenance-memc-updates' => 'frissítések:',
	'maintenance-memc-uncacheable' => 'nem gyorsítótárazható:',
	'maintenance-memc-diffcache' => 'Változatok közötti eltérések gyorsítótára',
	'maintenance-reassignEdits' => 'Ezen űrlap segítségével szerkesztéseket adhatsz át egyik felhasználótól a másiknak.',
	'maintenance-re-from' => 'A felhasználó neve, akitől elveszed a szerkesztéseket',
	'maintenance-re-to' => 'A felhasználó neve, akinek adod a szerkesztéseket',
	'maintenance-re-force' => 'Akkor is adja át, ha a felhasználó nem létezik',
	'maintenance-re-rc' => 'Ne frissítsd a friss változtatások táblát',
	'maintenance-re-report' => 'Írja ki, hogy milyen változtatások történnének, de ne hajtsa őket végre.',
	'maintenance-re-nf' => '$1 felhasználó nem található',
	'maintenance-re-rr' => 'Futtassa újra a szkriptet „$1” nélkül a frissítéshez',
	'maintenance-re-ce' => 'Aktuális szerkesztések: $1',
	'maintenance-re-de' => 'Törölt szerkesztések: $1',
	'maintenance-re-rce' => 'Friss változtatások bejegyzései: $1',
	'maintenance-re-total' => 'Összes megváltoztatandó bejegyzés: $1',
	'maintenance-re-re' => 'Szerkesztések átadása … megtörtént',
);

/** Interlingua (interlingua)
 * @author McDutchie
 */
$messages['ia'] = array(
	'maintenance' => 'Executar scripts de mantenentia',
	'maintenance-desc' => '[[Special:Maintenance|Interfacie web]] pro diverse scripts de mantenentia',
	'right-maintenance' => 'Executar scripts de mantenentia per [[Special:Maintenance]]',
	'maintenance-backlink' => 'Retornar al selection de script',
	'maintenance-header' => 'Per favor selige in basso un script pro executar.
Le descriptones se trova al latere de cata script.',
	'maintenance-error-badini' => 'Le file metadata.ini es o defectuose o mancante. Per favor re-discarga le extension "Maintenance".',
	'maintenance-error-invalidtype' => 'Le script specificate non esseva trovate',
	'maintenance-error-badargs' => 'Tu non ha specificate tote le optiones obligatori',
	'maintenance-generic-done' => 'finite',
	'maintenance-generic-username' => 'Nomine de usator',
	'maintenance-generic-password' => 'Contrasigno',
	'maintenance-generic-reason' => 'Motivo',
	'maintenance-cleanupTable-dry-run' => 'Executar un test',
	'maintenance-cleanupTable-check' => 'Verifica le presentia de titulos invalide...',
	'maintenance-cleanupTable-checkfix' => 'Verifica e repara titulos invalide...',
	'maintenance-cleanupTable-progress' => '$1 $2: $3% finite in $4; ETA $5 [$6/$7] $8/sec <$9% actualisate>',
	'maintenance-cleanupTable-missingparam' => '$1: Parametro $2 manca',
	'maintenance-cleanupTable-processing' => 'Processa $1...',
	'maintenance-cleanupTable-finished' => '$1 finite... $2 de $3 {{PLURAL:$3|linea|lineas}} actualisate',
	'maintenance-option-quiet' => 'Supprimer le output non-error',
	'maintenance-option-globals' => 'Listar le variabiles global al fin del processamento pro detection de errores',
	'maintenance-option-confirm' => 'Confirmar',
	'maintenance-option-batch-size' => 'Executar tante operationes per lot, predefinition: $1',
	'maintenance-option-required' => '(obligatori)',
	'maintenance-option-optional' => '(optional)',
	'maintenance-output-success' => '$1 se executava con successo!',
	'maintenance-output-failure' => 'Le execution de $1 non ha succedite!',
	'maintenance-attachLatest' => 'Usa iste formulario pro reparar le entratas in le tabella de paginas ubi "page_latest" es equal a 0',
	'maintenance-attachLatest-desc' => 'Reparar entratas "page_latest" in le tabella de paginas',
	'maintenance-attachLatest-option-fix' => 'De facto reparar le entratas, alteremente un test es executate',
	'maintenance-attachLatest-output-begin' => 'Cerca paginas con "page_latest" equal a 0...',
	'maintenance-attachLatest-output-notime' => '$1 $2 [[$3]] non pote trovar le tempore del ultime version?!',
	'maintenance-attachLatest-output-norev' => '$1 $2 [[$3]] ultime hora $4, non pote trovar le ID del version',
	'maintenance-attachLatest-output-found' => '$1 $2 [[$3]] ultime hora $4, ID de version $5',
	'maintenance-attachLatest-output-done' => 'Finite! $1 {{PLURAL:$1|pagina|paginas}} processate.',
	'maintenance-attachLatest-output-dryrun' => 'Isto esseva un test; re-executa lo con "{{int:maintenance-attachLatest-option-fix}}" pro actualisar "page_latest".',
	'maintenance-benchmarkPurge' => 'Usa iste formulario pro testar quante tempore le functiones de purgation de Squid prende',
	'maintenance-benchmarkPurge-desc' => 'Testar le rendimento del functiones de purgation de Squid',
	'maintenance-benchmarkPurge-option-count' => 'Le numero de URLs a dar a Squid pro purgation',
	'maintenance-benchmarkPurge-error-nosquid' => 'Un test del rendimento del purgation de Squid es impossibile si le supporto de Squid non es active.',
	'maintenance-benchmarkPurge-output-numsquids' => 'Il ha $1 {{PLURAL:$1|servitor|servitores}} Squid definite:',
	'maintenance-benchmarkPurge-output-trial' => '$1 {{PLURAL:$1|titulo|titulos}} in $2ms ($3ms per titulo)',
	'maintenance-changePassword' => 'Usa iste formulario pro cambiar le contrasigno de un usator',
	'maintenance-changePassword-desc' => 'Cambiar le contrasigno de un usator',
	'maintenance-changePassword-error-nouser' => 'Usator non existe: $1',
	'maintenance-changePassword-output-set' => 'Contrasigno definite pro $1',
	'maintenance-checkAutoLoader' => 'Usa iste formulario pro facer alcun verificationes de sanitate sur le AutoLoader',
	'maintenance-checkAutoLoader-desc' => 'Verificationes de sanitate pro AutoLoader',
	'maintenance-checkAutoLoader-output-list2' => '$1: File errate: trovate in $2, listate in $3',
	'maintenance-checkBadRedirects' => 'Usa iste formulario pro vider si paginas marcate como redirectiones vermente es redirectiones',
	'maintenance-checkBadRedirects-desc' => 'Cercar mal redirectiones',
	'maintenance-checkBadRedirects-output-header' => 'Obtene redirectiones...',
	'maintenance-checkBadRedirects-output-found' => '$1 {{PLURAL:$1|redirection|redirectiones}} trovate.
Cerca mal redirectiones...',
	'maintenance-checkBadRedirects-output-footer' => '
Finite.',
	'maintenance-checkImages' => 'Usa iste formulario pro vider qual imagines in tu wiki es defectuose',
	'maintenance-checkImages-desc' => 'Verificar imagines pro determinar si illos existe, es legibile, etc.',
	'maintenance-checkImages-output-noaccess' => '$1: non localmente accessibile',
	'maintenance-checkImages-output-missing' => '$1: mancante',
	'maintenance-checkImages-output-isdir' => '$1: es un directorio',
	'maintenance-checkImages-output-truncated' => '$1: truncate, esseva $2',
	'maintenance-checkImages-output-mismatch' => '$1: dimension non correspondente, base de datos: $2, real: $3',
	'maintenance-checkImages-output-good' => 'Bon imagines: $1/$2',
	'maintenance-checkSyntax' => 'Usa iste formulario pro verificar le syntaxe de tote le files PHP in MediaWiki',
	'maintenance-checkSyntax-desc' => 'Verificar le syntaxe de tote le files PHP in MediaWiki',
	'maintenance-checkSyntax-option-with-extensions' => 'Percurrer etiam le directorio de extensiones',
	'maintenance-checkSyntax-option-path' => 'Cammino specific (file o directorio) a verificar, o con cammino absolute o relative al radice de iste installation de MediaWiki',
	'maintenance-checkSyntax-option-list-file' => 'Lista de files o directorios a verificar',
	'maintenance-checkSyntax-option-modified' => 'Verificar solmente le files que esseva modificate (require le cliente SVN a linea de commando)',
	'maintenance-checkSyntax-option-syntax-only' => 'Verificar solmente le validitate del syntaxe, saltante le advertimentos re le stilo del codice',
	'maintenance-checkSyntax-output-parsekit' => 'Verification del syntaxe (con "parsekit")',
	'maintenance-checkSyntax-output-phpl' => 'Verification del syntaxe (con "php -l", isto pote durar multo)',
	'maintenance-checkSyntax-output-footer' => 'Finite! $1 files verificate, $2 fallimentos e $3 advertimentos trovate',
	'maintenance-checkSyntax-output-svnlist' => 'Recuperation del lista ab Subversion...',
	'maintenance-checkSyntax-output-buildlist' => 'Construction del lista de files...',
	'maintenance-checkSyntax-output-error' => 'Error in $1 linea $2: $3',
	'maintenance-checkSyntax-output-warning' => 'Advertimento in file $1: $2 trovate',
	'maintenance-checkSyntax-error-nofile' => 'Error: non pote trovar le file o directorio $1',
	'maintenance-checkSyntax-error-cantopen' => 'Non pote aperir le file $1',
	'maintenance-checkSyntax-error-svnerr' => 'Error durante le obtention del lista ab Subversion!',
	'maintenance-checkUsernames' => 'Usa iste formulario pro revelar le nomines de usator rendite invalide per cambios de configuration. Si nihil es listate post le execution de iste script, tote le nomines de usator es valide.',
	'maintenance-checkUsernames-desc' => 'Verificar que le nomine de usator del base de dato es realmente valide',
	'maintenance-checkUsernames-error-notvalid' => 'Nomine de usator invalide: "$3" (ID del usator: $2)',
	'maintenance-cleanupCaps' => 'Usa iste formulario pro reparar paginas rendite defectuose per le modification de $wgCapitalLinks',
	'maintenance-cleanupCaps-desc' => 'Script pro nettar majusculas e minusculas',
	'maintenance-cleanupCaps-option-namespace' => 'Numero del spatio de nomines sub le qual executar le nettation de majusculas',
	'maintenance-cleanupCaps-output-islower' => '"$1" es ja in minusculas.',
	'maintenance-cleanupCaps-output-clash' => '"$1" saltate; "$2" ja existe',
	'maintenance-cleanupCaps-output-dryrun' => '"$1" -> "$2": TEST, NON DISPLACIATE',
	'maintenance-cleanupCaps-error-noneed' => '$wgCapitalLinks es active -- le nettation de majusculas in ligamines non es necessari.',
	'maintenance-cleanupSpam' => 'Usa iste formulario pro reverter le modificationes de spam con ligamines a sitos externe',
	'maintenance-cleanupSpam-desc' => 'Eliminar tote le spam proveniente de un servitor specific',
	'maintenance-cleanupSpam-option-hostname' => 'Nomine del host que produceva le spam',
	'maintenance-cleanupSpam-output-found' => '$1 {{PLURAL:$1|articulo|articulo}} trovate que contine $2',
	'maintenance-cleanupSpam-output-false' => 'Correspondentia false',
	'maintenance-cleanupSpam-output-blanking' => 'vacuation',
	'maintenance-cleanupSpam-output-reverting' => 'reversion',
	'maintenance-cleanupSpam-error-invalid' => 'Nomine de host invalide: $1',
	'maintenance-cleanupSpam-error-noid' => 'Error interne: nulle pagina pro le ID $1',
	'maintenance-clearInterwikiCache' => 'Usa iste formulario pro rader completemente le cache interwiki',
	'maintenance-clearInterwikiCache-desc' => 'Eliminar tote le ligamines interwiki pro tote le linguas del cache',
	'maintenance-createAndPromote' => 'Usa iste formulario pro crear un nove usator e promover le a administrator.
Marca le quadrato de bureaucrate si tu vole promover le etiam a bureaucrate.',
	'maintenance-createAndPromote-desc' => 'Crear un usator e promover le al stato de administrator',
	'maintenance-createAndPromote-option-bureaucrat' => 'Promover le usator al stato de bureaucrate',
	'maintenance-createAndPromote-output-creating' => 'Creation e promotion del Usator:$2...',
	'maintenance-createAndPromote-error-password' => 'Un error ha essite incontrate con le contrasigno que tu forniva: $1',
	'maintenance-deleteBatch' => 'Usa iste formulario pro deler paginas in massa.
Indica un sol pagina per linea.',
	'maintenance-deleteBatch-desc' => 'Deler paginas in massa',
	'maintenance-deleteRevision' => 'Usa iste forma pro deler versiones in massa.
Indica un sol numero de version per linea.',
	'maintenance-deleteRevision-desc' => 'Remover versiones del base de datos',
	'maintenance-initEditCount-desc' => 'Recalcular le computos de modificationes de usatores',
	'maintenance-initSiteStats' => 'Usa iste formulario pro recalcular le statisticas del sito. Specifica si tu vole recalcular etiam le visitas de paginas.',
	'maintenance-initSiteStats-desc' => 'Recalcular le statisticas del sito',
	'maintenance-moveBatch' => 'Usa iste formulario pro renominar paginas in massa.
Cata linea debe specificar un pagina de origine e un pagina de destination separate per un tubo ("<nowiki>|</nowiki>").',
	'maintenance-moveBatch-desc' => 'Renominar paginas in massa',
	'maintenance-reassignEdits-desc' => 'Reassignar modificationes ab un usator verso un altere',
	'maintenance-runJobs-desc' => 'Executar cargas listate in le cauda de actiones',
	'maintenance-runJobs-option-maxjobs' => 'Numero maxime de cargas a executar',
	'maintenance-runJobs-option-type' => 'Typo de carga a executar',
	'maintenance-runJobs-option-procs' => 'Numero de processos a usar',
	'maintenance-runJobs-option-exclusive' => 'Executar solmente un sol script runJobs exclusive a un vice. Le tempore de expiration es 1800 secundas.',
	'maintenance-runJobs-error-invalidprocs' => 'Tu debe specificar inter 1 e 1000 processos',
	'maintenance-showJobs-desc' => 'Monstrar un lista del cargas pendente in le cauda de actiones',
	'maintenance-showJobs-option-group' => 'Monstrar numero de cargas per typo de carga',
	'maintenance-sql' => 'Usa iste formularo pro executar un consulta SQL del le base de datos.',
	'maintenance-sql-desc' => 'Executar un consulta SQL',
	'maintenance-sql-option-file' => 'SQL a executar',
	'maintenance-sql-output-aff' => 'Consulta OK, $1 {{PLURAL:$1|linea|lineas}} afficite',
	'maintenance-sql-error-cantopen' => 'Impossibile aperir file de entrata',
	'maintenance-showCacheStats-desc' => 'Monstrar statisticas Memcached',
	'maintenance-eval' => 'Usa iste formulario pro evalutar codice PHP in le ambiente MediaWiki.',
	'maintenance-eval-desc' => 'Evalutar codice PHP in le ambiente MediaWiki',
	'maintenance-update' => 'Usar UPDATE pro actualisar un tabella? Dismarca pro usar DELETE/INSERT in vice.',
	'maintenance-noviews' => 'Marca isto pro impedir le actualisation del numero de visitas de paginas.',
	'maintenance-invalidname' => 'Nomine de usator invalide!',
	'maintenance-userexists' => 'Le usator existe jam!',
	'maintenance-invalidtitle' => 'Titulo invalide "$1"!',
	'maintenance-titlenoexist' => 'Le titulo specificate ("$1") non existe!',
	'maintenance-failed' => 'FALTA',
	'maintenance-deleted' => 'DELITE',
	'maintenance-revdelete' => 'Deletion del {{PLURAL:$3|version|versiones}} $1 del wiki $2',
	'maintenance-revnotfound' => 'Version $1 non trovate!',
	'maintenance-showCacheStats-edits' => 'Numero de moficicationes: $1',
	'maintenance-showCacheStats-articles' => 'Numero de paginas in le spatio de nomines principal: $1',
	'maintenance-showCacheStats-pages' => 'Numero de paginas: $1',
	'maintenance-showCacheStats-users' => 'Numero de usatores: $1',
	'maintenance-showCacheStats-admins' => 'Numero de administratores: $1',
	'maintenance-showCacheStats-images' => 'Numero de files: $1',
	'maintenance-showCacheStats-views' => 'Numero de visitas de paginas: $1',
	'maintenance-showCacheStats-update' => 'Actualisation del base de datos in curso…',
	'maintenance-move' => 'Renomination de $1 a $2 in curso…',
	'maintenance-movefail' => 'Error incontrate durante le renomination: $1.
Le renomination es abortate.',
	'maintenance-error' => 'Error: $1',
	'maintenance-memc-fake' => 'Tu executa FakeMemCachedClient. Nulle statistica pote esser fornite.',
	'maintenance-memc-requests' => 'Requestas',
	'maintenance-memc-withsession' => 'con session:',
	'maintenance-memc-withoutsession' => 'sin session:',
	'maintenance-memc-total' => 'total:',
	'maintenance-memc-parsercache' => 'Cache del analysator syntactic',
	'maintenance-memc-hits' => 'accessos:',
	'maintenance-memc-invalid' => 'invalide:',
	'maintenance-memc-expired' => 'expirate:',
	'maintenance-memc-absent' => 'absente:',
	'maintenance-memc-stub' => 'limine de pecietta:',
	'maintenance-memc-imagecache' => 'Cache de imagines',
	'maintenance-memc-misses' => 'non in cache:',
	'maintenance-memc-updates' => 'actualisationes:',
	'maintenance-memc-uncacheable' => 'non cachabile:',
	'maintenance-memc-diffcache' => 'Cache de comparationes',
	'maintenance-reassignEdits' => 'Usa iste formulario pro reassignar modificationes ab un usator verso un altere.',
	'maintenance-re-from' => 'Nomine del usator ab qui prender modificationes',
	'maintenance-re-to' => 'Nomine del usator a qui assignar modificationes',
	'maintenance-re-force' => 'Reassignar mesmo si le usator de destination non existe',
	'maintenance-re-rc' => 'Non actualisar le tabula de modificationes recente',
	'maintenance-re-report' => 'Imprimer detalios de lo que cambiarea, sed non actualisar',
	'maintenance-re-nf' => 'Usator $1 non trovate',
	'maintenance-re-rr' => 'Reexecutar le script sin "$1" a actualisar.',
	'maintenance-re-ce' => 'Modificationes actual: $1',
	'maintenance-re-de' => 'Modificationes delite: $1',
	'maintenance-re-rce' => 'Entratas de Modificationes recente: $1',
	'maintenance-re-total' => 'Total del entratas a cambiar: $1',
	'maintenance-re-re' => 'Reassignation del modificationes… complete',
);

/** Indonesian (Bahasa Indonesia)
 * @author Bennylin
 * @author Farras
 * @author IvanLanin
 * @author Kandar
 * @author Rex
 */
$messages['id'] = array(
	'maintenance' => 'Jalankan skrip pemeliharaan',
	'maintenance-desc' => '[[Special:Maintenance|Antarmuka Wiki]] untuk beragam skrip pemeliharaan',
	'right-maintenance' => 'Jalankan skrip pemeliharaan melalui [[Special:Maintenance]]',
	'maintenance-backlink' => 'Kembali ke pemilihan skrip',
	'maintenance-header' => 'Silakan pilih sebuah skrip di bawah ini untuk dijalankan.
Deskripsi tersedia di samping masing-masing skrip',
	'maintenance-error-badini' => 'Berkas metadata.ini rusak atau tidak ditemukan. Silakan unduh ulang ekstensi Pemeliharaan',
	'maintenance-error-invalidtype' => 'Skrip yang diberikan tidak ditemukan',
	'maintenance-error-badargs' => 'Anda tidak memberikan semua opsi yang diperlukan',
	'maintenance-generic-done' => 'selesai',
	'maintenance-generic-username' => 'Nama pengguna',
	'maintenance-generic-password' => 'Kata sandi',
	'maintenance-generic-reason' => 'Alasan',
	'maintenance-cleanupTable-dry-run' => 'Lakukan pengujian dasar',
	'maintenance-cleanupTable-check' => 'Memeriksa judul yang salah...',
	'maintenance-cleanupTable-checkfix' => 'Memeriksa dan memperbaiki judul yang salah...',
	'maintenance-cleanupTable-progress' => '$1 $2: $3% selesai pada $4; Perkiraan $5 [$6/$7] $8/detik <$9% diperbarui>',
	'maintenance-cleanupTable-missingparam' => '$1: Parameter tidak ditemukan $2',
	'maintenance-cleanupTable-processing' => 'Memproses $1...',
	'maintenance-cleanupTable-finished' => 'Selesai $1... $2 dari $3 baris diperbarui', # Fuzzy
	'maintenance-option-quiet' => 'Sembunyikan keluaran nongalat',
	'maintenance-option-globals' => 'Tampilkan globals pada akhir pemrosesan untuk debugging',
	'maintenance-option-confirm' => 'Konfirmasi',
	'maintenance-option-batch-size' => 'Jumlah operasi yang dijalankan sekaligus per giliran, bawaan: $1',
	'maintenance-option-required' => '(wajib diisi)',
	'maintenance-option-optional' => '(opsional)',
	'maintenance-output-success' => '$1 berjalan lancar!',
	'maintenance-output-failure' => '$1 tidak berjalan dengan sukses!',
	'maintenance-attachLatest' => 'Gunakan formulir ini untuk memperbaiki entri pada tabel halaman yang memiliki nilai page_latest 0',
	'maintenance-attachLatest-desc' => 'Perbaiki entri page_latest dalam tabel halaman',
	'maintenance-attachLatest-option-fix' => 'Lakukan perbaikan langsung entri, atau lakukan pengujian dasar',
	'maintenance-attachLatest-output-begin' => 'Mencari halaman dengan page_latest yang bernilai 0...',
	'maintenance-attachLatest-output-notime' => '$1 $2 [[$3]] tidak dapat menemukan waktu revisi terakhir?!',
	'maintenance-attachLatest-output-norev' => '$1 $2 [[$3]] waktu terbaru $4, tidak dapat menemukan id revisi',
	'maintenance-attachLatest-output-found' => '$1 $2 [[$3]] waktu terbaru $4, id revisi $5',
	'maintenance-attachLatest-output-done' => 'Selesai! Memproses $1 halaman.', # Fuzzy
	'maintenance-attachLatest-output-dryrun' => 'Ini adalah pengujian dasar; jalankan kembali dengan "{{int:maintenance-attachLatest-option-fix}}" untuk memperbarui page_latest.',
	'maintenance-changePassword' => 'Gunakan formulir ini untuk mengubah kata sandi pengguna',
	'maintenance-changePassword-desc' => 'Ubah kata sandi pengguna',
	'maintenance-checkBadRedirects-output-footer' => 'Selesai.',
	'maintenance-checkSyntax-error-cantopen' => 'Gagal membuka berkas $1',
	'maintenance-createAndPromote' => 'Gunakan formulir ini untuk membuat pengguna baru dan mempromosikannya menjadi pengurus.
Cek kotak birokrat jika Anda ingin mempromosikannya juga sebagai birokrat',
	'maintenance-createAndPromote-desc' => 'Buat seorang pengguna dan promosikan menjadi pengurus',
	'maintenance-deleteBatch' => 'Gunakan formulir ini untuk menghapus massal halaman.
Cantumkan hanya satu halaman per baris',
	'maintenance-deleteBatch-desc' => 'Penghapusan halaman secara masal',
	'maintenance-deleteRevision' => 'Gunakan formulir ini untuk menghapus massal revisi.
Cantumkan hanya satu nomor revisi per baris',
	'maintenance-deleteRevision-desc' => 'Hapus revisi dari basis data',
	'maintenance-initEditCount-desc' => 'Hitung ulang jumlah suntingan pengguna',
	'maintenance-initSiteStats' => 'Gunakan formulir ini untuk menghitung ulang statistik situs. Tentukan jika Anda ingin menghitung ulang juga tampilan halaman',
	'maintenance-initSiteStats-desc' => 'Hitung ulang statistik situs',
	'maintenance-moveBatch' => 'Gunakan formulir ini untuk menghapus massal halaman.
Setiap baris harus mencantumkan halaman sumber dan tujuan, dipisahkan dengan tanda pipa',
	'maintenance-moveBatch-desc' => 'Pindahkan halaman secara massal',
	'maintenance-reassignEdits-desc' => 'Ganti kredit suntingan dari satu pengguna lain ke yang lain',
	'maintenance-runJobs-desc' => 'Jalankan pekerjaan di antrean pekerjaan',
	'maintenance-showJobs-desc' => 'Tampilkan daftar pekerjaan tertunda di antrean pekerjaan',
	'maintenance-sql' => 'Gunakan formulir ini untuk menjalankan suatu kueri SQL pada basis data',
	'maintenance-sql-desc' => 'Jalankan suatu kueri SQL',
	'maintenance-showCacheStats-desc' => 'Tampilkan statistik Memcached',
	'maintenance-eval' => 'Gunakan formulir ini untuk mengevaluasi kode PHP di lingkungan MediaWiki.',
	'maintenance-eval-desc' => 'Evaluasi kode PHP di lingkungan MediaWiki',
	'maintenance-update' => 'Gunakan UPDATE sewaktu memperbarui suatu tabel? Jika tidak, akan digunakan DELETE/INSERT.',
	'maintenance-noviews' => 'Centang ini untuk mencegah pembaruan jumlah tampilan halaman',
	'maintenance-invalidname' => 'Nama pengguna tidak sah!',
	'maintenance-userexists' => 'Pengguna sudah ada!',
	'maintenance-invalidtitle' => 'Judul "$1" tidak sah!',
	'maintenance-titlenoexist' => 'Judul yang dimaksud ("$1") tidak ada!',
	'maintenance-failed' => 'GAGAL',
	'maintenance-deleted' => 'DIHAPUS',
	'maintenance-revdelete' => 'Menghapus {{PLURAL:$3|revisi|revisi}} $1 dari wiki $2',
	'maintenance-revnotfound' => 'Revisi $1 tidak ditemukan!',
	'maintenance-showCacheStats-edits' => 'Jumlah suntingan: $1',
	'maintenance-showCacheStats-articles' => 'Jumlah halaman pada ruang nama utama: $1',
	'maintenance-showCacheStats-pages' => 'Jumlah halaman: $1',
	'maintenance-showCacheStats-users' => 'Jumlah pengguna: $1',
	'maintenance-showCacheStats-admins' => 'Jumlah pengurus: $1',
	'maintenance-showCacheStats-images' => 'Jumlah berkas: $1',
	'maintenance-showCacheStats-views' => 'Jumlah tampilan halaman: $1',
	'maintenance-showCacheStats-update' => 'Memperbarui basis data{{int:ellipsis}}',
	'maintenance-move' => 'Memindahkan $1 ke $2{{int:ellipsis}}',
	'maintenance-movefail' => 'Terjadi kesalahan sewaktu memindahkan: $1
Pemindahan dibatalkan',
	'maintenance-error' => 'Kesalahan: $1',
	'maintenance-memc-fake' => 'Anda menjalankan FakeMemCachedClient. Tidak dapat menyediakan statistik.',
	'maintenance-memc-requests' => 'Permintaan',
	'maintenance-memc-withsession' => 'dengan sesi:',
	'maintenance-memc-withoutsession' => 'tanpa sesi:',
	'maintenance-memc-total' => 'total:',
	'maintenance-memc-parsercache' => 'Singgahan parser',
	'maintenance-memc-hits' => 'tohokan:',
	'maintenance-memc-invalid' => 'tak valid:',
	'maintenance-memc-expired' => 'kedaluwarsa:',
	'maintenance-memc-absent' => 'absen:',
	'maintenance-memc-stub' => 'ambang batas rintisan',
	'maintenance-memc-imagecache' => 'Singgahan berkas',
	'maintenance-memc-misses' => 'luput:',
	'maintenance-memc-updates' => 'pembaruan:',
	'maintenance-memc-uncacheable' => 'tak tersinggahkan:',
	'maintenance-memc-diffcache' => 'Singgahan Perbedaan',
	'maintenance-reassignEdits' => 'Gunakan formulir ini untuk memindahkan kredit suntingan dari satu pengguna yang lain.',
	'maintenance-re-from' => 'Nama pengguna pemilik awal suntingan',
	'maintenance-re-to' => 'Nama pengguna pemilik baru suntingan',
	'maintenance-re-force' => 'Ganti penyunting bahkan jika pengguna target tidak ada',
	'maintenance-re-rc' => 'Jangan perbarui tabel perubahan terbaru',
	'maintenance-re-report' => 'Tampilkan detail yang akan diubah, tapi jangan langsung diubah',
	'maintenance-re-nf' => 'Pengguna $1 tidak ditemukan',
	'maintenance-re-rr' => 'Jalankan lagi skrip tanpa pilihan "$1" untuk mengubah data.',
	'maintenance-re-ce' => 'Suntingan sekarang: $1',
	'maintenance-re-de' => 'Suntingan yang dihapus: $1',
	'maintenance-re-rce' => 'Entri PerubahanTerbaru: $1',
	'maintenance-re-total' => 'Entri total untuk diubah: $1',
	'maintenance-re-re' => 'Pengalihan suntingan{{int:ellipsis}} berhasil',
);

/** Italian (italiano)
 * @author Beta16
 * @author BrokenArrow
 * @author Darth Kule
 * @author F. Cosoleto
 * @author Gianfranco
 * @author Pietrodn
 */
$messages['it'] = array(
	'maintenance' => 'Esegui script di manutenzione',
	'maintenance-desc' => '[[Special:Maintenance|Interfaccia Wiki]] per alcuni script di manutenzione',
	'right-maintenance' => 'Esegui gli script di manutenzione mediante la pagina [[Special:Maintenance]]',
	'maintenance-backlink' => 'Torna alla selezione degli script',
	'maintenance-header' => 'Scegli uno script da eseguire.
Le descrizioni sono riportate a fianco di ciascuno script',
	'maintenance-error-invalidtype' => 'Lo script specificato non è stato trovato',
	'maintenance-error-badargs' => 'Non sono state specificate tutte le opzioni necessarie',
	'maintenance-generic-done' => 'fatto',
	'maintenance-generic-username' => 'Nome utente',
	'maintenance-generic-password' => 'Password',
	'maintenance-generic-reason' => 'Motivo',
	'maintenance-cleanupTable-check' => 'Controllo i titoli non validi...',
	'maintenance-cleanupTable-checkfix' => 'Controllo e correggo i titoli non validi...',
	'maintenance-cleanupTable-progress' => '$1 $2: $3% eseguito su $4; ETA $5 [$6/$7] $8/sec <$9% aggiornato>',
	'maintenance-cleanupTable-missingparam' => '$1: parametro $2 mancante',
	'maintenance-cleanupTable-processing' => 'Elaborazione $1 in corso...',
	'maintenance-cleanupTable-finished' => '$1 finito... $2 di $3 {{PLURAL:$3|riga|righe}} {{PLURAL:$2|aggiornata|aggiornate}}',
	'maintenance-option-confirm' => 'Conferma',
	'maintenance-option-required' => '(obbligatorio)',
	'maintenance-option-optional' => '(opzionale)',
	'maintenance-output-success' => '$1 eseguito con successo!',
	'maintenance-output-failure' => '$1 non è stato eseguito con successo!',
	'maintenance-attachLatest' => 'Usa questo modulo per correggere le voci nella tabella della pagina dove page_latest è impostato a 0',
	'maintenance-attachLatest-output-begin' => 'Ricerca delle pagine con page_latest impostato a 0...',
	'maintenance-attachLatest-output-done' => 'Fatto! Elaborate $1 {{PLURAL:$1|pagina|pagine}}.',
	'maintenance-benchmarkPurge-output-numsquids' => "{{PLURAL:$1|C'è un server Squid definito|Ci sono $1 server Squid definiti}}:",
	'maintenance-benchmarkPurge-output-trial' => '$1 {{PLURAL:$1|titolo|titoli}} in $2ms ($3ms ciascuno)',
	'maintenance-changePassword' => 'Usa questo modulo per cambiare la password di un utente',
	'maintenance-changePassword-desc' => 'Cambia una password utente',
	'maintenance-changePassword-error-nouser' => 'Nessun utente: $1',
	'maintenance-changePassword-output-set' => 'Password impostata per $1',
	'maintenance-checkAutoLoader-output-list2' => '$1: file sbagliato: trovato in $2, elencato in $3',
	'maintenance-checkBadRedirects-desc' => 'Controllo redirect sbagliati',
	'maintenance-checkBadRedirects-output-header' => 'Recupero redirect in corso...',
	'maintenance-checkBadRedirects-output-found' => 'Trovati $1 {{PLURAL:$1|redirect}}.
Controllo redirect sbagliati in corso...',
	'maintenance-checkBadRedirects-output-footer' => '
Fatto.',
	'maintenance-checkImages' => 'Utilizzare questo modulo per vedere quali immagini sul proprio wiki sono danneggiate',
	'maintenance-checkImages-desc' => 'Controllare le immagini per vedere se esistono, sono leggibili, ecc',
	'maintenance-checkImages-output-noaccess' => '$1: non è accessibile localmente',
	'maintenance-checkImages-output-missing' => '$1: mancante',
	'maintenance-checkImages-output-isdir' => '$1: è una directory',
	'maintenance-checkImages-output-mismatch' => '$1: mancata corrispondenza della dimensione DB=$2 , effettivo=$3',
	'maintenance-checkImages-output-good' => 'Immagini buone: $1/$2',
	'maintenance-checkSyntax' => 'Utilizzare questo modulo per controllare la sintassi di tutti i file PHP in MediaWiki',
	'maintenance-checkSyntax-desc' => 'Controllare la sintassi per tutti i file PHP in MediaWiki',
	'maintenance-checkSyntax-option-path' => 'Percorso preciso (file o directory) da verificare, con percorso assoluto oppure relativo alla radice di questa installazione di MediaWiki',
	'maintenance-checkSyntax-option-list-file' => 'Elenco dei file o directory da controllare',
	'maintenance-checkSyntax-option-modified' => 'Controllare solo i file che sono stati modificati (richiede il client di svn da riga di comando)',
	'maintenance-checkSyntax-option-syntax-only' => 'Controllare solo la validità della sintassi, ignorare gli avvisi sullo stile del codice',
	'maintenance-checkSyntax-output-parsekit' => 'Controllo sintassi (utilizzando parsekit)',
	'maintenance-checkSyntax-output-phpl' => 'Controllo sintassi (utilizzando php -l, questo può richiedere molto tempo)',
	'maintenance-checkSyntax-output-footer' => 'Fatto! $1 file {{PLURAL:$1|controllato|controllati}}, $2 {{PLURAL:$2|errore|errore}} e $3 {{PLURAL:$3|avviso|avvisi}} trovati',
	'maintenance-checkSyntax-output-svnlist' => 'Recupero elenco da Subversion in corso...',
	'maintenance-checkSyntax-output-buildlist' => 'Creazione elenco file in corso...',
	'maintenance-checkSyntax-output-error' => 'Errore in $1 linea $2: $3',
	'maintenance-checkSyntax-output-warning' => 'Attenzione nel file $1: trovato $2',
	'maintenance-checkSyntax-error-nofile' => 'Errore: impossibile trovare il file o la directory $1',
	'maintenance-checkSyntax-error-cantopen' => 'Impossibile aprire il file $1',
	'maintenance-checkSyntax-error-svnerr' => "Si è verificato un errore durante il recupero dell'elenco da Subversion.",
	'maintenance-checkUsernames' => "Utilizzare questo modulo per mostrare quali nomi utente non sono valide a causa di modifiche della configurazione. Se non è elencato niente dopo l'esecuzione di questo script, tutti i nomi utente sono validi",
	'maintenance-checkUsernames-desc' => 'Verificare che i nomi utente del database siano effettivamente validi',
	'maintenance-checkUsernames-error-notvalid' => 'Nome utente non valido: "$3" (id utente $2)',
	'maintenance-cleanupCaps' => 'Utilizzare questo modulo per correggere le pagine corrotte causate dalla modifica a $wgCapitalLinks',
	'maintenance-cleanupCaps-desc' => 'Script per ripulitura delle maiuscole',
	'maintenance-cleanupCaps-output-islower' => '"$1" già minuscolo.',
	'maintenance-cleanupCaps-output-clash' => '"$1" ignorato; "$2" esiste già',
	'maintenance-cleanupSpam' => 'Utilizzare questo modulo per annullare modifiche di spam che puntano a siti esterni',
	'maintenance-cleanupSpam-output-reverting' => 'ripristino',
	'maintenance-createAndPromote' => 'Usa questo modulo per creare un nuovo utente e promuoverlo amministratore (sysop).
Spunta la casella burocrate se vuoi promuoverlo anche burocrate',
	'maintenance-createAndPromote-desc' => 'Crea un utente e promuovilo amministratore (sysop)',
	'maintenance-createAndPromote-option-bureaucrat' => "Promuovi l'utente allo status di burocrate",
	'maintenance-createAndPromote-error-password' => 'Si è verificato un errore con la password inserita: $1',
	'maintenance-deleteBatch' => 'Usa questo modulo per cancellare pagine in blocco.
Indica solo una pagina per riga',
	'maintenance-deleteBatch-desc' => 'Cancella pagine in blocco',
	'maintenance-deleteRevision' => 'Usa questo modulo per cancellare revisioni in blocco.
Indica solo un numero di revisione per riga',
	'maintenance-deleteRevision-desc' => 'Rimuovi revisioni dal database',
	'maintenance-initEditCount-desc' => 'Ricalcola il conteggio degli edit degli utenti',
	'maintenance-initSiteStats' => 'Usa questo modulo per ricalcolare le statistiche del sito, specificando se vuoi ricalcolare anche il numero di visualizzazioni per pagina',
	'maintenance-initSiteStats-desc' => 'Ricalcola le statistiche del sito',
	'maintenance-moveBatch' => 'Usa questo modulo per spostare pagine in blocco.
Ogni riga deve indicare una pagina di origine ed una di destinazione, separate da un pipe (|)',
	'maintenance-moveBatch-desc' => 'Sposta pagine in blocco',
	'maintenance-reassignEdits-desc' => 'Riassegna gli edit da un utente ad un altro utente',
	'maintenance-runJobs-desc' => 'Esegui richieste in coda job',
	'maintenance-runJobs-option-maxjobs' => 'Numero massimo di lavori da eseguire',
	'maintenance-runJobs-option-type' => 'Tipo di lavoro da eseguire',
	'maintenance-runJobs-option-procs' => 'Numero di processi da utilizzare',
	'maintenance-runJobs-error-invalidprocs' => 'È necessario specificare tra 1 e 1000 processi',
	'maintenance-showJobs-desc' => 'Mostra un elenco di operazioni in attesa in coda job',
	'maintenance-showJobs-option-group' => 'Visualizza numero di lavori per tipo di lavoro',
	'maintenance-sql' => 'Usa questo modulo per eseguire una query SQL sul database.',
	'maintenance-sql-desc' => 'Esegui una query SQL',
	'maintenance-sql-option-file' => 'SQL da eseguire',
	'maintenance-sql-error-cantopen' => 'Impossibile aprire il file di input',
	'maintenance-showCacheStats-desc' => 'Mostra statistiche latenti in Memcache',
	'maintenance-eval' => 'Usa questo modulo per sperimentare codice PHP in ambiente MediaWiki.',
	'maintenance-eval-desc' => 'Sperimenta codice PHP in ambiente MediaWiki',
	'maintenance-update' => "Usare l'istruzione UPDATE per l'aggiornamento delle tabelle? Se non selezionato, usa DELETE/INSERT.",
	'maintenance-noviews' => "Spuntare la casella per evitare l'aggiornamento del numero di visualizzazioni pagine",
	'maintenance-invalidname' => 'Nome utente non valido!',
	'maintenance-userexists' => 'Nome utente già esistente!',
	'maintenance-invalidtitle' => 'Titolo "$1" non valido!',
	'maintenance-titlenoexist' => 'Il titolo indicato ("$1") non esiste!',
	'maintenance-failed' => 'FALLITO',
	'maintenance-deleted' => 'CANCELLATO',
	'maintenance-revdelete' => 'Cancellazione di $1 {{PLURAL:$3|revisione|revisioni}} dal wiki $2',
	'maintenance-revnotfound' => 'Revisione $1 non trovata!',
	'maintenance-showCacheStats-edits' => 'Numero di edit: $1',
	'maintenance-showCacheStats-articles' => 'Numero di pagine nel namespace principale: $1',
	'maintenance-showCacheStats-pages' => 'Numero di pagine: $1',
	'maintenance-showCacheStats-users' => 'Numero di utenti: $1',
	'maintenance-showCacheStats-admins' => 'Numero di amministratori: $1',
	'maintenance-showCacheStats-images' => 'Numero di file: $1',
	'maintenance-showCacheStats-views' => 'Numero di visualizzazioni pagine: $1',
	'maintenance-showCacheStats-update' => 'Aggiornamento del database in corso{{int:ellipsis}}',
	'maintenance-move' => 'Spostamento di $1 a $2 in corso{{int:ellipsis}}',
	'maintenance-movefail' => 'Errore durante lo spostamento: $1.
Spostamento annullato',
	'maintenance-error' => 'Errore: $1',
	'maintenance-memc-fake' => 'Stai eseguendo FakeMemCachedClient. Non è possibile fornire statistiche',
	'maintenance-memc-requests' => 'Richieste',
	'maintenance-memc-withsession' => 'con la sessione:',
	'maintenance-memc-withoutsession' => 'senza sessione:',
	'maintenance-memc-total' => 'totale:',
	'maintenance-memc-parsercache' => 'Cache del parser',
	'maintenance-memc-hits' => 'corrispondenze:',
	'maintenance-memc-invalid' => 'non valido:',
	'maintenance-memc-expired' => 'terminata:',
	'maintenance-memc-absent' => 'assente:',
	'maintenance-memc-stub' => 'livello per stub:',
	'maintenance-memc-imagecache' => 'Cache immagini',
	'maintenance-memc-misses' => 'manca:',
	'maintenance-memc-updates' => 'aggiornamenti:',
	'maintenance-memc-uncacheable' => 'non inseribili in cache:',
	'maintenance-memc-diffcache' => 'Cache per le diff',
	'maintenance-reassignEdits' => 'Usa questo modulo per riassegnare edit da un utente ad un altro utente.',
	'maintenance-re-from' => "Nome dell'utente i cui edit devono essere riassegnati",
	'maintenance-re-to' => "Nome dell'utente al quale devono essere riassegnati gli edit",
	'maintenance-re-force' => "Riassegna anche se l'utente di destinazione non esiste",
	'maintenance-re-rc' => 'Non aggiornare la tabella delle ultime modifiche',
	'maintenance-re-report' => 'Mostra i dettagli di cosa verrebbe cambiato, ma non aggiornare',
	'maintenance-re-nf' => 'Utente $1 non trovato',
	'maintenance-re-rr' => 'Esegui di nuovo lo script senza "$1" per aggiornare.',
	'maintenance-re-ce' => 'Edit attuali: $1',
	'maintenance-re-de' => 'Edit cancellati: $1',
	'maintenance-re-rce' => 'Voci in RecentChanges: $1',
	'maintenance-re-total' => 'Totale voci da modificare: $1',
	'maintenance-re-re' => 'Riassegnazione edit{{int:ellipsis}} eseguita',
);

/** Japanese (日本語)
 * @author Aotake
 * @author Fryed-peach
 * @author Ohgi
 * @author Shirayuki
 */
$messages['ja'] = array(
	'maintenance' => 'メンテナンススクリプトを実行',
	'maintenance-desc' => 'さまざまなメンテナンス スクリプト用の[[Special:Maintenance|ウィキ インターフェイス]]',
	'right-maintenance' => '[[Special:Maintenance]] を使用してメンテナンス スクリプトを実行',
	'maintenance-backlink' => 'スクリプト選択に戻る',
	'maintenance-header' => '実行するスクリプトを以下から選択してください。説明は各スクリプトの隣にあります',
	'maintenance-error-badini' => 'metadata.ini ファイルが破損または欠落しています。メンテナンス拡張機能を再ダウンロードしてください',
	'maintenance-error-invalidtype' => '指定されたスクリプトが見つかりませんでした',
	'maintenance-error-badargs' => '指定していない必須項目があります',
	'maintenance-generic-done' => '完了',
	'maintenance-generic-username' => '利用者名',
	'maintenance-generic-password' => 'パスワード',
	'maintenance-generic-reason' => '理由',
	'maintenance-cleanupTable-dry-run' => '試験的に実行',
	'maintenance-cleanupTable-check' => 'ページ名が正しいかチェックしています...',
	'maintenance-cleanupTable-checkfix' => 'ページ名をチェックして、正しくないものを修正しています...',
	'maintenance-cleanupTable-missingparam' => '$1: パラメーター $2 がありません',
	'maintenance-cleanupTable-processing' => '$1 を処理中...',
	'maintenance-cleanupTable-finished' => '$1 の処理が完了しました... $3 {{PLURAL:$3|行}}中 $2 行を更新しました',
	'maintenance-option-quiet' => 'エラー以外の出力を抑制する',
	'maintenance-option-globals' => '処理が終了した際にグローバル変数を出力する (デバッグ用)',
	'maintenance-option-confirm' => '確認',
	'maintenance-option-required' => '(必須)',
	'maintenance-option-optional' => '(省略可能)',
	'maintenance-output-success' => '$1 を実行しました!',
	'maintenance-output-failure' => '$1 の実行に失敗しました!',
	'maintenance-attachLatest' => 'このフォームを使用してページ テーブル内で page_latest が 0 に設定されている項目を修正する',
	'maintenance-attachLatest-desc' => 'ページ テーブル内の page_latest 項目数を修正する',
	'maintenance-attachLatest-option-fix' => '項目を実際に修正する。チェックを外すと、試験的に実行します',
	'maintenance-attachLatest-output-begin' => 'page_latest が 0 に設定されているページを検索しています...',
	'maintenance-attachLatest-output-done' => '完了しました! $1 {{PLURAL:$1|件のページ}}を処理しました。',
	'maintenance-attachLatest-output-dryrun' => '今回は試験実行でした。page_latest を更新するには「{{int:maintenance-attachLatest-option-fix}}」を再実行してください。',
	'maintenance-benchmarkPurge-desc' => 'Squid のキャッシュ破棄機能のベンチマークを実行する',
	'maintenance-benchmarkPurge-output-numsquids' => '$1 件の Squid {{PLURAL:$1|サーバー}}が定義されています:',
	'maintenance-benchmarkPurge-output-trial' => '$2 ミリ秒で $1 {{PLURAL:$1|ページ}} (1 ページあたり $3 ミリ秒)',
	'maintenance-changePassword' => 'このフォームを使用して利用者のパスワードを変更',
	'maintenance-changePassword-desc' => '利用者のパスワードを変更する',
	'maintenance-changePassword-error-nouser' => '存在しない利用者です: $1',
	'maintenance-changePassword-output-set' => '$1 のパスワードを設定しました',
	'maintenance-checkBadRedirects' => 'このフォームを使用してリダイレクトの印が付いているページが本当にリダイレクトか調べる',
	'maintenance-checkBadRedirects-desc' => '壊れたリダイレクトをチェックする',
	'maintenance-checkBadRedirects-output-header' => 'リダイレクトを取得しています...',
	'maintenance-checkBadRedirects-output-found' => '$1 {{PLURAL:$1|件のリダイレクト}}が見つかりました。
壊れたリダイレクトをチェックしています...',
	'maintenance-checkBadRedirects-output-footer' => '
完了。',
	'maintenance-checkImages' => 'このフォームを使用してウィキ内のどの画像が破損しているか調べる',
	'maintenance-checkImages-output-noaccess' => '$1: ローカルではアクセスできません',
	'maintenance-checkImages-output-missing' => '$1: 見つかりません',
	'maintenance-checkImages-output-isdir' => '$1: ディレクトリです',
	'maintenance-checkImages-output-mismatch' => '$1: サイズが一致していません データベース=$2、実サイズ=$3',
	'maintenance-checkImages-output-good' => '正常な画像: $1/$2',
	'maintenance-checkSyntax' => 'このフォームを使用して MediaWiki のすべての PHP ファイルの構文をチェックする',
	'maintenance-checkSyntax-desc' => 'MediaWiki のすべての PHP ファイルの構文をチェックする',
	'maintenance-checkSyntax-option-with-extensions' => '拡張機能のフォルダーに対しても再帰的に実行する',
	'maintenance-checkSyntax-option-list-file' => 'チェックするファイルまたはディレクトリの一覧',
	'maintenance-checkSyntax-option-modified' => '変更されたファイルのみをチェックする (svn コマンドライン クライアントが必要)',
	'maintenance-checkSyntax-option-syntax-only' => '構文が正しいことのみをチェックして、スタイルの警告をスキップする',
	'maintenance-checkSyntax-output-parsekit' => '構文をチェックしています (parsekit を使用)',
	'maintenance-checkSyntax-output-phpl' => '構文をチェックしています (php -l を使用。長時間かかる場合があります)',
	'maintenance-checkSyntax-output-footer' => '完了しました! $1 ファイルをチェックしました。$2 件の失敗と $3 件の警告が発生しました',
	'maintenance-checkSyntax-output-svnlist' => 'Subversion から一覧を取得しています...',
	'maintenance-checkSyntax-output-buildlist' => 'ファイル一覧を構築しています...',
	'maintenance-checkSyntax-output-error' => '$1 の $2 行目でのエラー: $3',
	'maintenance-checkSyntax-output-warning' => 'ファイル $1 内での警告: $2 が見つかりました',
	'maintenance-checkSyntax-error-nofile' => 'エラー: ファイルまたはディレクトリ $1 が見つかりません',
	'maintenance-checkSyntax-error-cantopen' => 'ファイル $1 を開くことができません',
	'maintenance-checkSyntax-error-svnerr' => 'Subversion から一覧を取得する際にエラーが発生しました!',
	'maintenance-checkUsernames-desc' => 'データベースのユーザー名が本当に正しいか検証する',
	'maintenance-checkUsernames-error-notvalid' => '無効なユーザー名です:「$3」(利用者 ID $2)',
	'maintenance-cleanupCaps' => 'このフォームを使用して $wgCapitalLinks の変更が原因で壊れたページを修正する',
	'maintenance-cleanupCaps-output-islower' => '「$1」は既に小文字です。',
	'maintenance-cleanupCaps-output-clash' => '「$1」をスキップしました。「$2」は既に存在します。',
	'maintenance-cleanupCaps-output-dryrun' => '「$1」→「$2」: 試験実行であるため移動しません',
	'maintenance-cleanupSpam-desc' => '指定したホスト名からのスパムをすべて消去する',
	'maintenance-cleanupSpam-option-hostname' => 'スパム攻撃をしていたホスト名',
	'maintenance-cleanupSpam-output-found' => '$2 を含む記事が $1 {{PLURAL:$1|件}}見つかりました',
	'maintenance-cleanupSpam-error-invalid' => 'ホスト名の仕様を満たしていません: $1',
	'maintenance-cleanupSpam-error-noid' => '内部エラー: ID $1 のページはありません',
	'maintenance-clearInterwikiCache' => 'このフォームを使用してウィキ間キャッシュを完全に消去する',
	'maintenance-clearInterwikiCache-desc' => 'キャッシュから全言語のウィキ間リンクをすべて消去する',
	'maintenance-createAndPromote' => 'このフォームを使用して利用者を新規作成し、管理者にする。ビューロクラットにもしたい場合は、ビューロクラットのボックスにチェックを入れる',
	'maintenance-createAndPromote-desc' => '利用者を作成し、管理者にする',
	'maintenance-createAndPromote-option-bureaucrat' => '利用者をビューロクラットにする',
	'maintenance-createAndPromote-error-password' => '入力したパスワードでエラーが発生しました: $1',
	'maintenance-deleteBatch' => 'このフォームを使用してページを一括削除する。各行に 1 ページのみ記述',
	'maintenance-deleteBatch-desc' => 'ページを一括削除する',
	'maintenance-deleteRevision' => 'このフォームを使用して版を一括削除する。各行に 1 版のみ記述',
	'maintenance-deleteRevision-desc' => 'データベースから版を削除する',
	'maintenance-initEditCount-desc' => '利用者の編集回数を再計算する',
	'maintenance-initSiteStats' => 'このフォームを使用してサイト統計を再計算する。ページビュー数も再計算する場合は指定',
	'maintenance-initSiteStats-desc' => 'サイトの統計を再計算する',
	'maintenance-moveBatch' => 'このフォームを使用してページを一括移動する。各行には移動元ページと移動先ページをパイプ記号で区切って指定する',
	'maintenance-moveBatch-desc' => 'ページを一括移動する',
	'maintenance-reassignEdits-desc' => '編集を現在の利用者から別の利用者に再割り当てする',
	'maintenance-runJobs-desc' => 'ジョブキュー内のジョブを実行する',
	'maintenance-runJobs-option-maxjobs' => '実行するジョブの最大数',
	'maintenance-runJobs-option-type' => '実行するジョブの種類',
	'maintenance-runJobs-option-procs' => '使用するプロセスの数',
	'maintenance-runJobs-option-exclusive' => '一度に 1 つの排他的な runJobs スクリプトのみを実行します。タイムアウトは 1800 秒です。',
	'maintenance-runJobs-error-invalidprocs' => '1～1000 プロセスを指定してください',
	'maintenance-showJobs-desc' => 'ジョブキューで保留中のジョブ一覧を表示する',
	'maintenance-showJobs-option-group' => 'ジョブの種類ごとのジョブ数を表示する',
	'maintenance-sql' => 'このフォームを使用して SQL クエリをデータベース上で実行する。',
	'maintenance-sql-desc' => 'SQL クエリを実行する',
	'maintenance-sql-option-file' => '実行する SQL',
	'maintenance-sql-output-aff' => 'クエリを実行しました。$1 {{PLURAL:$1|行}}に影響を与えました。',
	'maintenance-sql-error-cantopen' => '入力ファイルを開くことができません',
	'maintenance-showCacheStats-desc' => 'メモリ内にキャッシュされた統計を表示する',
	'maintenance-eval' => 'このフォームを使用して MediaWiki 環境で PHP コードを評価する。',
	'maintenance-eval-desc' => 'MediaWiki 環境で PHP コードを評価する',
	'maintenance-update' => 'テーブルの更新に UPDATE を使用しますか? チェックを入れない場合は、代わりに DELETE/INSERT を使用します。',
	'maintenance-noviews' => 'ページビュー数の更新を避けるにはここにチェックを入れる',
	'maintenance-invalidname' => '無効な利用者名です!',
	'maintenance-userexists' => '利用者は既に存在します!',
	'maintenance-invalidtitle' => '「$1」は無効なページ名です!',
	'maintenance-titlenoexist' => '指定した名前 (「$1」) のページは存在しません!',
	'maintenance-failed' => '失敗',
	'maintenance-deleted' => '削除',
	'maintenance-revdelete' => 'ウィキ $2 から{{PLURAL:$3|版}} $1 を削除中',
	'maintenance-revnotfound' => '版 $1 が見つかりません!',
	'maintenance-showCacheStats-edits' => '編集回数: $1',
	'maintenance-showCacheStats-articles' => '標準名前空間のページ数: $1',
	'maintenance-showCacheStats-pages' => 'ページ数: $1',
	'maintenance-showCacheStats-users' => '利用者数: $1',
	'maintenance-showCacheStats-admins' => '管理者数: $1',
	'maintenance-showCacheStats-images' => 'ファイル数: $1',
	'maintenance-showCacheStats-views' => 'ページビュー数: $1',
	'maintenance-showCacheStats-update' => 'データベースを更新中{{int:ellipsis}}',
	'maintenance-move' => '$1 を $2 に移動中{{int:ellipsis}}',
	'maintenance-movefail' => '移動の際にエラーが発生しました: $1。
移動を中止しています',
	'maintenance-error' => 'エラー: $1',
	'maintenance-memc-fake' => 'FakeMemCachedClient が動作しているため、統計は提供できません',
	'maintenance-memc-requests' => '要求',
	'maintenance-memc-withsession' => 'セッションあり:',
	'maintenance-memc-withoutsession' => 'セッションなし:',
	'maintenance-memc-total' => '合計:',
	'maintenance-memc-parsercache' => 'パーサー キャッシュ',
	'maintenance-memc-hits' => 'ヒット数:',
	'maintenance-memc-invalid' => '無効:',
	'maintenance-memc-expired' => '期限切れ:',
	'maintenance-memc-absent' => '欠損:',
	'maintenance-memc-stub' => 'スタブの閾値:',
	'maintenance-memc-imagecache' => '画像キャッシュ',
	'maintenance-memc-misses' => 'ミス数:',
	'maintenance-memc-updates' => '更新:',
	'maintenance-memc-uncacheable' => 'キャッシュ不可:',
	'maintenance-memc-diffcache' => '差分キャッシュ',
	'maintenance-reassignEdits' => 'このフォームを使用して編集を現在の利用者から別の利用者に再割り当てする。',
	'maintenance-re-from' => '編集が現在割り当てられている利用者の名前',
	'maintenance-re-to' => '編集を新しく割り当てる利用者の名前',
	'maintenance-re-force' => '割り当て先の利用者が存在しない場合でも再割り当てする',
	'maintenance-re-rc' => '最近の更新テーブルを更新しない',
	'maintenance-re-report' => '更新せずに、変更点の詳細を出力する',
	'maintenance-re-nf' => '利用者 $1 は見つかりません',
	'maintenance-re-rr' => '「$1」を更新せずにスクリプトを再実行する。',
	'maintenance-re-ce' => '現在の編集: $1',
	'maintenance-re-de' => '削除する編集: $1',
	'maintenance-re-rce' => '最近の更新ページの項目: $1',
	'maintenance-re-total' => '変更する項目の合計: $1',
	'maintenance-re-re' => '編集の再割り当て{{int:ellipsis}} 完了',
);

/** Georgian (ქართული)
 * @author David1010
 */
$messages['ka'] = array(
	'maintenance-generic-done' => 'შესრულდა',
	'maintenance-generic-username' => 'მომხმარებლის სახელი',
	'maintenance-generic-password' => 'პაროლი',
	'maintenance-generic-reason' => 'მიზეზი',
	'maintenance-cleanupTable-missingparam' => '$1: დაკარგულია პარამეტრი $2',
	'maintenance-cleanupTable-processing' => 'მუშავდება $1...',
	'maintenance-option-confirm' => 'დადასტურება',
	'maintenance-option-required' => '(სავალდებულო)',
	'maintenance-option-optional' => '(არასავალდებულო)',
	'maintenance-output-success' => '$1 წარმატებით შესრულდა!',
	'maintenance-output-failure' => '$1 წარმატებით ვერ შესრულდა!',
	'maintenance-attachLatest-output-notime' => '$1 $2 [[$3]] ვერ პოულობს ბოლო ვერსიის დროს?!',
	'maintenance-attachLatest-output-norev' => '$1 $2 [[$3]] ბოლო დრო $4, ვერსიის იდენტიფიკატორის პოვნა ვერ მოხერხდა',
	'maintenance-attachLatest-output-found' => '$1 $2 [[$3]] ბოლო დრო $4, $5 ვერსიის იდენტიფიკატორი',
	'maintenance-attachLatest-output-done' => 'გაკეთდა! დამუშავებულია $1 {{PLURAL:$1|გვერდი}}.',
	'maintenance-changePassword' => 'მომხმარებლის პაროლის შესაცვლელად გამოიყენეთ ეს ფორმა',
	'maintenance-changePassword-desc' => 'მომხმარებლის პაროლის შეცვლა',
	'maintenance-changePassword-error-nouser' => 'მომხმარებელი: $1 არ არსებობს',
	'maintenance-changePassword-output-set' => 'დაყენდა პაროლი $1-თვის',
	'maintenance-checkAutoLoader-output-list2' => '$1: არასწორი ფაილი: ნაპოვნია $2-ში, მითითებულია $3-ში',
	'maintenance-checkBadRedirects-desc' => 'არასწორი გადამისამართებების მონიშვნა',
	'maintenance-checkBadRedirects-output-footer' => 'შესრულებულია.',
	'maintenance-checkImages-output-noaccess' => '$1: ლოკალურად არ არის ხელმისაწვდომი',
	'maintenance-checkImages-output-missing' => '$1: არ არის',
	'maintenance-checkImages-output-isdir' => '$1 - კატალოგი',
	'maintenance-checkImages-output-good' => 'კარგი სურათები: $1/$2',
	'maintenance-checkSyntax-output-buildlist' => 'ფაილების სიის შექმნა...',
	'maintenance-checkSyntax-error-cantopen' => 'ფაილ $1 გახსნა შეუძლებელია',
	'maintenance-checkUsernames-error-notvalid' => 'არასწორი მომხმარებლის სახელი: "$3" (მომხმარებლის იდენტიფიკატორი $2)',
	'maintenance-cleanupCaps-output-dryrun' => '„$1“ → „$2“: საცდელი გაშვება, არ გადატანილა',
	'maintenance-cleanupSpam-output-reverting' => 'დაბრუნება',
	'maintenance-createAndPromote-desc' => 'მომხმარებლის შექმნა ადმინისტრატორის სტატუსით',
	'maintenance-createAndPromote-option-bureaucrat' => 'მომხმარებლისათვის ბიუროკრატის უფლებების მინიჭება',
	'maintenance-deleteBatch' => 'გვერდების მასიურად წასაშლელად გამოიყენეთ ეს ფორმა. ერთ ხაზზე უნდა იყოს მხოლოდ ერთი გვერდი.',
	'maintenance-deleteBatch-desc' => 'გვერდების მასობრივად წაშლა',
	'maintenance-moveBatch-desc' => 'გვერდების მასობრივად გადატანა',
	'maintenance-invalidname' => 'არასწორი მომხმარებლის სახელი!',
	'maintenance-userexists' => 'მომხმარებელი უკვე არსებობს!',
	'maintenance-invalidtitle' => 'არასწორი სათაური "$1"!',
	'maintenance-titlenoexist' => 'მითითებული სათაური ("$1") არ არსებობს!',
	'maintenance-failed' => 'წარუმატებელია',
	'maintenance-deleted' => 'წაშლილია',
	'maintenance-revnotfound' => '$1 გვერდის ვერსია ვერ მოიძებნა!',
	'maintenance-showCacheStats-edits' => 'რედაქტირებების რაოდენობა: $1',
	'maintenance-showCacheStats-articles' => 'გვერდების რაოდენობა ძირითად სახელთა სივცეში: $1',
	'maintenance-showCacheStats-pages' => 'გვერდების რაოდენობა: $1',
	'maintenance-showCacheStats-users' => 'მომხმარებლების რაოდენობა: $1',
	'maintenance-showCacheStats-admins' => 'ადმინისტრატორების რაოდენობა: $1',
	'maintenance-showCacheStats-images' => 'ფაილების რაოდენობა: $1',
	'maintenance-showCacheStats-views' => 'ნანახი გვერდების რაოდენობა: $1',
	'maintenance-showCacheStats-update' => 'მონაცემტა ბაზის განახლება{{int:ellipsis}}',
	'maintenance-move' => '$1 გადატანა $2-ზე{{int:ellipsis}}',
	'maintenance-error' => 'შეცდომა: $1',
	'maintenance-memc-requests' => 'თხოვნები',
	'maintenance-memc-withsession' => 'სეანსით:',
	'maintenance-memc-withoutsession' => 'სეანსის გარეშე:',
	'maintenance-memc-total' => 'სულ:',
	'maintenance-memc-parsercache' => 'პარსერის ქეში',
	'maintenance-memc-hits' => 'ნახვა:',
	'maintenance-memc-invalid' => 'არასწორი:',
	'maintenance-memc-expired' => 'ვადაგასული:',
	'maintenance-memc-absent' => 'არარსებული:',
	'maintenance-memc-imagecache' => 'სურათის ქეში',
	'maintenance-memc-misses' => 'შეცდომები:',
	'maintenance-memc-updates' => 'განახლებები:',
	'maintenance-re-ce' => 'მიმდინარე რედაქტირებები: $1',
	'maintenance-re-de' => 'წაშლილი რედაქტირებები: $1',
	'maintenance-re-rce' => 'ბოლო ცვლილებების ჩანაწერები: $1',
);

/** Khmer (ភាសាខ្មែរ)
 * @author Lovekhmer
 * @author Thearith
 * @author គីមស៊្រុន
 */
$messages['km'] = array(
	'maintenance' => 'ដំណើរការស្រ្គីបតំហែទាំ',
	'maintenance-error-invalidtype' => 'គំរូ​មិន​ត្រឹមត្រូវ!', # Fuzzy
	'maintenance-option-confirm' => 'អះអាង',
	'maintenance-output-success' => '$1 បាន​ដំណើការ​ដោយ​ជោគជ័យ​!',
	'maintenance-changePassword-desc' => 'ប្តូរពាក្យសំងាត់របស់អ្នកប្រើប្រាស់',
	'maintenance-createAndPromote-desc' => 'បង្កើត​អ្នកប្រើប្រាស់ និង​ដំឡើង​ទៅជា​អ្នកអភិបាល (sysop status)',
	'maintenance-invalidname' => 'អ្នកប្រើប្រាស់មិនត្រឹមត្រូវ!',
	'maintenance-userexists' => 'អ្នកប្រើប្រាស់មានរួចជាស្រេចហើយ!',
	'maintenance-invalidtitle' => 'ចំណងជើង​មិនត្រឹមត្រូវ "$1"!',
	'maintenance-titlenoexist' => 'ចំណងជើងដែលបានផ្ដល់អោយ ("$1") មិនមានទេ!',
	'maintenance-failed' => 'បាន​បរាជ័យ',
	'maintenance-deleted' => 'បាន​លុប',
	'maintenance-revdelete' => 'លុប {{PLURAL:$3|ការពិនិត្យឡើងវិញ|ការពិនិត្យឡើងវិញ}} $1 ពី​វិគី $2',
	'maintenance-revnotfound' => 'រក​មិនឃើញ​ការពិនិត្យឡើងវិញ $1 ទេ​!',
	'maintenance-showCacheStats-edits' => 'ចំនួនកំណែប្រែ៖ $1',
	'maintenance-showCacheStats-articles' => 'ចំនួន​ទំព័រ​នៅក្នុង​លំហឈ្មោះ​ដើម: $1',
	'maintenance-showCacheStats-pages' => 'ចំនួនទំព័រ: $1',
	'maintenance-showCacheStats-users' => 'ចំនួនអ្នកប្រើប្រាស់: $1',
	'maintenance-showCacheStats-admins' => 'ចំនួនអ្នកថែទាំប្រព័ន្ធ: $1',
	'maintenance-showCacheStats-images' => 'ចំនួនឯកសារ: $1',
	'maintenance-showCacheStats-views' => 'ចំនួន​នៃ​ការមើល​ទំព័រ: $1',
	'maintenance-showCacheStats-update' => 'ធ្វើឱ្យ​ទិន្នន័យ​ទាន់សម័យ​...',
	'maintenance-move' => 'កំពុងប្តូរទីតាំង$1ទៅ$2...',
	'maintenance-error' => 'កំហុស: $1',
	'maintenance-memc-requests' => 'ស្នើសុំ',
	'maintenance-memc-total' => 'សរុប:',
	'maintenance-memc-invalid' => 'មិន​ត្រឹមត្រូវ:',
	'maintenance-memc-expired' => 'បានផុតកំណត់៖',
	'maintenance-memc-absent' => 'អវត្តមាន:',
	'maintenance-memc-misses' => 'ខ្វះ:',
	'maintenance-memc-updates' => 'បន្ទាន់សម័យ​៖',
	'maintenance-re-nf' => 'រក​មិន​ឃើញ​អ្នកប្រើប្រាស់ $1 ទេ',
	'maintenance-re-rr' => 'ដំណើរការ​ស្គ្រីប​ម្ដងទៀត ដោយ​គ្មាន "$1" ដើម្បី​បន្ទាន់សម័យ​ទេ​។',
	'maintenance-re-ce' => 'កំណែប្រែ​បច្ចុប្បន្ន: $1',
	'maintenance-re-de' => 'កំណែប្រែ​ដែល​បាន​លុប: $1',
);

/** Kannada (ಕನ್ನಡ)
 * @author Nayvik
 */
$messages['kn'] = array(
	'maintenance-memc-total' => 'ಒಟ್ಟು:',
);

/** Korean (한국어)
 * @author Ficell
 * @author Kwj2772
 * @author 아라
 */
$messages['ko'] = array(
	'maintenance-generic-username' => '사용자 이름',
	'maintenance-option-confirm' => '확인',
);

/** Colognian (Ripoarisch)
 * @author Purodha
 */
$messages['ksh'] = array(
	'maintenance' => 'Waadongsprojramme loufe lohße',
	'maintenance-desc' => '[[Special:Maintenance|Web Engerfäjß]] för divärse Waadongsprojramme',
	'right-maintenance' => 'E Waadongsprojramm övver <i lang="en">[[Special:Maintenance]]</i> loufe ze lohße',
	'maintenance-backlink' => 'Zoröck zom Projramm-Wähle',
	'maintenance-header' => 'Donn hee e Projramm ußsööke wat De loufe lohße wells.
Näve dä Projramme es koot jesaat, wat se donn.',
	'maintenance-error-badini' => 'Di Dattei <code lang="en">metadata.ini</code> es kappott udder nit ze fenge.
Donn dat Zohsatzprojramm <code lang="en">Maintenance</code> norr_ens neu eronger laade.',
	'maintenance-error-invalidtype' => 'Dat aanjejovve Skrep hammer nit jefonge.',
	'maintenance-error-badargs' => 'Do häs nit all de nüüdeje Aanjabe jemaat.',
	'maintenance-generic-done' => 'jedonn',
	'maintenance-generic-username' => 'Metmaacher_Name',
	'maintenance-generic-password' => 'Paßwoot',
	'maintenance-generic-reason' => 'Jrond',
	'maintenance-cleanupTable-dry-run' => 'Bloß för ußzeprobeere',
	'maintenance-cleanupTable-check' => 'Ben op verkehte Sigge_Name aam prööfe …',
	'maintenance-cleanupTable-checkfix' => 'Ben op kappodde Siggee_Tittelle aam pröfe un di aam repareere&nbsp;…',
	'maintenance-cleanupTable-progress' => '$1 $2: $3% op $4 jedonn; bruch wall noch $5 [$6 vun $7] $8 pro Sekund <$9% sin ald aanjepaß>',
	'maintenance-cleanupTable-missingparam' => '$1: Dä Parrammeeter $2 fählt',
	'maintenance-cleanupTable-processing' => 'Ben $1 aam beärbeide&nbsp;…',
	'maintenance-cleanupTable-finished' => 'Fäädesch met $1. Han {{PLURAL:$2|eine|$2|keine}} vun {{PLURAL:$3|einem Daatesaz|$3 Daatesäz|kein Daatesäz}} beärbeidt.',
	'maintenance-option-quiet' => 'Donn de Ußjaabe ußer Fählermädonge ongerdröcke.',
	'maintenance-option-globals' => 'Donn aam Engk zom Prööfe de jlobaale Varijaable ußjävve.',
	'maintenance-option-confirm' => 'Bestätije',
	'maintenance-option-batch-size' => 'Donn esu vill Aufjabe en einem Rötsch äleedijje — der Standatt es: $1',
	'maintenance-option-required' => '(nüüdesch)',
	'maintenance-option-optional' => '(kann fott blieve)',
	'maintenance-output-success' => '„$1“ es joot jeloufe!',
	'maintenance-output-failure' => '„$1“ es donävve jejange.',
	'maintenance-attachLatest' => 'Donn met heh dämm Fommulaa de Endrääsch repareere, woh en de Sigge-Tabäll (<code lang="en">page</code>) et Feld <code lang="en">page_latest</code> op 0 jesaz es.',
	'maintenance-attachLatest-desc' => 'Endrääsch <code lang="en">page_latest</code> en dä Sigge-Tabäll repareere',
	'maintenance-attachLatest-option-fix' => 'Donn de Endrääsch verhaftesch repareere. Söns maach ene Louf zom Prööfe, der ohne jät ze verändere.',
	'maintenance-attachLatest-output-begin' => 'Ben noh Sigge aam söhke, wo <code lang="en">page_latest</code> op 0 jesads_es&nbsp;…',
	'maintenance-attachLatest-output-notime' => '$1 $2 [[$3]] kann der neuste Version ier Zick vum Afshpeishere nit fenge?!',
	'maintenance-attachLatest-output-norev' => '$1 $2 [[$3]] ier läzde Zick es $4, kann de Nommer vun dä Version nit fenge.',
	'maintenance-attachLatest-output-found' => '$1 $2 [[$3]] ier läzde Zick es $4, kann de Nommer vun dä Version es $5',
	'maintenance-attachLatest-output-done' => 'Fäädesch. Mer han {{PLURAL:$1|ein Sigg|$1 Sigge|kein Sigg}} beärbeidt.',
	'maintenance-attachLatest-output-dryrun' => 'Dat wohr ene Louf zom Prööfe. Maach dat norr_ens met ene Höhksche bei „{{int:maintenance-attachLatest-option-fix}}“, öm de Enndrääsch en <span class="plainlinks">page_latest</span> ze repareere.',
	'maintenance-benchmarkPurge' => 'Övver dat Fommulaa heh kam_mer eruß fenge, wi lang em <i lang="en">Squid</i> sing läddesch Maache un Oprühme duuert.',
	'maintenance-benchmarkPurge-desc' => 'Dem <i lang="en">Squid</i> sing läddesch Maache un Oprühme dorschprobeere.',
	'maintenance-benchmarkPurge-option-count' => 'Wie vill <i lang="en">URLs</i> sulle däm <i lang="en">Squid</i> zom läddesch Maache un Oprühme jejovve wääde?',
	'maintenance-benchmarkPurge-error-nosquid' => 'Der <i lang="en">Squid</i> ußzeprobeere deiht nit vill, sulang der <i lang="en">Squid</i> nit aanjeschaldt es.',
	'maintenance-benchmarkPurge-output-numsquids' => '{{PLURAL:$1|Eine|$1|Keine}} <i lang="en">Squid</i>-ẞööver {{PLURAL:$1|es|sin|es}} faßjelaat woode:',
	'maintenance-benchmarkPurge-output-trial' => '$1 Sigge ier Titelle en {{PLURAL:$2|ein Millisekund|$2 Millisekunde|nit ens en Millisekund}}, dat {{PLURAL:$3|es ein Millisekond|sinn_er $3 Millisekonde|es keine Millisekond}} pro Ttitel.',
	'maintenance-changePassword' => 'Ennem Medmaacher sing Passwoot övver e Formular änndere',
	'maintenance-changePassword-desc' => 'Ennem Metmaacher sing Paßwoot ändere',
	'maintenance-changePassword-error-nouser' => 'Mer han keine Metmaacher, dä „$1“ heiße däät.',
	'maintenance-changePassword-output-set' => 'Et Paßwoot för {{GENDER:$1|dä|et|dä Metmaacher|de|dat}} $1 es faßjelaat.',
	'maintenance-checkAutoLoader' => 'Met däm Fomulaa heh määt mer e paa Pröfunge, dat Projramm vum Selfs_Laader vernömftesch läuf.',
	'maintenance-checkAutoLoader-desc' => 'Pröfunge vum Selfs_Laader',
	'maintenance-checkAutoLoader-output-list2' => '$1: verkeehte Dattei: en $2 jefonge, es ävver opjeföhrd en $3',
	'maintenance-checkBadRedirects' => 'Met dämm Fommulaa kam_mer Sigge pröve, di als Ömleidonge en de Daatebangk shtonn, of di verhaftesch Ömleidonge sin.',
	'maintenance-checkBadRedirects-desc' => 'Noh kapodde Ömleidonge söhke',
	'maintenance-checkBadRedirects-output-header' => 'Ben Ömleidonge aam Laade&nbsp;……',
	'maintenance-checkBadRedirects-output-found' => 'Ensjesamp ham_mer {{PLURAL:$1|ein Ömleidung|$1 Ömleidunge|kein Ömleidung}} jefonge.
Ben noh kappodde Ömleidonge aam looere&nbsp;…',
	'maintenance-checkBadRedirects-output-footer' => '
Jedonn.',
	'maintenance-checkImages' => 'Met dämm Fommulaa heh kam_mer prööve, wat för en Belder em Wiki kapott sin.',
	'maintenance-checkImages-desc' => 'Donn Belder prööve, dat se doh sen, dat mer se lässe kann, un esu wigger.',
	'maintenance-checkImages-output-noaccess' => '$1: doh kammer om ẞööver nit drop zohjriefe',
	'maintenance-checkImages-output-missing' => '$1: es nit doh.',
	'maintenance-checkImages-output-isdir' => '$1: dat ess_e Verzeishneß.',
	'maintenance-checkImages-output-truncated' => '$1: es ze koot, un wohr ens $2.',
	'maintenance-checkImages-output-mismatch' => '$1: doh shtemmp der Ömfang nit, en dä Daatebangk shteiht $2, et sinn_er ävver $3',
	'maintenance-checkImages-output-good' => '{{PLURAL:$1|Ein Beld|$1 Belder|Kei Beld}} {{PLURAL:$2|vun ensjesamp einem Beld|vun ensjesamp $2|es em Wiki un dat}} {{PLURAL:$1|es en Oodenong|sin en Oodenong|es en Oodenong}}.',
	'maintenance-checkSyntax' => 'Met heh dämm Fommulaa kam_mer de Süntax vun alle <i lang="en">PHP</i>-Datteije em MediaWiki övverprööfe.',
	'maintenance-checkSyntax-desc' => 'De Süntax vun alle <i lang="en">PHP</i>-Datteije em MediaWiki prööfe.',
	'maintenance-checkSyntax-option-with-extensions' => 'Donn och de Datteije em Verzeishneß „…<code lang="en">/extensions</code>“ prööfe',
	'maintenance-checkSyntax-option-path' => 'Jiv ene beshtemmpte Pahd för en Dattei udder e Verzeishneß aan, för zom Prööfe, entweder med enem absoluute Pahd udder enem relative Pahd vum Aanfangsverzeishneß vun heh dä Enshtallzjuhn vum MedijaWiki uß.',
	'maintenance-checkSyntax-option-list-file' => 'Leß met de Datteije udder Verzeishneße zom Pröfe',
	'maintenance-checkSyntax-option-modified' => 'Donn bloß di Datteije prööfe, di verändert woodte (Doför bruche mer et Kommando <code lang="en">svn</code>)',
	'maintenance-checkSyntax-option-syntax-only' => 'Donn blooß de Süntax ier Jölteschkeit prööfe, un donn de Warnonge wääje em Shtiil un der Schriifwiiß fott lohße.',
	'maintenance-checkSyntax-output-parsekit' => 'Ben de Süntax met dem <code class="plainlinks">parsekit</code> aam prööfe&nbsp;…',
	'maintenance-checkSyntax-output-phpl' => 'Ben de Süntax met „<code lang="en">php -l</code>“ aam övverprööfe, wadd en janze Zick dooere kann.',
	'maintenance-checkSyntax-output-footer' => 'Fäädesch! {{PLURAL:$1|Ein Dattei|$1 Datteije|Kein Dattei}} dorschjelässe, {{PLURAL:$2|eine Fähler|$2 Fähler|keine Fähler}} un {{PLURAL:$3|ein Warnong|$3 Warnonge|keine Warnong}} jefonge.',
	'maintenance-checkSyntax-output-svnlist' => 'Ben di Leß uss_em <i lang="en">Subversion</i> aam holle&nbsp;…',
	'maintenance-checkSyntax-output-buildlist' => 'Ben en Leß met Datteije aam opboue&nbsp;…',
	'maintenance-checkSyntax-output-error' => 'Ene Fähler es en dä Dattei $1 en dä Reih $2 opjefalle: $3',
	'maintenance-checkSyntax-output-warning' => 'Opjepaß: En dä Dattei $1 ham_mer $2 jefonge.',
	'maintenance-checkSyntax-error-nofile' => 'Ene Fähler es opjetrodde: mer kunnte di Dattei udder et Verzeishneß $1 nit fenge.',
	'maintenance-checkSyntax-error-cantopen' => 'Mer kunnte di Dattei $1 nit opmache.',
	'maintenance-checkSyntax-error-svnerr' => 'Ene Fähler es opjetrodde beim Versohch, di Leß vum <i lang="en">Subversion</i> ze holle.',
	'maintenance-checkUsernames' => 'Heh dat Fommulaa deiht all de Name vun Metmaachere aanzeije, di nit mieh jöltesch sin, nohdämm aan Enshtällunge vum Wiki jät verändert woodt. Wann nix jezeish weed, nohdämm dat Projramm jeloufe es, sin all de Metmaacher ier Naame em Wiki akeraat en Oodenong.',
	'maintenance-checkUsernames-desc' => 'Donn prööve, dat de Name för de Metmaacher en de Daatebangk och jöltesch sin.',
	'maintenance-checkUsernames-error-notvalid' => 'Dä Name „$3“ för ene Metmaacher met dä Kännommer $2 es nit jöltesch.',
	'maintenance-cleanupCaps' => 'Met dämm Fommulaa heh kam_mer de Tittelle vun Sigge repaerere, op di mer nit mieh zohjriife kann, nohämm <span class="plainlinks">$wgCapitalLinks</span> verändert woode es.',
	'maintenance-cleanupCaps-desc' => 'Skrep för verkeht jrußjeschrevve Sigge ier Tittelle ze repareere',
	'maintenance-cleanupCaps-option-namespace' => 'De Nommer vum Appachtemang, woh mer de Fähler jrußjeschrevve Sigge_Titelle söhke un oprühme welle',
	'maintenance-cleanupCaps-output-islower' => '„$1“ es ald klein jeschrevve.',
	'maintenance-cleanupCaps-output-clash' => 'Han „$1“ övverjange, nohsämm et „$2“ ald johv.',
	'maintenance-cleanupCaps-output-dryrun' => '„$1“ → „$2“: Prööflouf nix wood ömjedäuf.',
	'maintenance-cleanupCaps-error-noneed' => '<span class="plainlinks">$wgCapitalLinks </span> es aanjeschalldt, dröm bruch mer kein jruußjeschrevve Lengks oprühme.',
	'maintenance-cleanupSpam' => 'Met heh däm Fommolaa kam_mer SPAM wider loßwääde, dä op ander Webßaits lengke deiht.',
	'maintenance-cleanupSpam-desc' => 'Donn alle SPAm Fottschmiiße, dä op enen beschtemmpte Räschner zeisch.',
	'maintenance-cleanupSpam-option-hostname' => 'Da Naame vun däm Rääschner, vun woh dä SPAM hehr kohm',
	'maintenance-cleanupSpam-output-found' => 'Mer han {{PLURAL:$1|eine Atikel|$1 Atikelle|kein Atikelle}} jefonge met „$2“ dren.',
	'maintenance-cleanupSpam-output-false' => 'Jetroffe, wohr ävver verkiehrt.',
	'maintenance-cleanupSpam-output-blanking' => 'läddesch maache',
	'maintenance-cleanupSpam-output-reverting' => 'retuur ändere',
	'maintenance-cleanupSpam-error-invalid' => 'Kein jölteje Aanjaabe för enem Rääschner singe Naame: „$1“',
	'maintenance-cleanupSpam-error-noid' => 'Fähler em Wiki: Kein Sigg met dä Kännong $1 jefonge.',
	'maintenance-clearInterwikiCache' => 'Met heh däm Fommulaa kanns_De der Engerwiki-Zwescheschpeischer kumplätt läddesch maache.',
	'maintenance-clearInterwikiCache-desc' => 'SChmiiß all Engerwiki-Lengks uss_em wescheschpeischer fott.',
	'maintenance-createAndPromote' => 'Met dämm Fommulaa hee kanns De ene neue Metmaacher aanläje un och tiräk
ene {{int:group-sysop-member}} odder ene {{int:group-bureaucrat-member}}
druß maache.',
	'maintenance-createAndPromote-desc' => 'Don ene Metmaacher aanlääje un zom Wiki-Köbes maache',
	'maintenance-createAndPromote-option-bureaucrat' => 'Donn dä Metmaacher zom Bürrokraat opshtoofe.',
	'maintenance-createAndPromote-output-creating' => 'Aanlääje un zom Wiki_Kööbes maache: {{ns:user}}:$2&nbsp;&hellip;',
	'maintenance-createAndPromote-error-password' => 'Ene Fähler wohr opjetrodde met däm Paßwoot, wat De enjejovve häs: „$1“',
	'maintenance-deleteBatch' => 'Met hee dämm Fommulaa kanns De Sigge ang-maß fott schmiiße.
Jif nur eine Sigge-Tittel en jede Reih en.',
	'maintenance-deleteBatch-desc' => 'Massehaff Sigge fottschmiiße',
	'maintenance-deleteRevision' => 'Met hee dämm Fommulaa kanns De Versione ang-maß fott schmiiße.
Jif nur eine Versionsnummer en jede Reih en.',
	'maintenance-deleteRevision-desc' => 'Sigge-Versione uß de Datebank schmiiße',
	'maintenance-initEditCount-desc' => 'Ennem Metmaacher sing Aanzahl Sigge-Änderonge neu ußzälle',
	'maintenance-initSiteStats' => 'Met hee dämm Fommulaa kanns De Shtatistike för Sigge neu ußräschne.
Do kanns extra aanjevve, of De de Sigge-Afroofe och neu jezallt han wells.',
	'maintenance-initSiteStats-desc' => 'De Sigge ier Statistike neu ußzälle',
	'maintenance-moveBatch' => 'Met hee dämm Fommulaa kanns De maßisch Sigge ömnenne.
En jede Reih sullt ene ahle u nene neue Siggetittel hengereneejn shtonn,
met enem senkrääschte Shtresh dozwesche, allsu däm „|“',
	'maintenance-moveBatch-desc' => 'Messehaff Sigge ömnänne',
	'maintenance-reassignEdits-desc' => 'Änderunge aam Wiki vun einem Metmaacher enem andere Metmaacher zohschrihve',
	'maintenance-runJobs-desc' => 'Aufjaabe uß de Leß aanshtüße, dat se jetz jedonn wääde',
	'maintenance-runJobs-option-maxjobs' => 'De hühsde Aanzahl Aufjabe för afzeärbeide',
	'maintenance-runJobs-option-type' => 'De Zoot Aufjabe för ze beärbeide',
	'maintenance-runJobs-option-procs' => 'De Aanzahl Vörjäng för de Aufjabe',
	'maintenance-runJobs-option-exclusive' => 'Donn dat Skrep <code lang="en">runJobs</code> nur eijmohl einzel ußföhre. De Zick doför es 1800 Sekonde.',
	'maintenance-runJobs-error-invalidprocs' => 'Do moß en Zahl zwesche 1 un 1000 Vörjäng aanjävve.',
	'maintenance-showJobs-desc' => 'De Leß met de Aufjabe aanzeije',
	'maintenance-showJobs-option-group' => 'Donn de Aanzahl Aufjabe vun jeede Zoot aanzeije',
	'maintenance-sql' => 'Met hee dämm Fommulaa kanns De ene SQL-Befäähl aan de Datebangk schecke.',
	'maintenance-sql-desc' => 'De <i lang="en">SQL</i> Datebangk befroore',
	'maintenance-sql-option-file' => 'Dat <i lang="en">SQL</i>-Projramm zom Ußföhre',
	'maintenance-sql-output-aff' => 'Dat hät jeflup, {{PLURAL:$1|ein Reih wood|$1 Reije woode|kein Reih wood}} beärbeidt.',
	'maintenance-sql-error-cantopen' => 'Mer künne di Dattei för zom Lässe nit opmaache.',
	'maintenance-showCacheStats-desc' => 'Zeich de Statistike vom <tt>Memcached</tt>',
	'maintenance-eval' => 'Dat Fommulaa hee kanns De bruche, öm e PHP-Projrammshtöck enjebett en dem MediaWiki sing Ömjävung ußzeprobeere.',
	'maintenance-eval-desc' => 'E PHP-Projrammshtöck en de MediaWiki Ömjävung ußprobeere',
	'maintenance-update' => 'Met Höksche: bruch <span style="text-transform:uppercase">update</span> wann de Tabäll jänndert wede soll. Ohne Höksche: nemm <span style="text-transform:uppercase">delete</span> odder <span style="text-transform:uppercase">insert</span> doför.',
	'maintenance-noviews' => 'Maach hee e Hööksche, öm de Aanzahl affjeroofe Sigge nit aanzepacke',
	'maintenance-invalidname' => 'Der Metmaacher kenne mer nit!',
	'maintenance-userexists' => 'Dä Metmaacher jidd_et ald!',
	'maintenance-invalidtitle' => 'Onjöltije Sigge-Tittel: „$1“!',
	'maintenance-titlenoexist' => 'Dä aanjejovve Tittel „$1“ jidd_et nit!',
	'maintenance-failed' => '<span style="text-transform:uppercase">donevve jejange</span>',
	'maintenance-deleted' => '<span style="text-transform:uppercase">fottjeschmesse</span>',
	'maintenance-revdelete' => 'Ben dabei, {{PLURAL:$3|de Version|de Versione|kein Version}} $1 vum Wiki $2 fottzeschmiiße.',
	'maintenance-revnotfound' => 'En Version $1 hammer nit jefonge!',
	'maintenance-showCacheStats-edits' => 'Aanzahl Sigge-Änderonge: $1',
	'maintenance-showCacheStats-articles' => 'Aanzahl Sigge em Appachtemang met de Atikele: $1',
	'maintenance-showCacheStats-pages' => 'Aanzahl Sigge: $1',
	'maintenance-showCacheStats-users' => 'Aanzahl Metmaacher: $1',
	'maintenance-showCacheStats-admins' => 'Aanzahl Wiki-Köbesse: $1',
	'maintenance-showCacheStats-images' => 'Aanzahl Dateie: $1',
	'maintenance-showCacheStats-views' => 'Aanzahl Sigge-Afroofe: $1',
	'maintenance-showCacheStats-update' => 'Ben de Datebank am ändere&nbsp;…',
	'maintenance-move' => 'Ben „$1“ op „$2“ aam Ömenne&nbsp;…',
	'maintenance-movefail' => 'Ene Fähler es paßeet beim ömnänne vun dä Sigk: „$1“
Dat Ömnenne weed jeshtopp.',
	'maintenance-error' => 'Fähler: $1',
	'maintenance-memc-fake' => 'Ühr hat der <code>FakeMemCachedClient</code> am Loufe. Do jidd_et kein Statistike för.',
	'maintenance-memc-requests' => 'Aanfrore',
	'maintenance-memc-withsession' => 'Met en Setzung:',
	'maintenance-memc-withoutsession' => 'Oohne en Setzung:',
	'maintenance-memc-total' => 'Zosamme:',
	'maintenance-memc-parsercache' => 'Däm Paaser singe Zwescheshpeisher',
	'maintenance-memc-hits' => 'Treffer:',
	'maintenance-memc-invalid' => 'onjöltesch:',
	'maintenance-memc-expired' => 'afjeloufe:',
	'maintenance-memc-absent' => 'nit do:',
	'maintenance-memc-stub' => 'Jrenz för Shtümpschens-Sigge:',
	'maintenance-memc-imagecache' => 'Dä Zwescheshpeisher för de Bellder',
	'maintenance-memc-misses' => 'Nit jetroffe:',
	'maintenance-memc-updates' => 'Änderonge:',
	'maintenance-memc-uncacheable' => 'kam_mer nit zewscheshpeishere:',
	'maintenance-memc-diffcache' => 'Zweschespeicher för de Ungerscheide',
	'maintenance-reassignEdits' => 'Di Sigk hee kanns De bruche, öm de Änderunge vun einem Metmaacher enem andere zozeschrieve.',
	'maintenance-re-from' => 'Däm Metmaacher singe Name, däm sing Änderunge enem andere zojeschrevve wäde sulle',
	'maintenance-re-to' => 'Däm Metmaacher, däm de Änderunge zojeschrevve wäde sulle, singe Name',
	'maintenance-re-force' => 'Neu zodeijle, selfs wann et dä neue Metmacher jaa nit jit',
	'maintenance-re-rc' => 'Donn de „{{int:recentchanges}}“ en de Datebangk nit ändere',
	'maintenance-re-report' => 'Änderonge zeije, ävver nit maache',
	'maintenance-re-nf' => 'Metmaacher $1 nit jefonge',
	'maintenance-re-rr' => 'Lohß dat norr_ens loufe oohne „$1“ öm de Änderonge och ze maache.',
	'maintenance-re-ce' => 'Aktoälle Aanzahl Änderunge: $1',
	'maintenance-re-de' => 'Aanzahl fottjeschmeße Änderunge: $1',
	'maintenance-re-rce' => 'Enndrääsch en de Neuste Änderunge: $1',
	'maintenance-re-total' => 'Aanzahl Endräch zom Ändere: $1',
	'maintenance-re-re' => "Änderunge neu zo'oodene … jedonn",
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Les Meloures
 * @author Purodha
 * @author Robby
 */
$messages['lb'] = array(
	'maintenance' => 'Maintenance-Skripten ausféieren',
	'maintenance-desc' => '[[Special:Maintenance|Web interface]] fir verschidde Maintenance-Skripten',
	'right-maintenance' => 'Ënnerhalts-Skripten op [[Special:Maintenance]] starten',
	'maintenance-backlink' => "Zréck op d'Auswiel vum Script",
	'maintenance-header' => "Sicht w.e.g. ënnendrëmmer e Script eraus fir auszeféieren.
D'Beschreiwunge stinn niewent all Script.",
	'maintenance-error-badini' => "De Fichier metada.ini ass entweder korrupt oder e feelt. Lued w.e.g. d''Maintenance'-Erweiderung nach eng Kéier erof",
	'maintenance-error-invalidtype' => 'De Skript den ugi gouf, gouf net fonnt',
	'maintenance-error-badargs' => 'Dir hutt net all déi obligatoresch Optiounen uginn',
	'maintenance-generic-done' => 'fäerdeg',
	'maintenance-generic-username' => 'Benotzernumm',
	'maintenance-generic-password' => 'Passwuert',
	'maintenance-generic-reason' => 'Grond',
	'maintenance-cleanupTable-dry-run' => 'Een Testlaf maachen',
	'maintenance-cleanupTable-check' => 'No falschen Titele sichen...',
	'maintenance-cleanupTable-checkfix' => 'No falschen Titele sichen an se flécken ...',
	'maintenance-cleanupTable-progress' => '$1 $2: $3% fäerdeg den $4; ETA $5 [$6/$7] $8/sec <$9% aktualiséiert>',
	'maintenance-cleanupTable-missingparam' => '$1: De Parameter $2 feelt',
	'maintenance-cleanupTable-processing' => '$1 gëtt verschafft...',
	'maintenance-cleanupTable-finished' => '$1 Fäerdeg... $2 vun $3 {{PLURAL:$3|Zeil|Zeile}} goufen aktualiséiert',
	'maintenance-option-confirm' => 'Confirméieren',
	'maintenance-option-required' => '(obligatoresch)',
	'maintenance-option-optional' => '(optional)',
	'maintenance-output-success' => '$1 ass gemaach ginn!',
	'maintenance-output-failure' => '$1 huet net richteg fonctionnéiert!',
	'maintenance-attachLatest-output-begin' => 'No Säite sichen an deene page_latest op 0 steet...',
	'maintenance-attachLatest-output-notime' => '$1 $2 [[$3]] kann den neiste Versiounszäitpunkt net fannen?!',
	'maintenance-attachLatest-output-done' => 'Fäerdeg! $1 {{PLURAL:$1|Säit|Säite}} goufe behandelt.',
	'maintenance-benchmarkPurge-output-trial' => '$1 {{PLURAL:$1|Titel|Titelen}} a(n) $2ms ($3ms an der Moyenne)',
	'maintenance-changePassword' => "Dëse Formulaire benotze fir engem Benotzer säi Passwuert z'änneren",
	'maintenance-changePassword-desc' => 'Engem Benotzer säi Passwuert änneren',
	'maintenance-changePassword-error-nouser' => 'Et gëtt kee Benotzer: $1',
	'maintenance-changePassword-output-set' => 'Passwuert festgeluecht fir $1',
	'maintenance-checkAutoLoader-output-list2' => '$1: Falsche Fichier: op $2 fonnt, opgefouert an $3',
	'maintenance-checkBadRedirects' => 'Benotzt dëse Formulaire fir nozekucken ob Säiten déi als Viruleedunge markéiert sinn och wierklech Viruleedunge sinn',
	'maintenance-checkBadRedirects-desc' => 'No falsche Viruleedunge sichen',
	'maintenance-checkBadRedirects-output-header' => 'Viruleedunge lueden...',
	'maintenance-checkBadRedirects-output-found' => 'Am Ganze {{PLURAL:$1|gouf eng Viruleedung|goufe(n) $1 Viruleedunge}} fonnt.
No Falsche Viruleedunge sichen...',
	'maintenance-checkBadRedirects-output-footer' => 'Fäerdeg.',
	'maintenance-checkImages' => 'Benotzt dëse Formulaire fir erauszefanne wat fir eng Biller ob Ärer Wiki korrupt sinn',
	'maintenance-checkImages-desc' => 'Biller nokucken fir ze gesinn ob et se gëtt, ob se gelies kënne ginn, asw.',
	'maintenance-checkImages-output-noaccess' => '$1: ass lokal net accessibel',
	'maintenance-checkImages-output-missing' => '$1: feelt',
	'maintenance-checkImages-output-isdir' => '$1: ass e Repertoire',
	'maintenance-checkImages-output-truncated' => '$1: ofgeschnidden, et war $2',
	'maintenance-checkImages-output-good' => 'Gutt Biller: $1/$2',
	'maintenance-checkSyntax' => "Dëse Formulaire benotze fir d'Syntax vun alle PHP-Fichiere vu MediaWiki nozekucken.",
	'maintenance-checkSyntax-desc' => 'Syntax vun alle PHP-Fichieren vu MediaWiki nokucken',
	'maintenance-checkSyntax-option-list-file' => 'Lëscht vun de Fichieren oder Repertoiren déi nogekuckt musse ginn',
	'maintenance-checkSyntax-output-parsekit' => 'Syntax gëtt nogekuckt (parsekit gëtt benotzt)',
	'maintenance-checkSyntax-output-footer' => 'Fäerdeg! $1 Fichieren nogekuckt, $2 Feeler fonnt a(n) $3 Warnunge kritt',
	'maintenance-checkSyntax-output-buildlist' => "D'Lëscht vun de Fichiere gëtt opgebaut...",
	'maintenance-checkSyntax-output-error' => 'Feeler am $1, Linn $2:$3',
	'maintenance-checkSyntax-output-warning' => 'Warnung am Fichier $1: $2 fonnt',
	'maintenance-checkSyntax-error-nofile' => 'Feeler: De Fichier oder de Repertoire $1 gouf net fonnt.',
	'maintenance-checkSyntax-error-cantopen' => 'De Fichier $1 kann net opgemaach ginn',
	'maintenance-checkUsernames-desc' => "Nokucken ob d'Benotzernimm vun der Datebank valabel sinn",
	'maintenance-checkUsernames-error-notvalid' => 'Net valabele Benotzernumm: „$3“ (Benotzer ID $2)',
	'maintenance-cleanupCaps-desc' => 'Script fir Feeler mat grousse Buschtawen ze verbesseren',
	'maintenance-cleanupCaps-output-islower' => '"$1" ass scho kleng geschriwwen.',
	'maintenance-cleanupCaps-output-clash' => '"$1" iwwersprong; "$2" gëtt et schonn',
	'maintenance-cleanupSpam' => 'Benotzt dëse Formulaire fir Spam-Ännerungen zréckzesetzen déi op extern Site linken',
	'maintenance-cleanupSpam-output-blanking' => 'eidelmaachen',
	'maintenance-cleanupSpam-output-reverting' => 'zerécksetzen',
	'maintenance-cleanupSpam-error-noid' => 'Interne Feeler: keng Säit fir ID $1',
	'maintenance-createAndPromote' => "Dëse Formulaire benotze fir en neie Benotzer unzeleeën a fir him Adminstrateur's-Rechter ze ginn.
Klickt d'Bürokrate-Këscht u wann Dir wëllt datt en och Bürokrat gi soll.",
	'maintenance-createAndPromote-desc' => 'E Benotzerkont opmaachen an deem de Statut vun engem Administrateur ginn',
	'maintenance-createAndPromote-option-bureaucrat' => 'Dem Benotzer de Statut vu Bürokrat ginn',
	'maintenance-createAndPromote-error-password' => 'Et gouf e Feeler mam Passwuert dat Dir aginn hutt: $1',
	'maintenance-deleteBatch' => 'Dëse Formulaire benotze fir eng Rei vu Säiten ze läschen.
Nëmmen eng Säit pro Linn aginn.',
	'maintenance-deleteBatch-desc' => 'Vill Säite matenee läschen',
	'maintenance-deleteRevision' => 'Benotzt dëse Formulaire fir vill Versioune mateneen ze läschen.
Schreiwt an all Linn just eng Versioun.',
	'maintenance-deleteRevision-desc' => 'Versiounen aus der Datebank eraushuelen',
	'maintenance-initEditCount-desc' => "D'Compteuren vun den Ännerunge vun de Benotzer nei berechnen",
	'maintenance-initSiteStats' => "Benotzt dëse Formulaire fir d'Statistike vum Site nei ze berechnen, gitt w.e.g. unn ob Dir d'Zuel vun de Säiten-Ufroen och wëllt nei berechent hunn",
	'maintenance-initSiteStats-desc' => "D'Statistike vum Site neiberechnen",
	'maintenance-moveBatch' => "Benotzt dëse Formulaire fir eng Grous Zuel vu Säiten ze réckelen.
An all Linn soll en Quellsäit an eng Zilsäit, getrennt duerch een ''<nowiki>|</nowiki>'', drastoen.",
	'maintenance-moveBatch-desc' => 'Vill Säite matenee réckelen',
	'maintenance-reassignEdits-desc' => 'Ännerunge vun engem Benotzer engem aneren zouweisen',
	'maintenance-runJobs-desc' => 'Aarbechten an der Queue vun den Aarbechte starten',
	'maintenance-runJobs-error-invalidprocs' => 'Dir musst zwëschen 1 an 1000 Prozesser uginn',
	'maintenance-showJobs-desc' => "Weis d'Lësccht vun den Aarbechten déi nach an der ''Queue'' stinn",
	'maintenance-sql' => 'Dëse Formaulaire benotze fir eng SQL-Ufro an der Datebank ze maachen.',
	'maintenance-sql-desc' => 'Eng SQL-Ufro ausféieren',
	'maintenance-sql-option-file' => 'SQL-Ufro déi ausgeféiert gi soll',
	'maintenance-showCacheStats-desc' => 'Statistiken vun der Cache Memoire weisen',
	'maintenance-eval' => 'Benotzt dëse Formulaire fir PHP-Code am MediaWiki-Kontext ze bewerten',
	'maintenance-eval-desc' => 'PHP-Code am MediaWiki-Kontext bewerten',
	'maintenance-update' => "UPDATE benotze fir eng Tabell z'aktualiséieren? Wann et net ugekräizt ass gëtt DELETE/INSERT dofir benotzt.",
	'maintenance-noviews' => "Dëst nokucke fir d'Aktualisatioun vun der Zuel vun deVisite vun der Säit ze verhënneren",
	'maintenance-invalidname' => 'Ongëltege Benotzernumm!',
	'maintenance-userexists' => 'De Benotzer gëtt et schonn!',
	'maintenance-invalidtitle' => 'Ongëltegen Titel "$1"!',
	'maintenance-titlenoexist' => 'Den Titel den dir uginn hutt ("$1") gëtt et net!',
	'maintenance-failed' => 'Huet net fonctionnéiert',
	'maintenance-deleted' => 'GELÄSCHT',
	'maintenance-revdelete' => 'Läsche {{PLURAL:$3|vun der Versioun| vun de Versioune(n)}} $1 vun der Wiki $2',
	'maintenance-revnotfound' => "D'Versioun $1 gouf net fonnt!",
	'maintenance-showCacheStats-edits' => 'Zuel vun den Ännerungen: $1',
	'maintenance-showCacheStats-articles' => 'Zuel vun de Säiten am Haaptnummraum: $1',
	'maintenance-showCacheStats-pages' => 'Zuel vun de Säiten: $1',
	'maintenance-showCacheStats-users' => 'Zuel vun de Benotzer: $1',
	'maintenance-showCacheStats-admins' => 'Zuel vun den Administrateuren: $1',
	'maintenance-showCacheStats-images' => 'Zuel vun de Fichieren: $1',
	'maintenance-showCacheStats-views' => 'Zuel vun de besichte Säiten: $1',
	'maintenance-showCacheStats-update' => "D'Datebank gëtt aktualiséiert {{int:ellipsis}}",
	'maintenance-move' => '$1 gëtt op $2 geréckelt {{int:ellipsis}}',
	'maintenance-movefail' => 'Feeler beim Réckele vu(n): $1.
Réckelen ofgebrach',
	'maintenance-error' => 'Feeler: $1',
	'maintenance-memc-fake' => 'Dir benotzt FakeMemCachedClient. Et si keng Statistiken disponibel',
	'maintenance-memc-requests' => 'Ufroen',
	'maintenance-memc-withsession' => 'mat Sessioun:',
	'maintenance-memc-withoutsession' => 'ouni Sessioun:',
	'maintenance-memc-total' => 'Total:',
	'maintenance-memc-parsercache' => 'Parser-Tëschespäicher',
	'maintenance-memc-hits' => 'Klicken:',
	'maintenance-memc-invalid' => 'net valabel:',
	'maintenance-memc-expired' => 'ofgelaf:',
	'maintenance-memc-absent' => 'net do:',
	'maintenance-memc-stub' => 'Limit fir eng Skizz:',
	'maintenance-memc-imagecache' => 'Bild Tëschespäicher (Cache)',
	'maintenance-memc-misses' => 'verluer:',
	'maintenance-memc-updates' => 'Aktualiséierungen:',
	'maintenance-memc-uncacheable' => 'kann net tëschegespäichert ginn:',
	'maintenance-memc-diffcache' => 'Diff-Tëschespäicher',
	'maintenance-reassignEdits' => 'Benotzt dëse Formulaire fir Ännerunge vun engem Benotzer engem aneren zouzeweisen.',
	'maintenance-re-from' => "Numm vum Benotzer deem d'Ännerunge ewechgeholl solle ginn",
	'maintenance-re-to' => 'Numm vum Benotzer deem dës Ännerungen zougewise solle ginn',
	'maintenance-re-force' => 'Och dann nees zouweise wann et den Zilbenotzer net gëtt',
	'maintenance-re-rc' => 'Tabell vun de rezenten Ännerungen net aktualiséieren',
	'maintenance-re-report' => 'Detailer weisen vun deem wat geännert géif  ginn, awer et net aktualiséieren.',
	'maintenance-re-nf' => 'De Benotzer $1 gouf net fonnt',
	'maintenance-re-rr' => 'De Skript nachemol lafe lossen ouni "$1" z\'aktualiséieren',
	'maintenance-re-ce' => 'Aktuell Ännerungen: $1',
	'maintenance-re-de' => 'Geläschten Ännerungen: $1',
	'maintenance-re-rce' => 'Zuel vun de rezenten Ännerungen: $1',
	'maintenance-re-total' => "Total vun den Ännerunge déi z'ännere sinn: $1",
	'maintenance-re-re' => 'Reassignéiere vun Ännerungen{{int:ellipsis}} ass gemaach',
);

/** Lingua Franca Nova (Lingua Franca Nova)
 * @author Malafaya
 */
$messages['lfn'] = array(
	'maintenance-showCacheStats-edits' => 'Numero de cambias: $1',
);

/** Lithuanian (lietuvių)
 * @author Eitvys200
 */
$messages['lt'] = array(
	'maintenance-generic-done' => 'atlikta',
	'maintenance-generic-username' => 'Vartotojo vardas',
	'maintenance-generic-password' => 'Slaptažodis',
	'maintenance-generic-reason' => 'Priežastis',
	'maintenance-option-confirm' => 'Patvirtinti',
	'maintenance-option-required' => '(privaloma)',
	'maintenance-option-optional' => '(nebūtinas)',
	'maintenance-checkBadRedirects-output-footer' => '
Atlikta.',
	'maintenance-invalidname' => 'Negalimas vartotojo vardas!',
	'maintenance-userexists' => 'Vartotojas jau egzistuoja!',
	'maintenance-failed' => 'NEPAVYKO',
	'maintenance-deleted' => 'IŠTRINTA',
	'maintenance-error' => 'Klaida: $1',
	'maintenance-memc-requests' => 'Prašymai',
	'maintenance-memc-total' => 'iš viso:',
	'maintenance-memc-invalid' => 'netinkamas:',
	'maintenance-memc-expired' => 'baigiasi:',
);

/** Macedonian (македонски)
 * @author Bjankuloski06
 * @author Brest
 */
$messages['mk'] = array(
	'maintenance' => 'Пушти скрипти за одржување',
	'maintenance-desc' => '[[Special:Maintenance|Вики-посредник]] за разни скрипти за одржување',
	'right-maintenance' => 'Пуштање на скрипти за одржување преку [[Special:Maintenance]]',
	'maintenance-backlink' => 'Назад кон изборот на скрипта',
	'maintenance-header' => 'Одберете скрипта подолу за извршување.
До секоја скрипта стои нејзин опис',
	'maintenance-error-badini' => 'Податотеката metadata.ini е оштетена или недостасува. Преземете го додатокот Maintenance повторно',
	'maintenance-error-invalidtype' => 'Не ја најдов наведената скрипта',
	'maintenance-error-badargs' => 'Не ги наведовте сите потребни можности',
	'maintenance-generic-done' => 'готово',
	'maintenance-generic-username' => 'Корисничко име',
	'maintenance-generic-password' => 'Лозинка',
	'maintenance-generic-reason' => 'Причина',
	'maintenance-cleanupTable-dry-run' => 'Пушти на суво',
	'maintenance-cleanupTable-check' => 'Проверувам неправилни наслови...',
	'maintenance-cleanupTable-checkfix' => 'Проверувам и поправам погрешни наслови...',
	'maintenance-cleanupTable-progress' => '$1 $2: $3% завршено на $4; преостанува $5 [$6/$7] $8/сек <$9% подновено>',
	'maintenance-cleanupTable-missingparam' => '$1: Недостасува параметарот $2',
	'maintenance-cleanupTable-processing' => 'Го обработувам $1...',
	'maintenance-cleanupTable-finished' => 'Завршив со $1... {{PLURAL:$1|подновен е $2|подновени се $2}} од вкупно $3 {{PLURAL:$1|ред|реда}}',
	'maintenance-option-quiet' => 'Притаи изводи што не се однесуваат на грешки',
	'maintenance-option-globals' => 'Дај извод на глобални на крајот од обработката за отстранување грешки',
	'maintenance-option-confirm' => 'Потврди',
	'maintenance-option-batch-size' => 'Пушти волку операции по пакет. По основно: $1',
	'maintenance-option-required' => '(задолжително)',
	'maintenance-option-optional' => '(незадолжително)',
	'maintenance-output-success' => '$1 е успешно извршено!',
	'maintenance-output-failure' => '$1 не сработи успешно!',
	'maintenance-attachLatest' => 'Користете го овој образец за да ги поправите ставките во табелата каде page_latest е наместено на 0',
	'maintenance-attachLatest-desc' => 'Поправи ги ставките page_latest во табелата',
	'maintenance-attachLatest-option-fix' => 'Всушност поправи ги записите. Во спротивно ќе работи на суво',
	'maintenance-attachLatest-output-begin' => 'Барам страници со page_latest наместено на 0...',
	'maintenance-attachLatest-output-notime' => '$1 $2 [[$3]] не можете да го пронајдете времето на најновата ревизија?!',
	'maintenance-attachLatest-output-norev' => '$1 $2 [[$3]] време на посл. рев.: $4. Не можам да ја пронајдам назнаката на ревизијата',
	'maintenance-attachLatest-output-found' => '$1 $2 [[$3]] време на најнова верзија: $4, назнака на рев.: $5',
	'maintenance-attachLatest-output-done' => 'Готово! Обработив $1 {{PLURAL:$1|страница|страници}}.',
	'maintenance-attachLatest-output-dryrun' => 'Ова беше сработено на суво. Пуштете одново со „{{int:maintenance-attachLatest-option-fix}}“ за да го подновите page_latest.',
	'maintenance-benchmarkPurge' => 'Користете го овој образец за испробате колку време им треба да функциите за чистење на Squid',
	'maintenance-benchmarkPurge-desc' => 'Стави праг на функциите за чистење на Squid',
	'maintenance-benchmarkPurge-option-count' => 'Колку URL-адреси да му се даваат на Squid за чистење',
	'maintenance-benchmarkPurge-error-nosquid' => 'Прагот за чистење на Squid не врши работа без да Squid да го поддржува.',
	'maintenance-benchmarkPurge-output-numsquids' => 'Има $1 определени {{PLURAL:$1|опслужувач|опслужувачи}} на Squid:',
	'maintenance-benchmarkPurge-output-trial' => '$1 {{PLURAL:$1|наслов|наслови}} за $2 мс (секој по $3 мс)',
	'maintenance-changePassword' => 'Овој образец служи за менување на лозинка на корисник',
	'maintenance-changePassword-desc' => 'Измена на лозинка на корисник',
	'maintenance-changePassword-error-nouser' => 'Нема таков корисник: $1',
	'maintenance-changePassword-output-set' => 'Поставена е лозинката за $1',
	'maintenance-checkAutoLoader' => 'Користете го овој образец за да извршите извесни проверки на исправноста на АвтоВчитувачот',
	'maintenance-checkAutoLoader-desc' => 'Проверки на исправноста на АвтоВчитувачот',
	'maintenance-checkAutoLoader-output-list2' => '$1: Погрешна податотека: се наоѓа во $2, наведена во $3',
	'maintenance-checkBadRedirects' => 'Користете го овој образец за да видите дали страниците означени како пренасочувања се навистина пренасочувања',
	'maintenance-checkBadRedirects-desc' => 'Барај неправилни пренасочувања',
	'maintenance-checkBadRedirects-output-header' => 'Примам пренасочувања ...',
	'maintenance-checkBadRedirects-output-found' => 'Пронајдов $1 {{PLURAL:$1|пренасочување|пренасочувања}}.
Проверувам дали има лоши пренасочувања...',
	'maintenance-checkBadRedirects-output-footer' => 'Готово.',
	'maintenance-checkImages' => 'Послужете се со овој образец за да дознаете кои слики на вашето вики се оштетени',
	'maintenance-checkImages-desc' => 'Проверка на слики - дали постојат, дали се читливи и тн.',
	'maintenance-checkImages-output-noaccess' => '$1: не е локално достапна',
	'maintenance-checkImages-output-missing' => '$1: недостасува',
	'maintenance-checkImages-output-isdir' => '$1: е директориум',
	'maintenance-checkImages-output-truncated' => '$1: скратено, било $2',
	'maintenance-checkImages-output-mismatch' => '$1: несовпаѓање на големината DB=$2, вистинска=$3',
	'maintenance-checkImages-output-good' => 'Добри слики: $1/$2',
	'maintenance-checkSyntax' => 'Користете го овој образец за да ја проверите синтаксата на сите PHP-податотеки во МедијаВики',
	'maintenance-checkSyntax-desc' => 'Проверка на синтаксата сите PHP-податотеки во МедијаВики',
	'maintenance-checkSyntax-option-with-extensions' => 'Исто така повтори ја папката за додатоци',
	'maintenance-checkSyntax-option-path' => 'Конкретна патека (податотека или директориум) за проверка - или со апсолутна патека, или релативна на основата на оваа инсталација на МедијаВики',
	'maintenance-checkSyntax-option-list-file' => 'Список на податотеки или директориуми за проверка',
	'maintenance-checkSyntax-option-modified' => 'Проверувај ги само податотеките што се изменети (бара SVN-клиент со наредбен ред)',
	'maintenance-checkSyntax-option-syntax-only' => 'Провери ја исправноста само на синтаксата, прескокни ги предупредувањата за стил на кодот',
	'maintenance-checkSyntax-output-parsekit' => 'Ја проверувам синтаксата (користејќи прасерски прибор)',
	'maintenance-checkSyntax-output-phpl' => 'Ја проверувам синтаксата (користејќи php -l; ова може да трае долго)',
	'maintenance-checkSyntax-output-footer' => 'Готово! Проверени се $1 податотеки. Пронајдени се $2 неуспешни и $3 предупредувања',
	'maintenance-checkSyntax-output-svnlist' => 'Го преземам списокот од Subversion...',
	'maintenance-checkSyntax-output-buildlist' => 'Составувам список на податотеки...',
	'maintenance-checkSyntax-output-error' => 'Грешка во $1 - ред $2: $3',
	'maintenance-checkSyntax-output-warning' => 'Предупредување во податотеката $1: пронајдено е $2',
	'maintenance-checkSyntax-error-nofile' => 'Грешка: не можам да ја најдам податотеката или директориумот $1',
	'maintenance-checkSyntax-error-cantopen' => 'Не можам да ја отворам податотеката $1',
	'maintenance-checkSyntax-error-svnerr' => 'Грешка при преземањето на списокот на податотеки од Subversion!',
	'maintenance-checkUsernames' => 'Користете го овој образец за да проверите кои кориснички имиња се неважечки поради промени во псотавките. Ако по пуштањето на оваа скрипта не добиете ништо, тоа значи дека сите кориснички имиња се важечки',
	'maintenance-checkUsernames-desc' => 'Потврдете дека корисничките имиња во базата се всушност важечки',
	'maintenance-checkUsernames-error-notvalid' => 'Неважечко корисничко име: „$3“ (корисн. назнака: $2)',
	'maintenance-cleanupCaps' => 'Користете го овој образец за да поправите оштетени страници изменувајќи го $wgCapitalLinks',
	'maintenance-cleanupCaps-desc' => 'Скрипта за расчистување на големи букви',
	'maintenance-cleanupCaps-option-namespace' => 'Број на имен. простор кајшто треба да се исчисти големи букви',
	'maintenance-cleanupCaps-output-islower' => '„$1“ е веќе со мали букви.',
	'maintenance-cleanupCaps-output-clash' => '„$1“ е прескокнато. „$2“ веќе постои',
	'maintenance-cleanupCaps-output-dryrun' => '„$1“ -> „$2“: СРАБОТЕНО НА СУВО - НЕ Е ПРЕМЕСТЕНО',
	'maintenance-cleanupCaps-error-noneed' => '$wgCapitalLinks е вклучено -- нема потреба од чистење на врски со големи букви.',
	'maintenance-cleanupSpam' => 'Послужете се со овој образец за да отповикате уредувања со кои се вметнати надворешни спам-врски',
	'maintenance-cleanupSpam-desc' => 'Чистење на сиот спам за дадено домаќинско име',
	'maintenance-cleanupSpam-option-hostname' => 'Домаќинското име што ве спамираше',
	'maintenance-cleanupSpam-output-found' => 'Пронајдов $1 {{PLURAL:$1|статија што го содржи|статии што го содржат}} $2',
	'maintenance-cleanupSpam-output-false' => 'Погрешно совпаѓање',
	'maintenance-cleanupSpam-output-blanking' => 'целосно бришење',
	'maintenance-cleanupSpam-output-reverting' => 'отповикување',
	'maintenance-cleanupSpam-error-invalid' => 'Не претставува важечко домаќинско име: $1',
	'maintenance-cleanupSpam-error-noid' => 'Внатрешна грешка: нема страница за назнаката $1',
	'maintenance-clearInterwikiCache' => 'Послужете се со овој образец за наполно исчистите кешот во меѓувики',
	'maintenance-clearInterwikiCache-desc' => 'Чистење на сите меѓувики-врски на сите јазици од кешот',
	'maintenance-createAndPromote' => 'Овој образец служи за создавање на нов корисник и негово унапредување во администратор.
Штиклирајте го кутивчето за „бирократ“ ако сакате корисникот воедно да биде и во бирократ',
	'maintenance-createAndPromote-desc' => 'Создај корисник и унапреди го во администратор',
	'maintenance-createAndPromote-option-bureaucrat' => 'Унапреди го корисникот во бирократ',
	'maintenance-createAndPromote-output-creating' => 'Го создавам и унапредувам корисникот $2...',
	'maintenance-createAndPromote-error-password' => 'Се појави грешка во внесената лозинка: $1',
	'maintenance-deleteBatch' => 'Овој образец користи за групно бришење на слики.
Внесувајте само една страница по ред',
	'maintenance-deleteBatch-desc' => 'Групно бришење на страници',
	'maintenance-deleteRevision' => 'Овој образец служи за групно бришење на ревизии.
Внесувајте само по еден број на ревизија во секој ред',
	'maintenance-deleteRevision-desc' => 'Отстрани ревизии од базата на податоци',
	'maintenance-initEditCount-desc' => 'Одново пресметај го бројот на уредувањата на корисниците',
	'maintenance-initSiteStats' => 'Овој образец служи за одново пресметување на статистики, назначувајќи дали сакате да одновно да ги пресметате и прегледите на страниците',
	'maintenance-initSiteStats-desc' => 'Одново пресметај ги статистиките на мрежното место',
	'maintenance-moveBatch' => 'Овој образец служи за групно преместување на страници.
ВО секој ред треба да има наведено изворна страница и целна страница, одделени со знакот „|“',
	'maintenance-moveBatch-desc' => 'Групно преместување на страници',
	'maintenance-reassignEdits-desc' => 'Презадај уредувања од еден корисник на друг',
	'maintenance-runJobs-desc' => 'Пушти ги задачите во редицата на задачи',
	'maintenance-runJobs-option-maxjobs' => 'Макс. број на задачи за пуштање',
	'maintenance-runJobs-option-type' => 'Тип на задача за извршување',
	'maintenance-runJobs-option-procs' => 'Број на постапки што ќе се користат',
	'maintenance-runJobs-option-exclusive' => 'Работи една по една скрипта runJobs. Истекот е 1800 секунди.',
	'maintenance-runJobs-error-invalidprocs' => 'Мора да наведете помеѓу 1 и 1000 постапки',
	'maintenance-showJobs-desc' => 'Прикажи список на задачи во редот на чекање',
	'maintenance-showJobs-option-group' => 'Прикажи број на задачи по тип',
	'maintenance-sql' => 'Овој образец служи за вршење на SQL-барање од базата на податоци.',
	'maintenance-sql-desc' => 'Изврши SQL-барање',
	'maintenance-sql-option-file' => 'SQL за извршување',
	'maintenance-sql-output-aff' => 'Барањето е во ред. {{PLURAL:$1|Засегнат е $1 ред|Засегнати се $1 реда}}',
	'maintenance-sql-error-cantopen' => 'Не можам да ја отворам вносната податотека',
	'maintenance-showCacheStats-desc' => 'Прикажи Memcached статистики',
	'maintenance-eval' => 'Овој образец служи за проверка на PHP-код во МедијаВики околина.',
	'maintenance-eval-desc' => 'Проверка на PHP-кодот во МедијаВики околина',
	'maintenance-update' => 'Да користам UPDATE кога подновувам табела? Отшриклирајте ако сакате наместо тоа да користам DELETE/INSERT.',
	'maintenance-noviews' => 'Штиклирајте го ова за да го спречите ажурирањето на бројот на прегледи на страниците',
	'maintenance-invalidname' => 'Неважечко корисничко име!',
	'maintenance-userexists' => 'Корисникот веќе постои!',
	'maintenance-invalidtitle' => 'Неважечки наслов „$1“!',
	'maintenance-titlenoexist' => 'Назначениот наслов („$1“) не постои.',
	'maintenance-failed' => 'НЕУСПЕШНО',
	'maintenance-deleted' => 'ИЗБРИШАНО',
	'maintenance-revdelete' => 'Бришење на {{PLURAL:$3|ревизија|ревизии}} $1 од викито $2',
	'maintenance-revnotfound' => 'Ревизијата $1 не е пронајдена!',
	'maintenance-showCacheStats-edits' => 'Број на уредувања: $1',
	'maintenance-showCacheStats-articles' => 'Број на страници во главниот именски простор: $1',
	'maintenance-showCacheStats-pages' => 'Број на страници: $1',
	'maintenance-showCacheStats-users' => 'Број на корисници: $1',
	'maintenance-showCacheStats-admins' => 'Број на администратори: $1',
	'maintenance-showCacheStats-images' => 'Број на податотеки: $1',
	'maintenance-showCacheStats-views' => 'Број на прегледи на страниците: $1',
	'maintenance-showCacheStats-update' => 'Ја обновувам базата на податоци{{int:ellipsis}}',
	'maintenance-move' => 'Ја преместувам страницата $1 во $2{{int:ellipsis}}',
	'maintenance-movefail' => 'Настана грешка при преместувањето: $1.
Откажување на преместувањето',
	'maintenance-error' => 'Грешка: $1',
	'maintenance-memc-fake' => 'Работите со FakeMemCachedClient. Не може да се наведат статистики',
	'maintenance-memc-requests' => 'Барања',
	'maintenance-memc-withsession' => 'со сесија:',
	'maintenance-memc-withoutsession' => 'без сесија:',
	'maintenance-memc-total' => 'вкупно:',
	'maintenance-memc-parsercache' => 'Парсерски кеш',
	'maintenance-memc-hits' => 'погодоци:',
	'maintenance-memc-invalid' => 'неважечки:',
	'maintenance-memc-expired' => 'истечени:',
	'maintenance-memc-absent' => 'отсутно:',
	'maintenance-memc-stub' => 'праг за никулци:',
	'maintenance-memc-imagecache' => 'Кеш на сликите',
	'maintenance-memc-misses' => 'промашувања:',
	'maintenance-memc-updates' => 'подновувања:',
	'maintenance-memc-uncacheable' => 'некеширливи:',
	'maintenance-memc-diffcache' => 'Кеш на разликата',
	'maintenance-reassignEdits' => 'Овој образец служи за презадавање на уредувања од еден корисник на друг.',
	'maintenance-re-from' => 'Име на корисникот чиишто уредувања се презадаваат',
	'maintenance-re-to' => 'Име на корисникот кому му се презадаваат уредувањата',
	'maintenance-re-force' => 'Презадај дури и ако целниот корисник не постои',
	'maintenance-re-rc' => 'Не ја подновувај табелата на скорешни промени',
	'maintenance-re-report' => 'Прикажи ги подробностите од измените, но не ги применувај',
	'maintenance-re-nf' => 'Корисникот $1 не е пронајден',
	'maintenance-re-rr' => 'Повторно пушти ја скриптата без „$1“ за да ажурирате.',
	'maintenance-re-ce' => 'Тековни уредувања: $1',
	'maintenance-re-de' => 'Избришани уредувања: $1',
	'maintenance-re-rce' => 'Записи во скорешните промени: $1',
	'maintenance-re-total' => 'Вкупно записи за менување: $1',
	'maintenance-re-re' => 'Презадавањето на уредувањата{{int:ellipsis}} е завршено',
);

/** Malayalam (മലയാളം)
 * @author Praveenp
 * @author Shijualex
 */
$messages['ml'] = array(
	'maintenance' => 'പരിപാലന സ്ക്രിപ്റ്റുകൾ ഓടിക്കുക',
	'maintenance-desc' => 'വിവിധ പരിപാലന സ്ക്രിപ്റ്റുകൾക്കുള്ള [[Special:Maintenance|വിക്കി സമ്പർക്കമുഖം]]',
	'maintenance-backlink' => 'സ്ക്രിപ്റ്റുകളുടെ തിരഞ്ഞെടുക്കൽ താളിലേക്കു തിരിച്ചു പോവുക',
	'maintenance-header' => 'പ്രവർത്തിപ്പിക്കുവാനുള്ള സ്ക്രിപ്റ്റ് താഴെ നിന്നു തിരഞ്ഞെടുക്കുക. ഓരോ സ്ക്രിപ്റ്റിനു നേരെയും അതിനെക്കുറിച്ചുള്ള വിവരണം കൊടുത്തിരിക്കുന്നു.',
	'maintenance-option-confirm' => 'സ്ഥിരീകരിക്കുക',
	'maintenance-output-success' => '$1 വിജയകരമായി ഓടിച്ചിരിക്കുന്നു!',
	'maintenance-changePassword' => 'ഉപയോക്താവിന്റെ രഹസ്യവാക്ക് മാറ്റാൻ ഈ ഫോം ഉപയോഗിക്കുക',
	'maintenance-changePassword-desc' => 'ഒരു ഉപയോക്താവിന്റെ രഹസ്യവാക്ക് മാറ്റുക',
	'maintenance-createAndPromote' => 'ഒരു ഉപയോക്താവിനെ ഉണ്ടാക്കി പ്രസ്തുത ഉപയോക്താവിനെ സിസോപ്പ് ആയി ഉയർത്താൻ ഈ ഫോം ഉപയോഗിക്കുക.
പ്രസ്തുത ഉപയോക്താവിനെ ബ്യൂറോക്രാറ്റ് ആയി കൂടെ ഉയർത്തണമെകിൽ ബ്രൂറോക്രാറ്റിനടുത്തുള്ള ബോക്സ് തിരഞ്ഞെടുക്കുക.',
	'maintenance-createAndPromote-desc' => 'ഒരു ഉഒഅയോക്താവിനെ സൃഷ്ടിച്ച് സിസോപ്പായി സ്ഥാനക്കയറ്റം നൽകുക',
	'maintenance-deleteBatch' => 'താളുകൾ കൂട്ടത്തോടെ മായ്ക്കുവാൻ ഈ താൾ ഉപയോഗിക്കുക.
ഓരോ നിരയിലും ഒരു താൾ മാത്രം ചേർക്കുക.',
	'maintenance-deleteBatch-desc' => 'താലുകൾ കൂട്ടമായി ഒഴിവാക്കുക',
	'maintenance-deleteRevision' => 'പതിപ്പുകൾ കൂട്ടത്തോടെ മായ്ക്കുവാൻ ഈ താൾ ഉപയോഗിക്കുക.
ഓരോ നിരയിലും ഒരു പതിപ്പ് മാത്രം ചേർക്കുക.',
	'maintenance-deleteRevision-desc' => 'ഡാറ്റാബേസിൽ നിന്നു പതിപ്പുകൾ മാറ്റുക',
	'maintenance-initEditCount-desc' => 'ഉപയോക്താക്കളുടെ തിരുത്തലിന്റെ എണ്ണം വീണ്ടും കണക്കുകൂട്ടുക.',
	'maintenance-initSiteStats-desc' => 'സൈറ്റിന്റെ സ്ഥിതിവിവരക്കണക്ക് വീണ്ടും കണക്കുകൂട്ടുക',
	'maintenance-moveBatch' => 'താളുകളുടെ തലക്കെട്ട് കൂട്ടത്തോടെ മാറ്റുവാൻ ഈ താൾ ഉപയോഗിക്കുക. ഓരോ നിരയിൽ ഒരു സ്രോതസ്സ് താളും പൈപ്പ് ചിഹനം ഇട്ടു വേർതിരിച്ചതിനു ശേഷം അതിന്റെ ലക്ഷ്യതാളും മാത്രം ചേർക്കുക.',
	'maintenance-moveBatch-desc' => 'താളുകൾ കൂട്ടമായി മാറ്റുക',
	'maintenance-invalidname' => 'അസാധുവായ ഉപയോക്തൃനാമം!',
	'maintenance-userexists' => 'ഉപയോക്തൃനാമം നിലവിലുണ്ട്',
	'maintenance-invalidtitle' => 'അസാധുവായ തലക്കെട്ട് "$1"!',
	'maintenance-titlenoexist' => '("$1") എന്ന ശീർഷകത്തിലുള്ള ലേഖനം നിലവിലില്ല',
	'maintenance-failed' => 'പരാജയപ്പെട്ടു',
	'maintenance-deleted' => 'മായ്ച്ചു',
	'maintenance-revdelete' => '$2 വിക്കിയിൽ നിന്ന് {{PLURAL:$3|ഒരു പതിപ്പ്|പതിപ്പുകൾ}} $1 ഒഴിവാക്കുന്നു',
	'maintenance-revnotfound' => '$1 എന്ന പതിപ്പ് കണ്ടില്ല!',
	'maintenance-showCacheStats-edits' => 'ആകെ തിരുത്തുകൾ: $1',
	'maintenance-showCacheStats-articles' => 'മുഖ്യ നാമമേഖലയിലുള്ള താളുകളുടെ എണ്ണം: $1',
	'maintenance-showCacheStats-pages' => 'താളുകളുടെ എണ്ണം: $1',
	'maintenance-showCacheStats-users' => 'ഉപയോക്താക്കളുടെ എണ്ണം: $1',
	'maintenance-showCacheStats-admins' => 'കാര്യനിർ‌വാഹകരുടെ എണ്ണം: $1',
	'maintenance-showCacheStats-images' => 'പ്രമാണങ്ങളുടെ എണ്ണം: $1',
	'maintenance-showCacheStats-views' => 'പേജ് വ്യൂവിന്റെ എണ്ണം: $1',
	'maintenance-showCacheStats-update' => 'ഡാറ്റാബേസ് പുതുക്കുന്നു...',
	'maintenance-move' => '$1 നെ $2 ലേക്ക് മാറ്റുന്നു',
	'maintenance-movefail' => 'താൾ മാറ്റുമ്പോൾ പിഴവ് സം‌ഭവിച്ചു: $1
മാറ്റം നിർത്തിവയ്ക്കുന്നു',
	'maintenance-error' => 'പിഴവ്: $1',
	'maintenance-memc-requests' => 'അഭ്യർത്ഥനകൾ',
	'maintenance-memc-withsession' => 'സെഷനോടെ:',
	'maintenance-memc-withoutsession' => 'സെഷനില്ലാതെ:',
	'maintenance-memc-total' => 'ആകെ:',
	'maintenance-memc-hits' => 'എടുത്തുനോക്കലുകൾ:',
	'maintenance-memc-invalid' => 'അസാധു:',
	'maintenance-memc-expired' => 'കാലാവധി:',
	'maintenance-memc-absent' => 'അഭാവം:',
	'maintenance-memc-updates' => 'അപ്‌ഡേറ്റ്സ്:',
	'maintenance-re-nf' => '$1 എന്ന ഉപയോക്താവിനെ കണ്ടെത്താനായില്ല',
	'maintenance-re-ce' => 'ഇപ്പോഴത്തെ തിരുത്തലുകൾ: $1',
	'maintenance-re-de' => 'മായ്ക്കപ്പെട്ട തിരുത്തലുകൾ: $1',
);

/** Marathi (मराठी)
 * @author Kaustubh
 */
$messages['mr'] = array(
	'maintenance' => 'व्यवस्थापन स्क्रीप्ट्स चालवा',
	'maintenance-desc' => 'वेगवेगळ्या व्यवस्थापन स्क्रीप्ट्स करिता [[Special:Maintenance|वेब इंटरफेस]]',
	'maintenance-backlink' => 'स्क्रीप्ट निवडीकडे परत चला',
	'maintenance-header' => 'चालविण्यासाठी खालील एक स्क्रीप्ट निवडा.
प्रत्येक स्क्रीप्टच्या पुढे माहिती दिलेली आहे',
	'maintenance-error-invalidtype' => 'चुकीचा प्रकार!', # Fuzzy
	'maintenance-option-confirm' => 'निश्चित करा',
	'maintenance-output-success' => '$1 यशस्वीरित्या पूर्ण झाले!',
	'maintenance-changePassword' => 'हा अर्ज एखाद्या सदस्याचा परवलीचा शब्द बदलण्यासाठी वापरा',
	'maintenance-changePassword-desc' => 'एखाद्या सदस्याचा परवलीचा शब्द बदला',
	'maintenance-createAndPromote' => 'हा अर्ज एखादा नवीन सदस्य बनवून त्याला प्रबंधक करण्यासाठी वापरा.
सदस्याला अधिकारी बनविण्यासाठी अधिकारी बॉक्समध्ये सुद्धा टिचकी द्या',
	'maintenance-createAndPromote-desc' => 'एक सदस्य तयार करा व त्याला प्रबंधक बनवा',
	'maintenance-deleteBatch' => 'हा अर्ज एकाच वेळी अनेक पाने वगळण्यासाठी वापरा.
एका ओळीवर एकच पान लिहा',
	'maintenance-deleteBatch-desc' => 'खूप पाने एकत्र वगळा',
	'maintenance-deleteRevision' => 'हा अर्ज अनेक आवृत्त्या एकाचवेळी वगळण्यासाठी वापरा.
एका ओळीवर एकच आवृत्ती लिहा',
	'maintenance-deleteRevision-desc' => 'डाटाबेस मधून आवृत्त्या वगळा',
	'maintenance-initEditCount-desc' => 'सदस्यांची योगदान संख्या पुन्हा मोजा',
	'maintenance-initSiteStats' => 'हा अर्ज सांख्यिकी पुन्हा मोजण्यासाठी वापरा, त्यामध्ये तुम्ही पान बघण्याची सांख्यिकी सुद्धा पुन्हा मोजू शकता',
	'maintenance-initSiteStats-desc' => 'सांख्यिकी पुन्हा मोजा',
	'maintenance-moveBatch' => 'हा अर्ज एकाचवेळी अनेक पाने स्थानांतरीत करण्यासाठी वापरा.
प्रत्येक ओळीवर स्रोत पान व लक्ष्य पान पाईप चिन्ह वापरून लिहा',
	'maintenance-moveBatch-desc' => 'खूप पाने एकत्र स्थानांतरीत करा',
	'maintenance-runJobs-desc' => 'कार्य रांगेतील कार्ये करा',
	'maintenance-showJobs-desc' => 'कार्य रांगेतील पूर्ण न झालेल्या कार्यांची यादी दाखवा',
	'maintenance-showCacheStats-desc' => 'Memcached सांख्यिकी दाखवा',
	'maintenance-update' => 'सारणी बदलताना UPDATE चा वापर करायचा का? जर निवडले नाही तर DELETE/INSERT चा वापर होईल.',
	'maintenance-noviews' => 'पान पहाण्याची सांख्यिकी न बदलण्यासाठी हे निवडा',
	'maintenance-invalidname' => 'चुकीचे सदस्यनाव!',
	'maintenance-userexists' => 'सदस्य अगोदरच अस्तित्वात आहे!',
	'maintenance-invalidtitle' => 'चुकीचे शीर्षक "$1"!',
	'maintenance-titlenoexist' => 'दिलेले शीर्षक ("$1") अस्तित्वात नाही!',
	'maintenance-failed' => 'रद्द झाले',
	'maintenance-deleted' => 'वगळले',
	'maintenance-revdelete' => '$2 या विकिवरील $1 आवृत्त्या वगळत आहे', # Fuzzy
	'maintenance-revnotfound' => '$1 आवृत्ती सापडली नाही!',
	'maintenance-showCacheStats-edits' => 'संपादनांची संख्या: $1',
	'maintenance-showCacheStats-articles' => 'मुख्य नामविश्वातील पानांची संख्या: $1',
	'maintenance-showCacheStats-pages' => 'पृष्ठ संख्या: $1',
	'maintenance-showCacheStats-users' => 'सदस्य संख्या: $1',
	'maintenance-showCacheStats-admins' => 'प्रबंधकांची संख्या: $1',
	'maintenance-showCacheStats-images' => 'संचिकांची संख्या: $1',
	'maintenance-showCacheStats-views' => 'पाने पहाण्याची संख्या: $1',
	'maintenance-showCacheStats-update' => 'डाटाबेस बदलत आहे...',
	'maintenance-move' => ' $1 चे $2 ला स्थानांतरण करीत आहे...',
	'maintenance-movefail' => 'स्थानांतरण करण्यात त्रुटी: $1.
स्थानांतरण रद्द करत आहे',
	'maintenance-error' => 'त्रुटी: $1',
	'maintenance-memc-fake' => 'तुम्ही FakeMemCachedClient चालवित आहात. सांख्यिकी देता येणार नाही',
	'maintenance-memc-requests' => 'मागण्या',
	'maintenance-memc-withsession' => 'सेशन सहित:',
	'maintenance-memc-withoutsession' => 'सेशन रहित:',
	'maintenance-memc-total' => 'एकूण:',
	'maintenance-memc-parsercache' => 'पार्सर सय',
	'maintenance-memc-hits' => 'हिट्स:',
	'maintenance-memc-invalid' => 'अवैध:',
	'maintenance-memc-expired' => 'रद्द झालेले:',
	'maintenance-memc-absent' => 'गैरहजर:',
	'maintenance-memc-stub' => 'स्टब थ्रेशहोल्ड:',
	'maintenance-memc-imagecache' => 'चित्र सय',
	'maintenance-memc-misses' => 'मिसेस:',
	'maintenance-memc-updates' => 'अपडेट्स:',
	'maintenance-memc-uncacheable' => 'सयीत ठेवता येत नाही:',
	'maintenance-memc-diffcache' => 'फरक सय',
);

/** Malay (Bahasa Melayu)
 * @author Anakmalaysia
 * @author Aurora
 */
$messages['ms'] = array(
	'maintenance-generic-done' => 'siap',
	'maintenance-generic-username' => 'Nama pengguna',
	'maintenance-generic-password' => 'Kata laluan',
	'maintenance-generic-reason' => 'Sebab',
	'maintenance-option-confirm' => 'Sahkan',
	'maintenance-option-required' => '(wajib)',
	'maintenance-option-optional' => '(tidak wajib)',
	'maintenance-failed' => 'GAGAL',
	'maintenance-deleted' => 'DIHAPUSKAN',
);

/** Maltese (Malti)
 * @author Chrisportelli
 */
$messages['mt'] = array(
	'maintenance-generic-username' => 'Isem tal-utent',
	'maintenance-generic-password' => 'Password',
	'maintenance-generic-reason' => 'Raġuni',
	'maintenance-option-confirm' => 'Ikkonferma',
	'maintenance-option-required' => '(bżonnjuż)',
	'maintenance-option-optional' => '(opzjonali)',
	'maintenance-checkImages' => 'Uża din il-formola sabiex tara liema stampi fil-wiki tiegħek huma korrotti',
	'maintenance-checkImages-desc' => 'Tiċċekkja l-istampi biex tara jekk jeżistux, jekk jistgħux jinqraw, etċ.',
	'maintenance-checkImages-output-noaccess' => "$1: mhuwiex aċċessibbli b'mod lokali",
	'maintenance-checkImages-output-missing' => '$1: nieqes',
	'maintenance-checkImages-output-isdir' => '$1: dan huwa direttorju',
	'maintenance-checkImages-output-good' => 'Stampi tajbin: $1/$2',
	'maintenance-checkSyntax' => "Uża din il-formola sabiex tiċċekkja s-sintassi tal-fajls kollha tal-PHP f'MediaWiki",
	'maintenance-checkSyntax-desc' => "Tiċċekkja s-sintassi għal kull fajls PHP f'MediaWiki",
	'maintenance-invalidtitle' => 'It-titlu "$1" huwa ħażin!',
	'maintenance-titlenoexist' => 'It-titlu li tajt ("$1") ma jeżistix!',
	'maintenance-failed' => 'FALLA',
	'maintenance-deleted' => 'IMĦASSAR',
	'maintenance-revdelete' => 'Tħassir tar-{{PLURAL:$3|reviżjoni|reviżjonijiet}} $1 mill-wiki $2',
	'maintenance-revnotfound' => 'Ir-reviżjoni $1 ma nstabitx!',
	'maintenance-showCacheStats-edits' => "Numru ta' modifiki: $1",
	'maintenance-showCacheStats-articles' => "Numru ta' paġni fl-ispazju tal-isem prinċipali: $1",
	'maintenance-showCacheStats-pages' => "Numru ta' paġni: $1",
	'maintenance-showCacheStats-users' => "Numru ta' utenti: $1",
	'maintenance-showCacheStats-admins' => "Numru ta' amministraturi: $1",
	'maintenance-showCacheStats-images' => "Numru ta' fajls: $1",
	'maintenance-showCacheStats-views' => "Numru ta' żjajjar ta' paġni: $1",
	'maintenance-showCacheStats-update' => 'Għaddej l-aġġornament tad-databażi{{int:ellipsis}}',
	'maintenance-move' => "Għaddejja it-tmexxija ta' $1 lejn $2{{int:ellipsis}}",
	'maintenance-error' => 'Żball: $1',
	'maintenance-memc-fake' => "Qiegħed tesegwixxi FakeMemCachedClient. L-ebda statistika m'hi mogħtija",
	'maintenance-memc-requests' => 'Rikjesti',
);

/** Erzya (эрзянь)
 * @author Botuzhaleny-sodamo
 */
$messages['myv'] = array(
	'maintenance-option-confirm' => 'Кемекстамс',
	'maintenance-failed' => 'ЭЗЬ ЛИСЕ',
	'maintenance-deleted' => 'НАРДАЗЬ',
	'maintenance-showCacheStats-edits' => 'Зяроксть витнезь-петнезь: $1',
	'maintenance-showCacheStats-pages' => 'Зяро лопатнеде: $1',
	'maintenance-showCacheStats-admins' => 'Зяро админтнэде: $1',
	'maintenance-showCacheStats-images' => 'Зяро файлатнеде: $1',
	'maintenance-memc-requests' => 'Вешемат',
	'maintenance-memc-total' => 'весемезэ:',
	'maintenance-memc-absent' => 'арась:',
);

/** Nahuatl (Nāhuatl)
 * @author Fluence
 * @author Ricardo gs
 */
$messages['nah'] = array(
	'maintenance-invalidtitle' => '¡Ahcualli tōcāitl "$1"!',
	'maintenance-deleted' => 'TLAPOLOC',
	'maintenance-showCacheStats-edits' => 'Tlapatlaliztli tlapōhualli: $1',
	'maintenance-showCacheStats-articles' => 'Zāzanilli huēyi tōcātzimpan in ītlapōhual: $1',
	'maintenance-showCacheStats-pages' => 'Zāzanilli tlapōhualli: $1',
	'maintenance-showCacheStats-users' => 'Tlatequitiltilīlli tlapōhualli: $1',
	'maintenance-showCacheStats-images' => 'Tlahcuilōlli tlapōhualli: $1',
	'maintenance-move' => 'Mozacacah $1 īhuīc $2{{int:ellipsis}}',
	'maintenance-memc-total' => 'mochīntīn:',
	'maintenance-memc-expired' => 'ōmotlami:',
);

/** Norwegian Bokmål (norsk (bokmål)‎)
 * @author Nghtwlkr
 * @author Simny
 */
$messages['nb'] = array(
	'maintenance' => 'Kjør vedlikeholdsskript',
	'maintenance-desc' => '[[Special:Maintenance|Nettgrensesnitt]] for ulike vedlikeholdsskript',
	'right-maintenance' => 'Kjør vedlikeholdsskript gjennom [[Special:Maintenance]]',
	'maintenance-backlink' => 'Tilbake til skriptvalget',
	'maintenance-header' => 'Velg et skript å utføre nedenfor.
Beskrivelser gis ved siden av hvert skript.',
	'maintenance-error-badini' => 'Filen metadata.ini er enten skadet eller mangler. Last den ned utvidelsen Maintenance på nytt.',
	'maintenance-error-invalidtype' => 'Det angitte skriptet ble ikke funnet',
	'maintenance-error-badargs' => 'Du spesifiserte ikke alle de nødvendige alternativene',
	'maintenance-generic-done' => 'ferdig',
	'maintenance-generic-username' => 'Brukernavn',
	'maintenance-generic-password' => 'Passord',
	'maintenance-generic-reason' => 'Årsak',
	'maintenance-cleanupTable-dry-run' => 'Utfør en tørrkjøring',
	'maintenance-cleanupTable-check' => 'Ser etter dårlige titler...',
	'maintenance-cleanupTable-checkfix' => 'Ser etter og fikser dårlige titler...',
	'maintenance-cleanupTable-progress' => '$1 $2: $3% ferdig på $4; Antatt ferdig $5 [$6/$7] $8/sek <$9% oppdatert>',
	'maintenance-cleanupTable-missingparam' => '$1: Mangler parameter $2',
	'maintenance-cleanupTable-processing' => 'Behandler $1...',
	'maintenance-cleanupTable-finished' => 'Ferdig $1... $2 av $3 rader oppdatert', # Fuzzy
	'maintenance-option-quiet' => 'Undertrykk utdata for ikke-feil',
	'maintenance-option-confirm' => 'Bekreft',
	'maintenance-option-required' => '(påkrevd)',
	'maintenance-option-optional' => '(valgfri)',
	'maintenance-output-success' => '$1 ble gjennomført uten uhell.',
	'maintenance-benchmarkPurge-output-numsquids' => 'Det er $1 definerte Squid-tjenere:', # Fuzzy
	'maintenance-benchmarkPurge-output-trial' => '$1 titler på $2ms ($3ms hver)', # Fuzzy
	'maintenance-changePassword' => 'Bruk dette skjemaet for å endre en brukers passord',
	'maintenance-changePassword-desc' => 'Endre en brukers passord',
	'maintenance-changePassword-error-nouser' => 'Ingen slik bruker: $1',
	'maintenance-changePassword-output-set' => 'Passord satt for $1',
	'maintenance-checkAutoLoader' => 'Bruk dette skjemaet for å gjøre tilregnelighetssjekker på AutoLoader',
	'maintenance-checkAutoLoader-desc' => 'AutoLoader tilregnelighetssjekker',
	'maintenance-checkAutoLoader-output-list2' => '$1: Feil fil: fant i $2, listet i $3',
	'maintenance-checkBadRedirects' => 'Bruk dette skjemaet for å se om sider markert som omdirigeringer faktisk er omdirigeringer',
	'maintenance-checkBadRedirects-desc' => 'Ser etter dårlige omdirigeringer',
	'maintenance-checkBadRedirects-output-header' => 'Henter omdirigeringer...',
	'maintenance-checkBadRedirects-output-found' => 'Fant $1 omdirigeringer.
Ser etter dårlige omdirigeringer...', # Fuzzy
	'maintenance-checkBadRedirects-output-footer' => '
Ferdig.',
	'maintenance-checkImages' => 'Bruk dette skjemaet for å se hvilke bilder på tjeneren din som er skadet', # Fuzzy
	'maintenance-checkImages-desc' => 'Sjekk bilder for å se om de finnes, er lesbare, etc',
	'maintenance-checkImages-output-noaccess' => '$1: ikke tilgjengelig lokalt',
	'maintenance-checkImages-output-missing' => '$1: mangler',
	'maintenance-checkImages-output-isdir' => '$1: er en mappe',
	'maintenance-checkImages-output-truncated' => '$1: trunkert, var $2',
	'maintenance-checkImages-output-mismatch' => '$1: avvikende størrelse DB=$2, faktisk=$3',
	'maintenance-checkImages-output-good' => 'Gode bilder: $1/$2',
	'maintenance-checkSyntax' => 'Bruk dette skjemaet for å sjekke syntaksen til alle PHP-filene i MediaWiki',
	'maintenance-checkSyntax-desc' => 'Sjekk syntaksen for alle PHP-filene i MediaWiki',
	'maintenance-checkSyntax-output-buildlist' => 'Bygger filliste...',
	'maintenance-checkSyntax-output-error' => 'Feil i $1 linje $2: $3',
	'maintenance-checkSyntax-output-warning' => 'Advarsel i fil $1: $2 funnet',
	'maintenance-checkSyntax-error-nofile' => 'Feil: finner ikke fil eller mappe $1',
	'maintenance-checkSyntax-error-cantopen' => 'Kan ikke åpne fil $1',
	'maintenance-createAndPromote' => 'Bruk dette skjemaet for å opprette en ny bruker og gjøre den til administrator.
Kryss av i byråkratboksen om du ønsker å gjøre den til byråkrat også',
	'maintenance-createAndPromote-desc' => 'Opprett en bruker og gjør til administrator',
	'maintenance-deleteBatch' => 'Bruk dette skjemaet for å slette mange sider på én gang.
Skriv én sidetittel per rad',
	'maintenance-deleteBatch-desc' => 'Slett mange sider',
	'maintenance-deleteRevision' => 'Bruk dette skjemaet for å slette mange revisjoner på én gang.
Skriv ett revisjonsnummer per rad',
	'maintenance-deleteRevision-desc' => 'Fjern revisjoner fra databasen',
	'maintenance-initEditCount-desc' => 'Regne om redigeringstelleren for brukere',
	'maintenance-initSiteStats' => 'Bruk dette skjemaet for å regne ut sidestatistikken på nytt, spesielt om du vil regne ut sidevisninger på nytt',
	'maintenance-initSiteStats-desc' => 'Regne om sidestatistikken',
	'maintenance-moveBatch' => 'Bruk dette skjemaet for å flytte mange sider på én gang.
Hver linje bør oppgi kildeside og målside adskilt med strek (|)',
	'maintenance-moveBatch-desc' => 'Flytte mange sider',
	'maintenance-reassignEdits-desc' => 'Flytt endringer fra en bruker til en annen',
	'maintenance-runJobs-desc' => 'Kjøre jobber i jobbkøen',
	'maintenance-showJobs-desc' => 'Vise en liste over jobber som venter i jobbkøen',
	'maintenance-sql' => 'Bruk dette skjemaet for å utføre en SQL-spørring på databasen.',
	'maintenance-sql-desc' => 'Utfør en SQL-spørring',
	'maintenance-showCacheStats-desc' => 'Vis mellomlagret statistikk',
	'maintenance-eval' => 'Bruk dette skjemaet for å evaluere PHP-kode i MediaWiki-miljøet.',
	'maintenance-eval-desc' => 'Evaluer PHP-kode i MediaWiki-omgivelsene',
	'maintenance-update' => 'Bruk UPDATE under oppdatering av tabell? Om uavkrysset brukes DELETE/INSERT i stedet.',
	'maintenance-noviews' => 'Kryss av her for ikke å oppdatere sidevisninger',
	'maintenance-invalidname' => 'Ugyldig brukernavn.',
	'maintenance-userexists' => 'Brukeren finnes allerede.',
	'maintenance-invalidtitle' => 'Ugyldig tittel «$1».',
	'maintenance-titlenoexist' => 'Den oppgitte tittelen («$1») finnes ikke.',
	'maintenance-failed' => 'MISLYKTES',
	'maintenance-deleted' => 'SLETTET',
	'maintenance-revdelete' => 'Sletter {{PLURAL:$3|revisjonen|revisjonene}} $1 fra wikien $2',
	'maintenance-revnotfound' => 'Revisjon $1 ikke funnet.',
	'maintenance-showCacheStats-edits' => 'Antal redigeringer: $1',
	'maintenance-showCacheStats-articles' => 'Antall sider i hovednavnerommet: $1',
	'maintenance-showCacheStats-pages' => 'Antall sider: $1',
	'maintenance-showCacheStats-users' => 'Antall brukere: $1',
	'maintenance-showCacheStats-admins' => 'Antall administratorer: $1',
	'maintenance-showCacheStats-images' => 'Antall filer: $1',
	'maintenance-showCacheStats-views' => 'Antall sidevisninger: $1',
	'maintenance-showCacheStats-update' => 'Oppdaterer database …',
	'maintenance-move' => 'Flytter $1 til $2 …',
	'maintenance-movefail' => 'Feil oppsto under flytting: $1.
Avbryter flytting',
	'maintenance-error' => 'Feil: $1',
	'maintenance-memc-fake' => 'Du kjører en FakeMemCachedClient. Ingen statistikk kan oppgis.',
	'maintenance-memc-requests' => 'Forespørsler',
	'maintenance-memc-withsession' => 'med sesjon:',
	'maintenance-memc-withoutsession' => 'uten sesjon:',
	'maintenance-memc-total' => 'totalt:',
	'maintenance-memc-parsercache' => 'Parsermellomlager',
	'maintenance-memc-hits' => 'treff:',
	'maintenance-memc-invalid' => 'ugyldig:',
	'maintenance-memc-expired' => 'utgikk:',
	'maintenance-memc-absent' => 'ikke til stede:',
	'maintenance-memc-stub' => 'stubbgrense:',
	'maintenance-memc-imagecache' => 'Bildemellomlager',
	'maintenance-memc-misses' => 'bom:',
	'maintenance-memc-updates' => 'Oppdateringer:',
	'maintenance-memc-uncacheable' => 'Kan ikke mellomlagres:',
	'maintenance-memc-diffcache' => 'Forskjellsmellomlager',
	'maintenance-reassignEdits' => 'Bruk dette skjemaet for å flytte endringer fra en bruker til en annen.',
	'maintenance-re-from' => 'Navn på bruker som endringer skal tas fra',
	'maintenance-re-to' => 'Navn på bruker som endringer skal gis til',
	'maintenance-re-force' => 'Flytt endringer selv om målbrukeren ikke finnes',
	'maintenance-re-rc' => 'Ikke oppdater tabellen over siste endringer',
	'maintenance-re-report' => 'Skriv ut detaljer av det som ville ha endret seg, men ikke oppdater det',
	'maintenance-re-nf' => 'Fant ikke bruker $1',
	'maintenance-re-rr' => 'Kjør skriptet igjen uten «$1» for å oppdatere.',
	'maintenance-re-ce' => 'Nåværende redigeringer: $1',
	'maintenance-re-de' => 'Slettede redigeringer: $1',
	'maintenance-re-rce' => 'Bidrag på siste endringer: $1',
	'maintenance-re-total' => 'Totalt antall oppføringer som skal endres: $1',
	'maintenance-re-re' => 'Flytter endringer{{int:ellipsis}} fullført',
);

/** Nepali (नेपाली)
 * @author RajeshPandey
 */
$messages['ne'] = array(
	'maintenance-generic-username' => 'प्रयोगकर्ता नाम',
);

/** Dutch (Nederlands)
 * @author McDutchie
 * @author SPQRobin
 * @author Siebrand
 * @author Tvdm
 * @author Wiki13
 */
$messages['nl'] = array(
	'maintenance' => 'Beheerscripts uitvoeren',
	'maintenance-desc' => '[[Special:Maintenance|Wiki-interface]] voor een aantal beheerscripts',
	'right-maintenance' => 'Onderhoudscripts uitvoeren via [[Special:Maintenance]]',
	'maintenance-backlink' => 'Naar scriptselectie terugkeren',
	'maintenance-header' => 'Selecteer hieronder een uit te voeren script.
Beschrijvingen staan naast de scripts',
	'maintenance-error-badini' => 'Het bestand metadata.ini is corrupt of niet aanwezig. Download de uitbreiding Maintenance opnieuw.',
	'maintenance-error-invalidtype' => 'Het opgegeven script is niet gevonden',
	'maintenance-error-badargs' => 'U hebt niet alle verplichte instellingen gemaakt.',
	'maintenance-generic-done' => 'afgerond',
	'maintenance-generic-username' => 'Gebruikersnaam',
	'maintenance-generic-password' => 'Wachtwoord',
	'maintenance-generic-reason' => 'Reden',
	'maintenance-cleanupTable-dry-run' => 'Controle uitvoeren zonder wijzigingen te maken',
	'maintenance-cleanupTable-check' => 'Bezig met het controleren op incorrecte paginanamen...',
	'maintenance-cleanupTable-checkfix' => 'Bezig met het controleren en bijwerken van paginanamen...',
	'maintenance-cleanupTable-progress' => '$1 $2: $3% uitgevoerd op $4; Verwachte eindtijd $5 [$6/$7] $8/sec <$9% bijgewerkt>',
	'maintenance-cleanupTable-missingparam' => '$1: de parameter $2 mist',
	'maintenance-cleanupTable-processing' => 'Bezig met verwerken van $1...',
	'maintenance-cleanupTable-finished' => 'Klaar met $1... {{PLURAL:$3|De rij is|Er zijn $2 van $3 rijen}} bijgewerkt',
	'maintenance-option-quiet' => 'Niet-foutmeldingen onderdrukken',
	'maintenance-option-globals' => 'Globale variabelen uitvoeren aan het einde van de taak voor debuggen',
	'maintenance-option-confirm' => 'Bevestigen',
	'maintenance-option-batch-size' => 'Aantal uit te voeren operaties per batch. Standaard: $1',
	'maintenance-option-required' => '(vereist)',
	'maintenance-option-optional' => '(optioneel)',
	'maintenance-output-success' => '$1 is uitgevoerd!',
	'maintenance-output-failure' => '$1 is mislukt.',
	'maintenance-attachLatest' => 'Gebruik dit formulier om regels in de tabel "page" te corrigeren waar "page_latest" op 0 staat',
	'maintenance-attachLatest-desc' => '"page_latest"-regels in de tabel "page" corrigeren',
	'maintenance-attachLatest-option-fix' => 'Corrigeer de regels ook echt. Anders wordt alleen een proef uitgevoerd zonder wijzigingen te maken',
	'maintenance-attachLatest-output-begin' => 'Aan het zoeken naar pagina\'s waar "page_latest" 0 is...',
	'maintenance-attachLatest-output-notime' => '$1 $2 [[$3]] kan de laatste versietijd niet vinden!?',
	'maintenance-attachLatest-output-norev' => '$1 $2 [[$3]] laatste tijd $4, kan versienummer niet vinden',
	'maintenance-attachLatest-output-found' => '$1 $2 [[$3]] laatste tijd $4, versienummer $5',
	'maintenance-attachLatest-output-done' => "Uitgevoerd. Er {{PLURAL:$1|is één pagina|zijn $1 pagina's}} verwerkt.",
	'maintenance-attachLatest-output-dryrun' => 'Dit was een controle zonder wijzigingen aan te brengen. Voor opnieuw uit met "{{int:maintenance-attachLatest-option-fix}}" om "page_latest" echt bij te werken.',
	'maintenance-benchmarkPurge' => 'Gebruik dit formulier om te controleren hoe lang het duurt om de de purgefuncties van Squid uit te voeren',
	'maintenance-benchmarkPurge-desc' => 'Voer een benchmark uit voor de purgefuncties van Squid',
	'maintenance-benchmarkPurge-option-count' => "Hoeveel te purgen URL's moeten aan Squid gegeven worden",
	'maintenance-benchmarkPurge-error-nosquid' => "De benchmark voor het purgen van pagina's in Squid doet niet zoveel als Squid is uitgeschakeld.",
	'maintenance-benchmarkPurge-output-numsquids' => 'Er {{PLURAL:$1|is één squidserver|zijn $1 squidservers}} ingesteld:',
	'maintenance-benchmarkPurge-output-trial' => "{{PLURAL:$1|Eén pagina|$1 pagina's}} in $2ms ($3ms per pagina)",
	'maintenance-changePassword' => 'Gebruik dit formulier om het wachtwoord van een gebruiker te wijzigen',
	'maintenance-changePassword-desc' => 'Wachtwoord van een gebruiker wijzigen',
	'maintenance-changePassword-error-nouser' => 'Gebruiker bestaat niet: $1',
	'maintenance-changePassword-output-set' => 'Het wachtwoord voor $1 is ingesteld',
	'maintenance-checkAutoLoader' => 'Gebruik dit formulier om een aantal controles uit te voeren voor de Autoloader',
	'maintenance-checkAutoLoader-desc' => 'Controles voor Autoloader',
	'maintenance-checkAutoLoader-output-list2' => '$1: Onjuist bestand: $2 is aangetroffen in, opgegeven in $3',
	'maintenance-checkBadRedirects' => "Gebruik dit formulier om of pagina's die gemarkeerd zijn als doorverwijzing ook echt doorverwijzingen zijn",
	'maintenance-checkBadRedirects-desc' => 'Onjuiste doorverwijzingen zoeken',
	'maintenance-checkBadRedirects-output-header' => 'Doorverwijzingen aan het ophalen...',
	'maintenance-checkBadRedirects-output-found' => 'Er {{PLURAL:$1|is één doorverwijzing|zijn $1 doorverwijzingen}} gevonden.
Bezig met zoeken naar onjuiste doorverwijzingen...',
	'maintenance-checkBadRedirects-output-footer' => 'Uitgevoerd.',
	'maintenance-checkImages' => 'Gebruik dit formulier om te controleren welke beschadigde bestanden uw wiki bevat',
	'maintenance-checkImages-desc' => 'Controleer bestanden op bestaan, leesbaarheid, enzovoort.',
	'maintenance-checkImages-output-noaccess' => '$1: niet lokaal toegankelijk',
	'maintenance-checkImages-output-missing' => '$1: niet aanwezig',
	'maintenance-checkImages-output-isdir' => '$1: is een map',
	'maintenance-checkImages-output-truncated' => '$1: incompleet, was $2',
	'maintenance-checkImages-output-mismatch' => '$1: grootte wijkt af. Database = $2, feitelijk is $3',
	'maintenance-checkImages-output-good' => 'Goede bestanden: $1/$2',
	'maintenance-checkSyntax' => 'Gebruik dit formulier om alle PHP-instellingenbestanden van MediaWiki te controleren',
	'maintenance-checkSyntax-desc' => 'Alle PHP-instellingenbestanden van MediaWiki controleren',
	'maintenance-checkSyntax-option-with-extensions' => 'Ook in de map "extensions/" controleren',
	'maintenance-checkSyntax-option-path' => 'Controleren in een specifiek pad (bestand of map). Dit kan een absoluut pad zijn of een relatief pad vanaf de hoofdmap van deze installatie van MediaWiki',
	'maintenance-checkSyntax-option-list-file' => 'Lijst met te controleren bestanden of mappen',
	'maintenance-checkSyntax-option-modified' => 'Alleen bestanden controleren die gewijzigd zijn (hiervoor is een SVN-client op de commandoregel vereist)',
	'maintenance-checkSyntax-option-syntax-only' => 'Alleen controleren op juiste op juiste opmaal. Waarschuwingen voor stijl overslaan',
	'maintenance-checkSyntax-output-parsekit' => 'Opmaak controleren (met parsekit)',
	'maintenance-checkSyntax-output-phpl' => 'Opmaak controleren (met php -l). Dit kan lang duren',
	'maintenance-checkSyntax-output-footer' => 'Afgerond. Er zijn $1 bestanden gecontroleerd, $2 fouten gevonden en $3 waarschuwingen afgegeven',
	'maintenance-checkSyntax-output-svnlist' => 'bezig met het ophalen van de lijst in Subversion...',
	'maintenance-checkSyntax-output-buildlist' => 'Bezig met het opstellen van de bestandenlijst...',
	'maintenance-checkSyntax-output-error' => 'Fout in bestand $1 op regel $2: $3',
	'maintenance-checkSyntax-output-warning' => 'Waarschuwing in bestand $1: $2 aangetroffen',
	'maintenance-checkSyntax-error-nofile' => 'Fout: het bestand of de map $1 kan niet gevonden worden',
	'maintenance-checkSyntax-error-cantopen' => 'Het bestand $1 kan niet geopend worden',
	'maintenance-checkSyntax-error-svnerr' => 'Fout tijdens het ophalen van de lijst uit Subversion',
	'maintenance-checkUsernames' => 'Gebruik dit formulier om aan te geven welke gebruikersnamen ongeldig zijn vanwege wijzigingen in de instellingen. Als er niets wordt vermeld na het uitvoeren van dit script, zijn alle gebruikersnamen geldig',
	'maintenance-checkUsernames-desc' => 'Controleren of gebruikersnamen in de database geldig zijn',
	'maintenance-checkUsernames-error-notvalid' => 'Ongeldige gebruikersnaam: "$3" (gebruikersnummer $2)',
	'maintenance-cleanupCaps' => 'Gebruik dit formulier om kapotte pagina\'s te repareren door het aanpassen van $wgCapitalLinks',
	'maintenance-cleanupCaps-desc' => 'Script om hoofdlettergebruik op te schonen',
	'maintenance-cleanupCaps-option-namespace' => 'Het naamruimtenummer om de opschoonactie op uit te voeren',
	'maintenance-cleanupCaps-output-islower' => '"$1" wordt al in kleine letters geschreven.',
	'maintenance-cleanupCaps-output-clash' => '"$1" is overgeslagen; "$2" bestaat al',
	'maintenance-cleanupCaps-output-dryrun' => '"$1" -> "$2": Controlerun, nog niet verplaatst',
	'maintenance-cleanupCaps-error-noneed' => '$wgCapitalLinks is actief -- Hoofdletters en kleine letters hoeven niet opgeschoond te worden.',
	'maintenance-cleanupSpam' => 'Gebruik dit formulier om spambewerkingen terug te draaien die naar externe websites verwijzen',
	'maintenance-cleanupSpam-desc' => 'Alle spam van een opgegeven hostnaam opruimen',
	'maintenance-cleanupSpam-option-hostname' => 'De hostnaam die heeft gespamd',
	'maintenance-cleanupSpam-output-found' => "{{PLURAL:$1|Eén pagina die $2 bevat|$1 pagina's die $2 bevatten}} gevonden",
	'maintenance-cleanupSpam-output-false' => 'Onjuiste overeenkomst',
	'maintenance-cleanupSpam-output-blanking' => 'leeghalen',
	'maintenance-cleanupSpam-output-reverting' => 'bezig met terugdraaien',
	'maintenance-cleanupSpam-error-invalid' => 'Geen geldige hostnaamspecificatie: $1',
	'maintenance-cleanupSpam-error-noid' => 'Interne fout: geen pagina voor ID $1',
	'maintenance-clearInterwikiCache' => 'Gebruik dit formulier om de interwikicache volledig te legen',
	'maintenance-clearInterwikiCache-desc' => 'Alle interwikikoppelingen voor alle talen verwijderen uit de cache',
	'maintenance-createAndPromote' => "Gebruik dit formulier om een gebruiker aan te maken en deze beheerder te maken.
Vink het vakje 'bureaucraat' aan om de gebruik ook bureacraat te maken",
	'maintenance-createAndPromote-desc' => 'Een nieuwe gebruiker aanmaken en deze beheerder maken',
	'maintenance-createAndPromote-option-bureaucrat' => 'Gebruiker bureaucraat maken',
	'maintenance-createAndPromote-output-creating' => 'De gebruiker {{ns:user}}:$2 wordt aangemaakt en in de opgegeven gebruikersgroepen geplaatst...',
	'maintenance-createAndPromote-error-password' => 'Er is een fout opgetreden met het wachtwoord dat u hebt opgegeven: $1',
	'maintenance-deleteBatch' => "Gebruik dit formulier om en masse pagina's te verwijderen.
Geef op iedere regel een paginanaam op",
	'maintenance-deleteBatch-desc' => "Pagina's en masse verwijderen",
	'maintenance-deleteRevision' => 'Gebruik dit formulier om en masse versie te verwijderen.
Geef op iedere regel een paginanaam op',
	'maintenance-deleteRevision-desc' => 'Versies uit de database verwijderen',
	'maintenance-initEditCount-desc' => 'Aantal bewerkingen van gebruikers herberekenen',
	'maintenance-initSiteStats' => 'Gebruik dit formulier de sitestatistieken opnieuw te berekenen. Geef daarbij aan of u de tellingen van het aantal keren dat een pagina is bekeken ook wilt bijwerken',
	'maintenance-initSiteStats-desc' => 'Sitestatistieken herberekenen',
	'maintenance-moveBatch' => 'Gebruik dit formulier om en masse pagina\'s te hernoemen.
Iedere regel moet een doelpagina en een bestemmingspagina bevatten, gescheiden door een pipe-teken ("|")',
	'maintenance-moveBatch-desc' => "Pagina's en masse hernoemen",
	'maintenance-reassignEdits-desc' => 'Bewerkingen aan een andere gebruiker toewijzen',
	'maintenance-runJobs-desc' => 'Taken uit de jobqueue uitvoeren',
	'maintenance-runJobs-option-maxjobs' => 'Maximaal aantal uit te voeren taken',
	'maintenance-runJobs-option-type' => 'Type uit te voeren taak',
	'maintenance-runJobs-option-procs' => 'Aantal te gebruiken processen',
	'maintenance-runJobs-option-exclusive' => 'Maximaal een runJobs-script tegelijkertijd uitvoeren. Dit script kan maximaal 1.800 seconden worden uitgevoerd.',
	'maintenance-runJobs-error-invalidprocs' => 'U moet een waarde tussen 1 en 1.000 processen opgeven',
	'maintenance-showJobs-desc' => 'Openstaande taken in de jobqueue bekijken',
	'maintenance-showJobs-option-group' => 'Aantal taken per taaktype weergeven',
	'maintenance-sql' => 'Gebruik dit formulier om een SQL-query op de database uit te voeren.',
	'maintenance-sql-desc' => 'SQL-query uitvoeren',
	'maintenance-sql-option-file' => 'Uit te voeren SQL',
	'maintenance-sql-output-aff' => 'Query uitgevoerd. Er {{PLURAL:$1|is $1 rij|zijn $1 rijen}} aangepast',
	'maintenance-sql-error-cantopen' => 'Het was niet mogelijk het invoerbestand te openen',
	'maintenance-showCacheStats-desc' => 'Memcachedstatistieken bekijken',
	'maintenance-eval' => 'Gebruik dit formulier om PHP-code in de MediaWiki-omgeving te evalueren.',
	'maintenance-eval-desc' => 'PHP-code evalueren in de MediaWiki-omgeving',
	'maintenance-update' => 'Gebruik UPDATE als u een tabel wilt bijwerken? Unchecked gebruiker in plaats daarvan DELETE/INSERT.',
	'maintenance-noviews' => 'Vink dit aan om te voorkomen dat het aantal keren dat een pagina is bekeken wordt bijgewerkt',
	'maintenance-invalidname' => 'Ongeldige gebruikersnaam!',
	'maintenance-userexists' => 'De gebruiker bestaat al!',
	'maintenance-invalidtitle' => 'Ongeldige paginanaam "$1"!',
	'maintenance-titlenoexist' => 'De opgegeven pagina ("$1") bestaat niet!',
	'maintenance-failed' => 'Mislukt',
	'maintenance-deleted' => 'Verwijderd',
	'maintenance-revdelete' => 'Bezig met het verwijderen van {{PLURAL:$3|versie|versies}} $1 van wiki $2',
	'maintenance-revnotfound' => 'Versie $1 niet gevonden!',
	'maintenance-showCacheStats-edits' => 'Aantal bewerkingen: $1',
	'maintenance-showCacheStats-articles' => "Aantal pagina's in de hoofdnaamruimte: $1",
	'maintenance-showCacheStats-pages' => "Aantal pagina's: $1",
	'maintenance-showCacheStats-users' => 'Aantal gebruikers: $1',
	'maintenance-showCacheStats-admins' => 'Aantal beheerders: $1',
	'maintenance-showCacheStats-images' => 'Aantal bestanden: $1',
	'maintenance-showCacheStats-views' => "Aantal bekeken pagina's: $1",
	'maintenance-showCacheStats-update' => 'Bezig met het bijwerken van de database…',
	'maintenance-move' => 'Bezig met het hernoemen van $1 naar $2…',
	'maintenance-movefail' => 'Er is een fout opgetreden bij het hernoemen: $1.
Hernoemen is afgebroken',
	'maintenance-error' => 'Fout: $1',
	'maintenance-memc-fake' => 'U maakt gebruik van FakeMemCachedClient. Het is niet mogelijk statistieken te berekenen',
	'maintenance-memc-requests' => 'Verzoeken',
	'maintenance-memc-withsession' => 'met sessie:',
	'maintenance-memc-withoutsession' => 'zonder sessie:',
	'maintenance-memc-total' => 'totaal:',
	'maintenance-memc-parsercache' => 'Parsercache',
	'maintenance-memc-hits' => 'hits:',
	'maintenance-memc-invalid' => 'ongeldig:',
	'maintenance-memc-expired' => 'vervallen:',
	'maintenance-memc-absent' => 'afwezig:',
	'maintenance-memc-stub' => 'stubdrempelwaarde:',
	'maintenance-memc-imagecache' => 'Beeldencache',
	'maintenance-memc-misses' => 'gemist:',
	'maintenance-memc-updates' => 'bijgewerkt:',
	'maintenance-memc-uncacheable' => 'kan niet gecached worden:',
	'maintenance-memc-diffcache' => 'Diff cache',
	'maintenance-reassignEdits' => 'Gebruik dit formulier om bewerkingen aan een andere gebruiker toe te wijzen.',
	'maintenance-re-from' => 'Brongebruiker',
	'maintenance-re-to' => 'Doelgebruiker',
	'maintenance-re-force' => 'Ook toewijzen als de doelgebruiker niet bestaat',
	'maintenance-re-rc' => 'Recente wijzigingen niet bijwerken',
	'maintenance-re-report' => 'Details weergeven van te maken wijzigingen zonder daarwerkelijk bij te werken',
	'maintenance-re-nf' => 'Gebruiker $1 bestaat niet',
	'maintenance-re-rr' => 'Voer de handeling opnieuw uit met bijwerken door de optie "$1" uit te schakelen.',
	'maintenance-re-ce' => 'Huidige bewerkingen: $1',
	'maintenance-re-de' => 'Verwijderde bewerkingen: $1',
	'maintenance-re-rce' => 'Regels in recente wijzigingen: $1',
	'maintenance-re-total' => 'Aantal bij te werken bewerkingen: $1',
	'maintenance-re-re' => 'Bezig met het toewijzen… Klaar',
);

/** Nederlands (informeel)‎ (Nederlands (informeel)‎)
 * @author Siebrand
 */
$messages['nl-informal'] = array(
	'maintenance-error-badargs' => 'Je hebt niet alle verplichte instellingen gemaakt.',
	'maintenance-checkImages' => 'Gebruik dit formulier om te controleren welke beschadigde bestanden je wiki bevat',
	'maintenance-createAndPromote-error-password' => 'Er is een fout opgetreden met het wachtwoord dat je hebt opgegeven: $1',
	'maintenance-runJobs-error-invalidprocs' => 'Je moet een waarde tussen 1 en 1.000 processen opgeven',
	'maintenance-memc-fake' => 'Je maakt gebruik van FakeMemCachedClient. Het is niet mogelijk statistieken te berekenen',
);

/** Norwegian Nynorsk (norsk (nynorsk)‎)
 * @author Harald Khan
 * @author Nghtwlkr
 * @author Njardarlogar
 */
$messages['nn'] = array(
	'maintenance' => 'Køyr vedlikehaldsskript',
	'maintenance-desc' => '[[Special:Maintenance|Wikigrensesnitt]] for ymse vedlikehaldsskript',
	'right-maintenance' => 'Køyra vedlikehaldsskript gjennom [[Special:Maintenance]]',
	'maintenance-backlink' => 'Attende til skriptval',
	'maintenance-header' => 'Vel eit skript under som skal verta køyrt.
Skildringa til kvart skript ligg ved sida det.',
	'maintenance-error-invalidtype' => 'Ugyldig type!', # Fuzzy
	'maintenance-generic-username' => 'Brukarnamn',
	'maintenance-generic-password' => 'Passord',
	'maintenance-option-confirm' => 'Stadfest',
	'maintenance-output-success' => '$1 blei køyrt gjennom utan problem.',
	'maintenance-changePassword' => 'Nytt dette skjemaet for å endra passordet til ein brukar.',
	'maintenance-changePassword-desc' => 'Endra passordet til ein brukar',
	'maintenance-createAndPromote' => 'Nytt dette skjemaet for å oppretta ein ny brukar og gjera han til administrator.
Kryss av i byråkratboksen om du ønskjer å gjera han til byråkrat òg',
	'maintenance-createAndPromote-desc' => 'Opprett ein brukar og gjer han til administrator',
	'maintenance-deleteBatch' => 'Nytt dette skjemaet for å sletta mange sider på éin gong.
Skriv inn berre éin sidetittel per rad.',
	'maintenance-deleteBatch-desc' => 'Masseslett sider',
	'maintenance-deleteRevision' => 'Nytt dette skjemaet for å sletta mange versjonar på éin gong.
Skriv berre inn eitt versjonsnummer per rad.',
	'maintenance-deleteRevision-desc' => 'Fjern versjonar frå databasen',
	'maintenance-initEditCount-desc' => 'Rekn om endringsteljaren til brukarar',
	'maintenance-initSiteStats' => 'Nytt dette skjemaet for å rekna ut sidestatistikken på nytt. Spesifiser om du òg ynskjer å rekna ut sidevisingar på nytt',
	'maintenance-initSiteStats-desc' => 'Rekn om sidestatistikken',
	'maintenance-moveBatch' => 'Nytt dette skjemaet for å flytta mange sider på éin gong.
Kvar linja bør oppgje ei kjeldesida og ei målsida skilde med ein strek (|).',
	'maintenance-moveBatch-desc' => 'Masseflytt sider',
	'maintenance-reassignEdits-desc' => 'Flytta endringar frå ein brukar til ein annan',
	'maintenance-runJobs-desc' => 'Køyra jobbar i jobbkøen',
	'maintenance-showJobs-desc' => 'Syn ei lista over jobbar som ventar i jobbkøen',
	'maintenance-sql' => 'Nytt dette skjemaet for å utføra ein SQL-spørjing på databasen.',
	'maintenance-sql-desc' => 'Utfør ei SQL-spørjing',
	'maintenance-showCacheStats-desc' => 'Vis mellomlagra statistikk',
	'maintenance-eval' => 'Nytt dette skjemaet til å evaluera PHP-kode i MediaWiki-omgjevnader.',
	'maintenance-eval-desc' => 'Evaluer PHP-kode i MediaWiki-omgjevnadene',
	'maintenance-update' => 'Nytt UPDATE under oppdatering av tabell? Om uavkryssa vert DELETE/INSERT nytta i staden.',
	'maintenance-noviews' => 'Kryss av her for ikkje å oppdatera sidevisingar',
	'maintenance-invalidname' => 'Ugyldig brukarnamn.',
	'maintenance-userexists' => 'Brukaren finst frå før.',
	'maintenance-invalidtitle' => 'Tittelen «$1» er ugyldig.',
	'maintenance-titlenoexist' => 'Den oppgjevne tittelen («$1») finst ikkje.',
	'maintenance-failed' => 'MISLUKKAST',
	'maintenance-deleted' => 'SLETTA',
	'maintenance-revdelete' => 'Slettar {{PLURAL:$3|versjonen|versjonane}} $1 frå wikien $2',
	'maintenance-revnotfound' => 'Fann ikkje versjonen $1.',
	'maintenance-showCacheStats-edits' => 'Tal på endringar: $1',
	'maintenance-showCacheStats-articles' => 'Tal på sider i hovudnamnerommet: $1',
	'maintenance-showCacheStats-pages' => 'Tal på sider: $1',
	'maintenance-showCacheStats-users' => 'Tal på brukarar: $1',
	'maintenance-showCacheStats-admins' => 'Tal på administratorar: $1',
	'maintenance-showCacheStats-images' => 'Tal på filer: $1',
	'maintenance-showCacheStats-views' => 'Tal på sidevisingar: $1',
	'maintenance-showCacheStats-update' => 'Oppdaterer databasen …',
	'maintenance-move' => 'Flyttar $1 til $2 …',
	'maintenance-movefail' => 'Feil oppstod under flytting: $1.
Stoggar flytting.',
	'maintenance-error' => 'Feil: $1',
	'maintenance-memc-fake' => 'Du køyrer ein FakeMemCachedClient. Ingen statistikk kan verta oppgjeven.',
	'maintenance-memc-requests' => 'Førespurnader',
	'maintenance-memc-withsession' => 'med økt:',
	'maintenance-memc-withoutsession' => 'utan økt:',
	'maintenance-memc-total' => 'totalt:',
	'maintenance-memc-parsercache' => 'Parsermellomlager',
	'maintenance-memc-hits' => 'treff:',
	'maintenance-memc-invalid' => 'ugyldig:',
	'maintenance-memc-expired' => 'gjekk ut:',
	'maintenance-memc-absent' => 'fråverande:',
	'maintenance-memc-stub' => 'spireterskel:',
	'maintenance-memc-imagecache' => 'Biletmellomlager',
	'maintenance-memc-misses' => 'gleppar:',
	'maintenance-memc-updates' => 'oppdateringar:',
	'maintenance-memc-uncacheable' => 'kan ikkje verta mellomlagra:',
	'maintenance-memc-diffcache' => 'Skilnadsmellomlager',
	'maintenance-reassignEdits' => 'Nytt dette skjemaet til å flytta endringar frå ein brukar til ein annan.',
	'maintenance-re-from' => 'Namnet på brukaren som skal endringane skal verta tekne frå',
	'maintenance-re-to' => 'Namnet på brukaren som skal få endringane',
	'maintenance-re-force' => 'Flytt endringar sjølv om målbrukar ikkje finst',
	'maintenance-re-rc' => 'Ikkje oppdater tabellen over siste endringar',
	'maintenance-re-report' => 'Skriv ut detaljar av det som ville ha vorte endra, men ikkje oppdater',
	'maintenance-re-nf' => 'Fann ikkje brukaren «$1»',
	'maintenance-re-rr' => 'Køyr skriptet omatt utan «$1» for å oppdatera.',
	'maintenance-re-ce' => 'Noverande endringar: $1',
	'maintenance-re-de' => 'Sletta endringar: $1',
	'maintenance-re-rce' => 'Bidrag på siste endringar: $1',
	'maintenance-re-total' => 'Endringar som skal verta endra: $1',
	'maintenance-re-re' => 'Flyttar endringar{{int:ellipsis}} gjort',
);

/** Occitan (occitan)
 * @author Cedric31
 */
$messages['oc'] = array(
	'maintenance' => 'Aviar los escripts de mantenença',
	'maintenance-desc' => '[[Special:Maintenance|Interfàcia Web]] pels diferents escripts de mantenença',
	'right-maintenance' => "Aviar d'escriptes de mantenença dempuèi [[Special:Maintenance]]",
	'maintenance-backlink' => "Retorn cap a la seleccion de l'escript",
	'maintenance-header' => "Seleccionatz, çaijós, un escript d'executar.
Las descripcions son a la seguida de cadun d'aquestes.",
	'maintenance-error-invalidtype' => 'Tipe incorrècte !', # Fuzzy
	'maintenance-option-confirm' => 'Confirmar',
	'maintenance-output-success' => '$1 a marchat amb succès !',
	'maintenance-changePassword' => 'Utilizar aqueste formulari per cambiar lo senhal d’un utilizaire',
	'maintenance-changePassword-desc' => 'Cambiar lo senhal d’un utilizaire',
	'maintenance-createAndPromote' => 'Utilizar aqueste formulari per crear un utilizaire novèl e per lo promòure administrator.
Marcar la casa burocrata se li desiratz conferir tanben aqueste estatut.',
	'maintenance-createAndPromote-desc' => "Crear un utilizaire e promòure a l'estatut d’administrator",
	'maintenance-deleteBatch' => 'Utilizatz aqueste formulari per suprimir en massa de paginas/
Indicar una sola pagina per linha',
	'maintenance-deleteBatch-desc' => 'Supression en massa de las paginas',
	'maintenance-deleteRevision' => 'Utilizatz aqueste formulari per suprimir en massa las versions.
Indicatz una sola version per linha',
	'maintenance-deleteRevision-desc' => 'Levar las versions de la banca de donadas',
	'maintenance-initEditCount-desc' => 'Tornar calcular los comptadors d’edicions dels utilizaires',
	'maintenance-initSiteStats' => 'Utilizatz aqueste formulari per tornar calcular las estatisticas del site, en indicant, se fa mestièr, se desiratz lo recalcul del nombre de visitas per pagina.',
	'maintenance-initSiteStats-desc' => 'Tornar calcular las estatisticas del site',
	'maintenance-moveBatch' => 'Utilizatz aqueste formulari per desplaçar en massa las paginas.
Cada linha deurà indicar la pagina d’origina e la de destinacion ; las qualas deuràn èsser separadas per un « <nowiki>|</nowiki> »',
	'maintenance-moveBatch-desc' => 'Cambiament de nom en massa de las paginas',
	'maintenance-reassignEdits-desc' => "Tornar assignar de modificacions d'un utilizaire cap a un autre",
	'maintenance-runJobs-desc' => "Aviar los prètzfaches dins la lista de los d'acomplir",
	'maintenance-showJobs-desc' => "Afichar una lista dels prètzfaches en cors dins la lista de los d'acomplir",
	'maintenance-sql' => 'Utilizatz aquesta forma per executar una requèsta SQL sus la banca de donadas.',
	'maintenance-sql-desc' => 'Executar una requèsta SQL',
	'maintenance-showCacheStats-desc' => 'Afichar las estatisticas de la memòria-escondedor',
	'maintenance-eval' => 'Utilizatz aquesta forma per avalorar lo còde PHP dins un environament MediaWiki.',
	'maintenance-eval-desc' => "Avalorar un còde PHP dins l'environament MediaWiki",
	'maintenance-update' => "Utilizar UPDATE al moment de la mesa a jorn d'una taula ? Desmarcatz l'usatge DELETE/INSERT al luòc d'aquò.",
	'maintenance-noviews' => 'Marcar aquò per evitar la mesa a jorn del nombre de visitas de las paginas.',
	'maintenance-invalidname' => 'Nom d’utilizaire incorrècte !',
	'maintenance-userexists' => 'L’utilizaire existís ja !',
	'maintenance-invalidtitle' => 'Títol incorrècte « $1 » !',
	'maintenance-titlenoexist' => 'Lo títol indicat (« $1 ») existís pas !',
	'maintenance-failed' => 'FRACÀS',
	'maintenance-deleted' => 'SUPRIMIT',
	'maintenance-revdelete' => 'Supression {{PLURAL:$3|de la revision|de las revisions}} $1 del wiki $2',
	'maintenance-revnotfound' => 'Version $1 introbabla !',
	'maintenance-showCacheStats-edits' => 'Nombre d’edicions : $1',
	'maintenance-showCacheStats-articles' => 'Nombre de paginas dins lo meteis espaci : $1',
	'maintenance-showCacheStats-pages' => 'Nombre de paginas : $1',
	'maintenance-showCacheStats-users' => "Nombre d'utilizaires : $1",
	'maintenance-showCacheStats-admins' => "Nombre d'administrators : $1",
	'maintenance-showCacheStats-images' => 'Nombre de fichièrs : $1',
	'maintenance-showCacheStats-views' => 'Nombre de paginas visitadas : $1',
	'maintenance-showCacheStats-update' => 'Mesa a jorn de la banca de donadas…',
	'maintenance-move' => 'Desplaçament de $1 cap a $2…',
	'maintenance-movefail' => 'Error constatada al moment del cambiament de nom : $1.
Arrèst del desplaçament.',
	'maintenance-error' => 'Error : $1',
	'maintenance-memc-fake' => "Sètz a aviar FakeMemCachedClient. Cap d'estatistica serà pas provesida.",
	'maintenance-memc-requests' => 'Requèstas',
	'maintenance-memc-withsession' => 'amb la sesilha :',
	'maintenance-memc-withoutsession' => 'sens la sesilha :',
	'maintenance-memc-total' => 'soma :',
	'maintenance-memc-parsercache' => 'Escondedor del parser',
	'maintenance-memc-hits' => 'clics :',
	'maintenance-memc-invalid' => 'invalid :',
	'maintenance-memc-expired' => 'expirats :',
	'maintenance-memc-absent' => 'absent :',
	'maintenance-memc-stub' => 'sulhèt de despart :',
	'maintenance-memc-imagecache' => 'Escondedor imatge',
	'maintenance-memc-misses' => 'perduts :',
	'maintenance-memc-updates' => 'meses a jorn :',
	'maintenance-memc-uncacheable' => "fòra de l'amagatal :",
	'maintenance-memc-diffcache' => 'Escondedor dels dif',
	'maintenance-reassignEdits' => "Utilizatz aqueste formulari per tornar assignar de modificacions d'un utilizaire cap a un autre.",
	'maintenance-re-from' => "Nom de l'utilizaire al qual préner las modificacions",
	'maintenance-re-to' => "Nom de l'utilizaire al qual assignar las modificacions",
	'maintenance-re-force' => "Tornar assignar quitament se l'utilizaire cibla existís pas",
	'maintenance-re-rc' => 'Modificar pas la taula dels darrièrs cambiaments',
	'maintenance-re-report' => 'Afichar los detalhs de çò que va èsser modificat, mas sens metre a jorn las donadas',
	'maintenance-re-nf' => "L'utilizaire « $1 » es pas estat trobat",
	'maintenance-re-rr' => "Aviar tornmai l'escript sens metre a jorn « $1 ».",
	'maintenance-re-ce' => 'Modificacions actualas : $1.',
	'maintenance-re-de' => 'Modificacions suprimidas : $1',
	'maintenance-re-rce' => 'Entradas dins la taula dels darrièrs cambiaments : $1',
	'maintenance-re-total' => 'Nombre total de modificacions de modificar : $1',
	'maintenance-re-re' => 'Reafectacion dels cambiaments{{int:ellipsis}} fach',
);

/** Oriya (ଓଡ଼ିଆ)
 * @author Odisha1
 * @author Psubhashish
 */
$messages['or'] = array(
	'maintenance-generic-done' => 'କରାଯାଇଛି',
	'maintenance-generic-reason' => 'କାରଣ',
	'maintenance-option-confirm' => 'ନିଶ୍ଚିତ କରନ୍ତୁ',
	'maintenance-checkBadRedirects-output-footer' => 'କରାଯାଇଛି.',
	'maintenance-memc-requests' => 'ଅନୁରୋଧ',
	'maintenance-memc-updates' => 'ଅଦ୍ୟତନ:',
);

/** Ossetic (Ирон)
 * @author Amikeco
 */
$messages['os'] = array(
	'maintenance-deleted' => 'АППÆРСТ',
);

/** Deitsch (Deitsch)
 * @author Xqt
 */
$messages['pdc'] = array(
	'maintenance-generic-done' => 'geduh',
	'maintenance-generic-username' => 'Yuuser-Naame',
	'maintenance-generic-password' => 'Paesswatt',
	'maintenance-checkBadRedirects-output-footer' => 'Geduh.',
	'maintenance-deleted' => 'VERWISCHT',
);

/** Polish (polski)
 * @author BeginaFelicysym
 * @author Maikking
 * @author McMonster
 * @author Sp5uhe
 * @author Woytecr
 */
$messages['pl'] = array(
	'maintenance' => 'Uruchom skrypty konserwacyjne',
	'maintenance-desc' => '[[Special:Maintenance|Interfejs]] dla różnych skryptów konserwacyjnych',
	'right-maintenance' => 'Uruchamianie skryptów konserwacyjnych z wykorzystaniem [[Special:Maintenance]]',
	'maintenance-backlink' => 'Wróć do wyboru skryptu',
	'maintenance-header' => 'Wybierz skrypt, który chcesz uruchomić.
Przy nazwach skryptów znajdują się ich opisy.',
	'maintenance-error-badini' => 'Plik metadata.ini jest uszkodzony lub nie istnieje. Proszę pobrać ponownie rozszerzenie konserwacji',
	'maintenance-error-invalidtype' => 'Wskazany skrypt nie został znaleziony',
	'maintenance-error-badargs' => 'Nie określono wszystkich wymaganych opcji',
	'maintenance-generic-done' => 'gotowe',
	'maintenance-generic-username' => 'Nazwa użytkownika',
	'maintenance-generic-password' => 'Hasło',
	'maintenance-generic-reason' => 'Powód',
	'maintenance-cleanupTable-dry-run' => 'Wykonaj próbę generalną',
	'maintenance-cleanupTable-check' => 'Trwa sprawdzanie złych tytułów...',
	'maintenance-cleanupTable-checkfix' => 'Sprawdzanie i korekta złych tytułów...',
	'maintenance-cleanupTable-progress' => '$1 $2: $3% zakończono w czasie $4; ETA $5 [$6/$7] $8/sek <zmieniono $9%>',
	'maintenance-cleanupTable-missingparam' => '$1: Brak parametru $2',
	'maintenance-cleanupTable-processing' => 'Przetwarzanie $1...',
	'maintenance-cleanupTable-finished' => 'Zakończono $1... zaktualizowano $2 z $3 {{PLURAL:$3|wiersza|wierszy|wierszy}}',
	'maintenance-option-quiet' => 'Pominięcie na wyjściu wszystkiego co nie jest błędem',
	'maintenance-option-globals' => 'Globalne dane wyjściowe na końcu przetwarzania w celu debugowania',
	'maintenance-option-confirm' => 'Potwierdź',
	'maintenance-option-batch-size' => 'Uruchom tyle operacji na wsad, domyślnie: $1',
	'maintenance-option-required' => '(wymagane)',
	'maintenance-option-optional' => '(opcjonalne)',
	'maintenance-output-success' => '$1 wykonany pomyślnie!',
	'maintenance-output-failure' => '$1 nie został wykonany pomyślnie!',
	'maintenance-attachLatest' => 'Ten formularz służy do ustalenia wpisów tabeli stron gdzie page_latest jest ustawiona na 0',
	'maintenance-attachLatest-desc' => 'Ustalenie wpisów page_latest w tabeli stron',
	'maintenance-attachLatest-option-fix' => 'Obecnie naprawia zapisy, w przeciwnym przepadku wykona przebieg testowy',
	'maintenance-attachLatest-output-begin' => 'Wyszukiwanie stron z page_latest ustawionym na 0...',
	'maintenance-attachLatest-output-notime' => '$1 $2 [[$3]] nie można odnaleźć czasu ostatniej wersji?!',
	'maintenance-attachLatest-output-norev' => '$1 $2 [[$3]] najnowsza data $4, nie udało się odnaleźć id wersji',
	'maintenance-attachLatest-output-found' => '$1 $2 [[$3]] najnowsza data $4, id wersji $5',
	'maintenance-attachLatest-output-done' => 'Gotowe! Przetworzono $1 {{PLURAL:$1|stronę|strony|stron}}.',
	'maintenance-attachLatest-output-dryrun' => 'To był suchy przebieg; uruchom ponownie z "{{int:maintenance-attachLatest-option-fix}}" by zaktualizować page_latest.',
	'maintenance-benchmarkPurge' => 'Skorzystaj z tego formularza by sprawdzić, jak dużo czasu zajmują funkcje oczyszczania Squid',
	'maintenance-benchmarkPurge-desc' => 'Benchmark funkcji oczyszczania Squid',
	'maintenance-benchmarkPurge-option-count' => 'Jak wieloma URLami napełnić Squid przed czyszczeniem',
	'maintenance-benchmarkPurge-error-nosquid' => 'Benchmark oczyszczania Squid nie przyda się na wiele bez aktywowania obsługi Squid.',
	'maintenance-benchmarkPurge-output-numsquids' => 'Zdefiniowano $1 {{PLURAL:$1|serwer|serwery|serwerów}} Squid:',
	'maintenance-benchmarkPurge-output-trial' => '$1 {{PLURAL:$1|tytuł|tytuły|tytułów}} w  $2ms ($3ms każdy)',
	'maintenance-changePassword' => 'Użyj tego formularza, by zmienić hasło użytkownika',
	'maintenance-changePassword-desc' => 'Zmień hasło użytkownika',
	'maintenance-changePassword-error-nouser' => 'Nie istnieje użytkownik: $1.',
	'maintenance-changePassword-output-set' => 'Ustawiono hasło dla $1',
	'maintenance-checkAutoLoader' => 'Ten formularz służy do wykonania pewnych sprawdzeń integralności AutoLoadera',
	'maintenance-checkAutoLoader-output-list2' => '$1: Niewłaściwy plik: znaleziony w $2, wymieniony w $3',
	'maintenance-checkBadRedirects' => 'Ten formularz służy do sprawdzenia, czy strony oznaczone jako przekierowania są naprawdę przekierowaniami',
	'maintenance-checkBadRedirects-desc' => 'Sprawdź w poszukiwaniu nieprawidłowych przekierowań',
	'maintenance-checkBadRedirects-output-header' => 'Pobieranie przekierowań...',
	'maintenance-checkBadRedirects-output-found' => 'Znaleziono $1 {{PLURAL:$1|przekierowanie|przekierowania|przekierowań}}.
Trwa sprawdzanie niepoprawnych przekierowań...',
	'maintenance-checkBadRedirects-output-footer' => 'Gotowe.',
	'maintenance-checkImages-desc' => 'Sprawdzenie obrazów, czy istnieją, są czytelne, itp',
	'maintenance-checkImages-output-noaccess' => '$1: niedostępny lokalnie',
	'maintenance-checkImages-output-missing' => '$1: brak',
	'maintenance-checkImages-output-isdir' => '$1: jest katalogiem',
	'maintenance-checkImages-output-truncated' => '$1: obcięto, było $2',
	'maintenance-checkImages-output-good' => 'Poprawne obrazy:  $1/$2',
	'maintenance-checkSyntax' => 'Ten formularz umożliwia sprawdzenie składni wszystkich plików PHP MediaWiki',
	'maintenance-checkSyntax-desc' => 'Sprawdzanie składni dla wszystkich plików PHP w MediaWiki',
	'maintenance-checkSyntax-option-with-extensions' => 'Sprawdzić również folder rozszerzeń',
	'maintenance-checkSyntax-option-list-file' => 'Lista plików oraz katalogów do sprawdzenia',
	'maintenance-checkSyntax-option-modified' => 'Sprawdź tylko te pliki, które zostały zmienione (wymaga klienta svn wiersza polecenia)',
	'maintenance-checkSyntax-output-svnlist' => 'Trwa pobieranie listy z Subversion...',
	'maintenance-checkSyntax-output-buildlist' => 'Trwa budowanie listy plików...',
	'maintenance-checkSyntax-output-error' => 'Błąd w $1 linia $2: $3',
	'maintenance-checkSyntax-output-warning' => 'Ostrzeżenie w pliku $1: znaleziono $2',
	'maintenance-checkSyntax-error-nofile' => 'Błąd: nie można odnaleźć pliku lub katalogu $1',
	'maintenance-checkSyntax-error-cantopen' => 'Nie można otworzyć pliku $1',
	'maintenance-checkSyntax-error-svnerr' => 'Błąd pobierania listy z Subversion!',
	'maintenance-checkUsernames-desc' => 'Sprawdzenie, czy użytkownicy z bazy danych są rzeczywiście poprawni',
	'maintenance-cleanupCaps' => 'Ten formularz służy do napraw zerwanie połączeń do stron spowodowane przez zmodyfikowanie $wgCapitalLinks',
	'maintenance-cleanupCaps-desc' => 'Skrypt do oczyszczania z wielkich liter',
	'maintenance-cleanupCaps-output-islower' => '" $1 " już zapisane małymi literami.',
	'maintenance-cleanupCaps-output-clash' => '" $1 " pominięto; " $2 " już istnieje',
	'maintenance-cleanupCaps-output-dryrun' => '" $1 "->" $2 ": PRZEBIEG TESTOWY, NIE PRZENIESIONO',
	'maintenance-cleanupCaps-error-noneed' => '$wgCapitalLinks jest włączona -- nie potrzeba czyszczenia ogranicza łącz z wielkich liter.',
	'maintenance-cleanupSpam-desc' => 'Wyczyścić wszystkie wiadomości-śmieci z hosta o wskazanej nazwie',
	'maintenance-cleanupSpam-option-hostname' => 'Nazwa hosta, który rozsyłał spam',
	'maintenance-cleanupSpam-output-found' => 'Znaleziono $1 {{PLURAL:$1|artykuł zawierający|artykuły zawierające|artykułów zawierających}} $2',
	'maintenance-cleanupSpam-output-false' => 'Niepoprawne dopasowanie',
	'maintenance-cleanupSpam-output-blanking' => 'czyszczenie',
	'maintenance-cleanupSpam-output-reverting' => 'wycofanie',
	'maintenance-cleanupSpam-error-invalid' => 'Nieprawidłowa specyfikacja nazwy hosta: $1',
	'maintenance-cleanupSpam-error-noid' => 'Błąd wewnętrzny: brak strony o identyfikatorze $1',
	'maintenance-clearInterwikiCache' => 'Ten formularz służy do całkowitego wyczyszczenia pamięci podręcznej interwiki',
	'maintenance-clearInterwikiCache-desc' => 'Wyczyść wszystkie łącza innych wiki dla wszystkich języków z pamięci podręcznej',
	'maintenance-createAndPromote' => 'Użyj tego formularza, by utworzyć nowe konto użytkownika i nadać mu uprawnienia administratora.
Zaznacz pole wyboru poniżej, aby przyznać mu również uprawnienia biurokraty.',
	'maintenance-createAndPromote-desc' => 'Utwórz użytkownika i nadaj mu uprawnienia administratora',
	'maintenance-createAndPromote-error-password' => 'Wystąpił błąd z wprowadzonym hasłem: $1',
	'maintenance-deleteBatch' => 'Używaj tego formularza do masowego usuwania stron.
W każdej linijce podaj tylko jedną nazwę strony.',
	'maintenance-deleteBatch-desc' => 'Usuń masowo strony',
	'maintenance-deleteRevision' => 'Używaj tego formularza do masowego usuwania wersji artykułów.
W każdej linijce podaj tylko jeden numer wersji artykułu.',
	'maintenance-deleteRevision-desc' => 'Usuwanie wersji z bazy danych',
	'maintenance-initEditCount-desc' => 'Przelicz ponownie liczniki edycji użytkowników',
	'maintenance-initSiteStats' => 'Formularz pozwala na przeliczanie statystyk witryny, z możliwością wymuszenia przeliczenia również liczby odsłon',
	'maintenance-initSiteStats-desc' => 'Przelicz ponownie statystyki strony',
	'maintenance-moveBatch' => 'Formularz służy do masowego przenoszenia stron. 
W każdym wierszu należy określić stronę źródłową oraz stronę docelową rozdzielając je pionową kreską',
	'maintenance-moveBatch-desc' => 'Przenieś masowo strony',
	'maintenance-reassignEdits-desc' => 'Przypisanie edycji jednego użytkownika drugiemu',
	'maintenance-runJobs-desc' => 'Uruchom zadania z kolejki',
	'maintenance-runJobs-option-maxjobs' => 'Maksymalna liczba wykonywanych zadań',
	'maintenance-runJobs-option-type' => 'Rodzaj uruchamianego zadania',
	'maintenance-runJobs-option-procs' => 'Liczba procesów do wykorzystania',
	'maintenance-runJobs-option-exclusive' => 'Wykonaj tylko i wyłącznie jeden skrypt runJobs na raz. Limit czasu to 1800 sekund.',
	'maintenance-runJobs-error-invalidprocs' => 'Należy wskazać od 1 do 1000 procesów',
	'maintenance-showJobs-desc' => 'Pokaż kolejkę zadań oczekujących na wykonanie',
	'maintenance-showJobs-option-group' => 'Pokazuj liczbę zadań na typ zadania',
	'maintenance-sql' => 'Formularz ten służy do wykonania zapytania SQL do bazy danych.',
	'maintenance-sql-desc' => 'Wykonywanie zapytań SQL',
	'maintenance-sql-option-file' => 'SQL do wykonania',
	'maintenance-sql-output-aff' => 'Zapytanie OK, dotyczy $1 {{PLURAL:$1| wiersza|wierszy|wierszy}}',
	'maintenance-sql-error-cantopen' => 'Nie można otworzyć pliku wejściowego',
	'maintenance-showCacheStats-desc' => 'Statystyki pamięci podręcznej',
	'maintenance-eval' => 'Formularz ten służy do oceny kodu PHP w środowisku MediaWiki.',
	'maintenance-eval-desc' => 'Sprawdzanie kodu PHP w środowisku MediaWiki',
	'maintenance-update' => 'Użyj UPDATE do aktualizacji tabel. Alternatywą jest zestawienie poleceń DELETE i INSERT.',
	'maintenance-noviews' => 'Zaznacz aby zapobiec aktualizacji liczników odsłon stron',
	'maintenance-invalidname' => 'Nieprawidłowa nazwa użytkownika!',
	'maintenance-userexists' => 'Użytkownik już istnieje!',
	'maintenance-invalidtitle' => 'Niepoprawny tytuł „$1”!',
	'maintenance-titlenoexist' => 'Wybrana nazwa „$1” nie istnieje!',
	'maintenance-failed' => 'NIEPOWODZENIE',
	'maintenance-deleted' => 'USUNIĘTO',
	'maintenance-revdelete' => 'Usuwanie {{PLURAL:$3|wersji|wersji:}} $1 z wiki $2',
	'maintenance-revnotfound' => 'Wersja $1 nie została odnaleziona!',
	'maintenance-showCacheStats-edits' => 'Liczba edycji $1',
	'maintenance-showCacheStats-articles' => 'Liczba stron w głównej przestrzeni nazw $1',
	'maintenance-showCacheStats-pages' => 'Liczba stron: $1',
	'maintenance-showCacheStats-users' => 'Liczba użytkowników: $1',
	'maintenance-showCacheStats-admins' => 'Liczba administratorów: $1',
	'maintenance-showCacheStats-images' => 'Liczba plików: $1',
	'maintenance-showCacheStats-views' => 'Liczba odwiedzin strony: $1',
	'maintenance-showCacheStats-update' => 'Aktualizacja bazy danych{{int:ellipsis}}',
	'maintenance-move' => 'Przenoszenie $1 do $2{{int:ellipsis}}',
	'maintenance-movefail' => 'Wystąpił błąd przy przenoszeniu $1.
Przenoszenie przerwane.',
	'maintenance-error' => 'Błąd: $1',
	'maintenance-memc-fake' => 'Korzystasz z FakeMemCachedClient. Statystyk brak',
	'maintenance-memc-requests' => 'Żądania',
	'maintenance-memc-withsession' => 'z sesją',
	'maintenance-memc-withoutsession' => 'bez sesji',
	'maintenance-memc-total' => 'łącznie',
	'maintenance-memc-parsercache' => 'Pamięć podręczna analizatora składni',
	'maintenance-memc-hits' => 'trafienia',
	'maintenance-memc-invalid' => 'nieważne',
	'maintenance-memc-expired' => 'przeterminowane',
	'maintenance-memc-absent' => 'nieobecne',
	'maintenance-memc-stub' => 'próg zalążków',
	'maintenance-memc-imagecache' => 'Obraz pamięci podręcznej',
	'maintenance-memc-misses' => 'nietrafionych',
	'maintenance-memc-updates' => 'aktualizacje:',
	'maintenance-memc-uncacheable' => 'nieobsługiwane przez pamięć podręczną',
	'maintenance-memc-diffcache' => 'Różnica w pamięci podręcznej',
	'maintenance-reassignEdits' => 'Formularz ten służy do przypisania edycji jednego użytkownika drugiemu.',
	'maintenance-re-from' => 'Nazwa użytkownika, którego edycje mają być przypisane',
	'maintenance-re-to' => 'Nazwa użytkownika, któremu edycje mają być przypisane',
	'maintenance-re-force' => 'Przypisz nawet jeśli użytkownik docelowy nie istnieje',
	'maintenance-re-rc' => 'Nie aktualizuj ostatnich zmian',
	'maintenance-re-report' => 'Pokaż jakie zmiany zostaną wprowadzone, ale ich nie wykonuj',
	'maintenance-re-nf' => 'Nie odnaleziono użytkownika $1',
	'maintenance-re-rr' => 'Uruchom skrypt ponownie, ale bez „$1”.',
	'maintenance-re-ce' => 'Obecnie {{PLURAL:$1|jest $1 edycja|są $1 edycje|jest $1 edycji}}',
	'maintenance-re-de' => 'Usunięto $1 {{PLURAL:$1|edycję|edycje|edycji}}',
	'maintenance-re-rce' => '$1 {{PLURAL:$1|wpis|wpisy|wpisów}} w ostatnich zmianach',
	'maintenance-re-total' => '{{PLURAL:$1|Jest $1 wpis|Są $1 wpisy|Jest $1 wpisów}} do zmienienia',
	'maintenance-re-re' => 'Edycje przypisano',
);

/** Piedmontese (Piemontèis)
 * @author Borichèt
 * @author Dragonòt
 */
$messages['pms'] = array(
	'maintenance' => 'Fa giré script ëd manutension',
	'maintenance-desc' => '[[Special:Maintenance|Antërfacia Wiki]] për vàire script ëd manutension',
	'right-maintenance' => 'Fa giré un senari ëd manutension con [[Special:Maintenance]]',
	'maintenance-backlink' => 'André a la selession dël senari',
	'maintenance-header' => "Për piasì ch'a selession-a un senari sì-sota da fé giré.
Le descrission a son tacà a minca senari",
	'maintenance-error-badini' => "L'archivi metadata.ini a l'é o pa bon o mancant. Për piasì dëscaria torna l'estension ëd Manutension",
	'maintenance-error-invalidtype' => "Ël copion specificà a l'é pa stàit trovà",
	'maintenance-error-badargs' => "A l'ha pa specificà tute j'opsion obligatòrie",
	'maintenance-generic-done' => 'fàit',
	'maintenance-generic-username' => 'Stranòm',
	'maintenance-generic-password' => 'Ciav',
	'maintenance-generic-reason' => 'Rason',
	'maintenance-cleanupTable-dry-run' => 'Fe marcé sensa modifiché la base ëd dàit',
	'maintenance-cleanupTable-check' => 'Control dij tìtoj pa bon...',
	'maintenance-cleanupTable-checkfix' => 'Control e coression dij tìtoj pa bon...',
	'maintenance-cleanupTable-progress' => '$1 $2: $3% fàit ël $4; ETA $5 [$6/$7] $8/sec <$9% agiornà>',
	'maintenance-cleanupTable-missingparam' => '$1: Paràmetr mancant $2',
	'maintenance-cleanupTable-processing' => 'Traté $1...',
	'maintenance-cleanupTable-finished' => 'Finì $1... $2 ëd $3 {{PLURAL:$3|riga|righe}} modificà',
	'maintenance-option-quiet' => "Sganfé la surtìa ëd tut lòn ch'a l'é pa n'eror",
	'maintenance-option-globals' => 'Smon-e le variàbij globaj a la fin dël tratament për eliminé ij givo',
	'maintenance-option-confirm' => 'Conferma',
	'maintenance-option-batch-size' => 'Fé andé tute coste operassion për baron, predefinì: $1',
	'maintenance-option-required' => '(obligatòri)',
	'maintenance-option-optional' => '(opsional)',
	'maintenance-output-success' => "$1 a l'ha girà da bin!",
	'maintenance-output-failure' => "$1 a l'ha pa marcià da bin!",
	'maintenance-attachLatest' => "Ch'a deuvra ës formolari për corege le vos ant la tàula dla pàgina anté che page_latest a l'é ampostà a 0",
	'maintenance-attachLatest-desc' => 'Corege le vos page_latest ant la tàula dla pàgina',
	'maintenance-attachLatest-option-fix' => 'Corege për da bon le vos, dësnò a marcërà sensa fé dle coression',
	'maintenance-attachLatest-output-begin' => 'Arserca dle pàgine con page_latest ampostà a 0...',
	'maintenance-attachLatest-output-notime' => "$1 $2 [[$3]] as peul nen trovess la dàita dl'ùltima revision?",
	'maintenance-attachLatest-output-norev' => "$1 $2 [[$3]] ùltima vira $4, as peul pa trovesse l'id ëd la revision",
	'maintenance-attachLatest-output-found' => '$1 $2 [[$3]] ùltima vira $4, id ëd la revision $5',
	'maintenance-attachLatest-output-done' => 'Fàit! Tratà $1 {{PLURAL:$1|pagina|pagine}}.',
	'maintenance-attachLatest-output-dryrun' => "Costa a l'era na preuva; ch'a lo fasa torna andé con «{{int:maintenance-attachLatest-option-fix}}» për modifiché page_latest.",
	'maintenance-benchmarkPurge' => "Ch'a deuvra ës formolari për ëmzuré ël temp ch'a duro le funsion ëd purga dë Squid",
	'maintenance-benchmarkPurge-desc' => 'Valuté le funsion ëd purga dë Squid',
	'maintenance-benchmarkPurge-option-count' => 'Vàire anliure deje a Squid da purghé',
	'maintenance-benchmarkPurge-error-nosquid' => "La preuva ëd purga dë Squid a fà pa tant sensa l'apògg dë Squid anvisch.",
	'maintenance-benchmarkPurge-output-numsquids' => 'A-i son $1 {{PLURAL:$1|servent}} Squid definì:',
	'maintenance-benchmarkPurge-output-trial' => '$1 {{PLURAL:$1|tìtol|tìtoj}} an $2ms ($3ms mincadun)',
	'maintenance-changePassword' => "Dovré ës formolari për cangé na ciav ëd n'utent",
	'maintenance-changePassword-desc' => 'Cangia na ciav utent',
	'maintenance-changePassword-error-nouser' => 'Pa gnun utent: $1.',
	'maintenance-changePassword-output-set' => 'Ciav ampostà për $1',
	'maintenance-checkAutoLoader' => "Ch'a deuvra 's formolari për fé chèich contròj ëd bon fonsionament dël carior automàtich",
	'maintenance-checkAutoLoader-desc' => 'Contròj ëd bon fonsionament dël carior automàtich',
	'maintenance-checkAutoLoader-output-list2' => '$1: Archivi pa bon: trovà an $2, listà an $3',
	'maintenance-checkBadRedirects' => "Ch'a deuvra 's formolari për vëdde se le pàgine marcà tanme ridiression a son për da bon dle ridiression",
	'maintenance-checkBadRedirects-desc' => 'Sërché dle ridiression nen bon-e',
	'maintenance-checkBadRedirects-output-header' => 'Arcuperassion dle ridiression...',
	'maintenance-checkBadRedirects-output-found' => 'Trovà $1 {{PLURAL:$1|ridiression}}.
Arserca dle ridiression nen bon-e...',
	'maintenance-checkBadRedirects-output-footer' => 'Fàit.',
	'maintenance-checkImages' => "Ch'a deuvra ës formolari për vëdde che figure dzora soa wiki a son danegià",
	'maintenance-checkImages-desc' => "Controlé le figure për vëdde s'a esisto, s'a son lesibij, e via fòrt",
	'maintenance-checkImages-output-noaccess' => '$1: pa acessibij localment',
	'maintenance-checkImages-output-missing' => '$1: mancant',
	'maintenance-checkImages-output-isdir' => "$1: a l'é na cartela",
	'maintenance-checkImages-output-truncated' => "$1: troncà, a l'era $2",
	'maintenance-checkImages-output-mismatch' => "$1: dimension ch'a corëspond pa, base ëd dàit=$2, vera=$3",
	'maintenance-checkImages-output-good' => 'Figure bon-e: $1/$2',
	'maintenance-checkSyntax' => "Ch'a deuvra ës formolari për controlé la sintassi ëd tùit j'archivi PHP an MediaWiki",
	'maintenance-checkSyntax-desc' => "Controlé la sintassi ëd tùit j'archivi PHP an MediaWiki",
	'maintenance-checkSyntax-option-with-extensions' => "Ëdcò ricorsivament an sla cartela d'estension",
	'maintenance-checkSyntax-option-path' => 'Përcors specìfich (archivi o dossié) da controlé, o bin con ël përcors assolù opura con col relativ a la rèis ëd costa istalassion ëd MediaWiki',
	'maintenance-checkSyntax-option-list-file' => "Lista d'archivi o dossié da controlé",
	'maintenance-checkSyntax-option-modified' => "Controlé mach j'archivi ch'a son stàit modificà (a l'ha damanca dël client svn an linia ëd comand)",
	'maintenance-checkSyntax-option-syntax-only' => "Controlé mach la validità dla sintassi, ignoré j'avis an slë stil dël còdes",
	'maintenance-checkSyntax-output-parsekit' => 'Contròl ëd la sintassi (dovrand parsekit)',
	'maintenance-checkSyntax-output-phpl' => 'Contròl ëd la sintassi (dovrand php -l, sòn a peul pijé motobin ëd temp)',
	'maintenance-checkSyntax-output-footer' => 'Fàit! $1 archivi controlà, trovà $2 faliment e $3 avis',
	'maintenance-checkSyntax-output-svnlist' => 'Arcuperassion dla lista da Sot-version...',
	'maintenance-checkSyntax-output-buildlist' => "Costrussion ëd la lista d'archivi...",
	'maintenance-checkSyntax-output-error' => 'Eror an $1 linia $2: $3',
	'maintenance-checkSyntax-output-warning' => "Avis ant l'archivi $1: $2 trovà",
	'maintenance-checkSyntax-error-nofile' => "Eror: as peul pa trovesse l'archivi o ël dossié $1",
	'maintenance-checkSyntax-error-cantopen' => "As peul pa deurbse l'archivi $1",
	'maintenance-checkSyntax-error-svnerr' => "Eror durant l'arcuperassion ëd la lista da Sot-version!",
	'maintenance-checkUsernames' => "Ch'a deuvra ës formolaria për visualisé che stranòm d'utent a son pa bon a càusa ëd modìfiche ëd la configurassion. Se gnente a l'é listà apress avèj fàit core ël copion, tùit jë stranòm d'utent a son bon",
	'maintenance-checkUsernames-desc' => "Verifiché che jë stranòm d'utent ëd la base ëd dàit a sio efetivament bon",
	'maintenance-checkUsernames-error-notvalid' => "Stranòm d'utent nen bon: «$3» (id utent $2)",
	'maintenance-cleanupCaps' => 'Ch\'a deuvra sto formolari për corege le pàgine rote për via dla modìfica ëd $wgCapitalLinks',
	'maintenance-cleanupCaps-desc' => 'Copion për polidé la majùscolassion',
	'maintenance-cleanupCaps-option-namespace' => 'Nùmer ëd lë spassi nominal andoa polidé le majùscole',
	'maintenance-cleanupCaps-output-islower' => '«$1» già an minùscole.',
	'maintenance-cleanupCaps-output-clash' => '"$1" sautà; "$2" a esist già',
	'maintenance-cleanupCaps-output-dryrun' => '«$1» -> «$2»: VIRA ËD PREUVA, PA TRAMUDÀ',
	'maintenance-cleanupCaps-error-noneed' => '$wgCapitalLinks a l\'é ativ -- a-i è pa dabzògn ëd polidé le liure con majùscola.',
	'maintenance-cleanupSpam' => "Ch'a deuvra ës formolari për anulé le modìfiche dla rumenta che a ponto vers dij sit estern",
	'maintenance-cleanupSpam-desc' => "Polidé tuta la rumenta da un nòm d'òspit dàit",
	'maintenance-cleanupSpam-option-hostname' => "Nòm d'òspit che a l'ha mandà la rumenta",
	'maintenance-cleanupSpam-output-found' => 'Trovà $1 {{PLURAL:$1|artìcol|artìcoj}} contenent $2',
	'maintenance-cleanupSpam-output-false' => 'Fàussa corispondensa',
	'maintenance-cleanupSpam-output-blanking' => 'dësvuidament',
	'maintenance-cleanupSpam-output-reverting' => 'anulé',
	'maintenance-cleanupSpam-error-invalid' => "Nen na specificassion d'un nòm d'òspit bon: $1",
	'maintenance-cleanupSpam-error-noid' => "Eror antern: gnun-a pàgine për l'ID $1",
	'maintenance-clearInterwikiCache' => "Ch'a deuvra ëd formolari për scancelé completament la memòria local antërwiki",
	'maintenance-clearInterwikiCache-desc' => 'Scancelé tute le liure antërwiki për tute le lenghe da la memòria local',
	'maintenance-createAndPromote' => "Dovré ës formolari për creé un neuv utent e promeuvlo a aministrator.
Marché la casela mangiapapé s'a veul ëdcò promeuvlo a mangiapapé",
	'maintenance-createAndPromote-desc' => "Creé n'utent e promeuvlo a aministrator",
	'maintenance-createAndPromote-option-bureaucrat' => "Promeuv l'utent a lë stat ëd mangiapapé",
	'maintenance-createAndPromote-output-creating' => 'Creé e promeuve {{ns:user}}:$2...',
	'maintenance-createAndPromote-error-password' => "A l'é rëscontrasse n'eror con la ciav ch'a l'ha butà: $1",
	'maintenance-deleteBatch' => 'Dovré ës formolari për scancelé dle pàgine a bocc.
Buté mach na pàgina për linia',
	'maintenance-deleteBatch-desc' => 'Scancelassion ëd pàgine a bocc',
	'maintenance-deleteRevision' => 'Dovré ës formolari për scancelé dle revision a bocc.
Buté mach un nùmer ëd revision për linia',
	'maintenance-deleteRevision-desc' => 'Gava revision dal database',
	'maintenance-initEditCount-desc' => "Torna calcolé ij conteur ëd modìfiche dj'utent",
	'maintenance-initSiteStats' => "Dovré ës formolari për calcolé torna le statìstiche dël sit, spessificand s'a veul ëdcò calcolé torna le vìsite a le pàgine",
	'maintenance-initSiteStats-desc' => 'Torna calcolé le statìstiche dël sit',
	'maintenance-moveBatch' => 'Dovré ës formolari për tramudé dle pàgine a bocc.
Minca linia a dovrìa spessifiché na pàgina sorgiss e na pàgina destinassion separà da na bara vertical',
	'maintenance-moveBatch-desc' => 'tramuda pàgine a bocc',
	'maintenance-reassignEdits-desc' => "Riassigna modìfiche da n'utent a n'àutr",
	'maintenance-runJobs-desc' => 'Fà giré ij travajòt ant la coa dij travajòt',
	'maintenance-runJobs-option-maxjobs' => 'Màssim nùmer ëd travaj da fé andé',
	'maintenance-runJobs-option-type' => 'Sòrt ëd travaj da fé andé',
	'maintenance-runJobs-option-procs' => 'Nùmer ëd process da dovré',
	'maintenance-runJobs-option-exclusive' => "Fà andé mach un copin runJobs për vòta. La scadensa a l'é ëd 1800 second.",
	'maintenance-runJobs-error-invalidprocs' => 'A dev specifiché tra 1 e 1000 process',
	'maintenance-showJobs-desc' => 'Smon-e na lista dij travajòt an cors ant la coa dij travajòt',
	'maintenance-showJobs-option-group' => 'Smon-e ël nùmer ëd travaj për sòrt ëd travaj',
	'maintenance-sql' => "Dovré ës formolari për fé n'arcesta SQL an sla base ëd dàit.",
	'maintenance-sql-desc' => "Fé n'arcesta SQL",
	'maintenance-sql-option-file' => 'SQL da eseguì',
	'maintenance-sql-output-aff' => 'Arcesta bon-a, $1 {{PLURAL:$1|riga|righe}} agiornà',
	'maintenance-sql-error-cantopen' => "As peul pa duvertesse l'archivi d'anseriment",
	'maintenance-showCacheStats-desc' => 'Smon-e le statìstiche dla memòria local',
	'maintenance-eval' => "Dovré ës formolari për valuté ël còdes PHP ant l'ambient WikiMedia.",
	'maintenance-eval-desc' => "Valuté un còdes PHP ant l'ambient MediaWiki",
	'maintenance-update' => "Dovré UPDATE an modificand na tàula? Se pa marcà, a sò pòst a l'é dovrà DELETE/INSERT.",
	'maintenance-noviews' => "Marché sòn për ch'as modìfica pa ël nùmer ëd vìsite dle pàgine",
	'maintenance-invalidname' => 'Nòm utent pa bon!',
	'maintenance-userexists' => "L'utent a esist già!",
	'maintenance-invalidtitle' => 'Tìtol "$1" pa bon!',
	'maintenance-titlenoexist' => 'Ël tìtol spessificà ("$1") a esist pa!',
	'maintenance-failed' => 'FALÌ',
	'maintenance-deleted' => 'SCANCELÀ',
	'maintenance-revdelete' => 'Scancelassion {{PLURAL:$3|dla revision|dle revision}} $1 da la wiki $2',
	'maintenance-revnotfound' => 'Revision $1 pa trovà!',
	'maintenance-showCacheStats-edits' => 'Nùmer ëd modìfiche: $1',
	'maintenance-showCacheStats-articles' => 'Nùmer ëd pàgine ant lë spassi nominal prinsipal: $1',
	'maintenance-showCacheStats-pages' => 'Nùmer ëd pàgine: $1',
	'maintenance-showCacheStats-users' => "Nùmer d'utent: $1",
	'maintenance-showCacheStats-admins' => "Nùmer d'aministrator: $1",
	'maintenance-showCacheStats-images' => "Nùmer d'archivi: $1",
	'maintenance-showCacheStats-views' => 'Nùmer ëd pàgine visità: $1',
	'maintenance-showCacheStats-update' => 'Modìfica dla base ëd dàit{{int:ellipsis}}',
	'maintenance-move' => 'Bogé $1 a $2{{int:ellipsis}}',
	'maintenance-movefail' => 'Eror ancontrà an tramudand: $1.
Tramud abortì',
	'maintenance-error' => 'Eror: $1',
	'maintenance-memc-fake' => "A l'é an camin ch'a fa giré FakeMemCachedClient. Gnun-a statìstica a peul esse smonùa",
	'maintenance-memc-requests' => 'Arceste',
	'maintenance-memc-withsession' => 'con session:',
	'maintenance-memc-withoutsession' => 'sensa session:',
	'maintenance-memc-total' => 'total:',
	'maintenance-memc-parsercache' => 'Memòria local dël parser',
	'maintenance-memc-hits' => 'colp:',
	'maintenance-memc-invalid' => 'pa bon:',
	'maintenance-memc-expired' => 'scadù:',
	'maintenance-memc-absent' => 'assent:',
	'maintenance-memc-stub' => 'livel dë sbòss:',
	'maintenance-memc-imagecache' => 'Memòria local dle figure',
	'maintenance-memc-misses' => 'mancant:',
	'maintenance-memc-updates' => 'modìfiche:',
	'maintenance-memc-uncacheable' => 'fòra dla memòria local:',
	'maintenance-memc-diffcache' => 'Memòria local dle diferense',
	'maintenance-reassignEdits' => "Dovré ës formolari për riassigné dle modìfiche da n'utent a n'àutr.",
	'maintenance-re-from' => "Nòm ëd l'utent da 'ndoa pijé le modìfiche",
	'maintenance-re-to' => "Nòm ëd l'utent andoa assigné le modìfiche",
	'maintenance-re-force' => "Riassigné ëdcò se l'utent dëstinatari a esist pa",
	'maintenance-re-rc' => 'Modifiché pa la tàula dij cangiament recent',
	'maintenance-re-report' => "Smon-e ij detaj ëd lòn ch'a sarìa cangià, ma sensa modifichelo",
	'maintenance-re-nf' => 'Utent $1 pa trovà',
	'maintenance-re-rr' => 'Fa giré torna ël senari sensa modifiché "$1".',
	'maintenance-re-ce' => 'Modìfiche corente: $1',
	'maintenance-re-de' => 'Modìfiche scancelà: $1',
	'maintenance-re-rce' => 'Vos an RecentChanges: $1',
	'maintenance-re-total' => 'Vos totaj da cangé: $1',
	'maintenance-re-re' => 'Riassignassion dle modìfiche{{int:ellipsis}} fàita',
);

/** Pashto (پښتو)
 * @author Ahmed-Najib-Biabani-Ibrahimkhel
 */
$messages['ps'] = array(
	'maintenance-generic-done' => 'ترسره شو',
	'maintenance-generic-username' => 'کارن-نوم',
	'maintenance-generic-password' => 'پټنوم',
	'maintenance-generic-reason' => 'سبب',
	'maintenance-option-confirm' => 'تاييد',
	'maintenance-option-optional' => '(اختياري)',
	'maintenance-checkBadRedirects-output-footer' => 'ترسره شو.',
	'maintenance-invalidname' => 'ناسم کارن-نوم!',
	'maintenance-userexists' => 'دا کارن د پخوا نه ثبت دی!',
	'maintenance-deleted' => 'ړنګ شو',
	'maintenance-showCacheStats-edits' => 'د سمونو شمېر: $1',
	'maintenance-showCacheStats-pages' => 'د مخونو شمېر: $1',
	'maintenance-showCacheStats-users' => 'د کارنانو شمېر: $1',
	'maintenance-showCacheStats-admins' => 'د پازوالانو شمېر: $1',
	'maintenance-showCacheStats-images' => 'د دوتنو شمېر: $1',
	'maintenance-error' => 'تېروتنه: $1',
	'maintenance-memc-requests' => 'غوښتنې',
	'maintenance-memc-total' => 'ټولټال:',
	'maintenance-memc-invalid' => 'ناسم:',
	'maintenance-memc-absent' => 'ناسوب:',
	'maintenance-memc-updates' => 'مهالېدنې:',
	'maintenance-re-nf' => '$1 کارن و نه موندل شو',
);

/** Portuguese (português)
 * @author Hamilton Abreu
 * @author Malafaya
 * @author SandroHc
 * @author Waldir
 */
$messages['pt'] = array(
	'maintenance' => 'Executar scripts de manutenção',
	'maintenance-desc' => '[[Special:Maintenance|Interface na wiki]] para vários scripts de manutenção',
	'right-maintenance' => 'Executar scripts de manutenção através de [[Special:Maintenance]]',
	'maintenance-backlink' => 'Voltar à seleção de scripts',
	'maintenance-header' => 'Por favor, selecione abaixo um script a executar.
As descrições estão junto a cada script',
	'maintenance-error-badini' => 'O ficheiro metadata.ini não existe ou está corrompido. Faça novamente o dowload da extensão Manutenção',
	'maintenance-error-invalidtype' => 'O script especificado não foi encontrado',
	'maintenance-error-badargs' => 'Não especificou todas as opções necessárias',
	'maintenance-generic-done' => 'terminado',
	'maintenance-generic-username' => 'Nome de utilizador',
	'maintenance-generic-password' => 'Palavra-passe',
	'maintenance-generic-reason' => 'Motivo',
	'maintenance-cleanupTable-dry-run' => 'Executar um teste',
	'maintenance-cleanupTable-check' => 'A verificar títulos incorrectos...',
	'maintenance-cleanupTable-checkfix' => 'A verificar e corrrigir títulos incorrectos...',
	'maintenance-cleanupTable-progress' => '$1 $2: $3% em $4; hora prevista para terminar $5 [$6/$7] $8/seg <$9% actualizados>',
	'maintenance-cleanupTable-missingparam' => '$1: Parâmetros em falta $2',
	'maintenance-cleanupTable-processing' => 'A processar $1 ...',
	'maintenance-cleanupTable-finished' => 'Terminado $1... $2 de $3 linhas actualizadas', # Fuzzy
	'maintenance-option-quiet' => 'Suprimir resultados não relacionados com erros',
	'maintenance-option-globals' => 'Incluir as variáveis globais no fim do processamento para auxiliar o despiste de problemas',
	'maintenance-option-confirm' => 'Confirmar',
	'maintenance-option-batch-size' => 'Executar este número padrão de operações por cada conjunto de tarefas: $1',
	'maintenance-option-required' => '(obrigatório)',
	'maintenance-option-optional' => '(opcional)',
	'maintenance-output-success' => '$1 executado com sucesso!',
	'maintenance-output-failure' => '$1 não foi executado com sucesso!',
	'maintenance-attachLatest' => 'Use este formulário para corrigir entradas na tabela de páginas em que page_latest é igual a 0',
	'maintenance-attachLatest-desc' => 'Corrigir as entradas page_latest na tabela de páginas',
	'maintenance-attachLatest-option-fix' => 'Corrigir mesmo as entradas. Caso contrário, só será feita uma simulação.',
	'maintenance-attachLatest-output-begin' => 'A procurar páginas com page_latest igual a 0...',
	'maintenance-attachLatest-output-notime' => '$1 $2 [[$3]] não foi encontrada a data da última revisão!',
	'maintenance-attachLatest-output-norev' => '$1 $2 [[$3]] data da última revisão $4, não foi encontrada a identificação da revisão',
	'maintenance-attachLatest-output-found' => '$1 $2 [[$3]] data da última revisão $4, identificação da revisão $5',
	'maintenance-attachLatest-output-done' => 'Terminado! Foram processadas $1 páginas.', # Fuzzy
	'maintenance-attachLatest-output-dryrun' => 'Esta execução foi uma simulação; volte a executar com "{{int:maintenance-attachLatest-option-fix}}" para actualizar page_latest.',
	'maintenance-benchmarkPurge' => 'Use este formulário para testar quanto tempo demoram as funções de limpeza do Squid',
	'maintenance-benchmarkPurge-desc' => 'Aferir valores de referência para as funções de limpeza do Squid',
	'maintenance-benchmarkPurge-option-count' => 'Quantas URLs devem ser fornecidas ao Squid para limpeza',
	'maintenance-benchmarkPurge-error-nosquid' => 'A aferição dos valores de referência da limpeza do Squid não faz nada sem suporte do Squid.',
	'maintenance-benchmarkPurge-output-numsquids' => 'Existem $1 servidores Squid definidos:', # Fuzzy
	'maintenance-benchmarkPurge-output-trial' => '$1 títulos em $2ms ($3ms cada um)', # Fuzzy
	'maintenance-changePassword' => 'Use este formulário para alterar a palavra-chave de um utilizador',
	'maintenance-changePassword-desc' => 'Alterar a palavra-chave de um utilizador',
	'maintenance-changePassword-error-nouser' => 'Utilizador inexistente: $1',
	'maintenance-changePassword-output-set' => 'Palavra-chave definida como $1',
	'maintenance-checkAutoLoader' => 'Use este formulário para realizar algumas verificações de consistência do Autoloader',
	'maintenance-checkAutoLoader-desc' => 'Verificações de consistência do Autoloader',
	'maintenance-checkAutoLoader-output-list2' => '$1: Ficheiro errado: encontrado em $2, listado em $3',
	'maintenance-checkBadRedirects' => 'Use este formulário para verificar se as páginas marcadas como redireccionamentos são realmente redireccionamentos',
	'maintenance-checkBadRedirects-desc' => 'Verificar redireccionamentos falsos',
	'maintenance-checkBadRedirects-output-header' => 'A obter lista de redireccionamentos...',
	'maintenance-checkBadRedirects-output-found' => '{{PLURAL:$1|Foi encontrado|Foram encontrados}} $1 {{PLURAL:$1|redirecionamento|redirecionamentos}}.
A procurar redirecionamentos incorretos...',
	'maintenance-checkBadRedirects-output-footer' => 'Terminado.',
	'maintenance-checkImages' => 'Use este formulário para verificar as imagens que estão danificadas no seu servidor', # Fuzzy
	'maintenance-checkImages-desc' => 'Verificar se as imagens existem, são legíveis, etc.',
	'maintenance-checkImages-output-noaccess' => '$1: não são acessíveis localmente',
	'maintenance-checkImages-output-missing' => '$1: em falta',
	'maintenance-checkImages-output-isdir' => '$1: é um directório',
	'maintenance-checkImages-output-truncated' => '$1: truncado, era $2',
	'maintenance-checkImages-output-mismatch' => '$1: incompatibilidade de tamanho BD=$2, actual=$3',
	'maintenance-checkImages-output-good' => 'Imagens em bom estado: $1/$2',
	'maintenance-checkSyntax' => 'Use este formulário para verificar a sintaxe de todos os ficheiros PHP do MediaWiki',
	'maintenance-checkSyntax-desc' => 'Verificar a sintaxe de todos os ficheiros PHP do MediaWiki',
	'maintenance-checkSyntax-option-with-extensions' => 'Visitar também recursivamente o directório das extensões',
	'maintenance-checkSyntax-option-path' => 'Localização específica (ficheiro ou directório) a verificar, absoluta ou relativa à raiz desta instalação do MediaWiki',
	'maintenance-checkSyntax-option-list-file' => 'Lista de ficheiros ou directórios a verificar',
	'maintenance-checkSyntax-option-modified' => 'Verificar só os ficheiros que foram modificados (requer o cliente da linha de comandos SVN)',
	'maintenance-checkSyntax-option-syntax-only' => 'Verificar somente a validade da sintaxe, ignorando os avisos sobre o estilo do código',
	'maintenance-checkSyntax-output-parsekit' => 'A verificar a sintaxe (usando o parsekit)',
	'maintenance-checkSyntax-output-phpl' => 'A verificar a sintaxe (usando php -1; pode demorar bastante)',
	'maintenance-checkSyntax-output-footer' => 'Terminado! Foram verificados $1 ficheiros e encontradas $2 falhas e $3 avisos',
	'maintenance-checkSyntax-output-svnlist' => 'A obter a list a partir do Subversion...',
	'maintenance-checkSyntax-output-buildlist' => 'A construir a lista de ficheiros...',
	'maintenance-checkSyntax-output-error' => 'Erro em $1, na linha $2: $3',
	'maintenance-checkSyntax-output-warning' => 'Aviso no ficheiro $1: $2 encontrado',
	'maintenance-checkSyntax-error-nofile' => 'Erro: não foi possível encontrar o ficheiro ou directório $1',
	'maintenance-checkSyntax-error-cantopen' => 'Não é possível abrir o ficheiro $1',
	'maintenance-checkSyntax-error-svnerr' => 'Ocorreu um erro na obtençao da lista a partir do Subversion!',
	'maintenance-checkUsernames' => 'Use este formulário para mostrar os nomes de utilizador inválidos devido a alterações da configuração. Se não for listado nenhum nome após a execução, todos os nomes são válidos.',
	'maintenance-checkUsernames-desc' => 'Verificar que os nomes de utilizador da base de dados são realmente válidos',
	'maintenance-checkUsernames-error-notvalid' => 'Nome de utilizador inválido: "$3" (identificação do utilizador $2)',
	'maintenance-cleanupCaps' => 'Use este formulário para corrigir páginas quebradas pela modificação de $wgCapitalLinks',
	'maintenance-cleanupCaps-desc' => 'Ficheiro de comandos para limpar o uso de maiúsculas e minúsculas',
	'maintenance-cleanupCaps-option-namespace' => 'Número do espaço nominal sobre o qual será executada a limpeza do uso de maiúsculas e minúsculas',
	'maintenance-cleanupCaps-output-islower' => '"$1" já está em minúsculas.',
	'maintenance-cleanupCaps-output-clash' => '"$1" foi saltada; "$2" já existe',
	'maintenance-cleanupCaps-output-dryrun' => '"$1" -> "$2": EXECUÇÂO SIMULADA; NÃO FOI MOVIDA',
	'maintenance-cleanupCaps-error-noneed' => '$wgCapitalLinks está activado; não é necessário fazer a limpeza do uso de maiúsculas e minúsculas.',
	'maintenance-createAndPromote' => 'Utilize este formulário para criar um novo utilizador e promovê-lo a administrador.
Assinale a caixa de burocrata se pretende também promovê-lo a burocrata',
	'maintenance-createAndPromote-desc' => 'Criar um utilizador e promover a administrador',
	'maintenance-createAndPromote-option-bureaucrat' => 'Promover o utilizador ao estatuto de burocrata',
	'maintenance-deleteBatch' => 'Utilize este formulário para eliminar páginas em bloco.
Coloque apenas uma página por linha.',
	'maintenance-deleteBatch-desc' => 'Eliminar páginas em massa',
	'maintenance-deleteRevision' => 'Utilize este formulário para eliminar revisões em bloco. Coloque apenas um número de revisão por linha.',
	'maintenance-deleteRevision-desc' => 'Remover revisões da base de dados',
	'maintenance-initEditCount-desc' => 'Recalcular a contagem de edições de utilizadores',
	'maintenance-initSiteStats' => 'Utilize este formulário para recalcular as estatísticas do site, especificando se pretende recalcular também os visionamentos de páginas',
	'maintenance-initSiteStats-desc' => 'Recalcular estatísticas do site',
	'maintenance-moveBatch' => 'Utilize este formulário para mover páginas em bloco.
Cada linha deverá especificar uma página de origem e uma página destino, separadas por uma barra vertical "|".',
	'maintenance-moveBatch-desc' => 'Mover páginas em bloco',
	'maintenance-reassignEdits-desc' => 'Atribuir as edições de um utilizador a outro',
	'maintenance-runJobs-desc' => 'Executar as tarefas da fila de tarefas',
	'maintenance-runJobs-option-maxjobs' => 'Número máximo de tarefas a executar',
	'maintenance-runJobs-option-type' => 'Tipo de tarefa a executar',
	'maintenance-runJobs-option-procs' => 'Número de processos que serão usados',
	'maintenance-runJobs-option-exclusive' => 'Executar só um ficheiro de comandos runJobs exclusivo de cada vez. O tempo limite é 1800 segundos.',
	'maintenance-runJobs-error-invalidprocs' => 'Tem que especificar entre 1 e 1000 processos',
	'maintenance-showJobs-desc' => 'Mostrar uma lista de tarefas pendentes na fila de tarefas',
	'maintenance-showJobs-option-group' => 'Mostrar o número de tarefas por cada tipo de tarefa',
	'maintenance-sql' => 'Use este formulário para executar um comando SQL na base de dados.',
	'maintenance-sql-desc' => 'Executar um comando SQL',
	'maintenance-sql-option-file' => 'SQL a executar',
	'maintenance-sql-output-aff' => 'Consulta correcta, $1 {{PLURAL:$1|linha afectada|linhas afectadas}}',
	'maintenance-sql-error-cantopen' => 'Não foi possível abrir o ficheiro de entrada',
	'maintenance-showCacheStats-desc' => 'Mostrar estatísticas do Memcached',
	'maintenance-eval' => 'Utilize este formulário para executar código PHP no ambiente MediaWiki.',
	'maintenance-eval-desc' => 'Interpretar código PHP no ambiente MediaWiki',
	'maintenance-update' => 'Usar UPDATE para actualizar tabelas? Se desmarcado, será usado DELETE/INSERT.',
	'maintenance-noviews' => 'Marque esta opção para impedir a actualização dos visionamentos de páginas',
	'maintenance-invalidname' => 'Nome de utilizador inválido!',
	'maintenance-userexists' => 'O utilizador já existe!',
	'maintenance-invalidtitle' => 'O título "$1" é inválido!',
	'maintenance-titlenoexist' => 'O título especificado ("$1") não existe!',
	'maintenance-failed' => 'FALHADO',
	'maintenance-deleted' => 'ELIMINADO',
	'maintenance-revdelete' => 'A eliminar {{PLURAL:$3|a revisão|as revisões}} $1 da wiki $2',
	'maintenance-revnotfound' => 'A revisão $1 não foi encontrada!',
	'maintenance-showCacheStats-edits' => 'Número de edições: $1',
	'maintenance-showCacheStats-articles' => 'Número de páginas no espaço nominal principal: $1',
	'maintenance-showCacheStats-pages' => 'Número de páginas: $1',
	'maintenance-showCacheStats-users' => 'Número de utilizadores: $1',
	'maintenance-showCacheStats-admins' => 'Número de administradores: $1',
	'maintenance-showCacheStats-images' => 'Número de ficheiros: $1',
	'maintenance-showCacheStats-views' => 'Número de visionamentos: $1',
	'maintenance-showCacheStats-update' => 'A actualizar a base de dados{{int:ellipsis}}',
	'maintenance-move' => 'A mover $1 para $2{{int:ellipsis}}',
	'maintenance-movefail' => 'Erro encontrado durante a movimentação: $1.
A abortar a movimentação',
	'maintenance-error' => 'Erro: $1',
	'maintenance-memc-fake' => 'Está a executar o FakeMemCachedClient. Não podem ser fornecidas estatísticas.',
	'maintenance-memc-requests' => 'Pedidos',
	'maintenance-memc-withsession' => 'com sessão:',
	'maintenance-memc-withoutsession' => 'sem sessão:',
	'maintenance-memc-total' => 'total:',
	'maintenance-memc-parsercache' => 'Cache do analisador sintáctico',
	'maintenance-memc-hits' => 'acertos:',
	'maintenance-memc-invalid' => 'inválidos:',
	'maintenance-memc-expired' => 'caducados:',
	'maintenance-memc-absent' => 'ausentes:',
	'maintenance-memc-stub' => 'limite de esboço:',
	'maintenance-memc-imagecache' => 'Cache de imagens',
	'maintenance-memc-misses' => 'falhas:',
	'maintenance-memc-updates' => 'actualizações:',
	'maintenance-memc-uncacheable' => 'não "cacháveis":',
	'maintenance-memc-diffcache' => 'Cache de Diferenças',
	'maintenance-reassignEdits' => 'Utilize este formulário para re-atribuir edições de um utilizador a outro.',
	'maintenance-re-from' => 'Nome do utilizador a que desatribuir edições',
	'maintenance-re-to' => 'Nome do utilizador a que atribuir edições',
	'maintenance-re-force' => 'Re-atribuir mesmo que o utilizador alvo não exista',
	'maintenance-re-rc' => 'Não actualizar a tabela de modificações recentes',
	'maintenance-re-report' => 'Apresentar detalhes do que seria alterado, mas não alterar',
	'maintenance-re-nf' => 'Utilizador $1 não encontrado',
	'maintenance-re-rr' => 'Executar o script novamente sem "$1" para actualizar.',
	'maintenance-re-ce' => 'Edições actuais: $1',
	'maintenance-re-de' => 'Edições eliminadas: $1',
	'maintenance-re-rce' => 'Entradas das Mudanças Recentes: $1',
	'maintenance-re-total' => 'Entradas totais a alterar: $1',
	'maintenance-re-re' => 'A re-atribuir edições{{int:ellipsis}} concluído',
);

/** Brazilian Portuguese (português do Brasil)
 * @author Eduardo.mps
 */
$messages['pt-br'] = array(
	'maintenance' => 'Execute scripts de manutenção',
	'maintenance-desc' => '[[Special:Maintenance|Interface wiki]] para vários scripts de manutenção',
	'right-maintenance' => 'Executar scripts de manutenção através de [[Special:Maintenance]]',
	'maintenance-backlink' => 'Voltar à seleção de scripts',
	'maintenance-header' => 'Por favor, selecione abaixo um script a executar.
As descrições estão junto a cada script',
	'maintenance-error-invalidtype' => 'Tipo inválido!', # Fuzzy
	'maintenance-option-confirm' => 'Confirmar',
	'maintenance-output-success' => '$1 executado com sucesso!',
	'maintenance-changePassword' => 'Use este formulário para alterar a palavra-chave de um utilizador',
	'maintenance-changePassword-desc' => 'Alterar a palavra-chave de um utilizador',
	'maintenance-createAndPromote' => 'Utilize este formulário para criar um novo utilizador e promovê-lo a administrador.
Assinale a caixa de burocrata se pretende também promovê-lo a burocrata',
	'maintenance-createAndPromote-desc' => 'Criar um utilizador e promover a administrador',
	'maintenance-deleteBatch' => 'Utilize este formulário para eliminar páginas em massa.
Coloque apenas uma página por linha',
	'maintenance-deleteBatch-desc' => 'Eliminar páginas em massa',
	'maintenance-deleteRevision' => 'Utilize este formulário para eliminar revisões em massa.
Coloque apenas um número de revisão por linha',
	'maintenance-deleteRevision-desc' => 'Remover revisões da base de dados',
	'maintenance-initEditCount-desc' => 'Recalcular a contagem de edições de utilizadores',
	'maintenance-initSiteStats' => 'Utilize este formulário para recalcular as estatísticas do sítio, especificando se pretende recalcular as visualizações de página também',
	'maintenance-initSiteStats-desc' => 'Recalcular estatísticas do sítio',
	'maintenance-moveBatch' => 'Utilize este formulário para mover páginas em massa.
Cada linha deverá especificar uma página fonte e uma página destino, separadas por uma barra vertical ("pipe")',
	'maintenance-moveBatch-desc' => 'Mover páginas em bloco',
	'maintenance-reassignEdits-desc' => 'Reatribuir edições de um utilizador para outro',
	'maintenance-runJobs-desc' => 'Executar tarefas na fila de tarefas',
	'maintenance-showJobs-desc' => 'Mostrar uma lista de tarefas pendentes na fila de tarefas',
	'maintenance-sql' => 'Use este formulário para executar um comando SQL na base de dados.',
	'maintenance-sql-desc' => 'Executar um comando SQL',
	'maintenance-showCacheStats-desc' => 'Mostrar estatísticas do Memcached',
	'maintenance-eval' => 'Utilize este formulário para executar código PHP no ambiente MediaWiki.',
	'maintenance-eval-desc' => 'Interpretar código PHP no ambiente MediaWiki',
	'maintenance-update' => 'Usar UPDATE para atualizar uma tabela? Se desselecionado, usa DELETE/INSERT.',
	'maintenance-noviews' => 'Assinale aqui para prevenir a atualização do número de visualizações de página',
	'maintenance-invalidname' => 'Nome de utilizador inválido!',
	'maintenance-userexists' => 'O utilizador já existe!',
	'maintenance-invalidtitle' => 'Título "$1" inválido!',
	'maintenance-titlenoexist' => 'O título especificado ("$1") não existe!',
	'maintenance-failed' => 'FALHOU',
	'maintenance-deleted' => 'ELIMINADO',
	'maintenance-revdelete' => 'Eliminando {{PLURAL:$3|revisão|revisões}} $1 do wiki $2',
	'maintenance-revnotfound' => 'Revisão $1 não encontrada!',
	'maintenance-showCacheStats-edits' => 'Número de edições: $1',
	'maintenance-showCacheStats-articles' => 'Número de páginas no domínio principal: $1',
	'maintenance-showCacheStats-pages' => 'Número de páginas: $1',
	'maintenance-showCacheStats-users' => 'Número de utilizadores: $1',
	'maintenance-showCacheStats-admins' => 'Número de administradores: $1',
	'maintenance-showCacheStats-images' => 'Número de ficheiros: $1',
	'maintenance-showCacheStats-views' => 'Número de visualizações de página: $1',
	'maintenance-showCacheStats-update' => 'Atualizando base de dados{{int:ellipsis}}',
	'maintenance-move' => 'Movendo $1 para $2{{int:ellipsis}}',
	'maintenance-movefail' => 'Erro encontrado durante a movimentação: $1.
Abortando a movimentação',
	'maintenance-error' => 'Erro: $1',
	'maintenance-memc-fake' => 'Você está a executar o FakeMemCachedClient. Estatísticas não podem ser fornecidas.',
	'maintenance-memc-requests' => 'Pedidos',
	'maintenance-memc-withsession' => 'com sessão:',
	'maintenance-memc-withoutsession' => 'sem sessão:',
	'maintenance-memc-total' => 'total:',
	'maintenance-memc-parsercache' => 'Cache do analisador (parser)',
	'maintenance-memc-hits' => 'acertos:',
	'maintenance-memc-invalid' => 'inválidos:',
	'maintenance-memc-expired' => 'expirados:',
	'maintenance-memc-absent' => 'ausentes:',
	'maintenance-memc-stub' => 'limite de esboço:',
	'maintenance-memc-imagecache' => 'Cache de imagens',
	'maintenance-memc-misses' => 'faltas:',
	'maintenance-memc-updates' => 'atualizações:',
	'maintenance-memc-uncacheable' => 'não "cacheáveis":',
	'maintenance-memc-diffcache' => 'Cache de Diferenças',
	'maintenance-reassignEdits' => 'Utilize este formulário para re-atribuir edições de um utilizador a outro.',
	'maintenance-re-from' => 'Nome do utilizador a quem desatribuir edições',
	'maintenance-re-to' => 'Nome do utilizador a que atribuir edições',
	'maintenance-re-force' => 'Re-atribuir mesmo que o utilizador alvo não exista',
	'maintenance-re-rc' => 'Não atualizar a tabela de modificações recentes',
	'maintenance-re-report' => 'Apresentar detalhes do que seria alterado, mas não o atualizar',
	'maintenance-re-nf' => 'Utilizador $1 não encontrado',
	'maintenance-re-rr' => 'Executar o script novamente sem "$1" para atualizar.',
	'maintenance-re-ce' => 'Edições atuais: $1',
	'maintenance-re-de' => 'Edições eliminadas: $1',
	'maintenance-re-rce' => 'Entradas das Mudanças Recentes: $1',
	'maintenance-re-total' => 'Entradas totais a alterar: $1',
	'maintenance-re-re' => 'Re-atribuindo edições{{int:ellipsis}} concluído',
);

/** Romanian (română)
 * @author Firilacroco
 * @author KlaudiuMihaila
 * @author Minisarm
 * @author Stelistcristi
 */
$messages['ro'] = array(
	'maintenance' => 'Rulează scripturile de întreținere',
	'maintenance-desc' => '[[Special:Maintenance|Interfața wiki]] pentru diferite scripturi de întreținere',
	'right-maintenance' => 'Rulează scripturile de întreținere prin [[Special:Maintenance]]',
	'maintenance-backlink' => 'Înapoi la selecția scriptului',
	'maintenance-header' => 'Vă rugăm să selectați de mai jos un script pentru executare.
Descrierile se află în apropierea fiecărui script',
	'maintenance-error-badini' => 'Fișierul metadata.ini este fie corupt, fie inexistent. Vă rugăm să descărcați din nou extensia Maintenance',
	'maintenance-error-invalidtype' => 'Scriptul specificat nu a fost găsit',
	'maintenance-error-badargs' => 'Nu ați specificat toate informațiile necesare',
	'maintenance-generic-done' => 'realizat',
	'maintenance-generic-username' => 'Nume de utilizator',
	'maintenance-generic-password' => 'Parolă',
	'maintenance-generic-reason' => 'Motiv',
	'maintenance-cleanupTable-check' => 'Se caută titlurile rele...',
	'maintenance-cleanupTable-checkfix' => 'Se verifică și se corectează titlurile rele...',
	'maintenance-cleanupTable-processing' => 'Se procesează $1...',
	'maintenance-option-confirm' => 'Confirmă',
	'maintenance-option-required' => '(obligatoriu)',
	'maintenance-option-optional' => '(opțional)',
	'maintenance-output-success' => '$1 a rulat cu succes!',
	'maintenance-output-failure' => '$1 nu a rulat cu succes!',
	'maintenance-changePassword' => 'Utilizați acest formular pentru a schimba parola unui utilizator',
	'maintenance-changePassword-desc' => 'Schimbă parola unui utilizator',
	'maintenance-changePassword-error-nouser' => 'Niciun asemenea utilizator: $1',
	'maintenance-changePassword-output-set' => 'Parola setată pentru $1',
	'maintenance-checkBadRedirects-output-footer' => '
Realizat.',
	'maintenance-checkImages-output-noaccess' => '$1: inaccesibil local',
	'maintenance-checkImages-output-missing' => '$1: lipsește',
	'maintenance-checkImages-output-isdir' => '$1: este un director',
	'maintenance-checkImages-output-good' => 'Imagini bune: $1/$2',
	'maintenance-checkSyntax-output-buildlist' => 'Se construiește lista de fișiere...',
	'maintenance-checkSyntax-output-error' => 'Eroare în $1, linia $2: $3',
	'maintenance-checkSyntax-output-warning' => 'Avertisment în fișierul $1: $2 găsit',
	'maintenance-checkSyntax-error-cantopen' => 'Imposibil de deschis fișierul $1',
	'maintenance-checkUsernames-error-notvalid' => 'Nume de utilizator incorect: „$3” (ID utilizator $2)',
	'maintenance-cleanupCaps-output-islower' => '„$1” deja în minuscule.',
	'maintenance-cleanupSpam-output-reverting' => 'revenire',
	'maintenance-createAndPromote' => 'Utilizați acest formular pentru a crea un nou utilizator și a-l promova la statutul de administrator.
Bifați și caseta „birocrat” dacă doriți să-l promovați și la statutul de birocrat',
	'maintenance-createAndPromote-desc' => 'Creează un utilizator și promovează-l la statutul de administrator',
	'maintenance-deleteBatch' => 'Utilizați acest formular pentru ștergerea în masă a paginilor.
Puneți doar o pagină pe un rând',
	'maintenance-deleteBatch-desc' => 'Şterge pagini în masă',
	'maintenance-deleteRevision' => 'Utilizați acest formular pentru ștergerea în masă a versiunilor.
Specificați doar o versiune pe fiecare rând',
	'maintenance-deleteRevision-desc' => 'Şterge reviziile din baza de date',
	'maintenance-initEditCount-desc' => 'Recalculează numărul de modificări ale utilizatorilor',
	'maintenance-initSiteStats-desc' => 'Recalculează statisticile sitului',
	'maintenance-moveBatch-desc' => 'Redenumește pagini în masă',
	'maintenance-reassignEdits-desc' => 'Redistribuie contribuțiile de la un utilizator la altul',
	'maintenance-sql-desc' => 'Execută o interogare SQL',
	'maintenance-showCacheStats-desc' => 'Arată statisticile Memcached',
	'maintenance-eval-desc' => 'Evaluează codul PHP în mediul MediaWiki',
	'maintenance-invalidname' => 'Nume de utilizator incorect!',
	'maintenance-userexists' => 'Utilizatorul există deja!',
	'maintenance-invalidtitle' => 'Titlu „$1” este incorect!',
	'maintenance-titlenoexist' => 'Titlul specificat („$1”) nu există!',
	'maintenance-failed' => 'EȘUAT',
	'maintenance-deleted' => 'ȘTERS',
	'maintenance-revnotfound' => 'Revizia $1 nu a fost găsită!',
	'maintenance-showCacheStats-edits' => 'Număr de modificări: $1',
	'maintenance-showCacheStats-articles' => 'Număr de pagini în spațiul de nume principal: $1',
	'maintenance-showCacheStats-pages' => 'Număr de pagini: $1',
	'maintenance-showCacheStats-users' => 'Număr de utilizatori: $1',
	'maintenance-showCacheStats-admins' => 'Număr de administratori: $1',
	'maintenance-showCacheStats-images' => 'Număr de fișiere: $1',
	'maintenance-showCacheStats-views' => 'Număr de vizualizări ale paginii: $1',
	'maintenance-error' => 'Eroare: $1',
	'maintenance-memc-requests' => 'Cereri',
	'maintenance-memc-withsession' => 'cu sesiune:',
	'maintenance-memc-withoutsession' => 'fără sesiune:',
	'maintenance-memc-total' => 'total:',
	'maintenance-memc-hits' => 'clickuri:',
	'maintenance-memc-invalid' => 'incorect:',
	'maintenance-memc-expired' => 'expirat:',
	'maintenance-memc-absent' => 'absent:',
	'maintenance-memc-updates' => 'actualizări:',
	'maintenance-re-nf' => 'Utilizatorul $1 nu a fost găsit',
	'maintenance-re-ce' => 'Modificări curente: $1',
	'maintenance-re-de' => 'Modificări șterse: $1',
);

/** tarandíne (tarandíne)
 * @author Joetaras
 */
$messages['roa-tara'] = array(
	'maintenance-generic-done' => 'fatte',
	'maintenance-generic-username' => 'Nome utende',
	'maintenance-generic-password' => 'Passuord',
	'maintenance-generic-reason' => 'Mutive',
	'maintenance-cleanupTable-progress' => '$1 $2: $3% fatte sus a $4; ETA $5 [$6/$7] $8/sec <$9% aggiornate>',
	'maintenance-cleanupTable-processing' => 'Stoche a processe $1...',
	'maintenance-option-confirm' => 'Conferme',
	'maintenance-output-success' => '$1 eseguite cu successe!',
	'maintenance-output-failure' => "$1 non g'ha state eseguite cu successe!",
	'maintenance-userexists' => "L'utende già esiste!",
	'maintenance-showCacheStats-edits' => 'Numere de cangiaminde: $1',
	'maintenance-error' => 'Errore: $1',
	'maintenance-memc-requests' => 'Richieste',
	'maintenance-memc-withsession' => "cu 'a sessione:",
	'maintenance-memc-withoutsession' => 'senze sessione:',
	'maintenance-memc-total' => 'totale:',
	'maintenance-memc-hits' => 'cazzaminde:',
	'maintenance-memc-invalid' => 'invalide:',
	'maintenance-memc-expired' => 'scadute:',
	'maintenance-memc-absent' => 'assende:',
	'maintenance-memc-stub' => "soglie d'u stub:",
	'maintenance-memc-imagecache' => "Immaggine d'a cache",
	'maintenance-memc-misses' => 'perdute:',
	'maintenance-memc-updates' => 'aggiornate:',
);

/** Russian (русский)
 * @author DCamer
 * @author Ferrer
 * @author Haffman
 * @author Innv
 * @author KorneySan
 * @author Lockal
 * @author Putnik
 * @author Volkov
 * @author Александр Сигачёв
 */
$messages['ru'] = array(
	'maintenance' => 'Запуск скриптов обслуживания',
	'maintenance-desc' => '[[Special:Maintenance|Веб-интерфейс]] для различных скриптов обслуживания',
	'right-maintenance' => 'запуск скриптов обслуживания с помощью [[Special:Maintenance]]',
	'maintenance-backlink' => 'Вернуться к выбору скрипта',
	'maintenance-header' => 'Пожалуйста, выберите скрипт для исполнения. 
Описание рядом с каждым скриптом',
	'maintenance-error-badini' => 'Файл Metadata.ini поврежден или отсутствует. Пожалуйста, повторно загрузите расширение Maintenance',
	'maintenance-error-invalidtype' => 'Не найден указанный скрипт',
	'maintenance-error-badargs' => 'Вы не указали все необходимые параметры',
	'maintenance-generic-done' => 'выполнено',
	'maintenance-generic-username' => 'Имя участника',
	'maintenance-generic-password' => 'Пароль',
	'maintenance-generic-reason' => 'Причина',
	'maintenance-cleanupTable-dry-run' => 'Выполнить пробный прогон',
	'maintenance-cleanupTable-check' => 'Проверка на плохие названия ...',
	'maintenance-cleanupTable-checkfix' => 'Проверка и исправление плохих названий ...',
	'maintenance-cleanupTable-progress' => '$1 $2 : $3 % сделано на $4 ; ПВЗ $5 [ $6 / $7 ] $8 / сек < $9 % обновлено>',
	'maintenance-cleanupTable-missingparam' => '$1: Отсутствует параметр $2',
	'maintenance-cleanupTable-processing' => 'Обработка $1...',
	'maintenance-cleanupTable-finished' => 'Готово $1... $2 {{PLURAL:$2|строчка из $3 обновлена|строчки из $3 обновлены|строчек из $3 обновлены}}',
	'maintenance-option-quiet' => 'Показывать только ошибки',
	'maintenance-option-globals' => 'Выводить глобальные переменные в конце процесса отладки',
	'maintenance-option-confirm' => 'Подтвердить',
	'maintenance-option-batch-size' => 'Запуск всех этих операций в пакете, по умолчанию: $1',
	'maintenance-option-required' => '(обязательный)',
	'maintenance-option-optional' => '(необязательный)',
	'maintenance-output-success' => '$1 успешно выполнено!',
	'maintenance-output-failure' => 'Не удалось выполнить $1!',
	'maintenance-attachLatest' => 'Используйте эту форму для исправления записей в таблице страниц, где page_latest установлен в 0',
	'maintenance-attachLatest-desc' => 'Исправить записи page_latest в таблице страниц',
	'maintenance-attachLatest-option-fix' => 'На самом деле исправить записи, иначе запустить тестовый прогон',
	'maintenance-attachLatest-output-begin' => 'Поиск страниц с page_latest, равным 0...',
	'maintenance-attachLatest-output-notime' => '$1 $2 [[$3]] не может найти время последней версии?!',
	'maintenance-attachLatest-output-norev' => '$1 $2 [[$3]] последнее время $4, не удалось найти идентификатор версии',
	'maintenance-attachLatest-output-found' => '$1 $2 [[$3]] последнее время $4, идентификатор версии $5',
	'maintenance-attachLatest-output-done' => 'Сделано! Обработано $1 {{PLURAL:$1|страница|страницы|страниц}}.',
	'maintenance-attachLatest-output-dryrun' => 'Это был тестовый прогон; запустите вновь с "{{int:maintenance-attachLatest-option-fix}}" для обновления page_latest.',
	'maintenance-benchmarkPurge' => 'Используйте эту форму, чтобы проверить, сколько времени уйдёт на функции очистки Squid',
	'maintenance-benchmarkPurge-desc' => 'Измерение скорости функций очистки Squid',
	'maintenance-benchmarkPurge-option-count' => 'Сколько URL-адресов требуется для очистки Squid',
	'maintenance-benchmarkPurge-error-nosquid' => 'Измерение скорости очистки Squid не работает без поддержки Squid',
	'maintenance-benchmarkPurge-output-numsquids' => '$1 {{PLURAL:$1|определенный сервер Squid|определенных сервера Squid|определенных серверов Squid}}:',
	'maintenance-benchmarkPurge-output-trial' => '$1 {{PLURAL:$1|название|названия|названий}} в $2 мс ($3 мс каждое)',
	'maintenance-changePassword' => 'Используйте эту форму, чтобы изменить пароль участника',
	'maintenance-changePassword-desc' => 'Изменить пароль участника',
	'maintenance-changePassword-error-nouser' => 'Участник не существует: $1',
	'maintenance-changePassword-output-set' => 'Установлен пароль для $1',
	'maintenance-checkAutoLoader' => 'Используйте эту форму для проверок корректности AutoLoader',
	'maintenance-checkAutoLoader-desc' => 'Проверка корректности AutoLoader',
	'maintenance-checkAutoLoader-output-list2' => '$1: Неправильный файл: найден в $2, указан в $3',
	'maintenance-checkBadRedirects' => 'Используйте эту форму, чтобы увидеть, являются ли страницы с пометкой перенаправления перенаправлениями в самом деле',
	'maintenance-checkBadRedirects-desc' => 'Поиск неверных перенаправлений',
	'maintenance-checkBadRedirects-output-header' => 'Выборка перенаправлений...',
	'maintenance-checkBadRedirects-output-found' => 'Найдено {{PLURAL:$1|$1 перенаправление|$1 перенаправления|$1 перенаправлений}}.
Проверка на неверные перенаправления...',
	'maintenance-checkBadRedirects-output-footer' => 'Готово.',
	'maintenance-checkImages' => 'Используйте эту форму, чтобы увидеть, какие изображения на Вашей вики повреждены',
	'maintenance-checkImages-desc' => 'Проверка изображений на существование, читабельность и т.д.',
	'maintenance-checkImages-output-noaccess' => '$1: не доступен локально',
	'maintenance-checkImages-output-missing' => '$1: отсутствует',
	'maintenance-checkImages-output-isdir' => '$1 - каталог',
	'maintenance-checkImages-output-truncated' => '$1: усечен, был $2',
	'maintenance-checkImages-output-mismatch' => '$1: размер не совпадает: в базе данных — $2, фактически — $3',
	'maintenance-checkImages-output-good' => 'Хорошие изображения: $1/$2',
	'maintenance-checkSyntax' => 'Используйте эту форму для проверки синтаксиса всех PHP-файлов в MediaWiki.',
	'maintenance-checkSyntax-desc' => 'Проверить синтаксис всех файлов PHP в MediaWiki',
	'maintenance-checkSyntax-option-with-extensions' => 'Также рекурсивно папку расширений',
	'maintenance-checkSyntax-option-path' => 'Конкретный путь (к файлу или каталогу) для проверки, может быть абсолютным или относительным для корня  этой установки MediaWiki',
	'maintenance-checkSyntax-option-list-file' => 'Список файлов или папок для проверки',
	'maintenance-checkSyntax-option-modified' => 'Проверить только изменённые файлы (требуется клиент SVN для командной строки)',
	'maintenance-checkSyntax-option-syntax-only' => 'Проверить только синтаксис, пропускать предупреждения о стиле кода',
	'maintenance-checkSyntax-output-parsekit' => 'Проверка синтаксиса (с использованием parsekit)',
	'maintenance-checkSyntax-output-phpl' => 'Проверка синтаксиса (с использованием php -l, это может занять длительное время)',
	'maintenance-checkSyntax-output-footer' => 'Готово! Проверено файлов: $1. Сбоев: $2. Предупреждений: $3.',
	'maintenance-checkSyntax-output-svnlist' => 'Получение списка из Subversion...',
	'maintenance-checkSyntax-output-buildlist' => 'Построение списка файлов…',
	'maintenance-checkSyntax-output-error' => 'Ошибка в $1 в $2 строке: $3',
	'maintenance-checkSyntax-output-warning' => 'Предупреждение в файле $1. Найден $2',
	'maintenance-checkSyntax-error-nofile' => 'Ошибка: не удалось найти файл или каталог $1',
	'maintenance-checkSyntax-error-cantopen' => 'Невозможно открыть файл $1',
	'maintenance-checkSyntax-error-svnerr' => 'Ошибка при получении списка из Subversion!',
	'maintenance-checkUsernames' => 'Используйте эту форму, чтобы вывести имена участников, ставшие недействительными из-за изменения конфигурации. Если после запуска скрипта список останется пуст, значит все имена допустимы.',
	'maintenance-checkUsernames-desc' => 'Проверка действительности пользователей базы данных',
	'maintenance-checkUsernames-error-notvalid' => 'Неверное имя участника: $3 (идентификатор пользователя $2)',
	'maintenance-cleanupCaps' => 'Используйте эту форму для исправления страниц, испорченных изменением $wgCapitalLinks',
	'maintenance-cleanupCaps-desc' => 'Скрипт для очистки перевода в заглавные буквы',
	'maintenance-cleanupCaps-option-namespace' => 'Номер пространства имён для запуска очистки заглавных букв',
	'maintenance-cleanupCaps-output-islower' => '«$1» уже нижнем регистре.',
	'maintenance-cleanupCaps-output-clash' => '«$1» пропущена; «$2» уже существует',
	'maintenance-cleanupCaps-output-dryrun' => '«$1» → «$2»: ПРОБНЫЙ ЗАПУСК, НЕ ПЕРЕИМЕНОВАНА',
	'maintenance-cleanupCaps-error-noneed' => '$wgCapitalLinks включён — нет необходимости для очистки ссылок с заглавными буквами',
	'maintenance-cleanupSpam-output-reverting' => 'возврат',
	'maintenance-createAndPromote' => 'Используйте эту форму для создания нового участника с правами администратора.
Обратите внимание на форму бюрократа, если вы хотите сделать его бюрократом',
	'maintenance-createAndPromote-desc' => 'Создать участника со статусом администратора',
	'maintenance-createAndPromote-option-bureaucrat' => 'Дать участнику права бюрократа',
	'maintenance-createAndPromote-output-creating' => 'Создание и продвижение {{ns:user}}:$2...',
	'maintenance-deleteBatch' => 'Используйте эту форму для массового удаления страниц.
На одной строке должна находиться только одна страница.',
	'maintenance-deleteBatch-desc' => 'Массовое удаление страниц',
	'maintenance-deleteRevision' => 'Используйте эту форму для массового удаления версий страниц.
На одной строке должен быть только один номер версии страницы',
	'maintenance-deleteRevision-desc' => 'Удаление версий страниц из базы данных',
	'maintenance-initEditCount-desc' => 'Пересчитать число правок участников',
	'maintenance-initSiteStats' => 'Используйте эту форму для пересчёта статистики сайта, при необходимости укажите, что нужно пересчитывать также просмотры страниц',
	'maintenance-initSiteStats-desc' => 'Пересчитать статистику сайта',
	'maintenance-moveBatch' => 'Используйте эту форму для массового переименования страниц.
Каждая строка должна содержать исходную страницу и её новое название, разделённые знаком «|»',
	'maintenance-moveBatch-desc' => 'Массовое переименование страниц',
	'maintenance-reassignEdits-desc' => 'Переназначить правки с одного участника на другого',
	'maintenance-runJobs-desc' => 'Запустить задания в очереди заданий',
	'maintenance-runJobs-option-maxjobs' => 'Наибольшее количество задач для запуска',
	'maintenance-runJobs-option-type' => 'Вид работы для запуска',
	'maintenance-runJobs-option-procs' => 'Количество процессов для использования',
	'maintenance-runJobs-option-exclusive' => 'Одновременно выполнять только один эксклюзивный сценарий runJobs. Тайм-аут составляет 1800 секунд.',
	'maintenance-runJobs-error-invalidprocs' => 'Вы должны указать от 1 до 1000 процессов',
	'maintenance-showJobs-desc' => 'Показать список заданий из очереди заданий',
	'maintenance-showJobs-option-group' => 'Показать число задач по их типам',
	'maintenance-sql' => 'Используйте эту форму для выполнения SQL-запроса в базе данных.',
	'maintenance-sql-desc' => 'Выполнить SQL-запрос',
	'maintenance-sql-option-file' => 'SQL для выполнения',
	'maintenance-sql-output-aff' => 'Запрос выполнен. {{PLURAL:$1|Обработана $1 строка|Обработано $1 строки|Обработано $1 строк}}.',
	'maintenance-sql-error-cantopen' => 'Невозможно открыть входной файл',
	'maintenance-showCacheStats-desc' => 'Показать статистику Memcached',
	'maintenance-eval' => 'используйте эту форму для проверка кода PHP в окружении MediaWiki.',
	'maintenance-eval-desc' => 'Проверка кода PHP в окружении MediaWiki',
	'maintenance-update' => 'Использовать UPDATE для обновления таблицы? Снимите отметку чтобы использовать DELETE/INSERT.',
	'maintenance-noviews' => 'Проверьте это для предотвращения обновления числа просмотров',
	'maintenance-invalidname' => 'Ошибочное имя участника!',
	'maintenance-userexists' => 'Участник уже существует!',
	'maintenance-invalidtitle' => 'Ошибочный заголовок «$1»!',
	'maintenance-titlenoexist' => 'Указанный заголовок («$1») не существует!',
	'maintenance-failed' => 'НЕУДАЧНО',
	'maintenance-deleted' => 'УДАЛЕНО',
	'maintenance-revdelete' => 'Удаление {{PLURAL:$3|версия страницы|версии страницы|версий страниц}} $1 из вики $2',
	'maintenance-revnotfound' => 'Версия страницы $1 не найдена!',
	'maintenance-showCacheStats-edits' => 'Число правок: $1',
	'maintenance-showCacheStats-articles' => 'Количество страниц в основном пространстве: $1',
	'maintenance-showCacheStats-pages' => 'Количество страниц: $1',
	'maintenance-showCacheStats-users' => 'Количество участников: $1',
	'maintenance-showCacheStats-admins' => 'Количество администраторов: $1',
	'maintenance-showCacheStats-images' => 'Количество файлов: $1',
	'maintenance-showCacheStats-views' => 'Количество просмотров страниц: $1',
	'maintenance-showCacheStats-update' => 'Обновление базы данных...',
	'maintenance-move' => 'Переименование $1 в $2...',
	'maintenance-movefail' => 'Ошибки, возникшие при переименовании: $1.
Переименование отменено',
	'maintenance-error' => 'Ошибка: $1',
	'maintenance-memc-fake' => 'Вы запустили FakeMemCachedClient. Статистика не может быть предоставлена.',
	'maintenance-memc-requests' => 'Запросы',
	'maintenance-memc-withsession' => 'с сеансом:',
	'maintenance-memc-withoutsession' => 'без сеанса:',
	'maintenance-memc-total' => 'всего:',
	'maintenance-memc-parsercache' => 'Кэш парсера',
	'maintenance-memc-hits' => 'просмотров:',
	'maintenance-memc-invalid' => 'ошибочных:',
	'maintenance-memc-expired' => 'истекших:',
	'maintenance-memc-absent' => 'отсутствует:',
	'maintenance-memc-stub' => 'порог заготовок:',
	'maintenance-memc-imagecache' => 'Кэш изображений',
	'maintenance-memc-misses' => 'ошибок:',
	'maintenance-memc-updates' => 'обновлений:',
	'maintenance-memc-uncacheable' => 'некэшируемых:',
	'maintenance-memc-diffcache' => 'Кэш сравнений версий',
	'maintenance-reassignEdits' => 'Используйте эту форму для переназначения правок от одного участника к другому.',
	'maintenance-re-from' => 'Имя участника, правки которого переназначаются',
	'maintenance-re-to' => 'Имя участника, которому переназначаются правки',
	'maintenance-re-force' => 'Переназначить, даже если целевого участника не существует',
	'maintenance-re-rc' => 'Не обновлять таблицу свежих правок',
	'maintenance-re-report' => 'Вывести подробности об изменениях, но не применять их',
	'maintenance-re-nf' => 'Участник $1 не найден',
	'maintenance-re-rr' => 'Выполнить скрипт опять без «$1» к обновлению.',
	'maintenance-re-ce' => 'Текущие правки: $1',
	'maintenance-re-de' => 'Удалённые правки: $1',
	'maintenance-re-rce' => 'Записи свежих правок: $1',
	'maintenance-re-total' => 'Всего записей для изменения: $1',
	'maintenance-re-re' => 'Переназначение правок{{int:ellipsis}} завершено',
);

/** Sinhala (සිංහල)
 * @author Singhalawap
 * @author පසිඳු කාවින්ද
 */
$messages['si'] = array(
	'maintenance' => 'නඩත්තු කිරීම් කොටස්කර ධාවනය කරන්න',
	'maintenance-backlink' => 'අක්ෂර තේරීම වෙත නැවතත්',
	'maintenance-error-badargs' => 'ඔබ විසින් අවශ්‍ය විකල්පයන් සියල්ලම විශේෂණය කරේ නැත',
	'maintenance-generic-done' => 'සිදුකලා',
	'maintenance-generic-username' => 'පරිශීලක නාමය',
	'maintenance-generic-password' => 'මුරපදය',
	'maintenance-generic-reason' => 'හේතුව',
	'maintenance-cleanupTable-dry-run' => 'වියළි ධාවනයක් සිදු කරන්න',
	'maintenance-cleanupTable-check' => 'අයහපත් ශීර්ෂයන් සඳහා පරික්ෂා කරමින්...',
	'maintenance-cleanupTable-checkfix' => 'අයහපත් ශිර්ෂ පරික්ෂා කරමින් සහ සකස් කරමින්...',
	'maintenance-cleanupTable-missingparam' => '$1: $2 දක්නට නොමැති පරාමිතිය',
	'maintenance-cleanupTable-processing' => 'ක්‍රියායනය වෙමින් $1...',
	'maintenance-option-quiet' => 'දෝෂයක්-නොවන ප්‍රතිදානයක් මැඩපවත්වන්න',
	'maintenance-option-confirm' => 'තහවුරු කරන්න',
	'maintenance-option-required' => '(අවශ්‍යයි)',
	'maintenance-option-optional' => '(වෛකල්පිත)',
	'maintenance-output-success' => '$1 සාර්ථකව දුවන ලදී!',
	'maintenance-output-failure' => '$1 සාර්ථකව දුවන නොලදී!',
	'maintenance-attachLatest-output-begin' => 'page_latest කට්ටලය 0...  සමඟ පිටු සඳහා සොයමින්',
	'maintenance-attachLatest-output-norev' => '$1 $2 [[$3]] නවතම කාලය $4, සංශෝධන හැඳුනුම සොයා ගත නොහැක',
	'maintenance-attachLatest-output-found' => '$1 $2 [[$3]] නවතම කාලය $4, rev id $5',
	'maintenance-changePassword' => 'පරිශීලකගේ මුරපදය වෙනස් කිරීමට මෙම ආකෘතිපත්‍රය භාවිතා කරන්න',
	'maintenance-changePassword-desc' => 'පරිශීලකගේ මුරපදය වෙනස් කරන්න',
	'maintenance-changePassword-error-nouser' => 'පරිශීලකයෙකු නැත: $1',
	'maintenance-changePassword-output-set' => '$1 සඳහා මුරපදය සකසන ලදී',
	'maintenance-checkAutoLoader-desc' => 'ස්වයංපූරක සිහිනුවණ පරීක්ෂාවන්',
	'maintenance-checkBadRedirects-desc' => 'අයහපත් යළියොමුකිරීම් සඳහා පරික්ෂා කරන්න',
	'maintenance-checkBadRedirects-output-header' => 'යළියොමුකිරීම් පමුණුවමින්...',
	'maintenance-checkBadRedirects-output-footer' => 'හරි.',
	'maintenance-checkImages-output-noaccess' => '$1: ස්ථානීය වශයෙන් ප්‍රවේශ විය නොහැක',
	'maintenance-checkImages-output-missing' => '$1: දක්නට නොමැත',
	'maintenance-checkImages-output-isdir' => '$1: යනු නාමාවලියකි',
	'maintenance-checkImages-output-truncated' => '$1: ලුප්තයි, වූයේ $2',
	'maintenance-checkImages-output-mismatch' => '$1: ප්‍රමාණය නොගැලපේ DB=$2, සත්‍ය=$3',
	'maintenance-checkImages-output-good' => 'හොද පින්තූර : $1/$2',
	'maintenance-checkSyntax-option-with-extensions' => 'විස්තීර්ණ බහාලුමද ආවර්තනය කරන්න',
	'maintenance-checkSyntax-option-list-file' => 'පරික්ෂා කිරීමට ඇති ගොනු ලැයිස්තුව හෝ නාමාවලීන්',
	'maintenance-checkSyntax-output-svnlist' => 'පෙරළියෙන් ලැයිස්තුව ලබා ගනිමින්...',
	'maintenance-checkSyntax-output-buildlist' => 'ගොනු ලැයිස්තුව තනමින්...',
	'maintenance-checkSyntax-output-error' => '$1 හී දෝෂය පෙළ $2: $3',
	'maintenance-checkSyntax-output-warning' => '$1 ගොනුවේ අවවාදය: $2 හමුවුණි',
	'maintenance-checkSyntax-error-nofile' => 'දෝෂය: ගොනුව හෝ නාමාවලිය සොයාගත නොහැක $1',
	'maintenance-checkSyntax-error-cantopen' => '$1 ගොනුව විවෘත කල නොහැක',
	'maintenance-checkSyntax-error-svnerr' => 'පෙරළියෙන් ලැයිස්තුව ලබා ගැනීමේ දෝෂය!',
	'maintenance-checkUsernames-error-notvalid' => 'වලංගු නොවන පරිශීලක නාමය: "$3" (පරිශීලක හැඳුනුම $2)',
	'maintenance-cleanupCaps-desc' => 'ප්‍රාග්ධනායනය ශුද්ධ කල යුතු කොටස්කරය',
	'maintenance-cleanupCaps-output-islower' => '"$1" දැනටමත් කුඩා අකුරකි.',
	'maintenance-cleanupCaps-output-clash' => '"$1" මඟහරින ලදී; "$2" දැනටමත් පවතී',
	'maintenance-cleanupCaps-output-dryrun' => '"$1" -> "$2": ශුෂ්ක ධාවනය, ගෙන නොයන ලදී',
	'maintenance-cleanupSpam-option-hostname' => 'ඔත්තු බලන ධාරකනාමය',
	'maintenance-cleanupSpam-output-false' => 'අසත්‍ය ගැළපීම',
	'maintenance-cleanupSpam-output-blanking' => 'ශුන්‍ය කරමින්',
	'maintenance-cleanupSpam-output-reverting' => 'ප්‍රතිවර්තනය කරමින්',
	'maintenance-cleanupSpam-error-noid' => 'අභ්‍යන්තර දෝෂය: $1 හැඳුනුම සඳහා පිටුවක් නොමැත',
	'maintenance-deleteBatch-desc' => 'සමස්ත-පිටු මැකුම',
	'maintenance-initSiteStats-desc' => 'අඩවි සංඛ්‍යාන දත්ත නැවත ගණනය කරන්න',
	'maintenance-moveBatch-desc' => 'පිටු ගොඩක් ගෙනයාම',
	'maintenance-runJobs-desc' => 'කෘත්‍ය පෙලේ කාර්යයන් ධාවනය කරන්න',
	'maintenance-runJobs-option-maxjobs' => 'ධාවනය කල යුතු කාර්යයන් ගණන',
	'maintenance-runJobs-option-type' => 'ධාවනය කල යුතු කාර්යයේ වර්ගය',
	'maintenance-runJobs-option-procs' => 'භාවිතයට ගත යුතු ක්‍රියාවලියන් ගණන',
	'maintenance-showJobs-option-group' => 'කාර්යයන් වර්ගය අනුව කාර්යයන් ගණන පෙන්වන්න',
	'maintenance-sql-desc' => 'SQL ප්‍රශ්නය ක්‍රියාත්මක කරන්න',
	'maintenance-sql-option-file' => 'සම්පාදනය කල යුතු SQL',
	'maintenance-sql-error-cantopen' => 'ආදාන ගොනුව විවෘත කල නොහැක',
	'maintenance-showCacheStats-desc' => 'මතකකෑෂිත සංඛ්‍යාලේඛන පෙන්වන්න',
	'maintenance-invalidname' => 'වලංගු නොවන පරිශීලක නාමය!',
	'maintenance-userexists' => 'පරිශීලක දැනටමත් පවතියි!',
	'maintenance-invalidtitle' => 'වලංගු නොවන ශීර්ෂය "$1"!',
	'maintenance-titlenoexist' => 'විශේෂණය කෙරූ ("$1") ශීර්ෂය නොපවතී!',
	'maintenance-failed' => 'අසාර්ථක වූ',
	'maintenance-deleted' => 'මකා දමන ලද',
	'maintenance-revnotfound' => '$1 සංශෝධනය හමු නොවුණි!',
	'maintenance-showCacheStats-edits' => 'සංස්කරණ සංඛ්‍යාව: $1',
	'maintenance-showCacheStats-pages' => 'පිටු සංඛ්‍යාව: $1',
	'maintenance-showCacheStats-users' => 'පරිශීලකයන් සංඛ්‍යාව: $1',
	'maintenance-showCacheStats-admins' => 'පරිපාලකවරුන් සංඛ්‍යාව: $1',
	'maintenance-showCacheStats-images' => 'ගොනු සංඛ්‍යාව: $1',
	'maintenance-showCacheStats-views' => 'පිටුනැරඹුම් සංඛ්‍යාව: $1',
	'maintenance-showCacheStats-update' => 'දත්ත සංචිතය යාවත්කාලීන කරමින්{{int:ellipsis}}',
	'maintenance-move' => '$2 වෙත $1 ගෙනයමින්{{int:ellipsis}}',
	'maintenance-error' => 'දෝෂය: $1',
	'maintenance-memc-requests' => 'අයදුම්',
	'maintenance-memc-withsession' => 'සැසියක් සමඟ:',
	'maintenance-memc-withoutsession' => 'සැසියක් නොමැතිව:',
	'maintenance-memc-total' => 'එකතුව:',
	'maintenance-memc-parsercache' => 'ව්‍යාකරණ විග්‍රහ කෑෂය',
	'maintenance-memc-hits' => 'වැදුම්:',
	'maintenance-memc-invalid' => 'වලංගු නැති:',
	'maintenance-memc-expired' => 'ඉකුත් වූ:',
	'maintenance-memc-absent' => 'අසම්මුඛ:',
	'maintenance-memc-stub' => 'අක්කඩ ඒළකය:',
	'maintenance-memc-imagecache' => 'පින්තූර කෑෂය',
	'maintenance-memc-misses' => 'අතෑරුම්:',
	'maintenance-memc-updates' => 'යාවත්කාලීන:',
	'maintenance-memc-uncacheable' => 'කෑෂිත කල නොහැකි:',
	'maintenance-memc-diffcache' => 'වෙනස්කම් කෑෂය',
	'maintenance-re-from' => 'සංස්කරණ පවරා ගත යුතු පරිශීලකගේ නම',
	'maintenance-re-to' => 'සංස්කරණ පැවරිය යුතු පරිශීලකගේ නම',
	'maintenance-re-rc' => 'මෑත වෙනස්කම් වගුව යාවත්කාලීන කරන්න එපා',
	'maintenance-re-nf' => '$1 පරිශීලක හමුනොවුණි',
	'maintenance-re-ce' => 'වත්මන් සංස්කරණ: $1',
	'maintenance-re-de' => 'මකාදැමූ සංස්කරණ: $1',
	'maintenance-re-rce' => 'මෑතවෙනස්වීම් ඇතුල් කිරීම්: $1',
	'maintenance-re-total' => 'වෙනස් කිරීමට ඇති සමස්ත ඇතුල් කිරීම්: $1',
	'maintenance-re-re' => 'සංස්කරණ යළිපවරාගනිමින්{{int:ellipsis}} හරි',
);

/** Slovak (slovenčina)
 * @author Helix84
 */
$messages['sk'] = array(
	'maintenance' => 'Spustiť údržbové skripty',
	'maintenance-desc' => '[[Special:Maintenance|Webové rozhranie]] pre rozličné údržbové skripty',
	'right-maintenance' => 'Spúšťať údržbové skripty pomocou [[Special:Maintenance]]',
	'maintenance-backlink' => 'Späť na výber skriptu',
	'maintenance-header' => 'Prosím, vyberte dolu skript, ktorý sa má spustiť.',
	'maintenance-error-invalidtype' => 'Neplatný typ!', # Fuzzy
	'maintenance-option-confirm' => 'Potvrdiť',
	'maintenance-output-success' => '$1 prebehol úspešne!',
	'maintenance-changePassword' => 'Tento formulár slúži na zmenu hesla používateľa',
	'maintenance-changePassword-desc' => 'Zmeniť heslo používateľa',
	'maintenance-createAndPromote' => 'Tento formulár slúži na vytvorenie nového používateľa a jeho povýšenie na správcu.
Označte pole „byrokrat” ak ho chcete povýšiť aj na byrokrata.',
	'maintenance-createAndPromote-desc' => 'Vytvoriť používateľa a povyšiť ho na správcu',
	'maintenance-deleteBatch' => 'Tento formulár slúži na hromadné mazanie stránok.
Píšte iba jednu stránku na riadok',
	'maintenance-deleteBatch-desc' => 'Hromadné mazanie stránok',
	'maintenance-deleteRevision' => 'Tento formulár slúži na hromadné mazanie revízií.
Píšte iba jednu revíziu na riadok',
	'maintenance-deleteRevision-desc' => 'Odstránenie revízií z databázy',
	'maintenance-initEditCount-desc' => 'Znovu spočítať počty úprav používateľov',
	'maintenance-initSiteStats' => 'Tento formulár slúži na prepočítanie štatistík tejto wiki. Môžete určiť, či chcete prepočítať aj zobrazenia stránok.',
	'maintenance-initSiteStats-desc' => 'Znovu spočítať štatistiky wiki',
	'maintenance-moveBatch' => 'Tento formulár slúži na hromadné presúvanie stránok.
Na každom riadku by ste mali určiť zdrojovú a cieľovú stránku oddelenú znakom rúry („|”).',
	'maintenance-moveBatch-desc' => 'Hromadný presun stránok',
	'maintenance-reassignEdits-desc' => 'Zmeniť pôvodcu úprav z jedného používateľa na iného',
	'maintenance-runJobs-desc' => 'Spustiť úlohy vo fronte úloh',
	'maintenance-showJobs-desc' => 'Zobraziť zoznam čakajúcich úloh vo fronte úloh',
	'maintenance-sql' => 'Tento formulár môžete použiť na vykonanie SQL požiadavky do databázy.',
	'maintenance-sql-desc' => 'Vykonať SQL požiadavku',
	'maintenance-showCacheStats-desc' => 'Zobraziť štatistiky Memcached',
	'maintenance-eval' => 'Tento formulár môžete použiť na vyhodnotenie PHP kódu v prostredí MediaWiki.',
	'maintenance-eval-desc' => 'Vyhodnocovať PHP kód v prostredí MediaWiki',
	'maintenance-update' => 'Použiť na aktualizáciu tabuľky UPDATE? Ak nie, použije sa DELETE/INSERT.',
	'maintenance-noviews' => 'Ak je toto pole označené, nebude sa aktualizovať počet zobrazení stránky',
	'maintenance-invalidname' => 'Neplatné používateľské meno!',
	'maintenance-userexists' => 'Používateľ už existuje!',
	'maintenance-invalidtitle' => 'Neplatný názov „$1”!',
	'maintenance-titlenoexist' => 'Uvedený názov („$1”) neexistuje!',
	'maintenance-failed' => 'ZLYHALO',
	'maintenance-deleted' => 'ZMAZANÉ',
	'maintenance-revdelete' => '{{PLURAL:$3|Maže sa revízia|Mažú sa revízie}} $1 z wiki $2',
	'maintenance-revnotfound' => 'Revízia $1 nenájdená!',
	'maintenance-showCacheStats-edits' => 'Počet úprav: $1',
	'maintenance-showCacheStats-articles' => 'Počet stránok v hlavnom mennom priestore: $1',
	'maintenance-showCacheStats-pages' => 'Počet stránok: $1',
	'maintenance-showCacheStats-users' => 'Počet používateľov: $1',
	'maintenance-showCacheStats-admins' => 'Počet správcov: $1',
	'maintenance-showCacheStats-images' => 'Počet súborov: $1',
	'maintenance-showCacheStats-views' => 'Počet zobrazení stránky: $1',
	'maintenance-showCacheStats-update' => 'Aktualizuje sa databáza{{int:ellipsis}}',
	'maintenance-move' => 'Presúva sa $1 na $2{{int:ellipsis}}',
	'maintenance-movefail' => 'Počas presúvania sa vyskytla chyba: $1.
Presúvanie sa ruší',
	'maintenance-error' => 'Chyba: $1',
	'maintenance-memc-fake' => 'Používate FakeMemCachedClient. Štatistiky nie sú dostupné',
	'maintenance-memc-requests' => 'Požiadavky',
	'maintenance-memc-withsession' => 's reláciou:',
	'maintenance-memc-withoutsession' => 'bez relácie:',
	'maintenance-memc-total' => 'celkom:',
	'maintenance-memc-parsercache' => 'Vyrovnávacia pamäť syntaktického analyzátora',
	'maintenance-memc-hits' => 'zásahov:',
	'maintenance-memc-invalid' => 'neplatných:',
	'maintenance-memc-expired' => 'vypršaných:',
	'maintenance-memc-absent' => 'chýbajúcich:',
	'maintenance-memc-stub' => 'prah výhonku:',
	'maintenance-memc-imagecache' => 'Vyrovnávacia pamäť obrázkov',
	'maintenance-memc-misses' => 'minutí:',
	'maintenance-memc-updates' => 'aktualizácií:',
	'maintenance-memc-uncacheable' => 'nebolo možné použiť vyrovnávaciu pamäť:',
	'maintenance-memc-diffcache' => 'Rozdiel vo vyrovnávacej pamäti',
	'maintenance-reassignEdits' => 'Tento formulár môžete použiť na zmenu pôvodcu úprav z jedného používateľa na iného.',
	'maintenance-re-from' => 'Používateľské meno ktorého úpravy chcete zmeniť',
	'maintenance-re-to' => 'Používateľské meno komu chcete úpravy pripísať',
	'maintenance-re-force' => 'Zmeniť pôvodcu aj ak cieľový používateľ neexistuje',
	'maintenance-re-rc' => 'Neaktualizovať tabuľku posledných úprav',
	'maintenance-re-report' => 'Vypísať podrobnosti čo sa zmení, ale zatiaľ nevykonávať zmeny',
	'maintenance-re-nf' => 'Používateľ $1 nebol nájdený',
	'maintenance-re-rr' => 'Aktualizáciu vykonáte opätovným spustením skriptu bez „$1“',
	'maintenance-re-ce' => 'Aktuálne úpravy: $1',
	'maintenance-re-de' => 'Zmazané úpravy: $1',
	'maintenance-re-rce' => 'Záznamy Posledných úprav: $1',
	'maintenance-re-total' => 'Zmeniť celkovo záznamov: $1',
	'maintenance-re-re' => 'Zmena pôvodcu úprav{{int:ellipsis}} hotovo',
);

/** Slovenian (slovenščina)
 * @author Dbc334
 */
$messages['sl'] = array(
	'maintenance-generic-username' => 'Uporabniško ime',
);

/** Serbian (Cyrillic script) (српски (ћирилица)‎)
 * @author Rancher
 * @author Жељко Тодоровић
 * @author Михајло Анђелковић
 */
$messages['sr-ec'] = array(
	'maintenance' => 'Покрени скрипте за одржавање',
	'maintenance-desc' => '[[Special:Maintenance|Вики-сучеље]] за разне скриптове за одржавање',
	'maintenance-backlink' => 'Повратак на обележавање скрипти',
	'maintenance-header' => 'Молимо Вас да испот означите скрипту коју треба покренути.
Поред сваке скрипте се налази одговарајући опис.',
	'maintenance-error-invalidtype' => 'Не могу да пронађем наведени скрипт',
	'maintenance-generic-done' => 'готово',
	'maintenance-generic-username' => 'Корисничко име',
	'maintenance-generic-password' => 'Лозинка',
	'maintenance-generic-reason' => 'Разлог',
	'maintenance-cleanupTable-check' => 'Провера на лоше наслове...',
	'maintenance-cleanupTable-checkfix' => 'Проналажење и исправљање лоших наслова...',
	'maintenance-cleanupTable-processing' => 'Обрада $1...',
	'maintenance-option-confirm' => 'Потврди',
	'maintenance-option-required' => '(обавезно)',
	'maintenance-option-optional' => '(необавезно)',
	'maintenance-output-success' => '$1 се успешно извршила!',
	'maintenance-output-failure' => '$1 није успешно извршена!',
	'maintenance-changePassword' => 'Користите ову форму да бисте променили лозинку корисника',
	'maintenance-changePassword-desc' => 'Промени лозинку корисника',
	'maintenance-changePassword-error-nouser' => 'Нема таквог корисника: $1',
	'maintenance-changePassword-output-set' => 'Постављена је лозинка за $1',
	'maintenance-checkBadRedirects-desc' => 'Потражи неисправна преусмерења',
	'maintenance-checkBadRedirects-output-header' => 'Преузимам преусмерења…',
	'maintenance-checkBadRedirects-output-footer' => '
Готово.',
	'maintenance-checkImages' => 'Послужите се овим обрасцем да сазнате које су слике на вашем викију оштећене',
	'maintenance-createAndPromote-desc' => 'Направи корисника и унапреди га у администратора',
	'maintenance-deleteBatch' => 'Користите ову форму да бисте масовно брисали странице.
Уписујте само једну страну по линији.',
	'maintenance-deleteBatch-desc' => 'Стране за масовно брисање',
	'maintenance-deleteRevision' => 'Користите ову страну да бисте масовно брисали ревизије.
Уписујте број само једне ревизије по линији.',
	'maintenance-deleteRevision-desc' => 'Обриши ревизије из базе података',
	'maintenance-initEditCount-desc' => 'Освежи корисничке бројаче измена',
	'maintenance-initSiteStats' => 'Користите ову форму да бисте освежили статистике сајта, означивши да ли такође желите да освежите и прегледе страница.',
	'maintenance-initSiteStats-desc' => 'Освежи статистике сајта',
	'maintenance-moveBatch' => 'Користите ову форму да бисте масовно премештали странице.
У свакој линији треба (тим редом) означити тренутно и циљано име странице, и раздвојити их знаком "|"',
	'maintenance-moveBatch-desc' => 'Стране за масовно премештање',
	'maintenance-reassignEdits-desc' => 'Припиши измене једног корисника другом',
	'maintenance-runJobs-desc' => 'Покрени послове из реда за послове',
	'maintenance-showJobs-desc' => 'Покажи списак послова из реда за послове',
	'maintenance-sql' => 'Користите ову форму да извршите SQL захтев над базом података.',
	'maintenance-sql-desc' => 'Изврши SQL захтев',
	'maintenance-eval' => 'Користите ову форму да развијете PHP код у МедијаВики окружењу.',
	'maintenance-eval-desc' => 'Развиј PHP код у МедијаВики окружењу',
	'maintenance-noviews' => 'Означите ово да бисте спрежили освежавање броја прегледа страна',
	'maintenance-invalidname' => 'Погрешно корисничко име!',
	'maintenance-userexists' => 'Тај корисник већ постоји!',
	'maintenance-invalidtitle' => 'Неисправан наслов "$1"!',
	'maintenance-titlenoexist' => 'Наведени наслов ("$1") не постоји!',
	'maintenance-failed' => 'НЕУСПЕЛО',
	'maintenance-deleted' => 'ОБРИСАНО',
	'maintenance-revdelete' => 'Брисање {{PLURAL:$3|ревизије|ревизија}} $1 са $2-Викија.',
	'maintenance-revnotfound' => 'Ревизија $1 није пронађена!',
	'maintenance-showCacheStats-edits' => 'Број измена: $1',
	'maintenance-showCacheStats-articles' => 'Број страница у главном именском простору: $1',
	'maintenance-showCacheStats-pages' => 'Број страница: $1',
	'maintenance-showCacheStats-users' => 'Број корисника: $1',
	'maintenance-showCacheStats-admins' => 'Број администратора: $1',
	'maintenance-showCacheStats-images' => 'Број фајлова: $1',
	'maintenance-showCacheStats-views' => 'Број прегледа страница: $1',
	'maintenance-showCacheStats-update' => 'Освежавање базе података{{int:ellipsis}}',
	'maintenance-move' => 'Премештање $1 на $2{{int:ellipsis}}',
	'maintenance-movefail' => 'Грешка приликом премештања: $1.
Опозивање премештања',
	'maintenance-error' => 'Грешка: $1',
	'maintenance-memc-fake' => 'Ви сте покренули FakeMemCachedClient. Статистике не могу бити приложене',
	'maintenance-memc-requests' => 'Захтеви',
	'maintenance-memc-withsession' => 'са сесијом:',
	'maintenance-memc-withoutsession' => 'без сесије:',
	'maintenance-memc-total' => 'укупно:',
	'maintenance-memc-parsercache' => 'Кеш рашчлањивача',
	'maintenance-memc-hits' => 'погодака:',
	'maintenance-memc-invalid' => 'неисправно:',
	'maintenance-memc-expired' => 'истекло:',
	'maintenance-memc-absent' => 'одсутно:',
	'maintenance-memc-stub' => 'праг клице:',
	'maintenance-memc-imagecache' => 'Кеш слика',
	'maintenance-memc-misses' => 'промашаји',
	'maintenance-memc-uncacheable' => 'немогуће кеширати:',
	'maintenance-reassignEdits' => 'Користите ову форму да припишете измене једног корисника другом.',
	'maintenance-re-from' => 'Корисничко име чије се измене приписују',
	'maintenance-re-to' => 'Корисничко име којем се измене приписују',
	'maintenance-re-force' => 'Припиши чак иако циљани корисник не постоји',
	'maintenance-re-rc' => 'Не бележи измене у скорашњим изменама',
	'maintenance-re-nf' => 'Корисник $1 није пронађен',
	'maintenance-re-rr' => 'Опет покрени скрипту "$1" зарад освежења.',
	'maintenance-re-ce' => 'Тренутне измене: $1',
	'maintenance-re-de' => 'Обрисане измене: $1',
	'maintenance-re-re' => 'Приписивање измена{{int:ellipsis}} готово',
);

/** Serbian (Latin script) (srpski (latinica)‎)
 * @author Michaello
 */
$messages['sr-el'] = array(
	'maintenance' => 'Pokreni skripte za održavanje',
	'maintenance-desc' => '[[Special:Maintenance|Viki interfejs]] za razne skripte za održavanje',
	'maintenance-backlink' => 'Povratak na obeležavanje skripti',
	'maintenance-header' => 'Molimo Vas da ispot označite skriptu koju treba pokrenuti.
Pored svake skripte se nalazi odgovarajući opis.',
	'maintenance-error-invalidtype' => 'Ne mogu da pronađem navedeni skript',
	'maintenance-generic-done' => 'gotovo',
	'maintenance-generic-username' => 'Korisničko ime',
	'maintenance-generic-password' => 'Lozinka',
	'maintenance-generic-reason' => 'Razlog',
	'maintenance-cleanupTable-check' => 'Provera na loše naslove...',
	'maintenance-cleanupTable-checkfix' => 'Pronalaženje i ispravljanje loših naslova...',
	'maintenance-cleanupTable-processing' => 'Obrada $1...',
	'maintenance-option-confirm' => 'Potvrdi',
	'maintenance-option-required' => '(obavezno)',
	'maintenance-option-optional' => '(neobavezno)',
	'maintenance-output-success' => '$1 se uspešno izvršila!',
	'maintenance-output-failure' => '$1 nije uspešno izvršena!',
	'maintenance-changePassword' => 'Koristite ovu formu da biste promenili lozinku korisnika',
	'maintenance-changePassword-desc' => 'Promeni lozinku korisnika',
	'maintenance-changePassword-error-nouser' => 'Nema takvog korisnika: $1',
	'maintenance-changePassword-output-set' => 'Postavljena je lozinka za $1',
	'maintenance-checkBadRedirects-desc' => 'Potraži neispravna preusmerenja',
	'maintenance-checkBadRedirects-output-header' => 'Preuzimam preusmerenja…',
	'maintenance-checkBadRedirects-output-footer' => '
Gotovo.',
	'maintenance-checkImages' => 'Poslužite se ovim obrascem da saznate koje su slike na vašem vikiju oštećene',
	'maintenance-createAndPromote-desc' => 'Napravi korisnika i unapredi ga u administratora',
	'maintenance-deleteBatch' => 'Koristite ovu formu da biste masovno brisali stranice.
Upisujte samo jednu stranu po liniji.',
	'maintenance-deleteBatch-desc' => 'Strane za masovno brisanje',
	'maintenance-deleteRevision' => 'Koristite ovu stranu da biste masovno brisali revizije.
Upisujte broj samo jedne revizije po liniji.',
	'maintenance-deleteRevision-desc' => 'Obriši revizije iz baze podataka',
	'maintenance-initEditCount-desc' => 'Osveži korisničke brojače izmena',
	'maintenance-initSiteStats' => 'Koristite ovu formu da biste osvežili statistike sajta, označivši da li takođe želite da osvežite i preglede stranica.',
	'maintenance-initSiteStats-desc' => 'Osveži statistike sajta',
	'maintenance-moveBatch' => 'Koristite ovu formu da biste masovno premeštali stranice.
U svakoj liniji treba (tim redom) označiti trenutno i ciljano ime stranice, i razdvojiti ih znakom "|"',
	'maintenance-moveBatch-desc' => 'Strane za masovno premeštanje',
	'maintenance-reassignEdits-desc' => 'Pripiši izmene jednog korisnika drugom',
	'maintenance-runJobs-desc' => 'Pokreni poslove iz reda za poslove',
	'maintenance-showJobs-desc' => 'Pokaži spisak poslova iz reda za poslove',
	'maintenance-sql' => 'Koristite ovu formu da izvršite SQL zahtev nad bazom podataka.',
	'maintenance-sql-desc' => 'Izvrši SQL zahtev',
	'maintenance-eval' => 'Koristite ovu formu da razvijete PHP kod u MedijaViki okruženju.',
	'maintenance-eval-desc' => 'Razvij PHP kod u MedijaViki okruženju',
	'maintenance-noviews' => 'Označite ovo da biste sprežili osvežavanje broja pregleda strana',
	'maintenance-invalidname' => 'Pogrešno korisničko ime!',
	'maintenance-userexists' => 'Taj korisnik već postoji!',
	'maintenance-invalidtitle' => 'Neispravan naslov "$1"!',
	'maintenance-titlenoexist' => 'Navedeni naslov ("$1") ne postoji!',
	'maintenance-failed' => 'NEUSPELO',
	'maintenance-deleted' => 'OBRISANO',
	'maintenance-revdelete' => 'Brisanje {{PLURAL:$3|revizije|revizija}} $1 sa $2-Vikija.',
	'maintenance-revnotfound' => 'Revizija $1 nije pronađena!',
	'maintenance-showCacheStats-edits' => 'Broj izmena: $1',
	'maintenance-showCacheStats-articles' => 'Broj strana u glavnom imenskom prostoru: $1',
	'maintenance-showCacheStats-pages' => 'Broj strana: $1',
	'maintenance-showCacheStats-users' => 'Broj korisnika: $1',
	'maintenance-showCacheStats-admins' => 'Broj administratora: $1',
	'maintenance-showCacheStats-images' => 'Broj fajlova: $1',
	'maintenance-showCacheStats-views' => 'Broj pregleda strana: $1',
	'maintenance-showCacheStats-update' => 'Osvežavanje baze podataka{{int:ellipsis}}',
	'maintenance-move' => 'Premeštanje $1 na $2{{int:ellipsis}}',
	'maintenance-movefail' => 'Greška prilikom premeštanja: $1.
Opozivanje premeštanja',
	'maintenance-error' => 'Greška: $1',
	'maintenance-memc-fake' => 'Vi ste pokrenuli FakeMemCachedClient. Statistike ne mogu biti priložene',
	'maintenance-memc-requests' => 'Zahtevi',
	'maintenance-memc-withsession' => 'sa sesijom:',
	'maintenance-memc-withoutsession' => 'bez sesije:',
	'maintenance-memc-total' => 'ukupno:',
	'maintenance-memc-parsercache' => 'Keš parsera',
	'maintenance-memc-hits' => 'pogodaka:',
	'maintenance-memc-invalid' => 'neispravno:',
	'maintenance-memc-expired' => 'isteklo:',
	'maintenance-memc-absent' => 'odsutno:',
	'maintenance-memc-stub' => 'prag klice:',
	'maintenance-memc-imagecache' => 'Keš slika',
	'maintenance-memc-misses' => 'promašaji',
	'maintenance-memc-uncacheable' => 'nemoguće keširati:',
	'maintenance-reassignEdits' => 'Koristite ovu formu da pripišete izmene jednog korisnika drugom.',
	'maintenance-re-from' => 'Korisničko ime čije se izmene pripisuju',
	'maintenance-re-to' => 'Korisničko ime kojem se izmene pripisuju',
	'maintenance-re-force' => 'Pripiši čak iako ciljani korisnik ne postoji',
	'maintenance-re-rc' => 'Ne beleži izmene u skorašnjim izmenama',
	'maintenance-re-nf' => 'Korisnik $1 nije pronađen',
	'maintenance-re-rr' => 'Opet pokreni skriptu "$1" zarad osveženja.',
	'maintenance-re-ce' => 'Trenutne izmene: $1',
	'maintenance-re-de' => 'Obrisane izmene: $1',
	'maintenance-re-re' => 'Pripisivanje izmena{{int:ellipsis}} gotovo',
);

/** Sundanese (Basa Sunda)
 * @author Irwangatot
 */
$messages['su'] = array(
	'maintenance-deleted' => 'DIHAPUS',
);

/** Swedish (svenska)
 * @author Fluff
 * @author M.M.S.
 * @author Sannab
 * @author WikiPhoenix
 */
$messages['sv'] = array(
	'maintenance' => 'Kör underhållsskripter',
	'maintenance-desc' => '[[Special:Maintenance|Webbgränssnitt]] för olika underhållsskripter',
	'right-maintenance' => 'Kör underhållsskript genom [[Special:Maintenance]]',
	'maintenance-backlink' => 'Tillbaka till skriptvalet',
	'maintenance-header' => 'Var god ange ett skript nedan till att exekvera.
Beskrivningar finns brevid varje skript',
	'maintenance-error-invalidtype' => 'Det angivna skriptet hittades inte',
	'maintenance-generic-done' => 'klar',
	'maintenance-generic-username' => 'Användarnamn',
	'maintenance-generic-password' => 'Lösenord',
	'maintenance-generic-reason' => 'Anledning',
	'maintenance-cleanupTable-processing' => 'Bearbetar $1...',
	'maintenance-option-confirm' => 'Bekräfta',
	'maintenance-option-required' => '(nödvändig)',
	'maintenance-option-optional' => '(valfri)',
	'maintenance-output-success' => '$1 kördes lyckat!',
	'maintenance-benchmarkPurge-output-trial' => '$1 {{PLURAL:$1|titel|titlar}} på $2ms ($3ms vardera)',
	'maintenance-changePassword' => 'Använd detta formulär för att ändra en användares lösenord',
	'maintenance-changePassword-desc' => 'Ändra en användares lösenord',
	'maintenance-changePassword-error-nouser' => 'Ingen sådan användare: $1',
	'maintenance-checkBadRedirects-desc' => 'Letar efter dåliga omdirigeringar',
	'maintenance-checkBadRedirects-output-header' => 'Hämtar omdirigeringar...',
	'maintenance-checkBadRedirects-output-found' => 'Hittade $1 {{PLURAL:$1|omdirigering|omdirigeringar}}.
Letar efter dåliga omdirigeringar...',
	'maintenance-checkBadRedirects-output-footer' => '
Färdig.',
	'maintenance-cleanupSpam-output-found' => 'Hittade $1 {{PLURAL:$1|artikel|artiklar}} som innehåller $2',
	'maintenance-cleanupSpam-output-reverting' => 'återställer',
	'maintenance-createAndPromote' => 'Använd detta formulär för att skapa en ny användare och befodra den till administratör.
Kryssa i byråkratruta om du vill befodra den till byråkrat istället',
	'maintenance-createAndPromote-desc' => 'Skapa en användare och befodra till administratör',
	'maintenance-deleteBatch' => 'Använd detta formulär för att mass-radera sidor.
Skriv endast in en sida per rad',
	'maintenance-deleteBatch-desc' => 'Mass-radera sidor',
	'maintenance-deleteRevision' => 'Använd detta formulär för att mass-radera versioner.
Skriv endast in en version per rad',
	'maintenance-deleteRevision-desc' => 'Ta bort versioner från databasen',
	'maintenance-initEditCount-desc' => 'Omräkna redigeringräkningarna för användare',
	'maintenance-initSiteStats' => 'Använd detta formulär för att räkna om sajtens statistik, speciellt om du vill räkna om sidvisningar',
	'maintenance-initSiteStats-desc' => 'Omräkna sajtstatistiken',
	'maintenance-moveBatch' => 'Använd detta formulär för att mass-flytta sidor.
Varje rad specifierar den nuvarande sidan och destinationssidan separerade med ett lodrätt streck (|)',
	'maintenance-moveBatch-desc' => 'Mass-flytta sidor',
	'maintenance-reassignEdits-desc' => 'Flytta redigeringar från en användare till en annan',
	'maintenance-runJobs-desc' => 'Köra jobb i jobbkön',
	'maintenance-showJobs-desc' => 'Visa en lista över jobb som ligger i jobbkön',
	'maintenance-sql' => 'Använd detta formulär för att köra en SQL-fråga mot databasen.',
	'maintenance-sql-desc' => 'Kör SQL-fråga',
	'maintenance-showCacheStats-desc' => 'Visa mellanlagrad statistik',
	'maintenance-eval' => 'Använd detta formulär för att testa PHP-kod i MediaWiki-miljön.',
	'maintenance-eval-desc' => 'Evaluera PHP-kod i MediaWiki-miljön',
	'maintenance-update' => 'Använd UPPDATERA när du uppdaterar en tabell? Okryssade använder RADERA/INFOGA istället.',
	'maintenance-noviews' => 'Kolla det här för att förhindra uppdatering av sidvisningar',
	'maintenance-invalidname' => 'Ogiltigt användarnamn!',
	'maintenance-userexists' => 'Användaren existerar redan!',
	'maintenance-invalidtitle' => 'Ogiltig titel "$1"!',
	'maintenance-titlenoexist' => 'Titeln som specifierades ("$1") finns inte!',
	'maintenance-failed' => 'MISSLYCKAD',
	'maintenance-deleted' => 'RADERAD',
	'maintenance-revdelete' => 'Raderar {{PLURAL:$3|versionen|versionerna}} $1 från wiki $2',
	'maintenance-revnotfound' => 'Versionen $1 hittades inte!',
	'maintenance-showCacheStats-edits' => 'Antal redigeringar: $1',
	'maintenance-showCacheStats-articles' => 'Antal sidor i huvudnamnrymden: $1',
	'maintenance-showCacheStats-pages' => 'Antal sidor: $1',
	'maintenance-showCacheStats-users' => 'Antal användare: $1',
	'maintenance-showCacheStats-admins' => 'Antal administratörer: $1',
	'maintenance-showCacheStats-images' => 'Antal filer: $1',
	'maintenance-showCacheStats-views' => 'Antal sidvisningar: $1',
	'maintenance-showCacheStats-update' => 'Uppdaterar databasen{{int:ellipsis}}',
	'maintenance-move' => 'Flyttar $1 till $2{{int:ellipsis}}',
	'maintenance-movefail' => 'Ett fel uppstod medan flyttningen: $1.
Avbryt flyttning',
	'maintenance-error' => 'Fel: $1',
	'maintenance-memc-fake' => 'Du kör en FakeMemCachedClient. Ingen statistik kan uppges',
	'maintenance-memc-requests' => 'Efterfrågningar',
	'maintenance-memc-withsession' => 'med session:',
	'maintenance-memc-withoutsession' => 'utan session:',
	'maintenance-memc-total' => 'totalt:',
	'maintenance-memc-parsercache' => 'Parsercache',
	'maintenance-memc-hits' => 'träffar:',
	'maintenance-memc-invalid' => 'ogiltig:',
	'maintenance-memc-expired' => 'utgick:',
	'maintenance-memc-absent' => 'frånvarande:',
	'maintenance-memc-stub' => 'stubbgräns:',
	'maintenance-memc-imagecache' => 'Bildcache',
	'maintenance-memc-misses' => 'missar:',
	'maintenance-memc-updates' => 'uppdateringar:',
	'maintenance-memc-uncacheable' => 'ej mellanlagringsbara:',
	'maintenance-memc-diffcache' => 'Skillnadscache',
	'maintenance-reassignEdits' => 'Använd detta formulär för att flytta redigeringar från en användare till en annan.',
	'maintenance-re-from' => 'Namn på användaren som redigeringarna skall flyttas från',
	'maintenance-re-to' => 'Namn på användaren som redigeringarna skall flyttas till',
	'maintenance-re-force' => 'Flytta redigeringar även om målanvändaren inte existerar',
	'maintenance-re-rc' => 'Uppdatera inte tabellen för senaste ändringar',
	'maintenance-re-report' => 'Skriv ut detaljer om vad som skulle förändras, men genomför inte förändringen',
	'maintenance-re-nf' => 'Hittade inte användaren "$1"',
	'maintenance-re-rr' => 'Kör skriptet igen utan "$1" för att uppdatera.',
	'maintenance-re-ce' => 'Nuvarande redigeringar: $1',
	'maintenance-re-de' => 'Raderade redigeringar: $1',
	'maintenance-re-rce' => 'Bidrag på senaste ändringar: $1',
	'maintenance-re-total' => 'Totalt antal redigeringar att ändra: $1',
	'maintenance-re-re' => 'Flyttar redigeringar{{int:ellipsis}} klart',
);

/** Tamil (தமிழ்)
 * @author Karthi.dr
 * @author Shanmugamp7
 * @author TRYPPN
 * @author மதனாஹரன்
 */
$messages['ta'] = array(
	'maintenance-generic-done' => 'முடிந்தது',
	'maintenance-generic-username' => 'பயனர் பெயர்',
	'maintenance-generic-password' => 'கடவுச்சொல்',
	'maintenance-generic-reason' => 'காரணம்',
	'maintenance-cleanupTable-check' => 'மோசமான தலைப்புகளைத் தேடுகிறது ...',
	'maintenance-cleanupTable-checkfix' => 'மோசமான தலைப்புகளைத் தேடிச் சரிசெய்கிறது...',
	'maintenance-cleanupTable-processing' => '$1 முறைவழியாக்கப்படுகின்றது...',
	'maintenance-option-confirm' => 'உறுதிசெய்',
	'maintenance-option-required' => '(தேவைப்படுகிறது)',
	'maintenance-option-optional' => '(விருப்பதேர்வு)',
	'maintenance-output-success' => '$1 வெற்றிகரமாக ஓடியது!',
	'maintenance-output-failure' => '$1 வெற்றிகரமாக ஓடவில்லை!',
	'maintenance-changePassword' => 'ஒரு பயனரின் கடவுச் சொல்லை மாற்ற இப்படிவத்தைப் பயன்படுத்தவும்',
	'maintenance-changePassword-desc' => 'ஒரு பயனரின் கடவுச்சொல்லை மாற்று',
	'maintenance-changePassword-error-nouser' => '"$1" என்று ஒரு பயனர் இல்லை.',
	'maintenance-checkBadRedirects-output-footer' => 'முடிந்தது.',
	'maintenance-checkImages-output-isdir' => '$1: ஒரு கோப்புறை ஆகும்.',
	'maintenance-checkImages-output-good' => 'நற்படிமங்கள்: $1/$2',
	'maintenance-checkSyntax-output-buildlist' => 'கோப்புப் பட்டியல் உருவாக்கப்படுகிறது...',
	'maintenance-checkSyntax-error-cantopen' => '$1 கோப்பைத் திறக்க முடியவில்லை.',
	'maintenance-cleanupSpam-output-false' => 'தவறான பொருத்தம்',
	'maintenance-cleanupSpam-output-blanking' => 'வெறுமையாக்கல்',
	'maintenance-cleanupSpam-output-reverting' => 'மீளமைத்தல்',
	'maintenance-moveBatch-desc' => 'பக்கங்களை மொத்தமாக நகர்த்து',
	'maintenance-invalidname' => 'செல்லாத பயனர்பெயர்!',
	'maintenance-userexists' => 'பயனர் ஏற்கனவே உள்ளார்!',
	'maintenance-invalidtitle' => 'செல்லாத தலைப்பு "$1"!',
	'maintenance-titlenoexist' => 'குறிப்பிடப்பட்ட தலைப்பு ("$1") காணப்படவில்லை!',
	'maintenance-failed' => 'தோல்வி',
	'maintenance-deleted' => 'நீக்கப்பட்டுவிட்டது',
	'maintenance-showCacheStats-edits' => 'தொகுப்புகள் எண்ணிக்கை: $1',
	'maintenance-showCacheStats-pages' => 'பக்கங்களின் எண்ணிக்கை: $1',
	'maintenance-showCacheStats-users' => 'பயனர்கள் எண்ணிக்கை: $1',
	'maintenance-showCacheStats-admins' => 'நிருவாகிகள் எண்ணிக்கை: $1',
	'maintenance-showCacheStats-images' => 'கோப்புகள் எண்ணிக்கை: $1',
	'maintenance-showCacheStats-views' => 'பக்கங்கள் பார்வையிடப்பட்ட எண்ணிக்கை: $1',
	'maintenance-showCacheStats-update' => 'தரவுத் தளத்தை இற்றைப்படுத்துகின்றது{{int:ellipsis}}',
	'maintenance-error' => 'பிழை: $1',
	'maintenance-memc-requests' => 'வேண்டுகோள்கள்',
	'maintenance-memc-total' => 'மொத்தம்:',
	'maintenance-memc-invalid' => 'செல்லாதவை:',
	'maintenance-memc-expired' => 'காலாவதியாகிறது:',
	'maintenance-memc-absent' => 'இல்லாமை:',
	'maintenance-memc-imagecache' => 'படிம இடைமாற்று',
	'maintenance-memc-misses' => 'விடுபட்டவை:',
	'maintenance-memc-updates' => 'புதுப்பித்தல்கள்:',
	'maintenance-reassignEdits' => 'ஒரு பயனரிலிருந்து மற்றொரு பயனருக்கு தொகுப்புகளை மாற்றியமைக்க இந்தப் படிவத்தைப் பயன்படுத்தவும்.',
	'maintenance-re-from' => 'தொகுப்புகளிலிருந்து மாற்றியமைக்க வேண்டிய பயனரின்  பெயர்',
	'maintenance-re-to' => 'தொகுப்புகளை அமைக்க வேண்டிய பயனரின்  பெயர்',
	'maintenance-re-force' => 'இலக்கு பயனர் இல்லை எனினும் மாற்றியமைக்கவும்',
	'maintenance-re-rc' => 'அண்மைய மாற்றங்கள் பட்டியலை இற்றைப்படுத்த வேண்டாம்',
	'maintenance-re-nf' => 'பயனர் $1 காணப்படவில்லை',
	'maintenance-re-ce' => 'தற்போதைய தொகுப்புகள்: $1',
	'maintenance-re-de' => 'நீக்கப்பட்ட தொகுப்புகள்: $1',
	'maintenance-re-rce' => 'அண்மைய மாற்றங்கள் பதிவுகள்: $1',
	'maintenance-re-total' => 'மாற்ற வேண்டிய மொத்த பதிவுகள்: $1',
	'maintenance-re-re' => 'தொகுப்புகளை{{int:ellipsis}} மாற்றியமைத்தல் ஆயிற்று',
);

/** Telugu (తెలుగు)
 * @author C.Chandra Kanth Rao
 * @author Veeven
 */
$messages['te'] = array(
	'maintenance-error-invalidtype' => 'చెల్లని రకం!', # Fuzzy
	'maintenance-generic-username' => 'వాడుకరి పేరు',
	'maintenance-generic-password' => 'సంకేతపదం',
	'maintenance-generic-reason' => 'కారణం',
	'maintenance-option-confirm' => 'నిర్ధారించండి',
	'maintenance-option-required' => '(తప్పనిసరి)',
	'maintenance-option-optional' => '(ఐచ్చికం)',
	'maintenance-output-success' => '$1 విజయవంతంగా నడిచింది!',
	'maintenance-benchmarkPurge-output-trial' => '$2ms లో $1 {{PLURAL:$1|శీర్షిక|శీర్షికలు}} (ఒక్కోటి $3ms)',
	'maintenance-changePassword-desc' => 'వాడుకరి యొక్క సంకేతపదం మార్చండి',
	'maintenance-checkBadRedirects-output-footer' => 'పూర్తయింది.',
	'maintenance-initEditCount-desc' => 'వాడుకరులు మార్పుల సంఖ్యను మళ్లీ లెక్కించు',
	'maintenance-initSiteStats-desc' => 'సైటు గణాంకాలని మళ్ళీ లెక్కించు',
	'maintenance-invalidname' => 'తప్పుడు వాడుకరిపేరు!',
	'maintenance-userexists' => 'వాడుకరి ఇప్పటికే ఉన్నారు!',
	'maintenance-invalidtitle' => 'తప్పుడు శీర్షిక "$1"!',
	'maintenance-failed' => 'విఫలమైనది',
	'maintenance-deleted' => 'తొలిగించబడినది',
	'maintenance-showCacheStats-edits' => 'మార్పుల సంఖ్య: $1',
	'maintenance-showCacheStats-pages' => 'పేజీల సంఖ్య: $1',
	'maintenance-showCacheStats-users' => 'వాడుకర్ల సంఖ్య: $1',
	'maintenance-showCacheStats-admins' => 'నిర్వాహకుల సంఖ్య: $1',
	'maintenance-showCacheStats-images' => 'ఫైళ్ళ సంఖ్య: $1',
	'maintenance-showCacheStats-views' => 'పేజీ వీక్షణల సంఖ్య: $1',
	'maintenance-showCacheStats-update' => 'డాటాబేస్ తాజాకరింపబడుచున్నది',
	'maintenance-error' => 'పొరపాటు: $1',
	'maintenance-memc-requests' => 'అభ్యర్థనలు',
	'maintenance-memc-total' => 'మొత్తం:',
	'maintenance-memc-invalid' => 'చెల్లనివి:',
	'maintenance-memc-updates' => 'తాజాకరణలు:',
	'maintenance-re-nf' => 'వాడుకరి $1 కనబడలేదు',
	'maintenance-re-ce' => 'ప్రస్తుత మార్పుల: $1',
	'maintenance-re-de' => 'తొలగించిన మార్పులు: $1',
);

/** Tetum (tetun)
 * @author MF-Warburg
 */
$messages['tet'] = array(
	'maintenance-generic-username' => "Naran uza-na'in",
);

/** Thai (ไทย)
 * @author Octahedron80
 * @author Passawuth
 */
$messages['th'] = array(
	'maintenance-option-confirm' => 'ยืนยัน',
	'maintenance-memc-total' => 'รวม:',
);

/** Tagalog (Tagalog)
 * @author AnakngAraw
 */
$messages['tl'] = array(
	'maintenance' => 'Patakbuhin ang mga panitik na pang-pagpapanatili',
	'maintenance-desc' => '[[Special:Maintenance|Ugnayang-hangganan ng Wiki]] para sa sari-saring mga panitik na pang-pagpapanatili',
	'right-maintenance' => 'Patakbuhin ang mga panitik ng pagpapanatili sa pamamagitan ng [[Special:Maintenance]]',
	'maintenance-backlink' => 'Bumalik sa pilian ng mga panitik',
	'maintenance-header' => 'Pakipili lamang ng isang panitik sa ibaba na isasakatuparan.
Katabi ng bawat panitik ang mga paglalarawan',
	'maintenance-error-badini' => 'Maaaring sira o nawawala ang talaksang metadata.ini.  Paki muling ikargang paibaba ang dugtong ng Pagpapanatili.',
	'maintenance-error-invalidtype' => 'Hindi natagpuan ang tinukoy na panitik',
	'maintenance-error-badargs' => 'Hindi mo tinukoy ang lahat ng kinakailangang mga pagpili',
	'maintenance-generic-done' => 'nagawa na',
	'maintenance-generic-username' => 'Pangalan ng tagagamit',
	'maintenance-generic-password' => 'Hudyat',
	'maintenance-generic-reason' => 'Dahilan',
	'maintenance-cleanupTable-dry-run' => 'Subukan muna',
	'maintenance-cleanupTable-check' => 'Nagsusuri ng masasamang mga pamagat...',
	'maintenance-cleanupTable-checkfix' => 'Nagsusuri at nag-aayos ng masasamang mga pamagat...',
	'maintenance-cleanupTable-progress' => '$1 $2: $3% ginawa sa ibabaw ng $4; Inaasahang darating sa ganap na $5 [$6/$7] $8/segundo <$9% naisapanahon>',
	'maintenance-cleanupTable-missingparam' => '$1: Nawawala ang parametrong $2',
	'maintenance-cleanupTable-processing' => 'Isinasagawa ang $1...',
	'maintenance-cleanupTable-finished' => 'Natapos na ang $1... $2 ng $3 {{PLURAL:$3|hilera|mga hilera}} ang naisapanahon',
	'maintenance-option-quiet' => 'Supilin ang paglalabas na walang kamalian',
	'maintenance-option-globals' => 'Mga kinalabasang pangdaigdigan sa huli ng pagpoproseso para sa pagkukumpuni',
	'maintenance-option-confirm' => 'Tiyakin',
	'maintenance-option-batch-size' => 'Patakbuhin ang ganito karaming mga operasyon ayon sa langkay, likas na nakatakda: $1',
	'maintenance-option-required' => '(kailangan)',
	'maintenance-option-optional' => '(maaaring wala nito)',
	'maintenance-output-success' => 'Matagumpay na tumakbo ang $1!',
	'maintenance-output-failure' => 'Hindi tumakbong matagumpay ang $1!',
	'maintenance-attachLatest' => 'Gamitin ang pormularyong ito upang kumpunihin ang mga ipinasok sa talahanayan ng pahina kung saan ang page_latest ay nakatakda sa 0',
	'maintenance-attachLatest-desc' => 'Ayusin ang mga ipinasok na page_latest sa loob ng talahanayan ng pahina',
	'maintenance-attachLatest-option-fix' => 'Talagang kumpunihin ang mga pagpapasok, susubukan kapag hindi',
	'maintenance-attachLatest-output-begin' => 'Naghahanap ng mga pahinang may page_latest na nakatakda sa 0...',
	'maintenance-attachLatest-output-notime' => 'Hindi matagpuan ng $1 $2 [[$3]] ang pinakabagong oras ng pagbago?!',
	'maintenance-attachLatest-output-norev' => '$1 $2 [[$3]] pinakabagong oras $4, hindi matagpuan ang ID ng rebisyon',
	'maintenance-attachLatest-output-found' => '$1 $2 [[$3]] pinakabagong oras $4, ID ng rebisyon $5',
	'maintenance-attachLatest-output-done' => 'Tapos na! Nakapagsagawa ng $1 {{PLURAL:$1|pahina|mga pahina}}.',
	'maintenance-attachLatest-output-dryrun' => 'Isa itong pagsusubok; muling patakbuhin na may "{{int:maintenance-attachLatest-option-fix}}" upang maisapanahon ang page_latest.',
	'maintenance-benchmarkPurge' => 'Gamitin ang pormularyong ito upang masubukan kung gaano katagal magaganap ang mga tungkulin ng pagpupurga ng Pusit',
	'maintenance-benchmarkPurge-desc' => 'Suriin ang pagganap ng mga tungkuling pagpurga ng Pusit',
	'maintenance-benchmarkPurge-option-count' => 'Ilang mga URL ang ipapakain sa Pusit para ipurga',
	'maintenance-benchmarkPurge-error-nosquid' => 'Ang pangsuri ng pagpura ng Pusit ay hindi walang gaanong magagawa kung hindi buhay ang pangtangkilik ng Pusit.',
	'maintenance-benchmarkPurge-output-numsquids' => 'Mayroong $1 na binigyan ng kahulugan na {{PLURAL:$1|tagapaghain|mga tagapaghain}} ng Squid:',
	'maintenance-benchmarkPurge-output-trial' => '$1 {{PLURAL:$1|pamagat|mga pamagat}} sa loob ng $2ms ($3ms ang bawat isa)',
	'maintenance-changePassword' => 'Gamitin ang pormularyong ito upang baguhin ang hudyat ng isang tagagamit',
	'maintenance-changePassword-desc' => 'Palitan ang hudyat ng isang tagagamit',
	'maintenance-changePassword-error-nouser' => 'Walang ganyang tagagamit: $1',
	'maintenance-changePassword-output-set' => 'Hudyat na itinakda para sa $1',
	'maintenance-checkAutoLoader' => 'Gamitin ang pormularyong ito upang gumawa ng ilang mga pagsusuri ng katinuan sa AutoLoader',
	'maintenance-checkAutoLoader-desc' => 'Mga pagususri ng katinuan sa AutoLoader',
	'maintenance-checkAutoLoader-output-list2' => '$1:Maling talaksan: natagpuan sa $2 , nakatala sa $3',
	'maintenance-checkBadRedirects' => 'Gamitin ang pormularyong ito upang makita kung ang mga pahinang minarkahan bilang mga pagpapapunta sa ibang pahina ay talagang mga pagpapunta nga sa ibang mga pahina',
	'maintenance-checkBadRedirects-desc' => 'Magsuri ng masasamang mga pagpapapunta sa ibang pahina',
	'maintenance-checkBadRedirects-output-header' => 'Kinukuha ang mga pagpapapunta sa ibang pahina...',
	'maintenance-checkBadRedirects-output-found' => 'Nakatagpo ng $1 {{PLURAL:$1|pagpapapunta sa ibang pahina|mga pagpapapunta sa ibang pahina}}.
Nagsisiyasat ng masasamang mga pagpapapunta sa ibang pahina...',
	'maintenance-checkBadRedirects-output-footer' => 'Tapos na.',
	'maintenance-checkImages' => 'Gamitin ang pormularyong ito upang makita kung anong mga imahe sa wiki mo ang nadungisan',
	'maintenance-checkImages-desc' => 'Suriin ang mga larawan upang makita kung umiiral sila, nababasa, at iba pa',
	'maintenance-checkImages-output-noaccess' => '$1: hindi mapupuntahan ng lokal',
	'maintenance-checkImages-output-missing' => '$1: nawawala',
	'maintenance-checkImages-output-isdir' => '$1: ay isang direktoryo',
	'maintenance-checkImages-output-truncated' => '$1: pinutol, dating $2',
	'maintenance-checkImages-output-mismatch' => '$1: hindi tugmang sukat DB=$2, tunay na=$3',
	'maintenance-checkImages-output-good' => 'Mabubuting mga larawan: $1/$2',
	'maintenance-checkSyntax' => 'Gamitin ang pormularyong ito upang suriin ang palaugnayan ng lahat ng mga talaksang PHP sa MediaWiki',
	'maintenance-checkSyntax-desc' => 'Suriin ang palaugnayan para sa lahat ng mga talaksang PHP sa MediaWiki',
	'maintenance-checkSyntax-option-with-extensions' => 'Gayundin isailalim sa rekursyon ang mga polder ng mga dugtong',
	'maintenance-checkSyntax-option-path' => 'Partikular na landas (talaksan o direktoryo) na susuriin, maaaring may ganap na landas o may kaugnayan sa ugat ng pagtatalaga ng MediaWiking ito',
	'maintenance-checkSyntax-option-list-file' => 'Talaan ng mga talaksan o mga direktoryong susuriin',
	'maintenance-checkSyntax-option-modified' => 'Suriin lamang ang mg talaksang binago (nangangailangan ng kliyenteng utos-guhit ng SVN)',
	'maintenance-checkSyntax-option-syntax-only' => 'Suriin lamang ang pagiging katanggap-tanggap ng palaugnayan, laktawan ang mga babala sa estilo ng kodigo',
	'maintenance-checkSyntax-output-parsekit' => 'Sinusuri ang palaugnayan (ginagamit ang kasangkapang pambanghay)',
	'maintenance-checkSyntax-output-phpl' => 'Sinusuri ang palaugnayan (ginagamit ang php -1, maaaring matagalan ito)',
	'maintenance-checkSyntax-output-footer' => 'Tapos na!  $1 mga talaksan ang nasuri na, $2 mga nabigo at $3 mga babala ang natagpuan',
	'maintenance-checkSyntax-output-svnlist' => 'Kinukuha ang tala mula sa Kabahaging Bersyon...',
	'maintenance-checkSyntax-output-buildlist' => 'Nagtatatag ng tala ng talaksan...',
	'maintenance-checkSyntax-output-error' => 'Kamalian sa $1 guhit $2: $3',
	'maintenance-checkSyntax-output-warning' => 'Balala sa talaksang $1: $2 ang natagpuan',
	'maintenance-checkSyntax-error-nofile' => 'Kamalian: hindi mahanap ang talaksan o direktoryong $1',
	'maintenance-checkSyntax-error-cantopen' => 'Hindi mabuksan ang talaksang $1',
	'maintenance-checkSyntax-error-svnerr' => 'Kamalian sa pagkuha ng tala mula sa Kabahaging Bersyon!',
	'maintenance-checkUsernames' => 'Gamitin ang pormularyong ito upang ipakita kung anong mga pangalan ng tagagamit ang hindi katanggap-tanggap dahil sa mga pagbabago sa pagkakaayos. Kung walang nakatala pagkaraang patakbuhin ang panitik na ito, lahat ng mga pangalan ng tagagamit ay katanggap-tanggap',
	'maintenance-checkUsernames-desc' => 'Patunayan kung katanggap-tanggap talaga ang mga pangalan ng tagagamit sa kalipunan ng dato',
	'maintenance-checkUsernames-error-notvalid' => 'Hindi katanggap-tanggap na pangalan ng tagagamit: "$3" (ID ng tagagamit na $2)',
	'maintenance-cleanupCaps' => 'Gamitin ang pormularyong ito upang ayusin ang sirang mga pahina na dulot ng pagbago sa $wgCapitalLinks',
	'maintenance-cleanupCaps-desc' => 'Panitik upang malinis ang paggamit ng malalaking mga titik',
	'maintenance-cleanupCaps-option-namespace' => 'Bilang ng puwang ng pangalan na pagtatakbuhan ng paglilinis ng paggamit ng malalaking mga titik',
	'maintenance-cleanupCaps-output-islower' => 'Ang "$1" ay nasa maliliit nang mga titik.',
	'maintenance-cleanupCaps-output-clash' => 'Nilaktawan ang "$1"; umiiral na ang " $2 "',
	'maintenance-cleanupCaps-output-dryrun' => '"$1" -> "$2": PAGSUBOK LANG, HINDI INILIPAT',
	'maintenance-cleanupCaps-error-noneed' => 'Buhay ang $wgCapitalLinks -- hindi na kailangan ang paglilinis ng mga kawing sa malalaking mga titik.',
	'maintenance-cleanupSpam' => 'Gamitin ang pormularyong ito upang maipanumbalik sa dati ang ginawa ng mga basurang pamamatnugot na kumakawing sa panlabas na mga pook',
	'maintenance-cleanupSpam-desc' => 'Linisin ang lahat ng mga basurang liham magmula sa isang ibinigay na pangalan ng tagapagpasinaya',
	'maintenance-cleanupSpam-option-hostname' => 'Pangalan ng tagapagpasinaya na nagpapadala ng basura',
	'maintenance-cleanupSpam-output-found' => 'Nakatagpo ng $1 {{PLURAL:$1|artikulo|mga artikulo}}ng naglalaman ng $2',
	'maintenance-cleanupSpam-output-false' => 'Maling pagtutugma',
	'maintenance-cleanupSpam-output-blanking' => 'pagtatanggal ng laman',
	'maintenance-cleanupSpam-output-reverting' => 'pagpapanumbalik',
	'maintenance-cleanupSpam-error-invalid' => 'Hindi isang katanggap-tanggap na ispesipikasyon ng pangalan ng tagapagpasinaya: $1',
	'maintenance-cleanupSpam-error-noid' => 'Panloob na kamalian: walang pahina para sa ID na $1',
	'maintenance-clearInterwikiCache' => 'Gamitin ang pormularyong ito upang mahawi ng buo ang taguan ng ugnayang-wiki',
	'maintenance-clearInterwikiCache-desc' => 'Hawiin ang lahat ng mga kawing ng ugnayang-wiki para sa lahat ng mga wiki mula sa taguan',
	'maintenance-createAndPromote' => "Gamitin ang pormularyong ito upang makalikha ng isang bagong tagagamit at maitaas ito bilang ''sysop''.
Lagyan ng tsek ang kahon ng burokrato kung nais mong itaas din ito bilang burokrato",
	'maintenance-createAndPromote-desc' => "Lumikha ng isang tagagamit at itaas sa katayuang ''sysop'' (tagapagpatakbo ng sistema)",
	'maintenance-createAndPromote-option-bureaucrat' => 'Itaas ng ranggo ang tagagamit upang maging burokrata ang katayuan',
	'maintenance-createAndPromote-output-creating' => 'Nililikha at itinataguyod ang {{ns:user}}:$2...',
	'maintenance-createAndPromote-error-password' => 'Nakatagpo ng isang pagkakamali sa hudyat na ipinasok mo: $1',
	'maintenance-deleteBatch' => 'Gamitin ang pormularyong ito upang malawakang makapagbura ng mga pahina.
Maglagay lamang ng isang pahina sa bawat guhit',
	'maintenance-deleteBatch-desc' => 'Malawakang burahin ang mga pahina',
	'maintenance-deleteRevision' => 'Gamitin ang pormularyong ito upang malawakang makapagbura ng mga pagbabago.
Maglagay lamang ng isang bilang ng pagbabago sa bawat guhit',
	'maintenance-deleteRevision-desc' => 'Tanggalin ang mga pagbabago mula sa kalipunan ng dato',
	'maintenance-initEditCount-desc' => 'Muling tuusin ang mga bilang ng pagbabago ng mga tagagamit',
	'maintenance-initSiteStats' => 'Gamitin ang pormularyong ito upang muling tuusin ang mga estadistika ng sityo, na tinutukoy kung nais mo ring tuusing muli ang mga pagtingin sa pahina',
	'maintenance-initSiteStats-desc' => 'Muling tuusin ang mga estadistika ng sityo',
	'maintenance-moveBatch' => "Gamitin ang pormularyong ito upang malawakang makapaglipat ng mga pahina.
Dapat na tinutukoy ng bawat guhit ang isang pinagmulang pahina at kapupuntahang pahina na pinaghihiwalay ng isang \"tubo\" (''pipe'')",
	'maintenance-moveBatch-desc' => 'Malawakang ilipat ang mga pahina',
	'maintenance-reassignEdits-desc' => 'Muling italaga ang mga pagbabago mula sa isang tagagamit patungo sa iba pa',
	'maintenance-runJobs-desc' => 'Patakbuhin ang mga gawaing nasa loob ng pila ng gawain',
	'maintenance-runJobs-option-maxjobs' => 'Pinakamataas na bilang ng mga trabahong patatakbuhin',
	'maintenance-runJobs-option-type' => 'Uri ng trabahong patatakbuhin',
	'maintenance-runJobs-option-procs' => 'Bilang ng mga prosesong gagamitin',
	'maintenance-runJobs-option-exclusive' => 'Patakbuhin lamang ang isang nakabukod na mga panitik ng runJobs sa bawat isang pagkakataon.  Ang oras ng pahinga ay 1800 mga segundo.',
	'maintenance-runJobs-error-invalidprocs' => 'Dapat kang tumukoy sa pagitan ng 1 at 1000 mga proseso',
	'maintenance-showJobs-desc' => 'Magpakita ng isang talaan ng mga gawaing naghihintay sa loob ng pila ng mga gawain',
	'maintenance-showJobs-option-group' => 'Ipakita ang bilang ng mga trabaho sa bawat uri ng trabaho',
	'maintenance-sql' => 'Gamitin ang pormularyong ito upang maisakatuparan ang isang katanungang SQL sa kalipunan ng dato.',
	'maintenance-sql-desc' => 'Magsakatupran ng isang katanungang SQL',
	'maintenance-sql-option-file' => 'Isasagawang SQL',
	'maintenance-sql-output-aff' => 'Ayos ang pagtatanong, {{PLURAL:$1|pahalang na hanay|pahalang na mga hanay}} ang apektado',
	'maintenance-sql-error-cantopen' => 'Hindi magawang buksan ang talaksang pasukan',
	'maintenance-showCacheStats-desc' => 'Ipakita ang mga estadistikang nakatago sa alaala/memorya',
	'maintenance-eval' => 'Gamitin ang pormularyong ito upang suriin ang kodigong PHP na nasa loob ng kapaligiran ng MediaWiki.',
	'maintenance-eval-desc' => 'Limiin/Suriin ang kodigong PHP na nasa loob ng kapiligiran ng MediaWiki',
	'maintenance-update' => 'Gamitin ang ISAPANAHON kapag nagsasapanahon ng mga tabla? Sa halip nito, gumagamit ang mga hindi pa nasusuri ng BURAHIN/ISINGIT.',
	'maintenance-noviews' => 'Lagyan ito ng tsek upang maiwasan ang pagsasapanahon ng bilang ng mga pagtingin sa pahina',
	'maintenance-invalidname' => 'Hindi tanggap na pangalan ng tagagamit!',
	'maintenance-userexists' => 'Umiiral na ang tagagamit!',
	'maintenance-invalidtitle' => 'Hindi tanggap na pamagat ang "$1"!',
	'maintenance-titlenoexist' => 'Hindi umiiral ang tinukoy na pamagat ("$1")!',
	'maintenance-failed' => 'NABIGO',
	'maintenance-deleted' => 'NABURA',
	'maintenance-revdelete' => 'Binubura ang {{PLURAL:$3|pagbabago|mga pagbabago}}ng $1 mula sa wiking $2',
	'maintenance-revnotfound' => 'Hindi natagpuan ang pagbabagong $1!',
	'maintenance-showCacheStats-edits' => 'Bilang ng mga pagbabago: $1',
	'maintenance-showCacheStats-articles' => 'Bilang ng mga pahinang nasa pangunahing espasyo ng pangalan: $1',
	'maintenance-showCacheStats-pages' => 'Bilang ng mga pahina: $1',
	'maintenance-showCacheStats-users' => 'Bilang ng mga tagagamit: $1',
	'maintenance-showCacheStats-admins' => 'Bilang ng mga tagapangasiwa: $1',
	'maintenance-showCacheStats-images' => 'Bilang ng mga talaksan: $1',
	'maintenance-showCacheStats-views' => 'Bilang ng mga pagtingin sa pahina: $1',
	'maintenance-showCacheStats-update' => 'Isinasapanahon ang kalipunan ng dato{{int:ellipsis}}',
	'maintenance-move' => 'Inililipat ang $1 patungo sa $2{{int:ellipsis}}',
	'maintenance-movefail' => 'Nakaranas ng kamalian habang naglilipat: $1.
Itinitigil ang paglilipat',
	'maintenance-error' => 'Kamalian: $1',
	'maintenance-memc-fake' => 'Ipinatatakbo ang FakeMemCachedClient. Walang maibibigay na mga estadistika',
	'maintenance-memc-requests' => 'Mga kahilingan',
	'maintenance-memc-withsession' => 'may nakalaang panahon:',
	'maintenance-memc-withoutsession' => 'walang nakalaang panahon:',
	'maintenance-memc-total' => 'kabuoan:',
	'maintenance-memc-parsercache' => 'Ligpitan ng mga banghay',
	'maintenance-memc-hits' => 'mga pagsapol (pagpunta):',
	'maintenance-memc-invalid' => 'hindi tanggap:',
	'maintenance-memc-expired' => 'walang bisa:',
	'maintenance-memc-absent' => 'wala:',
	'maintenance-memc-stub' => 'katindihan ng usbong:',
	'maintenance-memc-imagecache' => 'Taguan ng larawan',
	'maintenance-memc-misses' => 'mga hindi pagsapol:',
	'maintenance-memc-updates' => 'mga pagsasapanahon:',
	'maintenance-memc-uncacheable' => 'hindi maitatago:',
	'maintenance-memc-diffcache' => 'Taguan ng Pagkakaiba',
	'maintenance-reassignEdits' => 'Gamitin ang pormularyong ito upang muling maitalaga ang mga pagbabago mula sa isang tagagamit patungo sa iba pa.',
	'maintenance-re-from' => 'Pangalan ng tagagamit na panggagalingan ng mga itatalagang pagbabago',
	'maintenance-re-to' => 'Pangalan ng tagagamit na patutunguhan ng mga itatalagang pagbabago',
	'maintenance-re-force' => 'Italagang muli kahit na hindi umiiral ang pinupukol na tagagamit',
	'maintenance-re-rc' => 'Huwag isapanahon ang tabla ng kamakailang mga pagbabago',
	'maintenance-re-report' => 'Maglimbag ng mga detalye hinggil sa mga babaguhin, subalit huwag itong isapanahon',
	'maintenance-re-nf' => 'Hindi natagpuan ang tagagamit na $1',
	'maintenance-re-rr' => 'Patakbuhing muli ang panitik na walang "$1" upang maisapanahon.',
	'maintenance-re-ce' => 'Pangkasalukuyang mga pagbabago: $1',
	'maintenance-re-de' => 'Naburang mga pagbabago: $1',
	'maintenance-re-rce' => 'Mga ipinasok na Kamakailang mga Pagbabago: $1',
	'maintenance-re-total' => 'Kabuoan ng mga ipinasok na babaguhin: $1',
	'maintenance-re-re' => 'Muling pagtatalaga ng mga pagbabago{{int:ellipsis}} nagawa na',
);

/** Turkish (Türkçe)
 * @author Erdemaslancan
 * @author Karduelis
 * @author Suelnur
 * @author Vito Genovese
 */
$messages['tr'] = array(
	'maintenance' => 'Bakım betiklerini çalıştır',
	'maintenance-desc' => 'Çeşitli bakım betikleri için [[Special:Maintenance|viki arayüzü]]',
	'maintenance-backlink' => 'Betik seçimine geri dön',
	'maintenance-header' => 'Lütfen çalıştırmak için aşağıdan bir betik seçin.
Her betiğin yanında açıklamalarına yer verilmiştir.',
	'maintenance-error-invalidtype' => 'Geçersiz tür!', # Fuzzy
	'maintenance-generic-username' => 'Kullanıcı adı',
	'maintenance-generic-password' => 'Parola',
	'maintenance-option-confirm' => 'Onayla',
	'maintenance-option-optional' => '(isteğe bağlı)',
	'maintenance-changePassword-desc' => 'Bir kullanıcının parolasını değiştir',
	'maintenance-deleteBatch-desc' => 'Sayfaları toplu sil',
	'maintenance-deleteRevision-desc' => 'Sürümleri veritabanından kaldır',
	'maintenance-initEditCount-desc' => 'Kullanıcıların değişiklik sayılarını tekrar hesapla',
	'maintenance-initSiteStats-desc' => 'Site istatistiklerini tekrar hesapla',
	'maintenance-moveBatch-desc' => 'Sayfaları toplu taşı',
	'maintenance-runJobs-desc' => 'İş kuyruğunda işleri yürüt',
	'maintenance-invalidname' => 'Geçersiz kullanıcı adı!',
	'maintenance-userexists' => 'Kullanıcı zaten mevcut!',
	'maintenance-failed' => 'BAŞARISIZ',
	'maintenance-deleted' => 'Silindi',
	'maintenance-revnotfound' => '$1 sürümü bulunamadı!',
	'maintenance-showCacheStats-edits' => 'Değişiklik sayısı: $1',
	'maintenance-showCacheStats-articles' => 'Ana isim alanındaki sayfaların saysı: $1',
	'maintenance-showCacheStats-pages' => 'Sayfa sayısı: $1',
	'maintenance-showCacheStats-users' => 'Kullanıcı sayısı: $1',
	'maintenance-showCacheStats-admins' => 'Hizmetli sayısı: $1',
	'maintenance-showCacheStats-images' => 'Dosya sayısı: $1',
	'maintenance-showCacheStats-views' => 'Sayfa görüntüleme sayısı: $1',
	'maintenance-error' => 'Hata: $1',
	'maintenance-memc-requests' => 'İstekler',
	'maintenance-memc-withsession' => 'oturumlu:',
	'maintenance-memc-withoutsession' => 'oturumsuz:',
	'maintenance-memc-total' => 'toplam:',
	'maintenance-memc-parsercache' => 'Ayrıştırıcı önbellek',
	'maintenance-memc-hits' => 'eşleşme:',
	'maintenance-memc-stub' => 'taslak eşiği:',
	'maintenance-memc-imagecache' => 'Resim önbelleği',
	'maintenance-memc-updates' => 'güncellemeler',
	'maintenance-memc-diffcache' => 'Fark Önbelleği',
	'maintenance-re-rc' => 'Son değişiklikler tablosunu güncellemeyin',
	'maintenance-re-nf' => 'Kullanıcı $1 bulunamadı',
	'maintenance-re-ce' => 'Mevcut değişiklik: $1',
	'maintenance-re-de' => 'Silinen değişiklikler: $1',
	'maintenance-re-rce' => 'SonDeğişiklikler girdileri: $1',
	'maintenance-re-total' => 'Değiştirilecek toplam girdi: $1',
);

/** Ukrainian (українська)
 * @author Base
 * @author Olvin
 * @author Prima klasy4na
 * @author Steve.rusyn
 * @author Тест
 */
$messages['uk'] = array(
	'maintenance' => 'Запуск скриптів обслуговування',
	'maintenance-desc' => '[[Special:Maintenance|Вікі інтерфейс]] для різноманітних скриптів обслуговування',
	'right-maintenance' => 'Запуск скриптів обслуговування через [[Special:Maintenance]]',
	'maintenance-backlink' => 'Повернутися до вибору скрипту',
	'maintenance-header' => 'Будь ласка, оберіть скрипт для виконання. Описи поруч із кожним скриптом',
	'maintenance-error-badini' => 'Файл metadata.ini пошкоджено або відсутній. Будь ласка, завантажте розширення Maintenance знову',
	'maintenance-error-invalidtype' => 'Вказаний скрипт не знайдено',
	'maintenance-error-badargs' => 'Ви не вказали всі необхідні параметри',
	'maintenance-generic-done' => 'виконано',
	'maintenance-generic-username' => "Ім'я користувача",
	'maintenance-generic-password' => 'Пароль',
	'maintenance-generic-reason' => 'Причина',
	'maintenance-cleanupTable-dry-run' => 'Виконати тестовий запуск',
	'maintenance-cleanupTable-check' => 'Перевірка на погані назви…',
	'maintenance-cleanupTable-checkfix' => 'Перевірка і заміна поганих назв…',
	'maintenance-cleanupTable-progress' => '$1 $2: $3% зроблено на $4; ETA $5 [$6/$7] $8/сек. <$9% оновлено>',
	'maintenance-cleanupTable-missingparam' => '$1: Відсутній параметр $2',
	'maintenance-cleanupTable-processing' => 'Обробка $1…',
	'maintenance-cleanupTable-finished' => 'Завершено $1… $2 {{PLURAL:$3|рядок|рядки|рядків}} із $3 оновлено',
	'maintenance-option-quiet' => 'Показувати лише помилки',
	'maintenance-option-globals' => 'Виводить глобальні змінні у кінці процесу відладки.',
	'maintenance-option-confirm' => 'Підтвердити',
	'maintenance-option-batch-size' => 'Запуск усіх цих операцій у пакеті, за замовчуванням: $1',
	'maintenance-option-required' => "(обов'язково)",
	'maintenance-option-optional' => "(необов'язково)",
	'maintenance-output-success' => '$1 успішно виконано!',
	'maintenance-output-failure' => 'Не вдалося виконати $1!',
	'maintenance-attachLatest' => 'Використовуйте цю форму для виправлення записів у таблиці сторінок, де page_latest встановлено у 0',
	'maintenance-attachLatest-desc' => 'Виправити записи page_latest у таблиці сторінок',
	'maintenance-attachLatest-option-fix' => 'Справді виправити записи, чи виконати тестовий запуск',
	'maintenance-attachLatest-output-begin' => 'Пошук сторінок із page_latest встановленим у 0…',
	'maintenance-changePassword-desc' => 'Змінити пароль користувача',
	'maintenance-changePassword-output-set' => 'Пароль для $1 встановлено',
	'maintenance-checkBadRedirects-output-footer' => 'Готово.',
	'maintenance-checkSyntax-output-buildlist' => 'Побудова списку файлів...',
	'maintenance-checkSyntax-output-error' => 'Помилка у $1 в $2 рядку: $3',
	'maintenance-checkSyntax-error-nofile' => 'Помилка: не вдається знайти файл або каталог $1',
	'maintenance-checkSyntax-error-cantopen' => 'Не вдається відкрити файл $1',
	'maintenance-initEditCount-desc' => 'Перерахувати кількість редагувань користувачів',
	'maintenance-initSiteStats-desc' => 'Перерахувати статистику сайту',
	'maintenance-reassignEdits-desc' => 'Перепризначити правки від одного користувача до іншого',
	'maintenance-runJobs-desc' => 'Запустити завдання в черзі завдань',
	'maintenance-runJobs-option-maxjobs' => 'Найбільша кількість завдань для запуску',
	'maintenance-runJobs-option-procs' => 'Кількість процесів для використання',
	'maintenance-runJobs-error-invalidprocs' => 'Ви повинні вказати від 1 до 1000 процесів',
	'maintenance-showJobs-desc' => 'Показати список завдань з черги завдань',
	'maintenance-showJobs-option-group' => 'Показати кількість задач за типами',
	'maintenance-sql' => 'Використовуйте цю форму, щоб виконати SQL-запит у базі даних.',
	'maintenance-sql-desc' => 'Виконати SQL-запит',
	'maintenance-sql-option-file' => 'SQL для виконання',
	'maintenance-sql-output-aff' => 'Запит виконано. Оброблено $1 {{PLURAL:$1|рядок|рядки|рядків}}.',
	'maintenance-sql-error-cantopen' => 'Не вдається відкрити вхідний файл',
	'maintenance-showCacheStats-desc' => 'Показати статистику Memcached',
	'maintenance-eval' => 'Використовуйте цю форму, щоб перевірити PHP-код в MediaWiki середовищі.',
	'maintenance-eval-desc' => 'Перевірка PHP-коду в середовищі MediaWiki',
	'maintenance-invalidname' => "Неправильне ім'я користувача!",
	'maintenance-userexists' => 'Користувач вже існує!',
	'maintenance-invalidtitle' => 'Неприпустима назва "$1"!',
	'maintenance-titlenoexist' => 'Вказаного заголовку ("$1") не існує!',
	'maintenance-deleted' => 'ВИЛУЧЕНО',
	'maintenance-revnotfound' => 'Версію $1 не знайдено!',
	'maintenance-showCacheStats-edits' => 'Кількість редагувань: $1',
	'maintenance-showCacheStats-articles' => 'Кількість сторінок в основному просторі назв: $1',
	'maintenance-showCacheStats-pages' => 'Кількість сторінок: $1',
	'maintenance-showCacheStats-users' => 'Кількість користувачів: $1',
	'maintenance-showCacheStats-admins' => 'Кількість адміністраторів: $1',
	'maintenance-showCacheStats-images' => 'Кількість файлів: $1',
	'maintenance-showCacheStats-views' => 'Кількість переглядів сторінок: $1',
	'maintenance-showCacheStats-update' => 'Оновлення бази даних{{int:ellipsis}}',
	'maintenance-error' => 'Помилка: $1',
	'maintenance-memc-requests' => 'Запити',
	'maintenance-memc-total' => 'всього:',
	'maintenance-memc-parsercache' => 'Кеш парсера',
	'maintenance-memc-hits' => 'переглядів:',
	'maintenance-memc-invalid' => 'помилкових:',
	'maintenance-memc-absent' => 'відсутніх:',
	'maintenance-memc-imagecache' => 'Кеш зображень',
	'maintenance-memc-misses' => 'помилок:',
	'maintenance-memc-updates' => 'оновлень:',
	'maintenance-re-nf' => 'Користувача $1 не знайдено',
	'maintenance-re-ce' => 'Поточні редагування: $1',
	'maintenance-re-de' => 'Вилучені редагування: $1',
);

/** Urdu (اردو)
 * @author පසිඳු කාවින්ද
 */
$messages['ur'] = array(
	'maintenance-backlink' => 'سکرپٹ کا انتخاب کرنے کے لئے واپس',
	'maintenance-header' => 'براہ مہربانی ایک سکرپٹ کو ذیل میں منتخب کریں ۔ انگيز ہر سکرپٹ کے سامنے ہیں',
	'maintenance-error-invalidtype' => 'مخصوص سکرپٹ نہیں پایا گیا',
	'maintenance-error-badargs' => 'آپ نے نہیں وضاحت ضروری اختیارات کے تمام',
	'maintenance-generic-done' => 'کیا کیا',
	'maintenance-generic-username' => 'صارف کا نام',
	'maintenance-generic-password' => 'پاس ورڈ',
	'maintenance-generic-reason' => 'وجہ',
	'maintenance-option-confirm' => 'اس بات کی تصدیق',
	'maintenance-option-required' => '(ضرورت)',
	'maintenance-option-optional' => '(اختیاری)',
	'maintenance-checkBadRedirects-output-footer' => 'کیا.',
	'maintenance-checkSyntax-output-buildlist' => 'تحریک منہاج القرآن کے فائل عمارت فہرست...',
	'maintenance-cleanupSpam-output-false' => 'باطل میچ',
	'maintenance-reassignEdits-desc' => 'گئی تدوین ایک صارف سے دوسرے اجازتیں',
	'maintenance-runJobs-desc' => 'کام قطار میں روزگار کے لیے چلائیں',
	'maintenance-runJobs-option-maxjobs' => 'کو چلانے کے لئے روزگار کے زیادہ سے زیادہ تعداد',
	'maintenance-runJobs-option-type' => 'کو چلانے کے لئے کام کی قسم',
	'maintenance-runJobs-option-procs' => 'استعمال کرنے کے لئے عمل کی تعداد',
	'maintenance-runJobs-error-invalidprocs' => 'آپ 1 اور 1000 کے عمل کے درمیان وضاحت ضروری',
	'maintenance-showJobs-desc' => 'کام قطار میں التواء روزگار کی فہرست دکھائیں',
	'maintenance-showJobs-option-group' => 'شو کی ملازمتوں فی کام قسم کی بڑی تعداد',
	'maintenance-invalidname' => 'باطل صارف کا نام!',
	'maintenance-userexists' => 'موجود صارف پہلے ہی ہے!',
	'maintenance-memc-requests' => 'کی درخواستیں',
	'maintenance-memc-total' => 'کل:',
	'maintenance-memc-invalid' => 'باطل:',
	'maintenance-memc-updates' => 'تازہ ترین معلومات:',
	'maintenance-reassignEdits' => 'اجازتیں گئی تدوین ایک صارف سے دوسرے کو اس فارم استعمال کریں ۔',
	'maintenance-re-from' => 'گئی تدوین سے تفویض کرنے کے لئے صارف کا نام',
);

/** Veps (vepsän kel’)
 * @author Игорь Бродский
 */
$messages['vep'] = array(
	'maintenance-error-invalidtype' => 'Vär tip!', # Fuzzy
	'maintenance-option-confirm' => 'Vahvištoitta',
	'maintenance-invalidname' => 'Vär kävutajannimi!',
	'maintenance-failed' => 'ONETOMAŠTI',
	'maintenance-deleted' => 'ČUTUD POIŠ',
	'maintenance-error' => 'Petuz: $1',
	'maintenance-memc-total' => 'kaiked:',
	'maintenance-memc-parsercache' => 'Parseran keš',
	'maintenance-memc-hits' => 'kacundoid:',
	'maintenance-memc-invalid' => 'värid:',
	'maintenance-memc-expired' => 'männuden lopstrokanke:',
	'maintenance-memc-absent' => 'ei ole:',
);

/** Vietnamese (Tiếng Việt)
 * @author Minh Nguyen
 * @author Vinhtantran
 */
$messages['vi'] = array(
	'maintenance' => 'Chạy mã bảo trì',
	'maintenance-desc' => '[[Special:Maintenance|Giao diện web]] dành cho các loại mã bảo trì khác nhau',
	'maintenance-backlink' => 'Quay lại lựa chọn mã',
	'maintenance-header' => 'Xin hãy chọn một đoạn mã ở dưới để thực thi.
Mô tả nằm ở bên cạnh mỗi đoạn mã',
	'maintenance-error-invalidtype' => 'Không tìm thấy kịch bản đã định rõ',
	'maintenance-generic-username' => 'Tên người dùng',
	'maintenance-generic-password' => 'Mật khẩu',
	'maintenance-generic-reason' => 'Lý do',
	'maintenance-option-confirm' => 'Xác nhận',
	'maintenance-output-success' => '$1 đã chạy thành công!',
	'maintenance-changePassword' => 'Sử dụng mẫu này để thay đổi mật khẩu của thành viên',
	'maintenance-changePassword-desc' => 'Thay đổi mật khẩu của thành viên',
	'maintenance-createAndPromote' => 'Sử dụng mẫu này để tạo ra thành viên mới và phong cho thành viên này cờ sysop.
Chọn vào ô hành chính viên nếu bạn cũng muốn phong thành Hành chính viên',
	'maintenance-createAndPromote-desc' => 'Tạo một thành viên và phong cho thành viên này thành sysop',
	'maintenance-deleteBatch' => 'Sử dụng mẫu này để xóa trang hàng loạt.
Chỉ ghi mỗi dòng một trang',
	'maintenance-deleteBatch-desc' => 'Xóa trang hàng loạt',
	'maintenance-deleteRevision' => 'Sử dụng mẫu này để xóa phiên bản hàng loạt.
Chỉ ghi mỗi dòng một phiên bản',
	'maintenance-deleteRevision-desc' => 'Xóa một phiên bản ra khỏi cơ sở dữ liệu',
	'maintenance-initEditCount-desc' => 'Tính toán lại số lần sửa đổi của thành viên',
	'maintenance-initSiteStats' => 'Sử dụng mẫu này để tính lại các thống kê của trang, hãy chỉ rõ nếu bạn cũng muốn tính lại số lần xem trang',
	'maintenance-initSiteStats-desc' => 'Tính toán lại các thống kê của trang',
	'maintenance-moveBatch' => 'Sử dụng mẫu này để di chuyển trang hàng loạt.
Mỗi dòng nên ghi rõ trang nguồn và trang đích, cách nhau bằng dấu sọc đứng',
	'maintenance-moveBatch-desc' => 'Di chuyển trang hàng loạt',
	'maintenance-runJobs-desc' => 'Chạy các tác vụ trong hàng đợi công việc',
	'maintenance-showJobs-desc' => 'Hiển thị danh sách các công việc đang chờ đợi trong hàng đợi việc',
	'maintenance-showCacheStats-desc' => 'Hiển thị thống kê được lưu vào bộ đệm',
	'maintenance-update' => 'Có sử dụng UPDATE khi cập nhật một bảng? Thay vào đó hãy bỏ chọn cách dùng DELETE/INSERT.',
	'maintenance-noviews' => 'Chọn cái này để ngăn cập nhật số lần xem trang',
	'maintenance-invalidname' => 'Tên người dùng không hợp lệ!',
	'maintenance-userexists' => 'Người dùng đã tồn tại!',
	'maintenance-invalidtitle' => 'Tựa đề “$1” không hợp lệ!',
	'maintenance-titlenoexist' => 'Tựa đề chỉ định (“$1”) không tồn tại!',
	'maintenance-failed' => 'THẤT BẠI',
	'maintenance-deleted' => 'ĐÃ XÓA',
	'maintenance-revdelete' => 'Đang xóa {{PLURAL:$3|phiên bản|các phiên bản}} $1 từ wiki $2',
	'maintenance-revnotfound' => 'Không tìm thấy phiên bản $1!',
	'maintenance-showCacheStats-edits' => 'Số lần sửa đổi: $1',
	'maintenance-showCacheStats-articles' => 'Số trang trong không gian tên chính: $1',
	'maintenance-showCacheStats-pages' => 'Số trang: $1',
	'maintenance-showCacheStats-users' => 'Số người dùng: $1',
	'maintenance-showCacheStats-admins' => 'Số quản lý: $1',
	'maintenance-showCacheStats-images' => 'Số tập tin: $1',
	'maintenance-showCacheStats-views' => 'Số lần xem trang: $1',
	'maintenance-showCacheStats-update' => 'Đang cập nhật cơ sở dữ liệu...',
	'maintenance-move' => 'Đang di chuyển $1 sang $2...',
	'maintenance-movefail' => 'Gặp lỗi khi di chuyển: $1.
Hủy di chuyển',
	'maintenance-error' => 'Lỗi: $1',
	'maintenance-memc-fake' => 'Bạn đang chạy FakeMemCachedClient. Không có thống kê nào',
	'maintenance-memc-requests' => 'Yêu cầu',
	'maintenance-memc-withsession' => 'với phiên:',
	'maintenance-memc-withoutsession' => 'không có phiên',
	'maintenance-memc-total' => 'tổng cộng:',
	'maintenance-memc-parsercache' => 'Bộ đệm Phân tích cú pháp',
	'maintenance-memc-hits' => 'số hit:',
	'maintenance-memc-invalid' => 'không hợp lệ:',
	'maintenance-memc-expired' => 'hết hạn:',
	'maintenance-memc-absent' => 'thiếu:',
	'maintenance-memc-stub' => 'ngưỡng sơ khai:',
	'maintenance-memc-imagecache' => 'Bộ đệm Hình ảnh',
	'maintenance-memc-misses' => 'số miss:',
	'maintenance-memc-updates' => 'số cập nhật:',
	'maintenance-memc-uncacheable' => 'không thể lưu đệm:',
	'maintenance-memc-diffcache' => 'Khác nhau Bộ đệm',
);

/** Volapük (Volapük)
 * @author Smeira
 */
$messages['vo'] = array(
	'maintenance-error-invalidtype' => 'Sot no lonöföl!', # Fuzzy
	'maintenance-option-confirm' => 'Fümedön',
	'maintenance-changePassword' => 'Gebolös fometi at ad votükön letavödi gebana',
	'maintenance-changePassword-desc' => 'Votükön gebanaletavödi',
	'maintenance-createAndPromote' => 'Gebolös fometi at ad jafön gebani nulik e gevön one guvanastadi.
Välolös i „büran“ if vilol gevön one i büranastadi.',
	'maintenance-createAndPromote-desc' => 'Jafön gebani e gevön one guvanastadi',
	'maintenance-deleteBatch' => 'Gebolös fometi at ad moükön padamödoti.
Penolös padi te bali a lien.',
	'maintenance-deleteBatch-desc' => 'Moükön padamödoti',
	'maintenance-deleteRevision' => 'Gebolös fometi at ad moükön revidamödoti.
Penolös revidi te bali a lien.',
	'maintenance-deleteRevision-desc' => 'Moükön revidis se nünodem',
	'maintenance-initEditCount-desc' => 'Dönukalkulön redakamanumi gebanas',
	'maintenance-initSiteStats' => 'Gebolös fometi at ad dönukalkulön statitis topädik. Mäniotolös, if vilol dönukalkulön i padilogamis.',
	'maintenance-initSiteStats-desc' => 'Dönukalkulön sitastatitis',
	'maintenance-moveBatch' => 'Gebolös fometi at ad topätükön padamödoti.
Lien alik muton ninädön fonätapadi e zeilapadi pateilölis dub malat: „|“',
	'maintenance-moveBatch-desc' => 'Topätükön padamödoti',
	'maintenance-reassignEdits-desc' => 'Givülön redakamis gebana bal gebane votik',
	'maintenance-invalidname' => 'Gebananem no lonöfon!',
	'maintenance-userexists' => 'Geban ya dabinon!',
	'maintenance-invalidtitle' => 'Tiäd no lonöföl: „$1“!',
	'maintenance-titlenoexist' => 'Tiäd pavilöl („$1“) no dabinon!',
	'maintenance-failed' => 'NO EPLÖPON',
	'maintenance-deleted' => 'PEMOÜKON',
	'maintenance-revdelete' => 'Revids: $1 se vük: $2 pamoükons', # Fuzzy
	'maintenance-revnotfound' => 'Revid: $1 no petuvon!',
	'maintenance-showCacheStats-edits' => 'Num redakamas: $1',
	'maintenance-showCacheStats-articles' => 'Num padas in nemaspad cifik: $1',
	'maintenance-showCacheStats-pages' => 'Num padas: $1',
	'maintenance-showCacheStats-users' => 'Num gebanas: $1',
	'maintenance-showCacheStats-admins' => 'Num guvanas: $1',
	'maintenance-showCacheStats-images' => 'Num ragivas: $1',
	'maintenance-showCacheStats-views' => 'Num padilogams: $1',
	'maintenance-move' => 'Pad: $1 patopätükon ad pad: $2{{int:ellipsis}}',
	'maintenance-movefail' => 'Pöl dü topätükam pada: $1.
Topätükam pestöpädon.',
	'maintenance-error' => 'Pöl: $1',
	'maintenance-memc-requests' => 'Begs',
	'maintenance-memc-total' => 'valod:',
	'maintenance-reassignEdits' => 'Gebolös fometi at ad dönugivülön redakamis gebana bal gebane votik.',
	'maintenance-re-from' => 'Nem gebana, kelas redakams podönugivülons',
	'maintenance-re-to' => 'Nem gebana, kele redakams pogivülons',
	'maintenance-re-force' => 'Dönugivülön ifi zeilageban no dabinon',
	'maintenance-re-nf' => 'Geban: $1 no petuvon',
	'maintenance-re-de' => 'Redakams pemoüköl: $1',
	'maintenance-re-re' => 'Redakams padönugivülons{{int:ellipsis}} peledunon.',
);

/** Walloon (walon)
 * @author Lucyin
 */
$messages['wa'] = array(
	'maintenance-deleted' => 'DISFACÉ',
);

/** Yiddish (ייִדיש)
 * @author פוילישער
 * @author පසිඳු කාවින්ද
 */
$messages['yi'] = array(
	'maintenance-generic-username' => 'באַניצער נאָמען',
	'maintenance-generic-password' => 'פאַסווארט',
	'maintenance-option-confirm' => 'באַשטעטיגן',
	'maintenance-invalidname' => 'אומגילטיקער באַניצער נאָמען!',
	'maintenance-move' => 'באוועגן $1 צו $2{{int:ellipsis}}',
);

/** Simplified Chinese (中文（简体）‎)
 * @author Hydra
 * @author Liangent
 * @author PhiLiP
 * @author Simon Shek
 * @author Wrightbus
 * @author Xiaomingyan
 * @author Yfdyh000
 */
$messages['zh-hans'] = array(
	'maintenance' => '运行维护脚本',
	'maintenance-desc' => '各种维护脚本的[[Special:Maintenance|wiki接口]]',
	'right-maintenance' => '通过[[Special:Maintenance]]运行维护脚本',
	'maintenance-backlink' => '返回到脚本选择',
	'maintenance-header' => '请在下面选择一个脚本来执行。描述在各脚本的旁边',
	'maintenance-error-badini' => 'metadata.ini文件已损坏或丢失。请重新下载Maintenance扩展',
	'maintenance-error-invalidtype' => '找不到指定的脚本',
	'maintenance-error-badargs' => '您没有指定所有必填的选项',
	'maintenance-generic-done' => '做好了',
	'maintenance-generic-username' => '用户名',
	'maintenance-generic-password' => '密码',
	'maintenance-generic-reason' => '原因',
	'maintenance-cleanupTable-dry-run' => '执行预运行',
	'maintenance-cleanupTable-check' => '检查坏的标题...',
	'maintenance-cleanupTable-checkfix' => '检查和修复坏的标题...',
	'maintenance-cleanupTable-missingparam' => '$1：缺少参数$2',
	'maintenance-cleanupTable-processing' => '处理$1...',
	'maintenance-cleanupTable-finished' => '完成$1... $3中的$2行已更新',
	'maintenance-option-quiet' => '阻止非错误输出',
	'maintenance-option-confirm' => '确认',
	'maintenance-option-batch-size' => '每批运行以下次数的操作，默认：$1',
	'maintenance-option-required' => '（必须要）',
	'maintenance-option-optional' => '（可选）',
	'maintenance-output-success' => '$1已成功运行！',
	'maintenance-output-failure' => '$1未成功运行！',
	'maintenance-attachLatest-option-fix' => '实际修复项目，否则预运行',
	'maintenance-attachLatest-output-begin' => '寻找page_latest设置为0的页面...',
	'maintenance-attachLatest-output-done' => '完成！已处理$1个页面。',
	'maintenance-changePassword' => '使用此表单来更改用户的密码',
	'maintenance-changePassword-desc' => '更改用户的密码',
	'maintenance-changePassword-error-nouser' => '没有这样的用户：$1',
	'maintenance-changePassword-output-set' => '已为$1设置密码',
	'maintenance-checkBadRedirects' => '使用此表单来查看标记为重定向的页面是否真的是重定向',
	'maintenance-checkBadRedirects-desc' => '检查坏的重定向',
	'maintenance-checkBadRedirects-output-header' => '读取重定向...',
	'maintenance-checkBadRedirects-output-found' => '找到了$1个重定向。
检查坏的重定向...',
	'maintenance-checkBadRedirects-output-footer' => '
完成。',
	'maintenance-checkImages' => '使用此表单来查看您的wiki上的哪些图像已损坏',
	'maintenance-checkImages-desc' => '检查图像以查看它们是否存在、可读等等',
	'maintenance-checkImages-output-noaccess' => '$1：本地不可访问',
	'maintenance-checkImages-output-missing' => '$1：丢失',
	'maintenance-checkImages-output-isdir' => '$1：是一个目录',
	'maintenance-checkImages-output-truncated' => '$1：被截断，原为$2',
	'maintenance-checkImages-output-mismatch' => '$1：大小不匹配 数据库=$2，实际=$3',
	'maintenance-checkImages-output-good' => '好图片：$1/$2',
	'maintenance-checkSyntax-output-svnlist' => '从Subversion获取列表...',
	'maintenance-checkSyntax-output-buildlist' => '建立文件列表...',
	'maintenance-checkSyntax-output-error' => '文件$1中于行$2的错误：$3',
	'maintenance-checkSyntax-output-warning' => '文件$1中的警告：$2',
	'maintenance-checkSyntax-error-nofile' => '错误：找不到文件或目录$1',
	'maintenance-checkSyntax-error-cantopen' => '无法打开文件$1',
	'maintenance-checkUsernames-error-notvalid' => '无效的使用者名：「$3 」（使用者id  $2 ）',
	'maintenance-cleanupSpam-output-blanking' => '正在清空',
	'maintenance-cleanupSpam-output-reverting' => '正在回退',
	'maintenance-cleanupSpam-error-noid' => '内部错误: 没有ID$1的页面',
	'maintenance-deleteBatch-desc' => '删除大量页面',
	'maintenance-deleteRevision-desc' => '从资料库中删除修改',
	'maintenance-initSiteStats-desc' => '重新计算网站的统计资料',
	'maintenance-moveBatch-desc' => '大量移动页面',
	'maintenance-runJobs-desc' => '运行工作队列中的工作',
	'maintenance-runJobs-option-maxjobs' => '最大的工作运行数量',
	'maintenance-runJobs-option-type' => '要运行的工作类型',
	'maintenance-runJobs-option-procs' => '要使用的进程数',
	'maintenance-showJobs-desc' => '显示工作队列中的挂起的工作列表',
	'maintenance-showJobs-option-group' => '显示的每个工作类型的工作数目',
	'maintenance-sql' => '使用此表单来在数据库上执行SQL查询。',
	'maintenance-sql-desc' => '执行SQL查询',
	'maintenance-sql-option-file' => '要执行的SQL',
	'maintenance-sql-output-aff' => '查询完成，$1行被影响',
	'maintenance-sql-error-cantopen' => '无法打开输入文件',
	'maintenance-showCacheStats-desc' => '显示Memcached统计信息',
	'maintenance-invalidname' => '无效用户名！',
	'maintenance-userexists' => '用户已存在！',
	'maintenance-invalidtitle' => '无效标题“$1”！',
	'maintenance-failed' => '失败了',
	'maintenance-deleted' => '删除了',
	'maintenance-revnotfound' => '修订$1没有找到！',
	'maintenance-showCacheStats-edits' => '编辑数：$1',
	'maintenance-showCacheStats-articles' => '主名字空间中的页面数：$1',
	'maintenance-showCacheStats-pages' => '页面数：$1',
	'maintenance-showCacheStats-users' => '用户数：$1',
	'maintenance-showCacheStats-admins' => '管理员数：$1',
	'maintenance-showCacheStats-images' => '文件数：$1',
	'maintenance-showCacheStats-views' => '页面访问数：$1',
	'maintenance-showCacheStats-update' => '更新数据库{{int:ellipsis}}',
	'maintenance-move' => '移动$1到$2{{int:ellipsis}}',
	'maintenance-error' => '错误：$1',
	'maintenance-memc-fake' => '您正在运行FakeMemCachedClient。没有统计资料可以提供',
	'maintenance-memc-requests' => '请求',
	'maintenance-memc-total' => '总数：',
	'maintenance-memc-parsercache' => '解析器缓存',
	'maintenance-memc-hits' => '命中：',
	'maintenance-memc-invalid' => '无效：',
	'maintenance-memc-expired' => '过期：',
	'maintenance-memc-absent' => '缺失：',
	'maintenance-memc-imagecache' => '图片缓存',
	'maintenance-memc-misses' => '未命中：',
	'maintenance-memc-updates' => '更新：',
	'maintenance-memc-uncacheable' => '无法缓存：',
	'maintenance-memc-diffcache' => '差异缓存',
	'maintenance-re-nf' => '用户$1没有找到',
	'maintenance-re-ce' => '当前编辑：$1',
	'maintenance-re-de' => '已删除编辑：$1',
	'maintenance-re-rce' => '最近更改条目：$1',
);

/** Traditional Chinese (中文（繁體）‎)
 * @author Mark85296341
 * @author Simon Shek
 * @author Wrightbus
 */
$messages['zh-hant'] = array(
	'maintenance' => '運行維護腳本',
	'maintenance-desc' => '各種維護腳本的[[Special:Maintenance|wiki界面]]',
	'right-maintenance' => '通過[[Special:Maintenance]]運行維護腳本',
	'maintenance-backlink' => '返回到腳本選擇',
	'maintenance-header' => '請在下面選擇一個腳本來執行。描述在各腳本的旁邊',
	'maintenance-error-badini' => 'metadata.ini文件已損壞或丟失。請重新下載Maintenance擴展',
	'maintenance-error-invalidtype' => '找不到指定的腳本',
	'maintenance-error-badargs' => '您沒有指定所有必填的選項',
	'maintenance-generic-done' => '完成',
	'maintenance-generic-username' => '用戶名',
	'maintenance-generic-password' => '密碼',
	'maintenance-generic-reason' => '原因',
	'maintenance-cleanupTable-dry-run' => '執行預運行',
	'maintenance-cleanupTable-check' => '檢查壞的標題...',
	'maintenance-cleanupTable-checkfix' => '檢查和修復壞的標題...',
	'maintenance-cleanupTable-missingparam' => '$1：缺少參數$2',
	'maintenance-cleanupTable-processing' => '處理$1...',
	'maintenance-cleanupTable-finished' => '完成$1... $3中的$2行已更新',
	'maintenance-option-quiet' => '阻止非錯誤輸出',
	'maintenance-option-confirm' => '確認',
	'maintenance-option-batch-size' => '每批運行以下次數的操作，默認：$1',
	'maintenance-option-required' => '（必須要）',
	'maintenance-option-optional' => '（可選）',
	'maintenance-output-success' => '$1已成功運行！',
	'maintenance-output-failure' => '$1未成功運行！',
	'maintenance-attachLatest-option-fix' => '實際修復項目，否則預運行',
	'maintenance-attachLatest-output-begin' => '尋找page_latest設置為0的頁面...',
	'maintenance-attachLatest-output-done' => '完成！已處理$1個頁面。',
	'maintenance-changePassword' => '使用此表單來更改用戶的密碼',
	'maintenance-changePassword-desc' => '變更使用者的密碼',
	'maintenance-changePassword-error-nouser' => '沒有這樣的用戶：$1',
	'maintenance-changePassword-output-set' => '已為$1設置密碼',
	'maintenance-checkBadRedirects' => '使用此表單來查看標記為重定向的頁面是否真的是重定向',
	'maintenance-checkBadRedirects-desc' => '檢查壞的重定向',
	'maintenance-checkBadRedirects-output-header' => '讀取重定向...',
	'maintenance-checkBadRedirects-output-found' => '找到了$1個重定向。
檢查壞的重定向...',
	'maintenance-checkBadRedirects-output-footer' => '
完成。',
	'maintenance-checkImages' => '使用此表單來查看您的wiki上的哪些圖像已損壞',
	'maintenance-checkImages-desc' => '檢查圖像以查看它們是否存在、可讀等等',
	'maintenance-checkImages-output-noaccess' => '$1：本地不可訪問',
	'maintenance-checkImages-output-missing' => '$1：丟失',
	'maintenance-checkImages-output-isdir' => '$1：是一個目錄',
	'maintenance-checkImages-output-truncated' => '$1：被截斷，原為$2',
	'maintenance-checkImages-output-mismatch' => '$1：大小不匹配 數據庫=$2，實際=$3',
	'maintenance-checkImages-output-good' => '好圖片：$1/$2',
	'maintenance-checkSyntax-output-svnlist' => '從Subversion獲取列表...',
	'maintenance-checkSyntax-output-buildlist' => '建立文件列表...',
	'maintenance-checkSyntax-output-error' => '文件$1中於行$2的錯誤：$3',
	'maintenance-checkSyntax-output-warning' => '文件$1中的警告：$2',
	'maintenance-checkSyntax-error-nofile' => '錯誤：找不到文件或目錄$1',
	'maintenance-checkSyntax-error-cantopen' => '無法打開文件$1',
	'maintenance-checkUsernames-error-notvalid' => '無效的使用者名：「$3 」（使用者id  $2 ）',
	'maintenance-cleanupSpam-output-blanking' => '正在清空',
	'maintenance-cleanupSpam-output-reverting' => '正在回退',
	'maintenance-cleanupSpam-error-noid' => '內部錯誤: 沒有ID$1的頁面',
	'maintenance-deleteBatch-desc' => '大量刪除頁面',
	'maintenance-deleteRevision-desc' => '從資料庫中刪除修改',
	'maintenance-initSiteStats-desc' => '重新計算網站的統計資料',
	'maintenance-moveBatch-desc' => '大量移動頁面',
	'maintenance-runJobs-desc' => '運行工作隊列中的工作',
	'maintenance-runJobs-option-maxjobs' => '最大的工作運行數量',
	'maintenance-runJobs-option-type' => '要運行的工作類型',
	'maintenance-runJobs-option-procs' => '要使用的進程數',
	'maintenance-showJobs-desc' => '顯示工作隊列中的掛起的工作列表',
	'maintenance-showJobs-option-group' => '顯示的每個工作類型的工作數目',
	'maintenance-sql' => '使用此表單來在數據庫上執行SQL查詢。',
	'maintenance-sql-desc' => '執行SQL查詢',
	'maintenance-sql-option-file' => '要執行的SQL',
	'maintenance-sql-output-aff' => '查詢完成，$1行被影響',
	'maintenance-sql-error-cantopen' => '無法打開輸入文件',
	'maintenance-showCacheStats-desc' => '顯示Memcached統計信息',
	'maintenance-invalidname' => '無效的使用者名稱！',
	'maintenance-userexists' => '用戶已存在！',
	'maintenance-invalidtitle' => '無效的標題「$1」！',
	'maintenance-failed' => '失敗',
	'maintenance-deleted' => '刪除的',
	'maintenance-revnotfound' => '修訂$1沒有找到！',
	'maintenance-showCacheStats-edits' => '編輯次數：$1',
	'maintenance-showCacheStats-articles' => '主名字空間中的頁面數：$1',
	'maintenance-showCacheStats-pages' => '頁面數：$1',
	'maintenance-showCacheStats-users' => '用戶數：$1',
	'maintenance-showCacheStats-admins' => '管理員人數：$1',
	'maintenance-showCacheStats-images' => '檔案數量：$1',
	'maintenance-showCacheStats-views' => '瀏覽數量：$1',
	'maintenance-showCacheStats-update' => '更新資料庫 {{int:ellipsis}}',
	'maintenance-move' => '移動 $1 至 $2{{int:ellipsis}}',
	'maintenance-error' => '錯誤：$1',
	'maintenance-memc-fake' => '您正在運行FakeMemCachedClient。沒有統計資料可以提供',
	'maintenance-memc-requests' => '請求',
	'maintenance-memc-total' => '總計：',
	'maintenance-memc-parsercache' => '清除快取',
	'maintenance-memc-hits' => '點擊數：',
	'maintenance-memc-invalid' => '無效：',
	'maintenance-memc-expired' => '到期日：',
	'maintenance-memc-absent' => '缺失：',
	'maintenance-memc-imagecache' => '圖片緩存',
	'maintenance-memc-misses' => '未命中：',
	'maintenance-memc-updates' => '更新：',
	'maintenance-memc-uncacheable' => '不可快取：',
	'maintenance-memc-diffcache' => '差異緩存',
	'maintenance-re-nf' => '用戶$1沒有找到',
	'maintenance-re-ce' => '目前編輯：$1',
	'maintenance-re-de' => '刪除編輯：$1',
	'maintenance-re-rce' => '最近更改條目：$1',
);
